/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.injector;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class BonReceptionFactureFournisseurSQLInjector
extends SQLInjector {
    public BonReceptionFactureFournisseurSQLInjector(DBRoot root) {
        super(root, "BON_RECEPTION", "FACTURE_FOURNISSEUR", true);
        this.map(this.getSource().getField("ID_FOURNISSEUR"), this.getDestination().getField("ID_FOURNISSEUR"));
        this.map(this.getSource().getField("NOM"), this.getDestination().getField("NOM"));
        this.map(this.getSource().getField("INFOS"), this.getDestination().getField("INFOS"));
    }

    @Override
    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        super.merge(srcRow, rowVals);
        SQLTable tableElementSource = this.getSource().getTable("BON_RECEPTION_ELEMENT");
        SQLTable tableElementDestination = this.getSource().getTable("FACTURE_FOURNISSEUR_ELEMENT");
        Collection myListItem = srcRow.asRow().getReferentRows(tableElementSource);
        this.transfertReference(srcRow, rowVals, "NOM", "NOM");
        this.transfertReference(srcRow, rowVals, "INFOS", "INFOS");
        this.transfertNumberReference(srcRow, rowVals, tableElementDestination, "ID_FACTURE_FOURNISSEUR");
        if (myListItem.size() != 0) {
            SQLInjector injector = SQLInjector.getInjector(tableElementSource, tableElementDestination);
            for (SQLRowAccessor rowElt : myListItem) {
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(rowElt.asRow());
                if (createRowValuesFrom.getTable().getFieldsName().contains("POURCENT_ACOMPTE") && createRowValuesFrom.getObject("POURCENT_ACOMPTE") == null) {
                    createRowValuesFrom.put("POURCENT_ACOMPTE", new BigDecimal(100.0));
                }
                createRowValuesFrom.put("ID_FACTURE_FOURNISSEUR", (Object)rowVals);
            }
        }
    }
}

