/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.Tuple2;

public final class GenerationMvtFichePaye
extends GenerationEcritures
implements Runnable {
    private int[] idFichePaye;
    private String mois;
    private String annee;
    private static final SQLTable tableFichePaye = base.getTable("FICHE_PAYE");
    private static final SQLTable tableFichePayeElt = base.getTable("FICHE_PAYE_ELEMENT");
    private static final SQLTable tableSalarie = base.getTable("SALARIE");
    private static final SQLTable tableReglementPaye = base.getTable("REGLEMENT_PAYE");
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
    private SQLTable tableCaisse = Configuration.getInstance().getBase().getTable("CAISSE_COTISATION");
    private static final Integer journalOD = 6;
    private Map<String, SQLTable> mapTableSource = new HashMap<String, SQLTable>();

    public GenerationMvtFichePaye(int[] idFichePaye, String mois, String annee) throws SQLException {
        this.setRowAnalytiqueSource(null);
        SQLTable tableNet = Configuration.getInstance().getBase().getTable("RUBRIQUE_NET");
        SQLTable tableBrut = Configuration.getInstance().getBase().getTable("RUBRIQUE_BRUT");
        SQLTable tableCotis = Configuration.getInstance().getBase().getTable("RUBRIQUE_COTISATION");
        SQLTable tableComm = Configuration.getInstance().getBase().getTable("RUBRIQUE_COMM");
        this.mapTableSource.put(tableNet.getName(), tableNet);
        this.mapTableSource.put(tableBrut.getName(), tableBrut);
        this.mapTableSource.put(tableCotis.getName(), tableCotis);
        this.mapTableSource.put(tableComm.getName(), tableComm);
        this.idFichePaye = idFichePaye;
        this.annee = annee;
        this.mois = mois;
        this.idMvt = this.getNewMouvement("", 1, 1, "Paye " + this.mois + " " + this.annee);
        new Thread(this).start();
    }

    private void genereComptaFichePaye() throws Exception {
        int idComptePayeRegl;
        System.out.println("G\u00e9n\u00e9ration des ecritures  reglement du mouvement " + this.idMvt);
        SQLRowValues rowValsCaisse = new SQLRowValues(this.tableCaisse);
        rowValsCaisse.put(this.tableCaisse.getKey().getName(), null);
        rowValsCaisse.put("NUMERO_COMPTE_PCE", null);
        rowValsCaisse.put("NUMERO_COMPTE_PCE_CHARGES", null);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValsCaisse);
        List<SQLRowValues> result = fetcher.fetch();
        HashMap<Integer, Tuple2<Integer, Integer>> mapCaisse = new HashMap<Integer, Tuple2<Integer, Integer>>(result.size());
        for (SQLRowValues sqlRowValues : result) {
            int idCompte = ComptePCESQLElement.getId(sqlRowValues.getString("NUMERO_COMPTE_PCE"));
            int idCompteCharges = ComptePCESQLElement.getId(sqlRowValues.getString("NUMERO_COMPTE_PCE_CHARGES"));
            mapCaisse.put(sqlRowValues.getID(), Tuple2.create(idCompteCharges, idCompte));
        }
        this.date = new java.util.Date();
        this.nom = "Paye " + this.mois + " " + this.annee;
        this.mEcritures.put("DATE", new Date(this.date.getTime()));
        this.mEcritures.put("NOM", this.nom);
        this.mEcritures.put("ID_JOURNAL", journalOD);
        this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
        int idComptePaye = rowPrefsCompte.getInt("ID_COMPTE_PCE_PAYE");
        if (idComptePaye <= 1) {
            idComptePaye = ComptePCESQLElement.getIdComptePceDefault("PayeRemunerationPersonnel");
        }
        int i = 0;
        while (i < this.idFichePaye.length) {
            SQLRow rowFiche = tableFichePaye.getRow(this.idFichePaye[i]);
            SQLRow rowSal = tableSalarie.getRow(rowFiche.getInt("ID_SALARIE"));
            this.mEcritures.put("NOM", String.valueOf(rowSal.getString("NOM")) + " " + this.nom);
            this.mEcritures.put("ID_COMPTE_PCE", idComptePaye);
            float sal = rowFiche.getFloat("SAL_BRUT");
            this.mEcritures.put("DEBIT", GestionDevise.parseLongCurrency(String.valueOf(sal)));
            this.mEcritures.put("CREDIT", 0L);
            this.ajoutEcriture();
            ++i;
        }
        float cotTotalnet = 0.0f;
        SQLSelect selAllFicheElt = new SQLSelect();
        selAllFicheElt.addSelectStar(tableFichePayeElt);
        ArrayList<Integer> idsElt = new ArrayList<Integer>();
        Object object = this.idFichePaye;
        int n = this.idFichePaye.length;
        int n2 = 0;
        while (n2 < n) {
            int id = object[n2];
            idsElt.add(id);
            ++n2;
        }
        Where w = new Where(tableFichePayeElt.getField("ID_FICHE_PAYE"), idsElt);
        w = w.and(new Where((FieldRef)tableFichePayeElt.getField("SOURCE"), "=", (Object)"RUBRIQUE_NET"));
        selAllFicheElt.setWhere(w);
        List<SQLRow> resultElt = SQLRowListRSH.execute(selAllFicheElt);
        object = resultElt.iterator();
        while (object.hasNext()) {
            SQLRow row = (SQLRow)object.next();
            String source = row.getString("SOURCE");
            int idSource = row.getInt("IDSOURCE");
            SQLRow sQLRow = this.mapTableSource.get(source).getRow(idSource);
            String t = sQLRow.getString("NUMERO_COMPTE_PCE_CHARGES");
            int idCompteCharge = t == null || t.trim().length() == 0 ? ComptePCESQLElement.getId("648") : ComptePCESQLElement.getId(t);
            long montant = 0L;
            if (row.getObject("MONTANT_SAL_DED") != null && row.getFloat("MONTANT_SAL_DED") != 0.0f) {
                montant -= GestionDevise.parseLongCurrency(row.getObject("MONTANT_SAL_DED").toString());
            }
            if (row.getObject("MONTANT_SAL_AJ") != null && row.getFloat("MONTANT_SAL_AJ") != 0.0f) {
                montant += GestionDevise.parseLongCurrency(row.getObject("MONTANT_SAL_AJ").toString());
            }
            cotTotalnet += (float)montant;
            if (montant == 0L) continue;
            SQLRow rowSal = row.getForeign("ID_FICHE_PAYE").getForeign("ID_SALARIE");
            SQLRow rowRegl = rowSal.getForeign("ID_REGLEMENT_PAYE");
            int idComptePayeRegl2 = rowRegl.getInt("ID_COMPTE_PCE");
            if (idComptePayeRegl2 <= 1) {
                idComptePayeRegl2 = ComptePCESQLElement.getIdComptePceDefault("PayeReglement");
            }
            String nomRub = sQLRow.getString("NOM");
            this.mEcritures.put("ID_COMPTE_PCE", idCompteCharge);
            this.mEcritures.put("NOM", String.valueOf(nomRub) + ", " + rowSal.getString("NOM") + ", " + this.nom);
            if (montant > 0L) {
                this.mEcritures.put("DEBIT", montant);
                this.mEcritures.put("CREDIT", 0L);
                this.ajoutEcriture();
                continue;
            }
            this.mEcritures.put("DEBIT", 0L);
            this.mEcritures.put("CREDIT", -montant);
            this.ajoutEcriture();
        }
        int i2 = 0;
        while (i2 < this.idFichePaye.length) {
            SQLRow rowFiche = tableFichePaye.getRow(this.idFichePaye[i2]);
            SQLRow rowSal = tableSalarie.getRow(rowFiche.getInt("ID_SALARIE"));
            SQLRow rowRegl = tableReglementPaye.getRow(rowSal.getInt("ID_REGLEMENT_PAYE"));
            idComptePayeRegl = rowRegl.getInt("ID_COMPTE_PCE");
            if (idComptePayeRegl <= 1) {
                idComptePayeRegl = ComptePCESQLElement.getIdComptePceDefault("PayeReglement");
            }
            this.mEcritures.put("ID_COMPTE_PCE", idComptePayeRegl);
            this.mEcritures.put("NOM", String.valueOf(rowSal.getString("NOM")) + " " + this.nom);
            float sal = rowFiche.getFloat("NET_A_PAYER");
            this.mEcritures.put("DEBIT", 0L);
            this.mEcritures.put("CREDIT", GestionDevise.parseLongCurrency(String.valueOf(sal)));
            this.ajoutEcriture();
            ++i2;
        }
        selAllFicheElt = new SQLSelect();
        selAllFicheElt.addSelectStar(tableFichePayeElt);
        idsElt = new ArrayList();
        int[] sal = this.idFichePaye;
        idComptePayeRegl = this.idFichePaye.length;
        int rowRegl = 0;
        while (rowRegl < idComptePayeRegl) {
            int id = sal[rowRegl];
            idsElt.add(id);
            ++rowRegl;
        }
        w = new Where(tableFichePayeElt.getField("ID_FICHE_PAYE"), idsElt);
        w = w.and(new Where((FieldRef)tableFichePayeElt.getField("SOURCE"), "=", (Object)"RUBRIQUE_COTISATION"));
        selAllFicheElt.setWhere(w);
        resultElt = SQLRowListRSH.execute(selAllFicheElt);
        HashMap mapCompteDebSal = new HashMap();
        HashMap<Integer, Long> mapCompteDebPat = new HashMap<Integer, Long>();
        HashMap<Integer, Long> mapCompteCredSal = new HashMap<Integer, Long>();
        HashMap<Integer, Long> mapCompteCredPat = new HashMap<Integer, Long>();
        for (SQLRow sQLRow : resultElt) {
            int idCompteTiers;
            String source = sQLRow.getString("SOURCE");
            int idSource = sQLRow.getInt("IDSOURCE");
            SQLRow rowSource = this.mapTableSource.get(source).getRow(idSource);
            int idCaisse = rowSource.getInt("ID_CAISSE_COTISATION");
            Tuple2 t = (Tuple2)mapCaisse.get(idCaisse);
            int idCompteCharge = t == null ? ComptePCESQLElement.getId("645") : (Integer)t.get0();
            int n3 = idCompteTiers = t == null ? ComptePCESQLElement.getId("437") : (Integer)t.get1();
            if (sQLRow.getObject("MONTANT_SAL_DED") != null && sQLRow.getFloat("MONTANT_SAL_DED") != 0.0f) {
                Object montantCredObj = mapCompteCredSal.get(idCompteTiers);
                long montantCred = montantCredObj == null ? 0L : (Long)montantCredObj;
                mapCompteCredSal.put(idCompteTiers, montantCred += GestionDevise.parseLongCurrency(sQLRow.getObject("MONTANT_SAL_DED").toString()));
            }
            if (sQLRow.getObject("MONTANT_PAT") == null || sQLRow.getFloat("MONTANT_PAT") == 0.0f) continue;
            Object montantDebObj = mapCompteDebPat.get(idCompteCharge);
            long montantDeb = montantDebObj == null ? 0L : (Long)montantDebObj;
            mapCompteDebPat.put(idCompteCharge, montantDeb += GestionDevise.parseLongCurrency(sQLRow.getObject("MONTANT_PAT").toString()));
            Object montantCredObj = mapCompteCredPat.get(idCompteTiers);
            long montantCred = montantCredObj == null ? 0L : (Long)montantCredObj;
            mapCompteCredPat.put(idCompteTiers, montantCred += GestionDevise.parseLongCurrency(sQLRow.getObject("MONTANT_PAT").toString()));
        }
        for (Map.Entry entry : mapCompteCredSal.entrySet()) {
            Integer idCompte = (Integer)entry.getKey();
            this.mEcritures.put("ID_COMPTE_PCE", idCompte);
            this.mEcritures.put("NOM", "Cotisations salariales, " + this.nom);
            this.mEcritures.put("DEBIT", 0L);
            this.mEcritures.put("CREDIT", entry.getValue());
            this.ajoutEcriture();
        }
        for (Map.Entry entry : mapCompteDebSal.entrySet()) {
            Integer idCompte = (Integer)entry.getKey();
            this.mEcritures.put("ID_COMPTE_PCE", idCompte);
            this.mEcritures.put("NOM", "Cotisations salariales, " + this.nom);
            this.mEcritures.put("CREDIT", 0L);
            this.mEcritures.put("DEBIT", entry.getValue());
            this.ajoutEcriture();
        }
        for (Map.Entry entry : mapCompteCredPat.entrySet()) {
            Integer idCompte = (Integer)entry.getKey();
            this.mEcritures.put("ID_COMPTE_PCE", idCompte);
            this.mEcritures.put("NOM", "Cotisations patronales, " + this.nom);
            this.mEcritures.put("DEBIT", 0L);
            this.mEcritures.put("CREDIT", entry.getValue());
            this.ajoutEcriture();
        }
        for (Map.Entry entry : mapCompteDebPat.entrySet()) {
            Integer idCompte = (Integer)entry.getKey();
            this.mEcritures.put("ID_COMPTE_PCE", idCompte);
            this.mEcritures.put("NOM", "Cotisations patronales, " + this.nom);
            this.mEcritures.put("CREDIT", 0L);
            this.mEcritures.put("DEBIT", entry.getValue());
            this.ajoutEcriture();
        }
    }

    @Override
    public void run() {
        try {
            this.genereComptaFichePaye();
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
            e.printStackTrace();
        }
    }
}

