/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;

public class TotalCommandeClientProvider
implements SpreadSheetCellValueProvider {
    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        Collection<? extends SQLRowAccessor> rows = row.getReferentRows(row.getTable().getTable("TR_COMMANDE_CLIENT"));
        long total = 0L;
        for (SQLRowAccessor sQLRowAccessor : rows) {
            if (sQLRowAccessor.isForeignEmpty("ID_COMMANDE_CLIENT")) continue;
            SQLRowAccessor rowCmd = sQLRowAccessor.getForeign("ID_COMMANDE_CLIENT");
            total += rowCmd.getLong("T_HT");
        }
        return new BigDecimal(total).movePointLeft(2);
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.account.command.total", new TotalCommandeClientProvider());
    }
}

