/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.UserInitialsValueProvider;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;

public class SaledTotalNotDiscountedProvider
extends UserInitialsValueProvider {
    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        SQLTable table = row.getTable();
        Collection<? extends SQLRowAccessor> cols = row.getReferentRows(table.getTable(String.valueOf(table.getName()) + "_ELEMENT"));
        BigDecimal total = BigDecimal.ZERO;
        for (SQLRowAccessor sQLRowAccessor : cols) {
            BigDecimal montant = sQLRowAccessor.getBigDecimal("PV_HT");
            BigDecimal qteUnit = sQLRowAccessor.getBigDecimal("QTE_UNITAIRE");
            int qte = sQLRowAccessor.getInt("QTE");
            if (montant == null) continue;
            total = total.add(montant.multiply(qteUnit).multiply(new BigDecimal(qte)).setScale(2, RoundingMode.HALF_UP));
        }
        if (table.contains("PORT_HT")) {
            total.add(new BigDecimal(row.getLong("PORT_HT")).movePointLeft(2));
        }
        return total;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.total.notdiscounted", new SaledTotalNotDiscountedProvider());
    }
}

