/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.UserInitialsValueProvider;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.DecimalUtils;

public class RemiseTotalProvider
extends UserInitialsValueProvider {
    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        SQLTable table = row.getTable();
        Collection<? extends SQLRowAccessor> cols = row.getReferentRows(table.getTable(String.valueOf(table.getName()) + "_ELEMENT"));
        BigDecimal total = BigDecimal.ZERO;
        for (SQLRowAccessor sQLRowAccessor : cols) {
            BigDecimal montant = sQLRowAccessor.getBigDecimal("MONTANT_REMISE");
            BigDecimal remise = (BigDecimal)sQLRowAccessor.getObject("POURCENT_REMISE");
            if (montant != null) {
                total = total.add(montant.setScale(2, RoundingMode.HALF_UP));
                continue;
            }
            if (remise == null || remise.signum() == 0) continue;
            BigDecimal subtract = BigDecimal.ONE.subtract(remise.movePointLeft(2));
            total = subtract.signum() == 0 ? total.add(sQLRowAccessor.getBigDecimal("PV_HT").multiply(sQLRowAccessor.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(sQLRowAccessor.getInt("QTE"))))) : total.add(sQLRowAccessor.getBigDecimal("T_PV_HT").divide(subtract, DecimalUtils.HIGH_PRECISION).subtract(sQLRowAccessor.getBigDecimal("T_PV_HT")).setScale(2, RoundingMode.HALF_UP));
        }
        return total;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.discount.total", new RemiseTotalProvider());
    }
}

