/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.utils.GestionDevise;

public class RecapFactureProvider
implements SpreadSheetCellValueProvider {
    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        Calendar c = row.getDate("DATE");
        Collection<? extends SQLRowAccessor> rows = row.getReferentRows(row.getTable().getTable("TR_COMMANDE_CLIENT"));
        StringBuffer result = new StringBuffer();
        HashSet<SQLRowAccessor> facture = new HashSet<SQLRowAccessor>();
        facture.add(row);
        for (SQLRowAccessor sQLRowAccessor : rows) {
            result.append(this.getPreviousAcompte(sQLRowAccessor.getForeign("ID_COMMANDE_CLIENT"), facture, c));
        }
        if (result.length() > 0) {
            return "Facturation pr\u00e9c\u00e9dente :" + result.toString();
        }
        return null;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.account.history", new RecapFactureProvider());
    }

    public String getPreviousAcompte(SQLRowAccessor sqlRowAccessor, Set<SQLRowAccessor> alreadyAdded, Calendar c) {
        if (sqlRowAccessor == null || sqlRowAccessor.isUndefined()) {
            return "";
        }
        Collection<? extends SQLRowAccessor> rows = sqlRowAccessor.getReferentRows(sqlRowAccessor.getTable().getTable("TR_COMMANDE_CLIENT"));
        StringBuffer result = new StringBuffer();
        for (SQLRowAccessor sQLRowAccessor : rows) {
            SQLRowAccessor rowFact = sQLRowAccessor.getForeign("ID_SAISIE_VENTE_FACTURE");
            if (rowFact == null || rowFact.isUndefined() || alreadyAdded.contains(rowFact) || !rowFact.getDate("DATE").before(c)) continue;
            alreadyAdded.add(rowFact);
            result.append(String.valueOf(rowFact.getString("NUMERO")) + " (" + GestionDevise.currencyToString(rowFact.getLong("T_HT")) + "\u20ac), ");
        }
        return result.toString();
    }
}

