/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;

public class PaiementRemainedProvider
implements SpreadSheetCellValueProvider {
    private final Type t;

    private PaiementRemainedProvider(Type t) {
        this.t = t;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        return this.getRestant(row);
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("invoice.payment.remained", new PaiementRemainedProvider(Type.REMAINED));
        SpreadSheetCellValueProviderManager.put("invoice.payment.done", new PaiementRemainedProvider(Type.DONE));
        SpreadSheetCellValueProviderManager.put("invoice.paiement.remained", new PaiementRemainedProvider(Type.REMAINED));
        SpreadSheetCellValueProviderManager.put("invoice.paiement.done", new PaiementRemainedProvider(Type.DONE));
    }

    private BigDecimal getRestant(SQLRowAccessor r) {
        Collection<? extends SQLRowAccessor> rows = r.getReferentRows(r.getTable().getTable("ECHEANCE_CLIENT"));
        long totalEch = 0L;
        for (SQLRowAccessor sQLRowAccessor : rows) {
            if (sQLRowAccessor.getBoolean("REGLE").booleanValue() || sQLRowAccessor.getBoolean("REG_COMPTA").booleanValue()) continue;
            totalEch += sQLRowAccessor.getLong("MONTANT");
        }
        long l = totalEch;
        if (this.t == Type.DONE) {
            l = r.getLong("T_TTC") - l;
        }
        return new BigDecimal(l).movePointLeft(2);
    }

    private static enum Type {
        DONE,
        REMAINED;

    }
}

