/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.AdresseClientProvider;
import org.openconcerto.sql.model.SQLRowAccessor;

public class AdresseFullClientValueProvider
extends AdresseClientProvider {
    private final int type;
    private final boolean withName;

    public AdresseFullClientValueProvider(int type, boolean withName) {
        this.type = type;
        this.withName = withName;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor r = this.getAdresse(context.getRow(), this.type);
        String result = "";
        if (this.withName) {
            result = String.valueOf(context.getRow().getForeign("ID_CLIENT").getString("NOM")) + "\n";
        }
        if (r.getString("LIBELLE").trim().length() > 0) {
            result = String.valueOf(r.getString("LIBELLE")) + "\n";
        }
        if (r.getString("DEST").trim().length() > 0) {
            result = String.valueOf(r.getString("DEST")) + "\n";
        }
        if (r.getString("RUE").trim().length() > 0) {
            result = String.valueOf(result) + r.getString("RUE") + "\n";
        }
        result = String.valueOf(result) + "\n" + r.getString("CODE_POSTAL");
        result = String.valueOf(result) + " ";
        if (r.getTable().contains("DISTRICT")) {
            result = String.valueOf(result) + r.getString("DISTRICT") + " ";
        }
        result = String.valueOf(result) + r.getString("VILLE");
        if (r.getBoolean("HAS_CEDEX").booleanValue()) {
            result = String.valueOf(result) + " Cedex";
            String cedex = r.getString("CEDEX");
            if (cedex != null && cedex.trim().length() > 0) {
                result = String.valueOf(result) + " " + cedex;
            }
        }
        if (r.getTable().contains("PROVINCE")) {
            result = String.valueOf(result) + "\n";
            if (r.getString("PROVINCE").trim().length() > 0) {
                result = String.valueOf(result) + r.getString("PROVINCE") + " ";
            }
            if (r.getTable().contains("DEPARTEMENT")) {
                result = String.valueOf(result) + r.getString("DEPARTEMENT");
            }
        }
        if (r.getString("PAYS").trim().length() > 0) {
            result = String.valueOf(result) + "\n" + r.getString("PAYS");
        }
        return result;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("address.customer.full", new AdresseFullClientValueProvider(ADRESSE_PRINCIPALE, false));
        SpreadSheetCellValueProviderManager.put("address.customer.invoice.full", new AdresseFullClientValueProvider(ADRESSE_FACTURATION, false));
        SpreadSheetCellValueProviderManager.put("address.customer.shipment.full", new AdresseFullClientValueProvider(ADRESSE_LIVRAISON, false));
        SpreadSheetCellValueProviderManager.put("address.customer.full.withname", new AdresseFullClientValueProvider(ADRESSE_PRINCIPALE, true));
        SpreadSheetCellValueProviderManager.put("address.customer.invoice.full.withname", new AdresseFullClientValueProvider(ADRESSE_FACTURATION, true));
        SpreadSheetCellValueProviderManager.put("address.customer.shipment.full.withname", new AdresseFullClientValueProvider(ADRESSE_LIVRAISON, true));
    }
}

