/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class ProgressPrintingFrame
extends JFrame {
    final JProgressBar progress = new JProgressBar(0, 100);
    final JLabel label;
    final JButton cancel = new JButton("Annluer");
    private boolean cancelled;

    public ProgressPrintingFrame(Window parent, final PrinterJob printJob, String title, String message, int minWidth) {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.label = new JLabel(message, 2);
        c.weightx = 1.0;
        c.fill = 2;
        p.add((Component)this.label, c);
        ++c.gridy;
        p.add((Component)this.progress, c);
        c.weightx = 1.0;
        c.fill = 0;
        ++c.gridy;
        c.anchor = 14;
        p.add((Component)this.cancel, c);
        this.setContentPane(p);
        this.setTitle(title);
        this.pack();
        this.setResizable(false);
        if (p.getWidth() < minWidth) {
            this.setSize(minWidth, this.getHeight());
        }
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressPrintingFrame.this.cancelled = true;
                printJob.cancel();
                ProgressPrintingFrame.this.dispose();
            }
        });
        this.setDefaultCloseOperation(0);
        this.setAlwaysOnTop(true);
    }

    public void setProgress(int percent) {
        this.progress.setValue(percent);
        if (percent >= 100) {
            this.dispose();
        }
    }

    public void setMessage(String m) {
        this.label.setText(m);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

