/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.supplier.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.GestionDevise;

public class HistoriqueFournBilanPanel
extends JPanel {
    private static String CHEQUE = " ch\u00e8que pour un total de ";
    private static String CHEQUES = " ch\u00e8ques pour un total de ";
    private static String NON_DECAISSE = " non d\u00e9caiss\u00e9";
    private static String NON_DECAISSES = " non d\u00e9caiss\u00e9s";
    private static String ACHAT = " achat pour un total de ";
    private static String ACHATS = " achats pour un total de ";
    private JLabel labelCheque = new JLabel();
    private JLabel labelAchat = new JLabel();

    public HistoriqueFournBilanPanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        this.add((Component)this.labelCheque, c);
        ++c.gridy;
        this.add((Component)this.labelAchat, c);
        this.updateData(-1);
    }

    public void updateData(final int idFournisseur) {
        new Thread(){

            @Override
            public void run() {
                HistoriqueFournBilanPanel.this.updateChequeData(idFournisseur);
                HistoriqueFournBilanPanel.this.updateAchatData(idFournisseur);
            }
        }.start();
    }

    private void updateChequeData(int idFournisseur) {
        List lnb;
        SQLBase base = ((ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance()).getSQLBaseSociete();
        SQLTable tableC = base.getTable("CHEQUE_FOURNISSEUR");
        final long valueTotal = this.getSumForField(tableC.getField("MONTANT"), idFournisseur);
        SQLSelect selNb = new SQLSelect(base);
        selNb.addSelectStar(tableC);
        if (idFournisseur > 1) {
            selNb.setWhere(tableC.getField("ID_FOURNISSEUR"), "=", idFournisseur);
        }
        final int nombreCheque = (lnb = (List)base.getDataSource().execute(selNb.asString(), new ArrayListHandler())) == null ? 0 : lnb.size();
        SQLSelect sel = new SQLSelect(base);
        sel.addSelectStar(tableC);
        Where w = new Where((FieldRef)tableC.getField("DECAISSE"), "=", (Object)Boolean.FALSE);
        if (idFournisseur > 1) {
            w = w.and(new Where((FieldRef)tableC.getField("ID_FOURNISSEUR"), "=", idFournisseur));
        }
        sel.setWhere(w);
        List l = (List)base.getDataSource().execute(sel.asString(), new ArrayListHandler());
        final int valueNonEncaisse = l == null ? 0 : l.size();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String labelCheques = String.valueOf(nombreCheque);
                labelCheques = nombreCheque > 1 ? String.valueOf(labelCheques) + CHEQUES : String.valueOf(labelCheques) + CHEQUE;
                labelCheques = String.valueOf(labelCheques) + GestionDevise.currencyToString(valueTotal, true) + " \u20ac TTC";
                labelCheques = valueNonEncaisse > 1 ? String.valueOf(labelCheques) + " dont " + String.valueOf(valueNonEncaisse) + NON_DECAISSES : String.valueOf(labelCheques) + " dont " + String.valueOf(valueNonEncaisse) + NON_DECAISSE;
                HistoriqueFournBilanPanel.this.labelCheque.setText(labelCheques);
            }
        });
    }

    private void updateAchatData(int idFournisseur) {
        List lnb;
        SQLBase base = ((ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance()).getSQLBaseSociete();
        SQLTable tableC = base.getTable("SAISIE_ACHAT");
        final long valueTotal = this.getSumForField(tableC.getField("MONTANT_TTC"), idFournisseur);
        SQLSelect selNb = new SQLSelect(base);
        selNb.addSelectStar(tableC);
        if (idFournisseur > 1) {
            selNb.setWhere(tableC.getField("ID_FOURNISSEUR"), "=", idFournisseur);
        }
        final int nombreAchat = (lnb = (List)base.getDataSource().execute(selNb.asString(), new ArrayListHandler())) == null ? 0 : lnb.size();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String labelAchats = String.valueOf(nombreAchat);
                labelAchats = nombreAchat > 1 ? String.valueOf(labelAchats) + ACHATS : String.valueOf(labelAchats) + ACHAT;
                labelAchats = String.valueOf(labelAchats) + GestionDevise.currencyToString(valueTotal, true) + " \u20ac TTC";
                HistoriqueFournBilanPanel.this.labelAchat.setText(labelAchats);
            }
        });
    }

    private long getSumForField(SQLField f, int idFourn) {
        SQLSelect sel = new SQLSelect(f.getTable().getBase());
        sel.addSelect(f, "SUM");
        if (idFourn > 1) {
            sel.setWhere(f.getTable().getField("ID_FOURNISSEUR"), "=", idFourn);
        }
        List l = (List)f.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
        int i = 0;
        while (i < l.size()) {
            Object[] tmp = (Object[])l.get(i);
            if (tmp != null && tmp[0] != null) {
                return new Double(tmp[0].toString()).longValue();
            }
            ++i;
        }
        return 0L;
    }
}

