/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.action;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Set;
import javax.swing.JFrame;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.PathBuilder;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.table.PercentTableCellRenderer;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;

public class ListeDesCommandesAction
extends CreateFrameAbstractAction {
    public ListeDesCommandesAction() {
        this.putValue("Name", "Liste des commandes fournisseurs");
    }

    public JFrame createFrame() {
        final SQLElement elementCmd = Configuration.getInstance().getDirectory().getElement("COMMANDE");
        SQLTableModelSourceOnline tableSource = elementCmd.getTableSource(true);
        BaseSQLTableModelColumn colAvancement = new BaseSQLTableModelColumn("Avancement r\u00e9ception", BigDecimal.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                return ListeDesCommandesAction.this.getAvancement(r);
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = ((PathBuilder)((PathBuilder)new PathBuilder(elementCmd.getTable()).addTable("TR_COMMANDE")).addTable("BON_RECEPTION")).build();
                return CollectionUtils.createSet(new FieldPath(p, "TOTAL_HT"));
            }
        };
        tableSource.getColumns().add(colAvancement);
        colAvancement.setRenderer(new PercentTableCellRenderer());
        IListFrame frame = new IListFrame(new ListeAddPanel(elementCmd, new IListe(tableSource)));
        return frame;
    }

    private BigDecimal getAvancement(SQLRowAccessor r) {
        Collection<? extends SQLRowAccessor> rows = r.getReferentRows(r.getTable().getTable("TR_COMMANDE"));
        long totalFact = 0L;
        long total = r.getLong("T_HT");
        for (SQLRowAccessor sQLRowAccessor : rows) {
            if (sQLRowAccessor.isForeignEmpty("ID_BON_RECEPTION")) continue;
            SQLRowAccessor rowFact = sQLRowAccessor.getForeign("ID_BON_RECEPTION");
            Long l = rowFact.getLong("TOTAL_HT");
            totalFact += l.longValue();
        }
        if (total > 0L) {
            return new BigDecimal(totalFact).divide(new BigDecimal(total), DecimalUtils.HIGH_PRECISION).movePointRight(2).setScale(2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ONE.movePointRight(2);
    }
}

