/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.shipment.ui;

import java.awt.Component;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.AbstractVenteArticleItemTable;
import org.openconcerto.erp.core.common.ui.Acompte;
import org.openconcerto.erp.core.common.ui.AcompteCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNumericHTConvertorCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseTableCellRenderer;
import org.openconcerto.erp.core.common.ui.QteCellEditor;
import org.openconcerto.erp.core.common.ui.Remise;
import org.openconcerto.erp.core.finance.accounting.model.CurrencyConverter;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.ui.ArticleRowValuesRenderer;
import org.openconcerto.erp.core.sales.product.ui.QteUnitRowValuesRenderer;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.sqlobject.ITextArticleWithCompletionCellEditor;
import org.openconcerto.sql.view.list.AutoCompletionManager;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.sql.view.list.SQLTextComboTableCellEditor;
import org.openconcerto.sql.view.list.ValidStateChecker;
import org.openconcerto.ui.table.XTableColumnModel;
import org.openconcerto.utils.DecimalUtils;

public class BonDeLivraisonItemTable
extends AbstractVenteArticleItemTable {
    private SQLTableElement tableElementPoidsTotalLivree;
    private SQLTable tableArticle = Configuration.getInstance().getBase().getTable("ARTICLE");

    public BonDeLivraisonItemTable(List<JButton> l) {
        super(l);
    }

    @Override
    protected void init() {
        SQLElement e = this.getSQLElement();
        SQLPreferences prefs = new SQLPreferences(this.getSQLElement().getTable().getDBRoot());
        boolean selectArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.USE_CREATED_ARTICLE, false);
        boolean createAuto = prefs.getBoolean(GestionArticleGlobalPreferencePanel.CREATE_ARTICLE_AUTO, true);
        final boolean filterFamilleArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.FILTER_BY_FAMILY, false);
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        list.add(new SQLTableElement(e.getTable().getField("ID_STYLE")));
        SQLTableElement tableFamille = new SQLTableElement(e.getTable().getField("ID_FAMILLE_ARTICLE"));
        list.add(tableFamille);
        SQLTableElement tableElementArticle = new SQLTableElement(e.getTable().getField("ID_ARTICLE"), true, true, true);
        list.add(tableElementArticle);
        SQLTableElement tableElementCode = new SQLTableElement(e.getTable().getField("CODE"), String.class, new ITextArticleWithCompletionCellEditor(e.getTable().getTable("ARTICLE"), e.getTable().getTable("ARTICLE_FOURNISSEUR")));
        list.add(tableElementCode);
        SQLTableElement tableElementNom = new SQLTableElement(e.getTable().getField("NOM"));
        list.add(tableElementNom);
        SQLTableElement tableElementDesc = new SQLTableElement(e.getTable().getField("DESCRIPTIF"));
        list.add(tableElementDesc);
        SQLTableElement tableElement_ValeurMetrique2 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_2"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && (modeNumber.intValue() == 5 || modeNumber.intValue() == 4 || modeNumber.intValue() == 2)) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique2);
        SQLTableElement tableElement_ValeurMetrique3 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_3"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && modeNumber.intValue() != 4) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique3);
        SQLTableElement tableElement_ValeurMetrique1 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_1"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && (modeNumber.intValue() == 5 || modeNumber.intValue() == 4 || modeNumber.intValue() == 6)) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique1);
        SQLField field = e.getTable().getField("PRIX_METRIQUE_VT_1");
        final DeviseNumericHTConvertorCellEditor editorPVHT = new DeviseNumericHTConvertorCellEditor(field);
        SQLTableElement tableElement_PrixMetrique1_VenteHT = new SQLTableElement(field, BigDecimal.class, editorPVHT);
        tableElement_PrixMetrique1_VenteHT.setRenderer(new DeviseTableCellRenderer());
        list.add(tableElement_PrixMetrique1_VenteHT);
        SQLTableElement eltDevise = null;
        SQLTableElement eltUnitDevise = null;
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            eltDevise = new SQLTableElement(e.getTable().getField("ID_DEVISE"));
            list.add(eltDevise);
            eltUnitDevise = new SQLTableElement(e.getTable().getField("PV_U_DEVISE"), BigDecimal.class){

                @Override
                public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                    return BonDeLivraisonItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
                }
            };
            eltUnitDevise.setRenderer(new DeviseTableCellRenderer());
            list.add(eltUnitDevise);
        }
        SQLTableElement qteU = new SQLTableElement(e.getTable().getField("QTE_UNITAIRE"), BigDecimal.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                SQLRowAccessor row = vals.getForeign("ID_UNITE_VENTE");
                if (row != null && !row.isUndefined() && row.getBoolean("A_LA_PIECE").booleanValue()) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex);
            }

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new QteUnitRowValuesRenderer();
            }
        };
        list.add(qteU);
        SQLTableElement uniteVente = new SQLTableElement(e.getTable().getField("ID_UNITE_VENTE"));
        list.add(uniteVente);
        this.qte = new SQLTableElement(e.getTable().getField("QTE"), Integer.class, new QteCellEditor()){

            @Override
            protected Object getDefaultNullValue() {
                return 0;
            }
        };
        list.add(this.qte);
        SQLTableElement tableElement_ModeVente = new SQLTableElement(e.getTable().getField("ID_MODE_VENTE_ARTICLE"));
        list.add(tableElement_ModeVente);
        final SQLTableElement tableElement_PrixVente_HT = new SQLTableElement(e.getTable().getField("PV_HT"), BigDecimal.class);
        tableElement_PrixVente_HT.setRenderer(new DeviseTableCellRenderer());
        list.add(tableElement_PrixVente_HT);
        this.tableElementTVA = new SQLTableElement(e.getTable().getField("ID_TAXE"));
        list.add(this.tableElementTVA);
        SQLTableElement tableElement_QuantiteLivree = new SQLTableElement(e.getTable().getField("QTE_LIVREE"), Integer.class);
        list.add(tableElement_QuantiteLivree);
        SQLTableElement tableElementPoids = new SQLTableElement(e.getTable().getField("POIDS"), Float.class);
        list.add(tableElementPoids);
        this.tableElementPoidsTotal = new SQLTableElement(e.getTable().getField("T_POIDS"), Float.class);
        list.add(this.tableElementPoidsTotal);
        this.tableElementPoidsTotalLivree = new SQLTableElement(e.getTable().getField("T_POIDS_LIVREE"), Float.class);
        list.add(this.tableElementPoidsTotalLivree);
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.ITEM_PACKAGING, false)) {
            SQLTableElement poidsColis = new SQLTableElement(e.getTable().getField("POIDS_COLIS_NET"), BigDecimal.class);
            list.add(poidsColis);
            SQLTableElement nbColis = new SQLTableElement(e.getTable().getField("NB_COLIS"), Integer.class);
            list.add(nbColis);
            final SQLTableElement totalPoidsColis = new SQLTableElement(e.getTable().getField("T_POIDS_COLIS_NET"), BigDecimal.class);
            list.add(totalPoidsColis);
            poidsColis.addModificationListener(totalPoidsColis);
            nbColis.addModificationListener(totalPoidsColis);
            totalPoidsColis.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    Object o2 = row.getObject("POIDS_COLIS_NET");
                    Object o3 = row.getObject("NB_COLIS");
                    if (o2 != null && o3 != null) {
                        BigDecimal poids = (BigDecimal)o2;
                        int nb = (Integer)o3;
                        return poids.multiply(new BigDecimal(nb), DecimalUtils.HIGH_PRECISION).setScale(totalPoidsColis.getDecimalDigits(), RoundingMode.HALF_UP);
                    }
                    return row.getObject("T_POIDS_COLIS_NET");
                }
            });
        }
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            this.tableElementTotalDevise = new SQLTableElement(e.getTable().getField("PV_T_DEVISE"), BigDecimal.class){

                @Override
                public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                    return BonDeLivraisonItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
                }
            };
            this.tableElementTotalDevise.setRenderer(new DeviseTableCellRenderer());
            list.add(this.tableElementTotalDevise);
        }
        SQLField fieldRemise = e.getTable().getField("POURCENT_REMISE");
        if (e.getTable().getFieldsName().contains("MONTANT_REMISE")) {
            this.tableElementRemise = new SQLTableElement(e.getTable().getField("POURCENT_REMISE"), Acompte.class, new AcompteCellEditor("POURCENT_REMISE", "MONTANT_REMISE")){

                @Override
                public void setValueFrom(SQLRowValues row, Object value) {
                    if (value != null) {
                        Acompte a = (Acompte)value;
                        row.put("MONTANT_REMISE", a.getMontant());
                        row.put("POURCENT_REMISE", a.getPercent());
                    } else {
                        row.put("MONTANT_REMISE", null);
                        row.put("POURCENT_REMISE", BigDecimal.ZERO);
                    }
                    this.fireModification(row);
                }
            };
            this.tableElementRemise.setRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    SQLRowValues rowVals = ((RowValuesTable)table).getRowValuesTableModel().getRowValuesAt(row);
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    BigDecimal percent = rowVals.getBigDecimal("POURCENT_REMISE");
                    BigDecimal amount = rowVals.getBigDecimal("MONTANT_REMISE");
                    Remise a = new Remise(percent, amount);
                    label.setText(a.toPlainString(true));
                    return label;
                }
            });
        } else {
            this.tableElementRemise = new SQLTableElement(fieldRemise){

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }
            };
        }
        list.add(this.tableElementRemise);
        this.totalHT = new SQLTableElement(e.getTable().getField("T_PV_HT"), BigDecimal.class);
        this.totalHT.setRenderer(new DeviseTableCellRenderer());
        list.add(this.totalHT);
        this.tableElementTotalTTC = new SQLTableElement(e.getTable().getField("T_PV_TTC"), BigDecimal.class);
        this.tableElementTotalTTC.setRenderer(new DeviseTableCellRenderer());
        list.add(this.tableElementTotalTTC);
        SQLRowValues defautRow = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(e.getTable()));
        defautRow.put("ID_TAXE", TaxeCache.getCache().getFirstTaxe().getID());
        defautRow.put("CODE", "");
        defautRow.put("NOM", "");
        RowValuesTableModel model = new RowValuesTableModel(e, list, e.getTable().getField("NOM"), false, defautRow);
        this.setModel(model);
        this.table = new RowValuesTable(model, this.getConfigurationFile());
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        if (filterFamilleArticle) {
            ((SQLTextComboTableCellEditor)tableElementArticle.getTableCellEditor(this.table)).setDynamicWhere(e.getTable().getTable("ARTICLE").getField("ID_FAMILLE_ARTICLE"));
        }
        ArrayList<String> completionField = new ArrayList<String>();
        final SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            completionField.add("CODE_DOUANIER");
        }
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            completionField.add("ID_PAYS");
        }
        completionField.add("ID_UNITE_VENTE");
        completionField.add("PA_HT");
        completionField.add("PV_HT");
        completionField.add("ID_TAXE");
        completionField.add("POIDS");
        completionField.add("PRIX_METRIQUE_HA_1");
        completionField.add("PRIX_METRIQUE_HA_2");
        completionField.add("PRIX_METRIQUE_HA_3");
        completionField.add("VALEUR_METRIQUE_1");
        completionField.add("VALEUR_METRIQUE_2");
        completionField.add("VALEUR_METRIQUE_3");
        completionField.add("ID_MODE_VENTE_ARTICLE");
        completionField.add("PRIX_METRIQUE_VT_1");
        completionField.add("PRIX_METRIQUE_VT_2");
        completionField.add("PRIX_METRIQUE_VT_3");
        completionField.add("SERVICE");
        completionField.add("ID_FAMILLE_ARTICLE");
        if (this.getSQLElement().getTable().getFieldsName().contains("DESCRIPTIF")) {
            completionField.add("DESCRIPTIF");
        }
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            completionField.add("ID_DEVISE");
        }
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            completionField.add("PV_U_DEVISE");
        }
        if (this.getSQLElement().getTable().getFieldsName().contains("QTE_ACHAT") && sqlTableArticle.getTable().getFieldsName().contains("QTE_ACHAT")) {
            completionField.add("QTE_ACHAT");
        }
        final AutoCompletionManager m = new AutoCompletionManager(tableElementCode, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("ARTICLE.CODE"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
                Object res = BonDeLivraisonItemTable.this.tarifCompletion(row, field, rowDest, true);
                if (res == null) {
                    return super.getValueFrom(row, field, rowDest);
                }
                return res;
            }
        };
        m.fill("NOM", "NOM");
        m.fill("ID", "ID_ARTICLE");
        for (String string : completionField) {
            m.fill(string, string);
        }
        final Where w = new Where((FieldRef)sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE);
        m.setWhere(w);
        final AutoCompletionManager m2 = new AutoCompletionManager(tableElementNom, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("ARTICLE.NOM"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
                Object res = BonDeLivraisonItemTable.this.tarifCompletion(row, field, rowDest, true);
                if (res == null) {
                    return super.getValueFrom(row, field, rowDest);
                }
                return res;
            }
        };
        m2.fill("CODE", "CODE");
        m2.fill("ID", "ID_ARTICLE");
        for (String string : completionField) {
            m2.fill(string, string);
        }
        m2.setWhere(w);
        AutoCompletionManager m3 = new AutoCompletionManager(tableElementArticle, sqlTableArticle.getField("NOM"), this.table, this.table.getRowValuesTableModel(), 2, true, true, new ValidStateChecker()){

            @Override
            protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
                Object res = BonDeLivraisonItemTable.this.tarifCompletion(row, field, rowDest, true);
                if (res == null) {
                    return super.getValueFrom(row, field, rowDest);
                }
                return res;
            }
        };
        m3.fill("CODE", "CODE");
        m3.fill("NOM", "NOM");
        for (String string : completionField) {
            m3.fill(string, string);
        }
        m3.setWhere(w);
        this.qte.addModificationListener(tableElement_PrixMetrique1_VenteHT);
        this.qte.addModificationListener(this.totalHT);
        qteU.addModificationListener(this.totalHT);
        this.tableElementRemise.addModificationListener(this.totalHT);
        tableElement_PrixVente_HT.addModificationListener(this.totalHT);
        this.totalHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                System.out.println("Compute totalHT");
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal f = (BigDecimal)row.getObject("PV_HT");
                System.out.println("Qte:" + qte + " et PV_HT:" + f);
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte)), DecimalUtils.HIGH_PRECISION).setScale(BonDeLivraisonItemTable.this.totalHT.getDecimalDigits(), 4);
                if (row.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                    BigDecimal acomptePercent = row.getBigDecimal("POURCENT_REMISE");
                    BigDecimal acompteMontant = row.getBigDecimal("MONTANT_REMISE");
                    Remise remise = new Remise(acomptePercent, acompteMontant);
                    r = remise.getResultFrom(r);
                }
                return r;
            }
        });
        this.qte.addModificationListener(this.tableElementTotalTTC);
        qteU.addModificationListener(this.tableElementTotalTTC);
        tableElement_PrixVente_HT.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTVA.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTotalTTC.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                BigDecimal f = (BigDecimal)row.getObject("T_PV_HT");
                int idTaux = Integer.parseInt(row.getObject("ID_TAXE").toString());
                Float resultTaux = TaxeCache.getCache().getTauxFromId(idTaux);
                float taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                editorPVHT.setTaxe(taux);
                BigDecimal r = f.multiply(BigDecimal.ONE.add(BigDecimal.valueOf(taux).movePointLeft(2)), DecimalUtils.HIGH_PRECISION).setScale(6, 4);
                return r.setScale(BonDeLivraisonItemTable.this.tableElementTotalTTC.getDecimalDigits(), 4);
            }
        });
        tableElement_ValeurMetrique1.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique2.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique3.addModificationListener(tableElementPoids);
        tableElementPoids.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                return new Float(ReferenceArticleSQLElement.getPoidsFromDetails(row));
            }
        });
        tableElementPoids.addModificationListener(this.tableElementPoidsTotal);
        this.qte.addModificationListener(this.tableElementPoidsTotal);
        qteU.addModificationListener(this.tableElementPoidsTotal);
        this.tableElementPoidsTotal.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                Number f = (Number)row.getObject("POIDS");
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                return Float.valueOf(b.multiply(new BigDecimal(f.floatValue() * (float)qte)).floatValue());
            }
        });
        tableElementPoids.addModificationListener(this.tableElementPoidsTotalLivree);
        tableElement_QuantiteLivree.addModificationListener(this.tableElementPoidsTotalLivree);
        this.tableElementPoidsTotalLivree.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                Number f = (Number)row.getObject("POIDS");
                Object qteOb = row.getObject("QTE_LIVREE");
                int qte = qteOb == null ? 0 : Integer.parseInt(qteOb.toString());
                float fValue = f == null ? 0.0f : f.floatValue();
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                return Float.valueOf(b.multiply(new BigDecimal(fValue * (float)qte)).floatValue());
            }
        });
        tableElement_PrixMetrique1_VenteHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (source != null && source.getField().getName().equals("PRIX_METRIQUE_VT_1")) {
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
                if (source != null && source.getField().getName().equals("PV_U_DEVISE")) {
                    if (!row.isForeignEmpty("ID_DEVISE")) {
                        String devCode = row.getForeign("ID_DEVISE").getString("CODE");
                        BigDecimal bigDecimal = (BigDecimal)row.getObject("PV_U_DEVISE");
                        CurrencyConverter c = new CurrencyConverter();
                        BigDecimal result = c.convert(bigDecimal, devCode, c.getCompanyCurrencyCode(), new Date(), true);
                        return result;
                    }
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
                return BonDeLivraisonItemTable.this.tarifCompletion(row.getForeign("ID_ARTICLE"), "PRIX_METRIQUE_VT_1", row);
            }
        });
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            if (eltUnitDevise != null) {
                eltUnitDevise.addModificationListener(tableElement_PrixMetrique1_VenteHT);
            }
            if (eltUnitDevise != null) {
                tableElement_PrixMetrique1_VenteHT.addModificationListener(eltUnitDevise);
                this.tableElementRemise.addModificationListener(this.tableElementTotalDevise);
                eltUnitDevise.setModifier(new CellDynamicModifier(){

                    @Override
                    public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                        if (source != null && source.getField().getName().equals("PV_U_DEVISE")) {
                            return row.getObject("PV_U_DEVISE");
                        }
                        if (!row.isForeignEmpty("ID_DEVISE")) {
                            String devCode = row.getForeign("ID_DEVISE").getString("CODE");
                            BigDecimal bigDecimal = (BigDecimal)row.getObject("PRIX_METRIQUE_VT_1");
                            CurrencyConverter c = new CurrencyConverter();
                            BigDecimal result = c.convert(bigDecimal, c.getCompanyCurrencyCode(), devCode, new Date(), true);
                            return result;
                        }
                        if (source != null && source.getField().getName().equalsIgnoreCase("PRIX_METRIQUE_VT_1")) {
                            return row.getObject("PRIX_METRIQUE_VT_1");
                        }
                        return row.getObject("PV_U_DEVISE");
                    }
                });
                this.tableElementRemise.addModificationListener(this.tableElementTotalDevise);
                this.tableElementTotalDevise.setModifier(new CellDynamicModifier(){

                    @Override
                    public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                        int qte = row.getInt("QTE");
                        BigDecimal prixDeVenteUnitaireDevise = row.getObject("PV_U_DEVISE") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PV_U_DEVISE");
                        BigDecimal qUnitaire = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                        BigDecimal prixVente = qUnitaire.multiply(prixDeVenteUnitaireDevise.multiply(BigDecimal.valueOf(qte), DecimalUtils.HIGH_PRECISION), DecimalUtils.HIGH_PRECISION);
                        if (row.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                            BigDecimal acomptePercent = row.getBigDecimal("POURCENT_REMISE");
                            BigDecimal acompteMontant = row.getBigDecimal("MONTANT_REMISE");
                            Remise remise = new Remise(acomptePercent, acompteMontant);
                            prixVente = remise.getResultFrom(prixVente);
                        }
                        return prixVente.setScale(BonDeLivraisonItemTable.this.tableElementTotalDevise.getDecimalDigits(), 4);
                    }
                });
            }
        }
        tableElement_ValeurMetrique1.addModificationListener(tableElement_PrixVente_HT);
        tableElement_ValeurMetrique2.addModificationListener(tableElement_PrixVente_HT);
        tableElement_ValeurMetrique3.addModificationListener(tableElement_PrixVente_HT);
        tableElement_PrixMetrique1_VenteHT.addModificationListener(tableElement_PrixVente_HT);
        tableElement_PrixVente_HT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (row.getInt("ID_MODE_VENTE_ARTICLE") == 5) {
                    System.err.println("Don't computeValue PV_HT --> " + row.getObject("PV_HT") + row);
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
                BigDecimal prixVTFromDetails = ReferenceArticleSQLElement.getPrixVTFromDetails(row);
                System.out.println("Prix de vente calcul\u00e9 au d\u00e9tail:" + prixVTFromDetails);
                return prixVTFromDetails.setScale(tableElement_PrixVente_HT.getDecimalDigits(), RoundingMode.HALF_UP);
            }
        });
        this.table.readState();
        tableFamille.addModificationListener(tableElementArticle);
        tableElementCode.addModificationListener(tableElementArticle);
        tableElementArticle.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                SQLRowAccessor foreign;
                if (filterFamilleArticle) {
                    if (row.isForeignEmpty("ID_FAMILLE_ARTICLE")) {
                        m.setWhere(w);
                        m2.setWhere(w);
                    } else {
                        m.setWhere(w.and(new Where((FieldRef)sqlTableArticle.getField("ID_FAMILLE_ARTICLE"), "=", row.getForeignID("ID_FAMILLE_ARTICLE"))));
                        m2.setWhere(w.and(new Where((FieldRef)sqlTableArticle.getField("ID_FAMILLE_ARTICLE"), "=", row.getForeignID("ID_FAMILLE_ARTICLE"))));
                    }
                }
                if ((foreign = row.getForeign("ID_ARTICLE")) != null && !foreign.isUndefined() && foreign.getObject("CODE") != null && foreign.getString("CODE").equals(row.getString("CODE"))) {
                    return foreign.getID();
                }
                return BonDeLivraisonItemTable.this.tableArticle.getUndefinedID();
            }
        });
        String valModeAvanceVt = DefaultNXProps.getInstance().getStringProperty("ArticleModeVenteAvance");
        Boolean bModeAvance = Boolean.valueOf(valModeAvanceVt);
        if (bModeAvance != null && !bModeAvance.booleanValue()) {
            this.hideColumn(model.getColumnForField("VALEUR_METRIQUE_1"));
            this.hideColumn(model.getColumnForField("VALEUR_METRIQUE_2"));
            this.hideColumn(model.getColumnForField("VALEUR_METRIQUE_3"));
            this.hideColumn(model.getColumnForField("PV_HT"));
            this.hideColumn(model.getColumnForField("ID_MODE_VENTE_ARTICLE"));
        }
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.ITEM_PACKAGING, false)) {
            this.setColumnVisible(model.getColumnForField("T_POIDS_COLIS_NET"), false);
        }
        this.setColumnVisible(model.getColumnForField("ID_ARTICLE"), selectArticle);
        this.setColumnVisible(model.getColumnForField("CODE"), !selectArticle || selectArticle && createAuto);
        this.setColumnVisible(model.getColumnForField("NOM"), !selectArticle || selectArticle && createAuto);
        this.setColumnVisible(this.getModel().getColumnForField("ID_FAMILLE_ARTICLE"), filterFamilleArticle);
        boolean gestionUV = prefs.getBoolean(GestionArticleGlobalPreferencePanel.UNITE_VENTE, true);
        this.setColumnVisible(model.getColumnForField("QTE_UNITAIRE"), gestionUV);
        this.setColumnVisible(model.getColumnForField("ID_UNITE_VENTE"), gestionUV);
        this.table.writeState();
    }

    @Override
    public float getPoidsTotal() {
        float poids = 0.0f;
        int poidsTColIndex = this.getModel().getColumnIndexForElement(this.tableElementPoidsTotalLivree);
        if (poidsTColIndex >= 0) {
            int i = 0;
            while (i < this.table.getRowCount()) {
                Number tmp = (Number)this.getModel().getValueAt(i, poidsTColIndex);
                if (tmp != null) {
                    poids += tmp.floatValue();
                }
                ++i;
            }
        }
        return poids;
    }

    @Override
    protected String getConfigurationFileName() {
        return "Table_Bon_Livraison.xml";
    }

    @Override
    public SQLElement getSQLElement() {
        return Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON_ELEMENT");
    }

    private void hideColumn(int col) {
        if (col >= 0) {
            XTableColumnModel columnModel = this.table.getColumnModel();
            columnModel.setColumnVisible(columnModel.getColumnByModelIndex(col), false);
        }
    }
}

