/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.sales.invoice.ui.DateEnvoiRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.PathBuilder;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.PercentTableCellRenderer;
import org.openconcerto.ui.table.TimestampTableCellEditor;
import org.openconcerto.ui.table.TimestampTableCellRenderer;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.SwingWorker2;
import org.openconcerto.utils.Tuple2;

public class ListeDesDevisPanel
extends JPanel {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private Map<Integer, ListeAddPanel> map = new HashMap<Integer, ListeAddPanel>();
    private SQLElement eltDevis = Configuration.getInstance().getDirectory().getElement("DEVIS");
    private SQLElement eltEtatDevis = Configuration.getInstance().getDirectory().getElement("ETAT_DEVIS");

    public ListeDesDevisPanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        ListeAddPanel panelAll = this.createPanel(-1);
        this.map.put(this.tabbedPane.getTabCount(), panelAll);
        this.tabbedPane.add("Tous", panelAll);
        ListeAddPanel panelCours = this.createPanel(5);
        this.map.put(this.tabbedPane.getTabCount(), panelCours);
        this.tabbedPane.add("  ", panelCours);
        ListeAddPanel panelAttente = this.createPanel(2);
        this.map.put(this.tabbedPane.getTabCount(), panelAttente);
        this.tabbedPane.add("  ", panelAttente);
        ListeAddPanel panelAccepte = this.createPanel(4);
        this.map.put(this.tabbedPane.getTabCount(), panelAccepte);
        this.tabbedPane.add("  ", panelAccepte);
        ListeAddPanel panelRefuse = this.createPanel(3);
        this.map.put(this.tabbedPane.getTabCount(), panelRefuse);
        this.tabbedPane.add("  ", panelRefuse);
        HashMap<IListe, SQLField> mapDate = new HashMap<IListe, SQLField>();
        this.tabbedPane.setSelectedIndex(1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        this.add((Component)this.tabbedPane, c);
        mapDate.put(panelAttente.getListe(), this.eltDevis.getTable().getField("DATE"));
        mapDate.put(panelAccepte.getListe(), this.eltDevis.getTable().getField("DATE"));
        mapDate.put(panelRefuse.getListe(), this.eltDevis.getTable().getField("DATE"));
        mapDate.put(panelCours.getListe(), this.eltDevis.getTable().getField("DATE"));
        mapDate.put(panelAll.getListe(), this.eltDevis.getTable().getField("DATE"));
        IListFilterDatePanel datePanel = new IListFilterDatePanel(mapDate, IListFilterDatePanel.getDefaultMap());
        ++c.gridy;
        c.anchor = 10;
        c.weighty = 0.0;
        datePanel.setFilterOnDefault();
        this.add((Component)datePanel, c);
        this.initTabTitles();
    }

    private void initTabTitles() {
        SwingWorker2<List<String>, Object> worker = new SwingWorker2<List<String>, Object>(){

            @Override
            protected List<String> doInBackground() throws Exception {
                SQLSelect quoteStates = new SQLSelect();
                SQLTable quoteStatesTable = ListeDesDevisPanel.this.eltEtatDevis.getTable();
                quoteStates.addSelect(quoteStatesTable.getKey());
                quoteStates.addSelect(quoteStatesTable.getField("NOM"));
                List<Integer> labelIds = Arrays.asList(5, 2, 4, 3);
                quoteStates.setWhere(new Where((FieldRef)quoteStatesTable.getKey(), true, labelIds));
                List values = quoteStatesTable.getDBSystemRoot().getDataSource().execute(quoteStates.asString());
                ArrayList<String> tabNames = new ArrayList<String>();
                String keyFieldName = quoteStatesTable.getKey().getName();
                block0: for (Integer id : labelIds) {
                    for (Map m : values) {
                        if (!m.get(keyFieldName).equals(id)) continue;
                        tabNames.add(m.get("NOM").toString());
                        continue block0;
                    }
                }
                return tabNames;
            }

            @Override
            protected void done() {
                try {
                    List tabNames = (List)this.get();
                    int index = 0;
                    while (index < tabNames.size()) {
                        ListeDesDevisPanel.this.tabbedPane.setTitleAt(index + 1, (String)tabNames.get(index));
                        ++index;
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle("Unable to set tab names", e);
                }
            }
        };
        worker.execute();
    }

    protected void setRenderer(SQLTableModelSourceOnline source) {
        SQLTableModelColumn column = source.getColumn(this.eltDevis.getTable().getField("DUNNING_DATE"));
        if (column != null) {
            column.setRenderer(new TimestampTableCellRenderer(false, false){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (value != null) {
                        Calendar calToDay = Calendar.getInstance();
                        Date d = (Date)value;
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(d);
                        if (cal.get(5) == calToDay.get(5) && cal.get(2) == calToDay.get(2) && cal.get(1) == calToDay.get(1)) {
                            c.setBackground(Color.green);
                        } else if (cal.before(calToDay)) {
                            c.setBackground(Color.red);
                        }
                    }
                    return c;
                }
            });
        }
    }

    private BigDecimal getAvancementCommande(SQLRowAccessor r) {
        Collection<? extends SQLRowAccessor> rows = r.getReferentRows(r.getTable().getTable("TR_DEVIS"));
        long totalFact = 0L;
        long total = r.getLong("T_HT");
        for (SQLRowAccessor sQLRowAccessor : rows) {
            if (sQLRowAccessor.isForeignEmpty("ID_COMMANDE_CLIENT")) continue;
            SQLRowAccessor rowFact = sQLRowAccessor.getForeign("ID_COMMANDE_CLIENT");
            Long l = rowFact.getLong("T_HT");
            totalFact += l.longValue();
        }
        if (total > 0L) {
            return new BigDecimal(totalFact).divide(new BigDecimal(total), DecimalUtils.HIGH_PRECISION).movePointRight(2).setScale(2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ONE.movePointRight(2);
    }

    private BigDecimal getAvancementFacture(SQLRowAccessor r) {
        Long l;
        SQLRowAccessor rowFact;
        Collection<? extends SQLRowAccessor> rows = r.getReferentRows(r.getTable().getTable("TR_DEVIS"));
        long totalFact = 0L;
        long total = r.getLong("T_HT");
        ArrayList<SQLRowAccessor> rowsCmd = new ArrayList<SQLRowAccessor>();
        for (SQLRowAccessor sQLRowAccessor : rows) {
            if (!sQLRowAccessor.isForeignEmpty("ID_SAISIE_VENTE_FACTURE")) {
                SQLRowAccessor rowFact2 = sQLRowAccessor.getForeign("ID_SAISIE_VENTE_FACTURE");
                Long l2 = rowFact2.getLong("T_HT");
                totalFact += l2.longValue();
            }
            if (sQLRowAccessor.isForeignEmpty("ID_COMMANDE_CLIENT")) continue;
            rowsCmd.add(sQLRowAccessor.getForeign("ID_COMMANDE_CLIENT"));
        }
        ArrayList<SQLRowAccessor> arrayList = new ArrayList<SQLRowAccessor>();
        for (SQLRowAccessor row : rowsCmd) {
            Collection<? extends SQLRowAccessor> rowsTrCmd = row.getReferentRows(r.getTable().getTable("TR_COMMANDE_CLIENT"));
            for (SQLRowAccessor sQLRowAccessor : rowsTrCmd) {
                if (!sQLRowAccessor.isForeignEmpty("ID_SAISIE_VENTE_FACTURE")) {
                    rowFact = sQLRowAccessor.getForeign("ID_SAISIE_VENTE_FACTURE");
                    l = rowFact.getLong("T_HT");
                    totalFact += l.longValue();
                }
                if (sQLRowAccessor.isForeignEmpty("ID_BON_DE_LIVRAISON")) continue;
                arrayList.add(sQLRowAccessor.getForeign("ID_BON_DE_LIVRAISON"));
            }
        }
        for (SQLRowAccessor row : arrayList) {
            Collection<? extends SQLRowAccessor> rowsTrBL = row.getReferentRows(r.getTable().getTable("TR_COMMANDE_CLIENT"));
            for (SQLRowAccessor sQLRowAccessor : rowsTrBL) {
                if (sQLRowAccessor.isForeignEmpty("ID_SAISIE_VENTE_FACTURE")) continue;
                rowFact = sQLRowAccessor.getForeign("ID_SAISIE_VENTE_FACTURE");
                l = rowFact.getLong("T_HT");
                totalFact += l.longValue();
            }
        }
        if (total > 0L) {
            return new BigDecimal(totalFact).divide(new BigDecimal(total), DecimalUtils.HIGH_PRECISION).movePointRight(2).setScale(2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ONE.movePointRight(2);
    }

    private ListeAddPanel createPanel(int idFilter) {
        IListTotalPanel total;
        SQLTableModelColumnPath dateEnvoiCol;
        SQLTableModelSourceOnline lAttente = this.eltDevis.getTableSource(true);
        if (idFilter == 4) {
            dateEnvoiCol = new SQLTableModelColumnPath(this.eltDevis.getTable().getField("DATE_ENVOI"));
            lAttente.getColumns().add(dateEnvoiCol);
            dateEnvoiCol.setRenderer(new DateEnvoiRenderer());
            dateEnvoiCol.setEditable(true);
            BaseSQLTableModelColumn colAvancementCmd = new BaseSQLTableModelColumn("Commande", BigDecimal.class){

                @Override
                protected Object show_(SQLRowAccessor r) {
                    return ListeDesDevisPanel.this.getAvancementCommande(r);
                }

                @Override
                public Set<FieldPath> getPaths() {
                    Path p = ((PathBuilder)((PathBuilder)new PathBuilder(ListeDesDevisPanel.this.eltDevis.getTable()).addTable("TR_DEVIS")).addTable("COMMANDE_CLIENT")).build();
                    return CollectionUtils.createSet(new FieldPath(p, "T_HT"));
                }
            };
            lAttente.getColumns().add(colAvancementCmd);
            colAvancementCmd.setRenderer(new PercentTableCellRenderer());
            BaseSQLTableModelColumn colAvancement = new BaseSQLTableModelColumn("Facturation", BigDecimal.class){

                @Override
                protected Object show_(SQLRowAccessor r) {
                    return ListeDesDevisPanel.this.getAvancementFacture(r);
                }

                @Override
                public Set<FieldPath> getPaths() {
                    Path p = ((PathBuilder)((PathBuilder)new PathBuilder(ListeDesDevisPanel.this.eltDevis.getTable()).addTable("TR_DEVIS")).addTable("SAISIE_VENTE_FACTURE")).build();
                    Path p2 = ((PathBuilder)((PathBuilder)((PathBuilder)((PathBuilder)new PathBuilder(ListeDesDevisPanel.this.eltDevis.getTable()).addTable("TR_DEVIS")).addTable("COMMANDE_CLIENT")).addTable("TR_COMMANDE_CLIENT")).addTable("SAISIE_VENTE_FACTURE")).build();
                    Path p3 = ((PathBuilder)((PathBuilder)((PathBuilder)((PathBuilder)((PathBuilder)((PathBuilder)new PathBuilder(ListeDesDevisPanel.this.eltDevis.getTable()).addTable("TR_DEVIS")).addTable("COMMANDE_CLIENT")).addTable("TR_COMMANDE_CLIENT")).addTable("BON_DE_LIVRAISON")).addTable("TR_BON_DE_LIVRAISON")).addTable("SAISIE_VENTE_FACTURE")).build();
                    return CollectionUtils.createSet(new FieldPath(p, "T_HT"), new FieldPath(p2, "T_HT"), new FieldPath(p3, "T_HT"));
                }
            };
            lAttente.getColumns().add(colAvancement);
            colAvancement.setRenderer(new PercentTableCellRenderer());
        } else {
            dateEnvoiCol = null;
        }
        if (idFilter > 1) {
            Where wAttente = new Where((FieldRef)this.eltDevis.getTable().getField("ID_ETAT_DEVIS"), "=", idFilter);
            lAttente.getReq().setWhere(wAttente);
        } else {
            lAttente.getColumns().add(new BaseSQLTableModelColumn("Etat", String.class){

                @Override
                protected Object show_(SQLRowAccessor r) {
                    return r.getForeign("ID_ETAT_DEVIS").getString("NOM");
                }

                @Override
                public Set<FieldPath> getPaths() {
                    HashSet<FieldPath> s = new HashSet<FieldPath>();
                    SQLTable table = ListeDesDevisPanel.this.eltDevis.getTable();
                    s.add(table.getField("ID_ETAT_DEVIS").getFieldPath());
                    return s;
                }
            });
        }
        this.setRenderer(lAttente);
        ListeAddPanel pane = new ListeAddPanel(this.eltDevis, new IListe(lAttente), "idFilter" + idFilter);
        if (this.eltDevis.getTable().contains("PREBILAN")) {
            ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>> fields = new ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>>(2);
            fields.add(Tuple2.create(pane.getListe().getSource().getColumn(11), IListTotalPanel.Type.SOMME));
            fields.add(Tuple2.create(pane.getListe().getSource().getColumn(this.eltDevis.getTable().getField("PREBILAN")), IListTotalPanel.Type.SOMME));
            fields.add(Tuple2.create(new BaseSQLTableModelColumn("%MB", String.class){

                @Override
                protected Object show_(SQLRowAccessor r) {
                    return null;
                }

                @Override
                public Set<FieldPath> getPaths() {
                    return null;
                }
            }, IListTotalPanel.Type.MOYENNE_MARGE));
            total = new IListTotalPanel(pane.getListe(), fields, null, "Total Global");
        } else {
            total = this.eltDevis.getTable().getFieldsName().contains("T_HA") && pane.getListe().getSource().getColumns(this.eltDevis.getTable().getField("T_HA")) != null && UserRightsManager.getCurrentUserRights().haveRight("CORPS_VOIR_PRIX_ACHAT") ? new IListTotalPanel(pane.getListe(), Arrays.asList(this.eltDevis.getTable().getField("T_HA"), this.eltDevis.getTable().getField("T_HT"))) : new IListTotalPanel(pane.getListe(), Arrays.asList(this.eltDevis.getTable().getField("T_HT")));
        }
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridy = 4;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        pane.add((Component)total, c);
        JTable table = pane.getListe().getJTable();
        if (idFilter == 4) {
            pane.getListe().setSQLEditable(true);
            TableColumn columnDateEnvoi = pane.getListe().getJTable().getColumnModel().getColumn(table.getColumnCount() - 1);
            columnDateEnvoi.setCellEditor(new TimestampTableCellEditor());
            SQLTableModelSourceOnline src = (SQLTableModelSourceOnline)pane.getListe().getModel().getReq();
            for (SQLTableModelColumn column : src.getColumns()) {
                if (column == dateEnvoiCol || !column.getClass().isAssignableFrom(SQLTableModelColumnPath.class)) continue;
                ((SQLTableModelColumnPath)column).setEditable(false);
            }
        }
        pane.getListe().setOpaque(false);
        pane.setOpaque(false);
        return pane;
    }

    public Map<Integer, ListeAddPanel> getListePanel() {
        return this.map;
    }
}

