/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.action;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.sales.product.ui.FamilleArticlePanel;
import org.openconcerto.erp.panel.ITreeSelection;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.PanelFrame;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

public class ListeDesArticlesAction
extends CreateFrameAbstractAction {
    private PanelFrame panelFrame;
    String title = "Liste des articles";
    private final SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
    private final SQLTable sqlTableFamilleArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("FAMILLE_ARTICLE");

    public ListeDesArticlesAction() {
        this.putValue("Name", "Liste des articles");
    }

    public JFrame createFrame() {
        SQLTableModelColumn colStock;
        final SQLElement elt = Configuration.getInstance().getDirectory().getElement(this.sqlTableArticle);
        final FamilleArticlePanel panelFam = new FamilleArticlePanel(elt.getForeignElement("ID_FAMILLE_ARTICLE"));
        SQLTableModelSourceOnline createTableSource = elt.initTableSource(elt.getTableSource(true));
        createTableSource.init();
        if (elt.getTable().getDBRoot().contains("ARTICLE_PRIX_REVIENT")) {
            colStock = createTableSource.getColumn(createTableSource.getColumns().size() - 2);
        } else {
            colStock = new BaseSQLTableModelColumn("Valeur HT du stock", BigDecimal.class){

                @Override
                protected Object show_(SQLRowAccessor r) {
                    SQLRowAccessor stock = r.getForeign("ID_STOCK");
                    if (stock == null || stock.isUndefined()) {
                        return BigDecimal.ZERO;
                    }
                    float qte = stock.getFloat("QTE_REEL");
                    BigDecimal ha = r.getBigDecimal("PA_HT");
                    BigDecimal total = ha.multiply(new BigDecimal(qte), DecimalUtils.HIGH_PRECISION);
                    if (total.signum() == 1) {
                        return total;
                    }
                    return BigDecimal.ZERO;
                }

                @Override
                public Set<FieldPath> getPaths() {
                    SQLTable table = elt.getTable();
                    Path p = new Path(table);
                    Path p2 = (Path)new Path(table).addForeignField("ID_STOCK");
                    return CollectionUtils.createSet(new FieldPath(p, "PA_HT"), new FieldPath(p2, "QTE_REEL"));
                }
            };
            colStock.setRenderer(ComptaSQLConfElement.CURRENCY_RENDERER);
            createTableSource.getColumns().add(colStock);
        }
        final IListe liste = new IListe(createTableSource);
        final ListeAddPanel panel = new ListeAddPanel(elt, liste){

            @Override
            protected void handleAction(final JButton source, final ActionEvent evt) {
                if (source == this.buttonEffacer && this.getListe().fetchSelectedRow() != null) {
                    JPanel panel = new JPanel();
                    DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                    c.gridwidth = 2;
                    panel.add((Component)new JLabel("Voulez vous supprimer ou rendre obsol\u00e9te?"), c);
                    JButton buttonObs = new JButton("Obsol\u00e9te");
                    JButton buttonSuppr = new JButton("Supprimer");
                    ++c.gridy;
                    panel.add((Component)buttonObs, c);
                    ++c.gridx;
                    panel.add((Component)buttonSuppr, c);
                    final PanelFrame frame = new PanelFrame(panel, "Suppression d'ecritures");
                    buttonObs.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            List<SQLRowValues> rowVals = liste.getSelectedRows();
                            UpdateBuilder build = new UpdateBuilder(ListeDesArticlesAction.this.sqlTableArticle);
                            build.setObject("OBSOLETE", (Object)Boolean.TRUE);
                            ArrayList<Integer> ids = new ArrayList<Integer>();
                            for (SQLRowValues sqlRowValues : rowVals) {
                                ids.add(sqlRowValues.getID());
                            }
                            build.setWhere(new Where(ListeDesArticlesAction.this.sqlTableArticle.getKey(), ids));
                            ListeDesArticlesAction.this.sqlTableArticle.getDBSystemRoot().getDataSource().execute(build.asString());
                            frame.dispose();
                        }
                    });
                    buttonSuppr.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            frame.dispose();
                            this.SuperHandleAction(source, evt);
                        }
                    });
                    frame.pack();
                    frame.setResizable(false);
                    frame.setLocationRelativeTo(null);
                    frame.setVisible(true);
                } else {
                    super.handleAction(source, evt);
                }
            }

            public void SuperHandleAction(JButton source, ActionEvent evt) {
                super.handleAction(source, evt);
            }
        };
        panel.getListe().getRequest().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                input.setWhere(ListeDesArticlesAction.this.getWhere(panelFam, input));
                return input;
            }
        });
        ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>> fields = new ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>>(1);
        fields.add(Tuple2.create(colStock, IListTotalPanel.Type.SOMME));
        IListTotalPanel total = new IListTotalPanel(liste, fields, null, "Total");
        DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
        c2.gridy = 4;
        c2.anchor = 13;
        c2.weightx = 0.0;
        c2.fill = 0;
        panel.add((Component)total, c2);
        JSplitPane pane = new JSplitPane(1, new JScrollPane(panelFam), panel);
        JPanel panelAll = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        panelAll.add((Component)pane, c);
        ITreeSelection tree = panelFam.getFamilleTree();
        tree.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                panel.getListe().getRequest().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect input) {
                        input.setWhere(ListeDesArticlesAction.this.getWhere(panelFam, input));
                        return input;
                    }
                });
            }
        });
        panel.getListe().addListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ListeDesArticlesAction.this.setTitle(panel);
            }
        });
        panel.getListe().addListenerOnModel(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == null || evt.getPropertyName().equals("loading") || evt.getPropertyName().equals("searching")) {
                    ListeDesArticlesAction.this.setTitle(panel);
                }
            }
        });
        panelFam.getCheckObsolete().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListSQLRequest request = panel.getListe().getRequest();
                request.setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect input) {
                        input.setWhere(ListeDesArticlesAction.this.getWhere(panelFam, input));
                        return input;
                    }
                });
            }
        });
        this.panelFrame = new PanelFrame(panelAll, "Liste des articles");
        return this.panelFrame;
    }

    protected void setTitle(ListeAddPanel panel) {
        String title = this.title;
        if (panel.getListe().getModel().isLoading()) {
            title = String.valueOf(title) + ", chargement en cours";
        }
        if (panel.getListe().getModel().isSearching()) {
            title = String.valueOf(title) + ", recherche en cours";
        }
        if (this.panelFrame != null) {
            this.panelFrame.setTitle(title);
        }
    }

    public Where getWhere(FamilleArticlePanel panel, SQLSelect request) {
        int id = panel.getFamilleTree().getSelectedID();
        Where w = null;
        if (panel.getCheckObsolete().isSelected()) {
            w = new Where((FieldRef)this.sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE);
            w = w.or(new Where(request.getAlias(this.sqlTableArticle.getForeignTable("ID_STOCK").getField("QTE_REEL")), ">", 0));
        }
        if (id > 1) {
            SQLRow row = this.sqlTableFamilleArticle.getRow(id);
            Where w2 = new Where((FieldRef)this.sqlTableArticle.getField("ID_FAMILLE_ARTICLE"), "=", this.sqlTableFamilleArticle.getKey());
            String code = String.valueOf(row.getString("CODE")) + ".%";
            Where w3 = new Where((FieldRef)this.sqlTableFamilleArticle.getField("CODE"), "LIKE", (Object)code);
            w2 = w2.and(w3.or(new Where((FieldRef)this.sqlTableFamilleArticle.getKey(), "=", id)));
            w = w != null ? w.and(w2) : w2;
        }
        return w;
    }
}

