/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.openconcerto.erp.core.sales.pos.ui.TicketPanel;

public class StatusBar
extends JPanel {
    private Image bg;
    private Image bg_retour;
    private String title = "";
    private boolean previous;
    private int offsetX = 110;

    StatusBar() {
        this("toolbar.png", "toolbar_retour.png");
    }

    StatusBar(String fileBg, String fileFg) {
        this.bg = new ImageIcon(TicketPanel.class.getResource(fileBg)).getImage();
        this.bg_retour = new ImageIcon(TicketPanel.class.getResource(fileFg)).getImage();
        this.setFont(new Font("Arial", 1, 24));
    }

    public void setPrevious(boolean b) {
        if (b != this.previous) {
            this.previous = b;
            this.repaint();
        }
    }

    public void setTitle(String t) {
        if (this.title == null || !this.title.equals(t)) {
            this.title = t;
            this.repaint();
        }
    }

    void setTitleLocation(int x) {
        this.offsetX = x;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int w = this.getWidth();
        int imWidth = this.bg.getWidth(null);
        int x = imWidth - 1;
        while (x <= w) {
            g.drawImage(this.bg, x, 0, null);
            x += imWidth;
        }
        if (this.previous) {
            g.drawImage(this.bg_retour, 0, 0, null);
        } else {
            g.drawImage(this.bg, 0, 0, null);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(new Color(250, 250, 250));
        g.drawString(this.title, this.offsetX, 30);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(320, 44);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(320, 44);
    }
}

