/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Categorie;
import org.openconcerto.erp.core.sales.pos.ui.ArticleSearchPanel;
import org.openconcerto.erp.core.sales.pos.ui.ArticleSelectorPanel;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.CaisseListener;
import org.openconcerto.erp.core.sales.pos.ui.PaiementPanel;
import org.openconcerto.erp.core.sales.pos.ui.StatusBar;
import org.openconcerto.erp.core.sales.pos.ui.TicketPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.utils.ExceptionHandler;

public class CaissePanel
extends JPanel
implements CaisseListener {
    private CaisseControler controler;
    private StatusBar st;
    private ArticleSelectorPanel articleSelectorPanel;
    private ArticleSearchPanel articleSearchPanel;
    private JPanel articleSelector;

    public CaissePanel(final CaisseFrame caisseFrame) {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.WHITE);
        this.setOpaque(this.isOpaque());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.controler = new CaisseControler(caisseFrame);
        c.fill = 2;
        this.st = new StatusBar("toolbar.png", "toolbar_menu.png");
        this.st.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getX() < 110) {
                    CaissePanel.this.controler.setLCD("Impression de", "votre ticket...", 0);
                    try {
                        CaissePanel.this.controler.printTicket();
                    }
                    catch (UnsatisfiedLinkError ex) {
                        JOptionPane.showMessageDialog(CaissePanel.this, "Erreur de configuration de la liaison \u00e0 l'imprimante");
                    }
                    catch (Throwable ex) {
                        JOptionPane.showMessageDialog(CaissePanel.this, "Erreur d'impression du ticket");
                    }
                    try {
                        CaissePanel.this.controler.saveAndClearTicket();
                    }
                    catch (Throwable ex) {
                        ExceptionHandler.handle("Erreur de sauvegardes des informations du ticket", ex);
                    }
                    CaissePanel.this.controler.setLCDDefaultDisplay(2);
                } else if (e.getX() > 165 && e.getX() < 275) {
                    try {
                        caisseFrame.showMenu();
                    }
                    catch (Throwable ex) {
                        ExceptionHandler.handle("Erreur d'affichage du menu", ex);
                    }
                }
            }
        });
        this.st.setPrevious(true);
        this.add((Component)this.st, c);
        TicketPanel t = new TicketPanel(this.controler);
        this.loadArticles();
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.anchor = 16;
        c.fill = 0;
        this.add((Component)t, c);
        c.fill = 1;
        ++c.gridx;
        c.weightx = 1.0;
        --c.gridy;
        c.gridheight = 2;
        this.articleSelectorPanel = new ArticleSelectorPanel(this.controler);
        this.articleSearchPanel = new ArticleSearchPanel(this.controler);
        this.articleSelector = this.articleSelectorPanel;
        this.add((Component)this.articleSelector, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new PaiementPanel(this.controler), c);
        this.controler.addCaisseListener(this);
    }

    private void loadArticles() {
        HashMap<Integer, Categorie> categoriesMap = new HashMap<Integer, Categorie>();
        SQLElement eltFam = Configuration.getInstance().getDirectory().getElement("FAMILLE_ARTICLE");
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement("ARTICLE");
        SQLSelect selFamille = new SQLSelect(Configuration.getInstance().getBase());
        selFamille.addSelectStar(eltFam.getTable());
        selFamille.addRawOrder(eltFam.getTable().getField("CODE").getFieldRef());
        List l = (List)Configuration.getInstance().getBase().getDataSource().execute(selFamille.asString(), SQLRowListRSH.createFromSelect(selFamille, eltFam.getTable()));
        for (SQLRow row : l) {
            Categorie c;
            Categorie cP = (Categorie)categoriesMap.get(row.getInt("ID_FAMILLE_ARTICLE_PERE"));
            if (cP != null) {
                c = new Categorie(row.getString("NOM"));
                cP.add(c);
            } else {
                c = new Categorie(row.getString("NOM"), true);
            }
            categoriesMap.put(row.getID(), c);
        }
        SQLSelect selArticle = new SQLSelect();
        selArticle.addSelectStar(eltArticle.getTable());
        List l2 = (List)Configuration.getInstance().getBase().getDataSource().execute(selArticle.asString(), SQLRowListRSH.createFromSelect(selArticle, eltArticle.getTable()));
        Categorie cUnclassified = new Categorie("Non class\u00e9s", true);
        for (SQLRow row : l2) {
            String name;
            Categorie s1 = (Categorie)categoriesMap.get(row.getInt("ID_FAMILLE_ARTICLE"));
            if (s1 == null) {
                s1 = cUnclassified;
                categoriesMap.put(row.getInt("ID_FAMILLE_ARTICLE"), cUnclassified);
            }
            if ((name = row.getString("NOM").trim()).length() <= 0) continue;
            Article a = new Article(s1, name, row.getID());
            String barcode = row.getString("CODE_BARRE");
            if (barcode == null || barcode.trim().isEmpty()) {
                a.setBarCode(row.getString("CODE"));
            } else {
                a.setBarCode(barcode);
            }
            a.setCode(row.getString("CODE"));
            a.setIdTaxe(row.getInt("ID_TAXE"));
            a.setPriceWithoutTax((BigDecimal)row.getObject("PV_HT"));
            a.setPriceWithTax((BigDecimal)row.getObject("PV_TTC"));
        }
    }

    @Override
    public void paint(Graphics g) {
        boolean minimalHeight;
        System.err.println("CaissePanel.paint()" + this.getWidth() + " x " + this.getHeight());
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g.setFont(new Font("Arial", 0, 32));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = 300;
        int y = 110;
        g.setFont(g.getFont().deriveFont(66.0f));
        int total = this.controler.getTotal();
        String euros = String.valueOf(CaisseControler.getEuros(total)) + ".";
        String cents = CaisseControler.getCents(total);
        Rectangle2D r = g.getFontMetrics().getStringBounds(euros, g);
        g.drawString(euros, x -= (int)r.getWidth(), y);
        g.setFont(g.getFont().deriveFont(40.0f));
        g.drawString(cents, x + (int)r.getWidth(), y);
        y += 40;
        x = 300;
        int paye = this.controler.getPaidTotal();
        euros = String.valueOf(CaisseControler.getEuros(paye)) + ".";
        cents = CaisseControler.getCents(paye);
        g.setFont(g.getFont().deriveFont(18.0f));
        Rectangle2D r2 = g.getFontMetrics().getStringBounds("Pay\u00e9", g);
        if (paye >= total) {
            g.setColor(Color.DARK_GRAY);
        } else {
            g.setColor(Color.ORANGE);
        }
        g.setFont(g.getFont().deriveFont(32.0f));
        r = g.getFontMetrics().getStringBounds(euros, g);
        g.drawString(euros, x - (int)r.getWidth(), y);
        g.setFont(g.getFont().deriveFont(24.0f));
        g.drawString(cents, x, y);
        g.setFont(g.getFont().deriveFont(18.0f));
        g.setColor(Color.GRAY);
        g.drawString("Pay\u00e9", x - (int)r2.getWidth() - (int)r.getWidth() - 10, y);
        boolean bl = minimalHeight = this.getHeight() < 750;
        if (!minimalHeight) {
            y += 40;
            x = 300;
        } else {
            x = 140;
        }
        int aRendre = paye - total;
        if (aRendre != 0) {
            String label;
            if (aRendre > 0) {
                label = "Rendu";
            } else {
                label = !minimalHeight ? "Reste \u00e0 payer" : "Doit";
                aRendre = -aRendre;
            }
            euros = String.valueOf(CaisseControler.getEuros(aRendre)) + ".";
            cents = CaisseControler.getCents(aRendre);
            g.setFont(g.getFont().deriveFont(18.0f));
            Rectangle2D r3 = g.getFontMetrics().getStringBounds(label, g);
            g.setColor(Color.DARK_GRAY);
            g.setFont(g.getFont().deriveFont(32.0f));
            r = g.getFontMetrics().getStringBounds(euros, g);
            g.drawString(euros, x - (int)r.getWidth(), y);
            g.setFont(g.getFont().deriveFont(24.0f));
            g.drawString(cents, x, y);
            g.setFont(g.getFont().deriveFont(18.0f));
            g.setColor(Color.GRAY);
            g.drawString(label, x - (int)r3.getWidth() - (int)r.getWidth() - 10, y);
        }
    }

    @Override
    public void caisseStateChanged() {
        this.repaint();
    }

    public void switchListMode() {
        GridBagConstraints c = ((GridBagLayout)this.getLayout()).getConstraints(this.articleSelector);
        this.remove(this.articleSelector);
        this.articleSelector = this.articleSelector == this.articleSearchPanel ? this.articleSelectorPanel : this.articleSearchPanel;
        this.add((Component)this.articleSelector, c);
        this.validate();
        this.repaint();
    }

    public CaisseControler getControler() {
        return this.controler;
    }
}

