/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.TicketPanel;
import org.openconcerto.utils.ExceptionHandler;

public class CaisseMenuPanel
extends JPanel
implements ListSelectionListener {
    private JList l;
    private CaisseFrame frame;
    private Image bg;

    CaisseMenuPanel(CaisseFrame caisseFrame) {
        this.frame = caisseFrame;
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        final Font font = new Font("Arial", 0, 46);
        this.l = new JList<String>(new String[]{"Retour", "", "Liste des tickets", "Cl\u00f4turer", "", "Fermer le logiciel", ""});
        this.l.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel l = new JLabel(value.toString()){

                    @Override
                    public void paint(Graphics g) {
                        super.paint(g);
                        g.setColor(Color.LIGHT_GRAY);
                        g.drawLine(0, 0, this.getWidth(), 0);
                    }
                };
                l.setFont(font);
                return l;
            }
        });
        this.l.setSelectionMode(0);
        this.l.getSelectionModel().addListSelectionListener(this);
        this.l.setFixedCellHeight(80);
        this.add((Component)this.l, c);
        this.bg = new ImageIcon(TicketPanel.class.getResource("toolbar.png")).getImage();
        this.setFont(new Font("Arial", 1, 24));
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        try {
            int selectedIndex = this.l.getSelectedIndex();
            switch (selectedIndex) {
                case 0: {
                    this.frame.showCaisse();
                    break;
                }
                case 2: {
                    this.frame.showTickets(null);
                    break;
                }
                case 3: {
                    this.frame.getControler().setLCD("Cloture", "En cours...", 0);
                    POSConfiguration.getInstance().commitAll(POSConfiguration.getInstance().allTickets());
                    this.frame.getControler().setLCD("Cloture", "Terminee", 0);
                    break;
                }
                case 5: {
                    this.frame.getControler().setLCD("   CAISSE FERMEE    ", "", 0);
                    this.frame.dispose();
                    Frame[] l = Frame.getFrames();
                    int i = 0;
                    while (i < l.length) {
                        Frame f = l[i];
                        System.err.println(String.valueOf(f.getName()) + " " + f + " Displayable: " + f.isDisplayable() + " Valid: " + f.isValid() + " Active: " + f.isActive());
                        ++i;
                    }
                    Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
                    for (Thread thread : threadSet) {
                        if (thread.isDaemon()) continue;
                        System.err.println(String.valueOf(thread.getName()) + " " + thread.getId() + " not daemon");
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handle("Erreur", ex);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int imWidth = this.bg.getWidth(null);
        int x = 0;
        while (x <= w) {
            g.drawImage(this.bg, x, 0, null);
            x += imWidth;
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(new Color(250, 250, 250));
        String str = "Menu Principal";
        Rectangle2D r = g.getFontMetrics().getStringBounds(str, g);
        int x2 = (int)((double)this.getWidth() - r.getWidth()) / 2;
        g.drawString(str, x2, 30);
    }
}

