/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseMenuPanel;
import org.openconcerto.erp.core.sales.pos.ui.CaissePanel;
import org.openconcerto.erp.core.sales.pos.ui.ListeDesTicketsPanel;
import org.openconcerto.sql.RemoteShell;
import org.openconcerto.utils.ClassPathLoader;
import org.openconcerto.utils.ExceptionHandler;

public class CaisseFrame
extends JFrame {
    CaissePanel t = new CaissePanel(this);

    CaisseFrame() {
        this.setContentPane(this.t);
        this.setFocusable(true);
    }

    public static void main(String[] args) {
        try {
            System.out.println("Lancement du module de caisse");
            ToolTipManager.sharedInstance().setInitialDelay(0);
            RemoteShell.startDefaultInstance(null, null);
            System.setProperty("redirectToFile", "true");
            System.setProperty("org.openconcerto.sql.identifier.allowRemoval", "true");
            ExceptionHandler.setForceUI(true);
            ExceptionHandler.setForumURL("http://www.openconcerto.org/forum");
            System.setProperty("sun.java2d.pmoffscreen", "false");
            System.setProperty("org.openconcerto.sql.structure.useXML", "true");
            System.setProperty("redirectToFile", "true");
            if (POSConfiguration.getInstance().isUsingJPos()) {
                ClassPathLoader c = ClassPathLoader.getInstance();
                try {
                    List<String> posDirectories = POSConfiguration.getInstance().getJPosDirectories();
                    for (String posDirectory : posDirectories) {
                        if (posDirectory == null || posDirectory.trim().isEmpty()) continue;
                        c.addJarFromDirectory(new File(posDirectory.trim()));
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                c.load();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        System.setProperty("awt.useSystemAAFontSettings", "on");
                        System.setProperty("swing.aatext", "true");
                        System.setProperty("org.openconcerto.sql.comboCanModify", "true");
                        POSConfiguration.getInstance().createConnexion();
                        CaisseFrame f = new CaisseFrame();
                        f.setUndecorated(true);
                        f.setDefaultCloseOperation(3);
                        f.pack();
                        f.setLocation(0, 0);
                        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                        if (POSConfiguration.getInstance().getScreenWidth() > 0 && POSConfiguration.getInstance().getScreenHeight() > 0) {
                            f.setSize(new Dimension(POSConfiguration.getInstance().getScreenWidth(), POSConfiguration.getInstance().getScreenHeight()));
                        } else {
                            f.setSize(screenSize);
                        }
                        System.out.println("Affichage de l'interface");
                        f.setVisible(true);
                        if (screenSize.getWidth() < 1280.0 || screenSize.getHeight() < 720.0) {
                            JOptionPane.showMessageDialog(f, "La r\u00e9solution de votre \u00e9cran est trop faible.\nLa largeur doit \u00eatre au minium de 1280 pixels.\nLa hauteur doit \u00eatre au minium de 720 pixels.");
                        }
                    }
                    catch (Throwable e) {
                        ExceptionHandler.handle("Erreur d'initialisation de la caisse (main)", e);
                    }
                }
            });
        }
        catch (Throwable e) {
            ExceptionHandler.handle("Erreur d'initialisation de la caisse", e);
        }
    }

    public void showMenu() {
        System.out.println("CaisseFrame.showMenu()");
        this.invalidate();
        this.setContentPane(new CaisseMenuPanel(this));
        this.validate();
        this.repaint();
        this.t.getControler().setLCD("OpenConcerto", "Menu", 0);
    }

    public void showCaisse() {
        System.out.println("CaisseFrame.showCaisse()");
        this.invalidate();
        this.setContentPane(this.t);
        this.validate();
        this.repaint();
        this.t.getControler().setLCD("OpenConcerto", "Caisse", 0);
        this.t.getControler().setLCDDefaultDisplay(5);
    }

    public void showTickets(Ticket t) {
        System.out.println("CaisseFrame.showMenu()");
        this.invalidate();
        ListeDesTicketsPanel panel = new ListeDesTicketsPanel(this);
        panel.setSelectedTicket(t);
        this.setContentPane(panel);
        this.validate();
        this.repaint();
    }

    public CaisseControler getControler() {
        return this.t.getControler();
    }
}

