/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.event.KeyEvent;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.io.BarcodeReader;
import org.openconcerto.erp.core.sales.pos.io.ConcertProtocol;
import org.openconcerto.erp.core.sales.pos.io.ESCSerialDisplay;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.ui.BarcodeListener;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.CaisseListener;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;
import org.openconcerto.utils.Pair;

public class CaisseControler
implements BarcodeListener {
    private Article articleSelected;
    private Paiement paiementSelected;
    private Ticket t;
    private List<CaisseListener> listeners = new ArrayList<CaisseListener>();
    private final BarcodeReader r;
    private Paiement p1 = new Paiement(1);
    private Paiement p2 = new Paiement(3);
    private Paiement p3 = new Paiement(2);
    private final CaisseFrame caisseFrame;
    private final ESCSerialDisplay lcd;

    public CaisseControler(CaisseFrame caisseFrame) {
        this.caisseFrame = caisseFrame;
        this.t = new Ticket(POSConfiguration.getInstance().getPosID());
        this.t.addPaiement(this.p1);
        this.t.addPaiement(this.p2);
        this.t.addPaiement(this.p3);
        this.r = new BarcodeReader(POSConfiguration.getInstance().getScanDelay());
        this.r.start();
        this.r.addBarcodeListener(this);
        this.lcd = new ESCSerialDisplay(POSConfiguration.getInstance().getLCDSerialPort());
        this.setLCDDefaultDisplay(0);
    }

    public Article getArticleSelected() {
        return this.articleSelected;
    }

    public Paiement getPaiementSelected() {
        return this.paiementSelected;
    }

    void setArticleSelected(Article a) {
        if (a != this.articleSelected) {
            this.articleSelected = a;
            this.paiementSelected = null;
            this.fire();
        }
    }

    void setPaiementSelected(Paiement p) {
        this.paiementSelected = p;
        this.articleSelected = null;
        this.fire();
    }

    private void fire() {
        int stop = this.listeners.size();
        int i = 0;
        while (i < stop) {
            this.listeners.get(i).caisseStateChanged();
            ++i;
        }
    }

    void addCaisseListener(CaisseListener l) {
        this.listeners.add(l);
    }

    void addArticle(Article a) {
        this.t.addArticle(a);
        this.fire();
        String price = TicketCellRenderer.centsToString(a.getPriceWithTax().movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue());
        this.setLCD(a.getName(), price, 0);
        this.setLCDDefaultDisplay(2);
    }

    void incrementArticle(Article a) {
        this.t.incrementArticle(a);
        this.fire();
        String price = TicketCellRenderer.centsToString(a.getPriceWithTax().movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue());
        this.setLCD(a.getName(), price, 0);
        this.setLCDDefaultDisplay(2);
    }

    void removeArticle(Article a) {
        this.t.removeArticle(a);
        this.fire();
    }

    public List<Paiement> getPaiements() {
        return this.t.getPaiements();
    }

    public void addPaiement(Paiement p) {
        this.t.addPaiement(p);
        this.fire();
    }

    public void clearPaiement(Paiement paiement) {
        if (this.p1.equals(paiement) || this.p2.equals(paiement) || this.p3.equals(paiement)) {
            paiement.setMontantInCents(0);
        }
        this.fire();
    }

    public void setPaiementValue(Paiement p, int v) {
        p.setMontantInCents(v);
        this.fire();
        this.setLCD("Paiement " + p.getTypeAsString().replace('\u00e8', 'e').replace('\u00e9', 'e'), TicketCellRenderer.centsToString(p.getMontantInCents()), 0);
        this.setLCDDefaultDisplay(3);
    }

    public int getTotal() {
        return this.t.getTotalInCents();
    }

    public int getPaidTotal() {
        return this.t.getPaidTotal();
    }

    public List<Pair<Article, Integer>> getItems() {
        return this.t.getArticles();
    }

    public int getItemCount(Article article) {
        return this.t.getItemCount(article);
    }

    public void clearArticle(Article article) {
        this.t.clearArticle(article);
        this.setArticleSelected(null);
    }

    public void setArticleCount(Article article, int count) {
        this.t.setArticleCount(article, count);
        this.setArticleSelected(null);
    }

    @Override
    public void barcodeRead(String code) {
        if (code.equalsIgnoreCase("especes")) {
            this.autoFillPaiement(this.p1);
        } else if (code.equalsIgnoreCase("cb")) {
            this.autoFillPaiement(this.p2);
        } else if (code.equalsIgnoreCase("cheque")) {
            this.autoFillPaiement(this.p3);
        } else if (code.equalsIgnoreCase("annuler")) {
            if (this.articleSelected != null) {
                this.clearArticle(this.articleSelected);
            } else if (this.paiementSelected != null) {
                this.paiementSelected.setMontantInCents(0);
                this.fire();
            }
        } else if (!(code.equalsIgnoreCase("valider") || code.equalsIgnoreCase("facture") || code.equalsIgnoreCase("ticket"))) {
            Article a = Article.getArticleFromBarcode(code);
            if (a != null) {
                this.incrementArticle(a);
                this.setArticleSelected(a);
            } else {
                Ticket t = Ticket.getTicketFromCode(code);
                if (t != null) {
                    this.caisseFrame.showTickets(t);
                }
            }
        }
    }

    void autoFillPaiement(Paiement p) {
        int montant = p.getMontantInCents();
        p.setMontantInCents(this.getTotal() - this.getPaidTotal() + montant);
        this.setPaiementSelected(p);
        this.setLCD("Paiement " + p.getTypeAsString(), TicketCellRenderer.centsToString(p.getMontantInCents()), 0);
        this.setLCDDefaultDisplay(3);
    }

    void addBarcodeListener(BarcodeListener l) {
        this.r.addBarcodeListener(l);
    }

    public boolean canAddPaiement(int type) {
        int paiementCount = this.t.getPaiements().size();
        if (paiementCount >= 6) {
            return false;
        }
        int i = 0;
        while (i < paiementCount) {
            Paiement p = this.t.getPaiements().get(i);
            if (p.getType() == type && p.getMontantInCents() <= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void keyReceived(KeyEvent ee) {
    }

    public static String getCents(int cents) {
        String s = String.valueOf(cents % 100);
        if (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    public static String getEuros(int cents) {
        String s = String.valueOf(cents / 100);
        return s;
    }

    public void saveAndClearTicket() {
        if (this.t.getTotalInCents() > 0 && this.getPaidTotal() >= this.getTotal()) {
            this.t.setCreationCal(Calendar.getInstance());
            this.t.save();
            this.t = new Ticket(POSConfiguration.getInstance().getPosID());
            this.p1 = new Paiement(1);
            this.p2 = new Paiement(3);
            this.p3 = new Paiement(2);
            this.t.addPaiement(this.p1);
            this.t.addPaiement(this.p2);
            this.t.addPaiement(this.p3);
            this.setPaiementSelected(null);
            this.setArticleSelected(null);
        }
    }

    public int getTicketNumber() {
        return this.t.getNumber();
    }

    public void printTicket() {
        if (this.t.getTotalInCents() > 0) {
            if (this.getPaidTotal() >= this.getTotal()) {
                POSConfiguration.getInstance().print(this.t);
            } else {
                System.err.println("Ticket not printed because not paid");
            }
        } else {
            System.err.println("Ticket not printed total <= 0");
        }
    }

    public void openDrawer() {
        try {
            TicketPrinter prt = POSConfiguration.getInstance().getTicketPrinterConfiguration1().createTicketPrinter();
            prt.openDrawer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void switchListMode() {
        this.caisseFrame.t.switchListMode();
    }

    public void setLCD(final String line1, final String line2, int delay) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    CaisseControler.this.lcd.setMessage(line1, line2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Timer timer = new Timer("LCD : " + line1, true);
        timer.schedule(task, delay * 1000);
    }

    public void setLCDDefaultDisplay(int delay) {
        if (this.t.getTotalInCents() > 0) {
            int count = 0;
            List<Pair<Article, Integer>> articles = this.t.getArticles();
            for (Pair<Article, Integer> pair : articles) {
                count += pair.getSecond().intValue();
            }
            String line1 = count == 1 ? "1 article" : String.valueOf(count) + " articles";
            int cents = this.t.getTotalInCents();
            this.setLCD(line1, "Total : " + TicketCellRenderer.centsToString(cents), delay);
        } else {
            this.setLCD(POSConfiguration.getInstance().getLCDLine1(), POSConfiguration.getInstance().getLCDLine2(), delay);
        }
    }

    public void sendCBRequest(final Paiement p) {
        final String creditCardPort = POSConfiguration.getInstance().getCreditCardPort();
        if (creditCardPort != null && creditCardPort.trim().length() > 2) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConcertProtocol cp = new ConcertProtocol(creditCardPort);
                        boolean ok = cp.sendCardPayment(p.getMontantInCents(), "978");
                        if (ok) {
                            JOptionPane.showMessageDialog(null, "Paiement CB OK");
                        } else {
                            JOptionPane.showMessageDialog(null, "Erreur paiement CB");
                        }
                    }
                    catch (Throwable ex) {
                        JOptionPane.showMessageDialog(null, "Erreur terminal CB");
                    }
                }
            });
            t.setDaemon(true);
            t.start();
        }
    }
}

