/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.io.DefaultTicketPrinter;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Categorie;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.model.ReceiptCode;
import org.openconcerto.erp.core.sales.pos.model.TicketLine;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.Pair;

public class Ticket {
    private static boolean inited = false;
    private List<Paiement> paiements = new ArrayList<Paiement>();
    private final List<Pair<Article, Integer>> items = new ArrayList<Pair<Article, Integer>>();
    private Calendar creationCal;
    private int number;
    private final int caisseNumber;
    private static final SQLTable tableArticle = Configuration.getInstance().getRoot().findTable("ARTICLE");

    public static Ticket getTicketFromCode(String code) {
        try {
            return Ticket.parseFile(new ReceiptCode(code).getFile());
        }
        catch (Exception e) {
            System.err.println("Error with ticket code : " + code);
            e.printStackTrace();
            return null;
        }
    }

    public static Ticket parseFile(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            SAXBuilder sxb = new SAXBuilder();
            Document document = sxb.build(file);
            Element root = document.getRootElement();
            ReceiptCode receiptCode = new ReceiptCode(root.getAttributeValue("code"));
            String h = root.getAttributeValue("hour");
            String m = root.getAttributeValue("minute");
            Calendar c = (Calendar)receiptCode.getDay().clone();
            c.set(11, Integer.parseInt(h));
            c.set(12, Integer.parseInt(m));
            Ticket t = new Ticket(receiptCode.getCaisseNb());
            t.setCreationCal(c);
            t.setNumber(receiptCode.getDayIndex());
            List<Element> children = root.getChildren("article");
            for (Element element : children) {
                int qte = Integer.parseInt(element.getAttributeValue("qte"));
                BigDecimal prix_unitaire_cents_ht = new BigDecimal(element.getAttributeValue("prixHT"));
                int idTaxe = Integer.parseInt(element.getAttributeValue("idTaxe"));
                BigDecimal prix_unitaire_cents = new BigDecimal(element.getAttributeValue("prix"));
                String categorie = element.getAttributeValue("categorie");
                String name = element.getValue();
                String codebarre = element.getAttributeValue("codebarre");
                String codeArt = element.getAttributeValue("code");
                Categorie cat = new Categorie(categorie);
                String valueID = element.getAttributeValue("id");
                int id = valueID == null || valueID.trim().length() == 0 ? tableArticle.getUndefinedID() : Integer.parseInt(valueID);
                Article art = new Article(cat, name, id);
                art.setPriceWithTax(prix_unitaire_cents);
                art.setCode(codeArt);
                art.setPriceWithoutTax(prix_unitaire_cents_ht);
                art.setIdTaxe(idTaxe);
                art.setBarCode(codebarre);
                Pair<Article, Integer> line = new Pair<Article, Integer>(art, qte);
                t.items.add(line);
            }
            List<Element> payChildren = root.getChildren("paiement");
            for (Element element : payChildren) {
                String type = element.getAttributeValue("type");
                int montant_cents = Integer.parseInt(element.getAttributeValue("montant"));
                if (montant_cents <= 0) continue;
                int tp = 1;
                if (type.equals("CB")) {
                    tp = 3;
                } else if (type.equals("CHEQUE")) {
                    tp = 2;
                } else if (type.equals("ESPECES")) {
                    tp = 1;
                }
                Paiement p = new Paiement(tp);
                p.setMontantInCents(montant_cents);
                t.paiements.add(p);
            }
            return t;
        }
        catch (Exception e) {
            System.err.println("Error with ticket : " + file);
            e.printStackTrace();
            return null;
        }
    }

    public Ticket(int caisse) {
        this.caisseNumber = caisse;
        this.creationCal = Calendar.getInstance();
        this.initNumber();
    }

    public void setNumber(int i) {
        this.number = i;
    }

    private void initNumber() {
        if (!inited) {
            int max = 0;
            for (ReceiptCode c : this.getReceiptCode().getSameDayCodes(true)) {
                if (c.getDayIndex() <= max) continue;
                max = c.getDayIndex();
            }
            this.setNumber(max + 1);
        }
    }

    public final ReceiptCode getReceiptCode() {
        return new ReceiptCode(this.getCaisseNumber(), this.getCreationCal(), this.getNumber());
    }

    public String getCode() {
        return this.getReceiptCode().getCode();
    }

    public int getNumber() {
        return this.number;
    }

    final int getCaisseNumber() {
        return this.caisseNumber;
    }

    public void save() {
        Calendar c = this.getCreationCal();
        int hour = c.get(11);
        int minute = c.get(12);
        File f = this.getFile();
        Element topLevel = new Element("ticket");
        topLevel.setAttribute(new Attribute("code", this.getCode()));
        topLevel.setAttribute("hour", String.valueOf(hour));
        topLevel.setAttribute("minute", String.valueOf(minute));
        for (Pair<Article, Integer> item : this.items) {
            Element e = new Element("article");
            e.setAttribute("qte", String.valueOf(item.getSecond()));
            e.setAttribute("prix", String.valueOf(item.getFirst().getPriceWithTax()));
            e.setAttribute("prixHT", String.valueOf(item.getFirst().getPriceWithoutTax()));
            e.setAttribute("idTaxe", String.valueOf(item.getFirst().getIdTaxe()));
            e.setAttribute("categorie", item.getFirst().getCategorie().getName());
            e.setAttribute("codebarre", item.getFirst().getBarCode());
            e.setAttribute("code", item.getFirst().getCode());
            e.setAttribute("id", String.valueOf(item.getFirst().getId()));
            e.setText(item.getFirst().getName());
            topLevel.addContent(e);
        }
        for (Paiement paiement : this.paiements) {
            int montantInCents = paiement.getMontantInCents();
            if (montantInCents <= 0) continue;
            Element e = new Element("paiement");
            String type = "";
            if (paiement.getType() == 3) {
                type = "CB";
            } else if (paiement.getType() == 2) {
                type = "CHEQUE";
            } else if (paiement.getType() == 1) {
                type = "ESPECES";
            }
            e.setAttribute("type", type);
            e.setAttribute("montant", String.valueOf(montantInCents));
            topLevel.addContent(e);
        }
        try {
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            FileOutputStream fileOutputStream = new FileOutputStream(f);
            out.output(topLevel, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void print(TicketPrinter prt, int ticketWidth) {
        int maxWidth = ticketWidth;
        int MAX_PRICE_WIDTH = 8;
        int MAX_QTE_WIDTH = 5;
        prt.clearBuffer();
        List<TicketLine> headers = POSConfiguration.getInstance().getHeaderLines();
        for (TicketLine line : headers) {
            prt.addToBuffer(line);
        }
        prt.addToBuffer("");
        SimpleDateFormat df = new SimpleDateFormat("EEEE d MMMM yyyy \u00e0 HH:mm", Locale.FRENCH);
        prt.addToBuffer(DefaultTicketPrinter.formatRight(maxWidth, "Le " + df.format(this.getCreationDate())));
        prt.addToBuffer("");
        for (Pair<Article, Integer> item : this.items) {
            String priceString;
            String qtyString;
            Article article = item.getFirst();
            Integer nb = item.getSecond();
            Float tauxFromId = TaxeCache.getCache().getTauxFromId(article.getIdTaxe());
            BigDecimal tauxTVA = new BigDecimal(tauxFromId.floatValue()).movePointLeft(2).add(BigDecimal.ONE);
            BigDecimal multiply = article.getPriceWithoutTax().multiply(new BigDecimal(nb), DecimalUtils.HIGH_PRECISION).multiply(tauxTVA, DecimalUtils.HIGH_PRECISION);
            if (article.getCode() != null && !article.getCode().isEmpty()) {
                qtyString = DefaultTicketPrinter.formatRight(MAX_QTE_WIDTH, String.valueOf(nb));
                String codeString = DefaultTicketPrinter.formatLeft(maxWidth - 2 - MAX_PRICE_WIDTH - MAX_QTE_WIDTH, article.getCode());
                priceString = DefaultTicketPrinter.formatRight(MAX_PRICE_WIDTH, TicketCellRenderer.centsToString(multiply.movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue()));
                prt.addToBuffer(String.valueOf(qtyString) + " " + codeString + " " + priceString);
                String nameString = DefaultTicketPrinter.formatLeft(maxWidth - MAX_QTE_WIDTH - 1, article.getName());
                prt.addToBuffer("      " + nameString);
                continue;
            }
            qtyString = DefaultTicketPrinter.formatRight(MAX_QTE_WIDTH, String.valueOf(nb));
            String nameString = DefaultTicketPrinter.formatLeft(maxWidth - 2 - MAX_PRICE_WIDTH - MAX_QTE_WIDTH, article.getName());
            priceString = DefaultTicketPrinter.formatRight(MAX_PRICE_WIDTH, TicketCellRenderer.centsToString(multiply.movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue()));
            prt.addToBuffer(String.valueOf(qtyString) + " " + nameString + " " + priceString);
        }
        StringBuilder spacer = new StringBuilder();
        int i = 0;
        while (i <= MAX_QTE_WIDTH) {
            spacer.append(' ');
            ++i;
        }
        i = 0;
        while (i < maxWidth - MAX_QTE_WIDTH - 1) {
            spacer.append('=');
            ++i;
        }
        prt.addToBuffer(spacer.toString());
        TotalCalculator calc = this.getTotalCalculator();
        int totalTTCInCents = calc.getTotalTTC().movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue();
        int totalTVHAInCents = calc.getTotalTVA().movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue();
        prt.addToBuffer(String.valueOf(DefaultTicketPrinter.formatRight(maxWidth - MAX_PRICE_WIDTH, "MONTANT TOTAL TTC (Euros) : ")) + DefaultTicketPrinter.formatRight(MAX_PRICE_WIDTH, TicketCellRenderer.centsToString(totalTTCInCents)), 1);
        prt.addToBuffer(String.valueOf(DefaultTicketPrinter.formatRight(maxWidth - MAX_PRICE_WIDTH, "Dont TVA : ")) + DefaultTicketPrinter.formatRight(MAX_PRICE_WIDTH, TicketCellRenderer.centsToString(totalTVHAInCents)), 0);
        prt.addToBuffer("");
        for (Paiement paiement : this.paiements) {
            String type = "";
            if (paiement.getType() == 3) {
                type = "Paiement CB";
            } else if (paiement.getType() == 2) {
                type = "Paiement par ch\u00e8que";
            } else if (paiement.getType() == 1) {
                type = "Paiement en esp\u00e8ces";
            }
            int montantInCents = paiement.getMontantInCents();
            if (montantInCents <= 0) continue;
            type = String.valueOf(type) + " de " + TicketCellRenderer.centsToString(montantInCents);
            type = montantInCents > 100 ? String.valueOf(type) + " euros" : String.valueOf(type) + " euro";
            prt.addToBuffer(type);
        }
        if (this.getTotalInCents() < this.getPaidTotal()) {
            int montantInCents = this.getPaidTotal() - this.getTotalInCents();
            String type = "Rendu : " + TicketCellRenderer.centsToString(montantInCents);
            type = montantInCents > 100 ? String.valueOf(type) + " euros" : String.valueOf(type) + " euro";
            prt.addToBuffer(type);
        }
        prt.addToBuffer("");
        List<TicketLine> footers = POSConfiguration.getInstance().getFooterLines();
        for (TicketLine line : footers) {
            prt.addToBuffer(line);
        }
        prt.addToBuffer("");
        prt.addToBuffer(this.getCode(), 10);
        prt.addToBuffer("");
        prt.addToBuffer("Ticket cr\u00e9\u00e9 par l'ERP OpenConcerto.");
        try {
            prt.printBuffer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File getFile() {
        return this.getReceiptCode().getFile();
    }

    public Date getCreationDate() {
        return this.getCreationCal().getTime();
    }

    public Calendar getCreationCal() {
        return this.creationCal;
    }

    public void setCreationCal(Calendar cal) {
        this.creationCal = (Calendar)cal.clone();
    }

    public void addPaiement(Paiement p1) {
        this.paiements.add(p1);
    }

    public void addArticle(Article a) {
        boolean alreadyExist = false;
        for (Pair<Article, Integer> line : this.items) {
            if (!line.getFirst().equals(a)) continue;
            alreadyExist = true;
            break;
        }
        if (!alreadyExist) {
            Pair<Article, Integer> line;
            line = new Pair<Article, Integer>(a, 1);
            this.items.add(line);
        }
    }

    public void incrementArticle(Article a) {
        boolean alreadyExist = false;
        for (Pair<Article, Integer> line : this.items) {
            if (!line.getFirst().equals(a)) continue;
            alreadyExist = true;
            line.setSecond(line.getSecond() + 1);
            break;
        }
        if (!alreadyExist) {
            Pair<Article, Integer> line;
            line = new Pair<Article, Integer>(a, 1);
            this.items.add(line);
        }
    }

    public List<Paiement> getPaiements() {
        return this.paiements;
    }

    public int getTotalInCents() {
        TotalCalculator calc = this.getTotalCalculator();
        BigDecimal totalTTC = calc.getTotalTTC();
        return totalTTC.movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue();
    }

    public TotalCalculator getTotalCalculator() {
        SQLTable tableElt = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().findTable("SAISIE_VENTE_FACTURE_ELEMENT");
        TotalCalculator calc = new TotalCalculator("T_PA_HT", "T_PV_HT", null);
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean bServiceActive = Boolean.valueOf(val);
        calc.setServiceActive(bServiceActive != null && bServiceActive != false);
        int size = this.items.size();
        int i = 0;
        while (i < size) {
            Pair<Article, Integer> line = this.items.get(i);
            int count = line.getSecond();
            Article art = line.getFirst();
            SQLRowValues rowVals = new SQLRowValues(tableElt);
            rowVals.put("T_PV_HT", art.getPriceWithoutTax().multiply(new BigDecimal(count)));
            rowVals.put("QTE", count);
            rowVals.put("ID_TAXE", art.getIdTaxe());
            calc.addLine(rowVals, tableArticle.getRow(art.getId()), i, false);
            ++i;
        }
        calc.checkResult();
        return calc;
    }

    public List<Pair<Article, Integer>> getArticles() {
        return this.items;
    }

    public void clearArticle(Article article) {
        Pair<Article, Integer> toRemove = null;
        for (Pair<Article, Integer> line : this.items) {
            if (!line.getFirst().equals(article)) continue;
            toRemove = line;
            break;
        }
        if (toRemove != null) {
            this.items.remove(toRemove);
        }
    }

    public void setArticleCount(Article article, int count) {
        if (count <= 0) {
            this.clearArticle(article);
            return;
        }
        Pair<Article, Integer> toModify = null;
        for (Pair<Article, Integer> line : this.items) {
            if (!line.getFirst().equals(article)) continue;
            toModify = line;
            break;
        }
        if (toModify != null) {
            toModify.setSecond(count);
        }
    }

    public int getItemCount(Article article) {
        for (Pair<Article, Integer> line : this.items) {
            if (!line.getFirst().equals(article)) continue;
            return line.getSecond();
        }
        return 0;
    }

    public int getPaidTotal() {
        int paid = 0;
        for (Paiement p : this.paiements) {
            paid += p.getMontantInCents();
        }
        return paid;
    }

    public void removeArticle(Article a) {
        Pair<Article, Integer> lineToDelete = null;
        for (Pair<Article, Integer> line : this.items) {
            if (!line.getFirst().equals(a)) continue;
            int count = line.getSecond() + 1;
            if (count <= 0) {
                lineToDelete = line;
            }
            line.setSecond(count);
            break;
        }
        if (lineToDelete != null) {
            this.items.remove(lineToDelete);
        }
    }

    public String toString() {
        return "Ticket " + this.getCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Ticket) {
            Ticket t = (Ticket)obj;
            return t.getCode().equals(this.getCode());
        }
        return false;
    }

    public int hashCode() {
        return this.getCode().hashCode();
    }

    public void deleteTicket() throws IOException {
        this.getReceiptCode().markDeleted();
    }
}

