/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ESCSerialDisplay {
    private static final int CR = 13;
    private String port;
    private int columns;
    private int lines;
    protected static final int ESC = 27;
    protected static final int STX = 2;
    private static final byte CLR = 12;

    public ESCSerialDisplay(String serialPort) {
        this(serialPort, 20, 2);
    }

    public int getColumnCount() {
        return this.columns;
    }

    public int getLineCount() {
        return this.lines;
    }

    public ESCSerialDisplay(String serialPort, int columns, int lines) {
        if (serialPort == null) {
            serialPort = "";
        }
        this.port = serialPort.trim();
        if (this.port.endsWith(":")) {
            this.port = this.port.substring(0, this.port.length() - 1);
        }
        this.columns = columns;
        this.lines = lines;
    }

    private SerialPort getSerialPort() throws Exception {
        if (this.port == null || this.port.length() == 0) {
            throw new IllegalStateException("Invalid serial port name: " + this.port);
        }
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier(this.port);
        if (portIdentifier.isCurrentlyOwned()) {
            throw new IllegalAccessError("Port " + this.port + " is currently in use");
        }
        int timeOutMs = 2000;
        CommPort commPort = portIdentifier.open("ESCSerialDisplay", 2000);
        if (!(commPort instanceof SerialPort)) {
            throw new IllegalStateException("Invalid serial port: " + this.port);
        }
        SerialPort serialPort = (SerialPort)commPort;
        serialPort.setSerialPortParams(9600, 8, 1, 0);
        return serialPort;
    }

    public synchronized void setMessage(String line1, String line2) throws Exception, IOException {
        if (this.port == null || this.port.trim().length() < 3) {
            return;
        }
        if (line1 == null) {
            line1 = "";
        }
        if (line2 == null) {
            line2 = "";
        }
        line1 = this.escape(line1);
        line2 = this.escape(line2);
        SerialPort serialPort = this.getSerialPort();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(12);
        out.write(this.defaultInternationnalCharacterSet('F'));
        out.write(this.overwriteMode());
        out.write(this.overrideO());
        if (line1.length() > this.columns) {
            line1 = line1.substring(0, this.columns);
        }
        if (line2.length() > this.columns) {
            line2 = line2.substring(0, this.columns);
        }
        out.write(27);
        out.write(81);
        out.write(65);
        int i = 0;
        while (i < line1.length()) {
            out.write((byte)line1.charAt(i));
            ++i;
        }
        out.write(13);
        if (this.lines > 1) {
            out.write(27);
            out.write(81);
            out.write(66);
            i = 0;
            while (i < line2.length()) {
                out.write((byte)line2.charAt(i));
                ++i;
            }
            out.write(13);
        }
        out.write(new byte[]{27, 91, 72});
        out.close();
        OutputStream outputStream = serialPort.getOutputStream();
        outputStream.write(out.toByteArray());
        outputStream.close();
        serialPort.close();
    }

    public String escape(String line) {
        line = line.replace('\u00e9', 'e');
        line = line.replace('\u00e8', 'e');
        line = line.replace('\u00ea', 'e');
        line = line.replace('\u00e0', 'a');
        line = line.replace('\u00e7', 'c');
        line = line.replace('\u00ee', 'i');
        line = line.replace('\u00f4', 'o');
        return line;
    }

    private byte[] overrideO() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(new byte[]{27, 37, 1});
        out.write(27);
        out.write(38);
        out.write(1);
        out.write(79);
        out.write(79);
        out.write(5);
        out.write(new byte[]{58, 65, 64, 65, 62});
        return out.toByteArray();
    }

    public byte[] horizontalScrollMode() {
        return new byte[]{27, 19};
    }

    public byte[] overwriteMode() {
        return new byte[]{27, 17};
    }

    private byte[] defaultInternationnalCharacterSet(char c) {
        byte[] b = new byte[]{27, 102, (byte)c};
        return b;
    }

    public static void main(String[] args) throws Exception {
        ESCSerialDisplay d = new ESCSerialDisplay("COM15:", 20, 2);
        d.setMessage("OpenConcerto", "ILM Informatique");
    }
}

