/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.MainFrame;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.pos.TicketPrinterConfiguration;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.model.ReceiptCode;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.model.TicketLine;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemsUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.erp.generationEcritures.GenerationMvtTicketCaisse;
import org.openconcerto.erp.generationEcritures.GenerationMvtVirement;
import org.openconcerto.erp.generationEcritures.GenerationReglementVenteNG;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectHandlerBuilder;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.DesktopEnvironment;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.Pair;
import org.openconcerto.utils.i18n.TranslationManager;

public class POSConfiguration {
    private static final String POS_CONFIGURATION_FILENAME = "pos.xml";
    private static POSConfiguration instance;
    private int screenWidth;
    private int screenHeight;
    private TicketPrinterConfiguration ticketPrinterConf1;
    private TicketPrinterConfiguration ticketPrinterConf2;
    private int userID = 2;
    private int companyID = 42;
    private int posID = 2;
    private int scanDelay = 80;
    private List<TicketLine> headerLines = new ArrayList<TicketLine>();
    private List<TicketLine> footerLines = new ArrayList<TicketLine>();
    private String creditCardPort = "";
    private String LCDSerialPort = "";
    private String LCDLine1 = "Bienvenue";
    private String LCDLine2 = "ILM Informatique";
    private SQLRow rowClient = null;

    public static synchronized POSConfiguration getInstance() {
        if (instance == null) {
            instance = new POSConfiguration();
            instance.loadConfiguration();
        }
        return instance;
    }

    private POSConfiguration() {
        this.ticketPrinterConf1 = new TicketPrinterConfiguration();
        this.ticketPrinterConf2 = new TicketPrinterConfiguration();
        this.ticketPrinterConf2.setCopyCount(0);
    }

    public TicketPrinterConfiguration getTicketPrinterConfiguration1() {
        return this.ticketPrinterConf1;
    }

    public TicketPrinterConfiguration getTicketPrinterConfiguration2() {
        return this.ticketPrinterConf2;
    }

    public boolean isConfigurationFileCreated() {
        File file = POSConfiguration.getConfigFile();
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getUserID() {
        return this.userID;
    }

    public void setUserID(int userID) {
        this.userID = userID;
    }

    public int getCompanyID() {
        return this.companyID;
    }

    public void setCompanyID(int companyID) {
        this.companyID = companyID;
    }

    public int getPosID() {
        return this.posID;
    }

    public void setPosID(int posID) {
        this.posID = posID;
    }

    public int getScanDelay() {
        return this.scanDelay;
    }

    public void setScanDelay(int ms) {
        this.scanDelay = ms;
    }

    public String getCreditCardPort() {
        return this.creditCardPort;
    }

    public void setCreditCardPort(String creditCardPort) {
        this.creditCardPort = creditCardPort;
    }

    public static File getConfigFile(String appName, File wd) {
        File confFile;
        File wdFile = new File(wd + "/Configuration", POS_CONFIGURATION_FILENAME);
        if (wdFile.isFile()) {
            confFile = wdFile;
        } else {
            File preferencesFolder = DesktopEnvironment.getDE().getPreferencesFolder(appName);
            if (!preferencesFolder.exists()) {
                preferencesFolder.mkdir();
            }
            confFile = new File(preferencesFolder, POS_CONFIGURATION_FILENAME);
        }
        return confFile;
    }

    public static File getConfigFile() {
        return POSConfiguration.getConfigFile(ComptaPropsConfiguration.APP_NAME, new File("."));
    }

    public void createConnexion() {
        ComptaPropsConfiguration conf = ComptaPropsConfiguration.create();
        TranslationManager.getInstance().addTranslationStreamFromClass(MainFrame.class);
        TranslationManager.getInstance().setLocale(Locale.getDefault());
        Configuration.setInstance(conf);
        try {
            conf.getBase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            UserManager.getInstance().setCurrentUser(this.getUserID());
            ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
            comptaPropsConfiguration.setUpSocieteDataBaseConnexion(this.getCompanyID());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "Impossible de configurer la connexion \u00e0 la base de donn\u00e9e.\n ID soci\u00e9t\u00e9: " + this.getCompanyID() + " \n ID utilisateur: " + this.getUserID());
            e.printStackTrace();
            System.exit(2);
        }
    }

    public void commitAll(final List<Ticket> tickets) {
        try {
            SQLUtils.executeAtomic(Configuration.getInstance().getSystemRoot().getDataSource(), new SQLUtils.SQLFactory<Object>(){

                @Override
                public Object create() throws SQLException {
                    SQLElement elt = Configuration.getInstance().getDirectory().getElement("TICKET_CAISSE");
                    SQLElement eltFact = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE_ELEMENT");
                    SQLElement eltEnc = Configuration.getInstance().getDirectory().getElement("ENCAISSER_MONTANT");
                    SQLElement eltMode = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
                    SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement("ARTICLE");
                    int imported = 0;
                    for (Ticket ticket : tickets) {
                        SQLSelect sel = new SQLSelect(Configuration.getInstance().getBase());
                        sel.addSelect(elt.getTable().getField("NUMERO"));
                        sel.setWhere(new Where((FieldRef)elt.getTable().getField("NUMERO"), "=", (Object)ticket.getCode()));
                        List l = Configuration.getInstance().getBase().getDataSource().executeCol(sel.asString());
                        if (l == null || l.size() != 0) continue;
                        SQLRowValues rowVals = new SQLRowValues(elt.getTable());
                        rowVals.put("NUMERO", ticket.getCode());
                        rowVals.put("DATE", ticket.getCreationDate());
                        rowVals.put("ID_CAISSE", POSConfiguration.this.getPosID());
                        TotalCalculator calc = new TotalCalculator("T_PA_HT", "T_PV_HT", null);
                        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
                        Boolean bServiceActive = Boolean.valueOf(val);
                        calc.setServiceActive(bServiceActive != null && bServiceActive != false);
                        for (Pair<Article, Integer> item : ticket.getArticles()) {
                            SQLRowValues rowValsElt = new SQLRowValues(eltFact.getTable());
                            Article article = item.getFirst();
                            Integer nb = item.getSecond();
                            rowValsElt.put("QTE", nb);
                            rowValsElt.put("PV_HT", article.getPriceWithoutTax());
                            Float tauxFromId = TaxeCache.getCache().getTauxFromId(article.getIdTaxe());
                            BigDecimal tauxTVA = new BigDecimal(tauxFromId.floatValue()).movePointLeft(2).add(BigDecimal.ONE);
                            BigDecimal valueHT = article.getPriceWithoutTax().multiply(new BigDecimal(nb), DecimalUtils.HIGH_PRECISION);
                            rowValsElt.put("T_PV_HT", valueHT);
                            rowValsElt.put("T_PV_TTC", valueHT.multiply(tauxTVA, DecimalUtils.HIGH_PRECISION));
                            rowValsElt.put("ID_TAXE", article.getIdTaxe());
                            rowValsElt.put("CODE", article.getCode());
                            rowValsElt.put("NOM", article.getName());
                            rowValsElt.put("ID_TICKET_CAISSE", (Object)rowVals);
                            rowValsElt.put("ID_ARTICLE", article.getId());
                            calc.addLine(rowValsElt, eltArticle.getTable().getRow(article.getId()), 0, false);
                        }
                        calc.checkResult();
                        long longValueTotalHT = calc.getTotalHT().movePointRight(2).setScale(0, RoundingMode.HALF_UP).longValue();
                        rowVals.put("TOTAL_HT", longValueTotalHT);
                        long longValueTotal = calc.getTotalTTC().movePointRight(2).setScale(0, RoundingMode.HALF_UP).longValue();
                        rowVals.put("TOTAL_TTC", longValueTotal);
                        long longValueTotalTVA = calc.getTotalTVA().movePointRight(2).setScale(0, RoundingMode.HALF_UP).longValue();
                        rowVals.put("TOTAL_TVA", longValueTotalTVA);
                        for (Paiement paiement : ticket.getPaiements()) {
                            if (paiement.getMontantInCents() <= 0) continue;
                            SQLRowValues rowValsElt = new SQLRowValues(eltEnc.getTable());
                            SQLRowValues rowValsEltMode = new SQLRowValues(eltMode.getTable());
                            if (paiement.getType() == 3) {
                                rowValsEltMode.put("ID_TYPE_REGLEMENT", 3);
                            } else if (paiement.getType() == 2) {
                                rowValsEltMode.put("ID_TYPE_REGLEMENT", 2);
                            } else if (paiement.getType() == 1) {
                                rowValsEltMode.put("ID_TYPE_REGLEMENT", 4);
                            }
                            rowValsElt.put("ID_MODE_REGLEMENT", (Object)rowValsEltMode);
                            try {
                                rowValsElt.put("ID_CLIENT", POSConfiguration.this.getClientCaisse().getID());
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                            long montant = paiement.getMontantInCents();
                            if (ticket.getPaiements().size() == 1 && paiement.getType() == 1) {
                                montant = longValueTotal;
                            }
                            rowValsElt.put("MONTANT", montant);
                            rowValsElt.put("NOM", "Ticket " + ticket.getCode());
                            rowValsElt.put("DATE", ticket.getCreationDate());
                            rowValsElt.put("ID_TICKET_CAISSE", (Object)rowVals);
                        }
                        SQLRow rowFinal = rowVals.insert();
                        ++imported;
                        GenerationMvtTicketCaisse mvt = new GenerationMvtTicketCaisse(rowFinal);
                        try {
                            Integer idMvt = mvt.genereMouvement().call();
                            SQLRowValues valTicket = rowFinal.asRowValues();
                            valTicket.put("ID_MOUVEMENT", idMvt);
                            rowFinal = valTicket.update();
                            Collection rowsEnc = rowFinal.getReferentRows(eltEnc.getTable());
                            long totalEnc = 0L;
                            for (SQLRow sqlRow : rowsEnc) {
                                long montant = sqlRow.getLong("MONTANT");
                                PrixTTC ttc = new PrixTTC(montant);
                                totalEnc += montant;
                                new GenerationReglementVenteNG("R\u00e8glement " + sqlRow.getForeignRow("ID_MODE_REGLEMENT").getForeignRow("ID_TYPE_REGLEMENT").getString("NOM") + " Ticket " + rowFinal.getString("NUMERO"), POSConfiguration.this.getClientCaisse(), ttc, sqlRow.getDate("DATE").getTime(), sqlRow.getForeignRow("ID_MODE_REGLEMENT"), rowFinal, rowFinal.getForeignRow("ID_MOUVEMENT"), false);
                            }
                            if (totalEnc > longValueTotal) {
                                SQLTable table = Configuration.getInstance().getDirectory().getElement("TYPE_REGLEMENT").getTable();
                                int idComptePceCaisse = table.getRow(4).getInt("ID_COMPTE_PCE_CLIENT");
                                if (idComptePceCaisse == table.getUndefinedID()) {
                                    idComptePceCaisse = ComptePCESQLElement.getId(ComptePCESQLElement.getComptePceDefault("VenteEspece"));
                                }
                                new GenerationMvtVirement(idComptePceCaisse, POSConfiguration.this.getClientCaisse().getInt("ID_COMPTE_PCE"), 0L, totalEnc - longValueTotal, "Rendu sur r\u00e8glement  Ticket " + rowFinal.getString("NUMERO"), new Date(), 5, " Ticket " + rowFinal.getString("NUMERO")).genereMouvement();
                            }
                        }
                        catch (Exception exn) {
                            exn.printStackTrace();
                            throw new SQLException(exn);
                        }
                        POSConfiguration.this.updateStock(rowFinal.getID());
                    }
                    for (Ticket ticket : tickets) {
                        ReceiptCode code = ticket.getReceiptCode();
                        try {
                            code.markImported();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        ReceiptCode.archiveCompletelyImported();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    final String count = String.valueOf(imported) + "/" + tickets.size();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, String.valueOf(count) + " ticket(s) import\u00e9(s). Cl\u00f4ture de la caisse termin\u00e9e.");
                        }
                    });
                    return null;
                }
            });
        }
        catch (Exception exn) {
            ExceptionHandler.handle("Une erreur est survenue pendant la cl\u00f4ture.", exn);
        }
    }

    private SQLRow getClientCaisse() throws SQLException {
        if (this.rowClient == null) {
            SQLElement elt = Configuration.getInstance().getDirectory().getElement("CLIENT");
            SQLSelect sel = new SQLSelect();
            sel.addSelectStar(elt.getTable());
            sel.setWhere(new Where((FieldRef)elt.getTable().getField("NOM"), "=", (Object)"Caisse OpenConcerto"));
            List l = (List)elt.getTable().getBase().getDataSource().execute(sel.asString(), new SQLSelectHandlerBuilder(sel).createHandler());
            if (l.size() > 0) {
                this.rowClient = (SQLRow)l.get(0);
            } else {
                SQLRowValues rowValues = new SQLRowValues(elt.getTable());
                rowValues.put("NOM", "Caisse OpenConcerto");
                SQLRowValues rowValuesMode = new SQLRowValues(elt.getTable().getTable("MODE_REGLEMENT"));
                rowValuesMode.put("ID_TYPE_REGLEMENT", 3);
                rowValues.put("ID_MODE_REGLEMENT", (Object)rowValuesMode);
                SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
                SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
                SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
                int idDefaultCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT");
                if (idDefaultCompteClient <= 1) {
                    try {
                        idDefaultCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                rowValues.put("ID_COMPTE_PCE", idDefaultCompteClient);
                this.rowClient = rowValues.insert();
            }
        }
        return this.rowClient;
    }

    private void updateStock(int id) throws SQLException {
        SQLRow row = this.getClientCaisse().getTable().getTable("TICKET_CAISSE").getRow(id);
        StockItemsUpdater stockUpdater = new StockItemsUpdater(new StockLabel(){

            @Override
            public String getLabel(SQLRowAccessor rowOrigin, SQLRowAccessor rowElt) {
                return "Ticket N\u00b0" + rowOrigin.getString("NUMERO");
            }
        }, row, (List<? extends SQLRowAccessor>)row.getReferentRows(this.getClientCaisse().getTable().getTable("SAISIE_VENTE_FACTURE_ELEMENT")), StockItemsUpdater.TypeStockUpdate.REAL_DELIVER);
        stockUpdater.update();
    }

    public List<Ticket> allTickets() {
        ArrayList<Ticket> l = new ArrayList<Ticket>();
        for (File f : ReceiptCode.getReceiptsToImport(this.getPosID())) {
            Ticket ticket = Ticket.parseFile(f);
            if (ticket == null) continue;
            l.add(ticket);
        }
        return l;
    }

    public List<TicketLine> getHeaderLines() {
        return this.headerLines;
    }

    public void setHeaderLines(List<TicketLine> headerLines) {
        this.headerLines = headerLines;
    }

    public List<TicketLine> getFooterLines() {
        return this.footerLines;
    }

    public void setFooterLines(List<TicketLine> footerLines) {
        this.footerLines = footerLines;
    }

    private void loadConfiguration() {
        if (!this.isConfigurationFileCreated()) {
            System.err.println("POSConfiguration.loadConfigurationFromXML() configuration not loaded. " + POSConfiguration.getConfigFile().getAbsolutePath() + " missing.");
            return;
        }
        SAXBuilder builder = new SAXBuilder();
        File file = POSConfiguration.getConfigFile();
        try {
            List<Element> printers;
            List<Element> footers;
            List<Element> headers;
            List<Element> childrenLCD;
            List<Element> childrenCreditCard;
            System.out.println("POSConfiguration.loadConfigurationFromXML() loading " + file.getAbsolutePath());
            Document document = builder.build(file);
            Element rootElement = document.getRootElement();
            this.setUserID(Integer.valueOf(rootElement.getAttributeValue("userID", "2")));
            this.setCompanyID(Integer.valueOf(rootElement.getAttributeValue("societeID", "42")));
            this.setPosID(Integer.valueOf(rootElement.getAttributeValue("caisseID", "2")));
            this.setScanDelay(Integer.valueOf(rootElement.getAttributeValue("scanDelay", "80")));
            List<Element> children = rootElement.getChildren("screen");
            if (children != null) {
                for (Element e : children) {
                    this.screenWidth = Integer.valueOf(e.getAttributeValue("width", "0"));
                    this.screenHeight = Integer.valueOf(e.getAttributeValue("height", "0"));
                }
            }
            if ((childrenCreditCard = rootElement.getChildren("creditcard")) != null) {
                for (Element e : childrenCreditCard) {
                    this.creditCardPort = e.getAttributeValue("port", "");
                }
            }
            if ((childrenLCD = rootElement.getChildren("lcd")) != null) {
                for (Element e : childrenLCD) {
                    this.LCDSerialPort = e.getAttributeValue("port", "");
                    this.LCDLine1 = e.getAttributeValue("line1", "");
                    this.LCDLine2 = e.getAttributeValue("line2", "");
                }
            }
            if ((headers = rootElement.getChildren("header")) != null) {
                for (Element header : headers) {
                    this.headerLines.add(new TicketLine(header.getValue(), header.getAttributeValue("style")));
                }
            }
            if ((footers = rootElement.getChildren("footer")) != null) {
                for (Element header : footers) {
                    this.footerLines.add(new TicketLine(header.getValue(), header.getAttributeValue("style")));
                }
            }
            if ((printers = rootElement.getChildren("ticketPrinter")).size() > 0) {
                this.configureTicketPrinter(this.ticketPrinterConf1, printers.get(0));
            }
            if (printers.size() > 1) {
                this.configureTicketPrinter(this.ticketPrinterConf2, printers.get(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void configureTicketPrinter(TicketPrinterConfiguration conf, Element element) {
        conf.setType(element.getAttributeValue("type"));
        conf.setName(element.getAttributeValue("name"));
        conf.setCopyCount(Integer.parseInt(element.getAttributeValue("copyCount")));
        conf.setTicketWidth(Integer.parseInt(element.getAttributeValue("ticketWidth")));
        conf.setFolder(element.getAttributeValue("folder", ""));
    }

    private Element getElementFromConfiguration(TicketPrinterConfiguration conf) {
        Element element = new Element("ticketPrinter");
        element.setAttribute("type", conf.getType());
        element.setAttribute("name", conf.getName());
        element.setAttribute("copyCount", String.valueOf(conf.getCopyCount()));
        element.setAttribute("ticketWidth", String.valueOf(conf.getTicketWidth()));
        element.setAttribute("folder", conf.getFolder());
        return element;
    }

    public void saveConfiguration() {
        File file = POSConfiguration.getConfigFile();
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            String style;
            Element e;
            System.out.println("Saving:" + file.getAbsolutePath());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Document doc = new Document();
            Element configElement = new Element("config");
            configElement.setAttribute("userID", String.valueOf(this.userID));
            configElement.setAttribute("societeID", String.valueOf(this.companyID));
            configElement.setAttribute("caisseID", String.valueOf(this.posID));
            configElement.setAttribute("scanDelay", String.valueOf(this.scanDelay));
            doc.addContent(configElement);
            Element screenElement = new Element("screen");
            screenElement.setAttribute("width", String.valueOf(this.screenWidth));
            screenElement.setAttribute("height", String.valueOf(this.screenHeight));
            configElement.addContent(screenElement);
            Element creditCardElement = new Element("creditcard");
            creditCardElement.setAttribute("port", this.creditCardPort);
            configElement.addContent(creditCardElement);
            Element lcdElement = new Element("lcd");
            lcdElement.setAttribute("port", this.LCDSerialPort);
            lcdElement.setAttribute("line1", this.LCDLine1);
            lcdElement.setAttribute("line2", this.LCDLine2);
            configElement.addContent(lcdElement);
            for (TicketLine line : this.headerLines) {
                e = new Element("header");
                style = line.getStyle();
                if (style != null && !style.isEmpty()) {
                    e.setAttribute("style", style);
                }
                e.setText(line.getText());
                configElement.addContent(e);
            }
            for (TicketLine line : this.footerLines) {
                e = new Element("footer");
                style = line.getStyle();
                if (style != null && !style.isEmpty()) {
                    e.setAttribute("style", style);
                }
                e.setText(line.getText());
                configElement.addContent(e);
            }
            configElement.addContent(this.getElementFromConfiguration(this.ticketPrinterConf1));
            configElement.addContent(this.getElementFromConfiguration(this.ticketPrinterConf2));
            outputter.output(doc, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionHandler.handle("Erreur lors de la sauvegarde de la configuration de la caisse.\n" + file.getAbsolutePath());
        }
    }

    public void print(Ticket ticket) {
        this.print(ticket, this.ticketPrinterConf1);
        this.print(ticket, this.ticketPrinterConf2);
    }

    public void print(Ticket ticket, TicketPrinterConfiguration conf) {
        if (conf.isValid() && conf.getCopyCount() > 0) {
            TicketPrinter prt = conf.createTicketPrinter();
            int i = 0;
            while (i < conf.getCopyCount()) {
                ticket.print(prt, conf.getTicketWidth());
                ++i;
            }
        }
    }

    public boolean isUsingJPos() {
        return false;
    }

    public List<String> getJPosDirectories() {
        ArrayList<String> result = new ArrayList<String>();
        return result;
    }

    public String getLCDSerialPort() {
        return this.LCDSerialPort;
    }

    public void setLCDSerialPort(String port) {
        this.LCDSerialPort = port;
    }

    public String getLCDLine1() {
        return this.LCDLine1;
    }

    public void setLCDLine1(String text) {
        this.LCDLine1 = text;
    }

    public String getLCDLine2() {
        return this.LCDLine2;
    }

    public void setLCDLine2(String text) {
        this.LCDLine2 = text;
    }
}

