/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.common.ui.ListeViewPanel;
import org.openconcerto.erp.core.finance.accounting.ui.ListeGestCommEltPanel;
import org.openconcerto.erp.core.sales.invoice.component.SaisieVenteFactureSQLComponent;
import org.openconcerto.erp.core.sales.invoice.ui.DateEnvoiRenderer;
import org.openconcerto.erp.core.sales.invoice.ui.ListeFactureRenderer;
import org.openconcerto.erp.core.sales.pos.ui.TextAreaTicketPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.IListener;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.PanelFrame;
import org.openconcerto.ui.table.TimestampTableCellEditor;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.TableSorter;
import org.openconcerto.utils.cc.IClosure;

public class ListeDesVentesPanel
extends JPanel
implements ActionListener {
    private ListeGestCommEltPanel listeFact;
    private JButton buttonEnvoye;
    private JButton buttonRegle;
    private JButton buttonDupliquer;
    private JLabelBold textField = new JLabelBold("0");
    private JLabelBold textField2 = new JLabelBold("0");
    private EditFrame editFrame;

    public ListeDesVentesPanel() {
        SQLElement elementVF;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 1, 2);
        c.fill = 1;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JTabbedPane tabbedPane = new JTabbedPane();
        SQLElement eltFacture = elementVF = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        SQLTableModelSourceOnline src = eltFacture.getTableSource(true);
        Where wPrev = new Where((FieldRef)eltFacture.getTable().getField("PREVISIONNELLE"), "=", (Object)Boolean.FALSE);
        if (src.getReq().getWhere() != null) {
            wPrev = wPrev.and(src.getReq().getWhere());
        }
        src.getReq().setWhere(wPrev);
        ListeFactureRenderer rend = new ListeFactureRenderer();
        for (SQLTableModelColumn column : src.getColumns()) {
            if (column.getClass().isAssignableFrom(SQLTableModelColumnPath.class)) {
                ((SQLTableModelColumnPath)column).setEditable(false);
            }
            if (column.getName().startsWith("Avancement")) continue;
            column.setRenderer(rend);
        }
        SQLTableModelColumn dateEnvoiCol = src.getColumn(eltFacture.getTable().getField("DATE_ENVOI"));
        ((SQLTableModelColumnPath)dateEnvoiCol).setEditable(true);
        SQLTableModelColumn dateReglCol = src.getColumn(eltFacture.getTable().getField("DATE_REGLEMENT"));
        if (dateReglCol != null) {
            ((SQLTableModelColumnPath)dateReglCol).setEditable(true);
        }
        dateEnvoiCol.setColumnInstaller(new IClosure<TableColumn>(){

            @Override
            public void executeChecked(TableColumn columnDateEnvoi) {
                columnDateEnvoi.setCellEditor(new TimestampTableCellEditor());
                columnDateEnvoi.setCellRenderer(new DateEnvoiRenderer());
            }
        });
        if (dateReglCol != null) {
            dateReglCol.setColumnInstaller(new IClosure<TableColumn>(){

                @Override
                public void executeChecked(TableColumn columnDateReglement) {
                    columnDateReglement.setCellEditor(new TimestampTableCellEditor());
                    columnDateReglement.setCellRenderer(new DateEnvoiRenderer());
                }
            });
        }
        this.listeFact = new ListeGestCommEltPanel(eltFacture, new IListe(src), true);
        this.listeFact.setOpaque(false);
        this.listeFact.getListe().setSQLEditable(true);
        JTable tableFact = this.listeFact.getListe().getJTable();
        SQLTableModelColumn numeroCol = src.getColumn(eltFacture.getTable().getField("NUMERO"));
        ((TableSorter)tableFact.getModel()).setSortingStatus(src.getColumns().indexOf(numeroCol), 1);
        JPanel panelFacture = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cFacture = new DefaultGridBagConstraints();
        this.buttonEnvoye = new JButton("Facture envoy\u00e9e");
        cFacture.fill = 0;
        this.buttonEnvoye.addActionListener(this);
        this.buttonEnvoye.setEnabled(false);
        panelFacture.setOpaque(false);
        panelFacture.add((Component)this.buttonEnvoye, cFacture);
        this.buttonRegle = new JButton("Facture r\u00e9gl\u00e9e");
        this.buttonRegle.addActionListener(this);
        this.buttonRegle.setEnabled(false);
        ++cFacture.gridx;
        panelFacture.add((Component)this.buttonRegle, cFacture);
        this.buttonDupliquer = new JButton("Cr\u00e9er \u00e0 partir de");
        cFacture.fill = 0;
        this.buttonDupliquer.addActionListener(this);
        this.buttonDupliquer.setEnabled(false);
        ++cFacture.gridx;
        panelFacture.add((Component)this.buttonDupliquer, cFacture);
        ++cFacture.gridy;
        cFacture.gridx = 0;
        cFacture.weighty = 1.0;
        cFacture.weightx = 1.0;
        cFacture.gridwidth = 0;
        cFacture.fill = 1;
        panelFacture.add((Component)this.listeFact, cFacture);
        ArrayList<SQLField> l = new ArrayList<SQLField>();
        l.add(eltFacture.getTable().getField("T_HT"));
        l.add(eltFacture.getTable().getField("T_TTC"));
        IListTotalPanel total = new IListTotalPanel(this.listeFact.getListe(), l);
        cFacture.weighty = 0.0;
        cFacture.fill = 0;
        ++cFacture.gridy;
        cFacture.anchor = 13;
        total.setOpaque(false);
        panelFacture.add((Component)total, cFacture);
        IListFilterDatePanel filterDate = new IListFilterDatePanel(this.listeFact.getListe(), eltFacture.getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        cFacture.weighty = 0.0;
        cFacture.fill = 2;
        ++cFacture.gridy;
        filterDate.setOpaque(false);
        panelFacture.add((Component)filterDate, cFacture);
        tabbedPane.add("Ventes avec facture", panelFacture);
        this.listeFact.getListe().addIListener(new IListener(){

            @Override
            public void selectionId(int id, int field) {
                ListeDesVentesPanel.this.buttonEnvoye.setEnabled(id > 1);
                ListeDesVentesPanel.this.buttonRegle.setEnabled(id > 1);
                if (id > 1) {
                    ITableModel model = ListeDesVentesPanel.this.listeFact.getListe().getModel();
                    SQLRowValues r = model.getRow(model.indexFromID(id)).getRow();
                    ListeDesVentesPanel.this.buttonDupliquer.setEnabled(r.getBoolean("PARTIAL") == false && r.getBoolean("SOLDE") == false);
                } else {
                    ListeDesVentesPanel.this.buttonDupliquer.setEnabled(false);
                }
            }
        });
        ListeViewPanel panelTicket = new ListeViewPanel(Configuration.getInstance().getDirectory().getElement("TICKET_CAISSE")){

            @Override
            protected void handleAction(JButton source, ActionEvent evt) {
                if (source == this.buttonModifier) {
                    new PanelFrame(new TextAreaTicketPanel(this.getListe().fetchSelectedRow()), "Ticket").setVisible(true);
                } else {
                    super.handleAction(source, evt);
                }
            }
        };
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cc = new DefaultGridBagConstraints();
        cc.weightx = 1.0;
        cc.weighty = 1.0;
        cc.fill = 1;
        panel.add((Component)panelTicket, cc);
        ArrayList<SQLField> l2 = new ArrayList<SQLField>();
        l2.add(panelTicket.getElement().getTable().getField("TOTAL_HT"));
        l2.add(panelTicket.getElement().getTable().getField("TOTAL_TTC"));
        IListTotalPanel total2 = new IListTotalPanel(panelTicket.getListe(), l2);
        cc.weighty = 0.0;
        cc.fill = 0;
        ++cc.gridy;
        cc.anchor = 13;
        total2.setOpaque(false);
        panel.add((Component)total2, cc);
        IListFilterDatePanel filterDate2 = new IListFilterDatePanel(panelTicket.getListe(), panelTicket.getElement().getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        cc.weighty = 0.0;
        cc.fill = 2;
        ++cc.gridy;
        filterDate2.setOpaque(false);
        panel.add((Component)filterDate2, cc);
        tabbedPane.add("Ventes caisse", panel);
        ListeGestCommEltPanel listeVC = new ListeGestCommEltPanel(Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_COMPTOIR"), true);
        listeVC.getListe().setSQLEditable(false);
        listeVC.setOpaque(false);
        JTable table = listeVC.getListe().getJTable();
        int i = 0;
        while (i < table.getColumnCount()) {
            if (table.getColumnClass(i) == Long.class || table.getColumnClass(i) == BigInteger.class) {
                table.getColumnModel().getColumn(i).setCellRenderer(rend);
            }
            ++i;
        }
        JPanel panelComptoir = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cc2 = new DefaultGridBagConstraints();
        cc2.weightx = 1.0;
        cc2.weighty = 1.0;
        cc2.fill = 1;
        panelComptoir.add((Component)listeVC, cc2);
        ArrayList<SQLField> l22 = new ArrayList<SQLField>();
        l22.add(listeVC.getElement().getTable().getField("MONTANT_HT"));
        l22.add(listeVC.getElement().getTable().getField("MONTANT_TTC"));
        IListTotalPanel total22 = new IListTotalPanel(listeVC.getListe(), l22);
        cc2.weighty = 0.0;
        cc2.fill = 0;
        ++cc2.gridy;
        cc2.anchor = 13;
        total22.setOpaque(false);
        panelComptoir.add((Component)total22, cc2);
        IListFilterDatePanel filterDate22 = new IListFilterDatePanel(listeVC.getListe(), listeVC.getElement().getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        cc2.weighty = 0.0;
        cc2.fill = 2;
        ++cc2.gridy;
        filterDate22.setOpaque(false);
        panelComptoir.add((Component)filterDate22, cc2);
        tabbedPane.add("Ventes comptoir", panelComptoir);
        this.add((Component)tabbedPane, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonEnvoye) {
            List<SQLRowValues> selectedRows = this.listeFact.getListe().getSelectedRows();
            for (SQLRowAccessor sQLRowAccessor : selectedRows) {
                SQLRowValues rowVals = sQLRowAccessor.asRow().createEmptyUpdateRow();
                rowVals.put("DATE_ENVOI", new Date());
                try {
                    rowVals.update();
                }
                catch (SQLException e1) {
                    ExceptionHandler.handle("Modification impossible", e1);
                }
            }
        } else if (e.getSource() == this.buttonRegle) {
            List<SQLRowValues> selectedRows = this.listeFact.getListe().getSelectedRows();
            for (SQLRowAccessor sQLRowAccessor : selectedRows) {
                SQLRowValues rowVals = sQLRowAccessor.asRow().createEmptyUpdateRow();
                rowVals.put("DATE_REGLEMENT", new Date());
                try {
                    rowVals.update();
                }
                catch (SQLException e1) {
                    ExceptionHandler.handle("Modification impossible", e1);
                }
            }
        } else if (e.getSource() == this.buttonDupliquer) {
            if (this.editFrame == null) {
                SQLElement eltFact = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
                this.editFrame = new EditFrame(eltFact, EditPanel.CREATION);
            }
            SQLRow selectedRow = this.listeFact.getListe().getSelectedRow().asRow();
            ((SaisieVenteFactureSQLComponent)this.editFrame.getSQLComponent()).loadFactureExistante(selectedRow.getID());
            this.editFrame.setVisible(true);
        }
    }
}

