/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.ui;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.openconcerto.erp.core.common.ui.DeviseNiceTableCellRenderer;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.ITableModel;

public class EcheanceRenderer
extends DeviseNiceTableCellRenderer {
    private static EcheanceRenderer instance = null;

    public static synchronized EcheanceRenderer getInstance() {
        if (instance == null) {
            instance = new EcheanceRenderer();
        }
        return instance;
    }

    private EcheanceRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        SQLRowValues rowAt = ITableModel.getLine(table.getModel(), row).getRow();
        if (comp instanceof JLabel) {
            JLabel label = (JLabel)comp;
            SQLRowAccessor foreignRow = rowAt.getForeign("ID_MODE_REGLEMENT");
            if (foreignRow != null) {
                int ajours = foreignRow.getInt("AJOURS");
                int njour = foreignRow.getInt("LENJOUR");
                if (ajours == 0 && njour == 0) {
                    if (foreignRow.getBoolean("COMPTANT") != null && !foreignRow.getBoolean("COMPTANT").booleanValue()) {
                        label.setText("Date de facture");
                    } else {
                        label.setText("Comptant");
                    }
                } else {
                    String s = "";
                    if (ajours != 0) {
                        s = String.valueOf(ajours) + (ajours > 1 ? " jours" : " jour");
                    }
                    s = njour > 0 && njour < 31 ? String.valueOf(s) + " le " + njour : (njour == 0 ? String.valueOf(s) + " date de facture" : String.valueOf(s) + " fin de mois");
                    label.setText(s);
                }
            }
        }
        return comp;
    }
}

