/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.credit.element;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.sales.credit.component.AvoirClientSQLComponent;
import org.openconcerto.erp.generationDoc.gestcomm.AvoirClientXmlSheet;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieVenteFacture;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.element.SQLElementLinksSetup;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.utils.ExceptionHandler;

public class AvoirClientSQLElement
extends ComptaSQLConfElement {
    public AvoirClientSQLElement() {
        super("AVOIR_CLIENT", "une facture d'avoir", "factures d'avoir");
        this.getRowActions().addAll(new MouseSheetXmlListeListener(AvoirClientXmlSheet.class).getRowActions());
    }

    @Override
    protected void setupLinks(SQLElementLinksSetup links) {
        super.setupLinks(links);
        if (this.getTable().contains("ID_ADRESSE")) {
            links.get("ID_ADRESSE").setType(SQLElementLink.LinkType.ASSOCIATION);
        }
        if (this.getTable().contains("ID_ADRESSE_LIVRAISON")) {
            links.get("ID_ADRESSE_LIVRAISON").setType(SQLElementLink.LinkType.ASSOCIATION);
        }
    }

    @Override
    public List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("ID_COMMERCIAL");
        l.add("ID_CLIENT");
        l.add("NOM");
        l.add("DATE");
        l.add("MONTANT_HT");
        l.add("MONTANT_TTC");
        l.add("MONTANT_SOLDE");
        l.add("MONTANT_RESTANT");
        l.add("SOLDE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("NOM");
        l.add("NUMERO");
        l.add("MONTANT_TTC");
        l.add("MONTANT_SOLDE");
        return l;
    }

    @Override
    protected SQLTableModelSourceOnline createTableSource() {
        SQLTableModelSourceOnline table = super.createTableSource();
        return table;
    }

    @Override
    public SQLComponent createComponent() {
        return new AvoirClientSQLComponent();
    }

    @Override
    protected void _initListRequest(ListSQLRequest req) {
        super._initListRequest(req);
        req.addToGraphToFetch("A_DEDUIRE", "MOTIF");
    }

    public void annulationAvoir(SQLRowAccessor row) {
        Collection<? extends SQLRowAccessor> rows = row.getReferentRows(this.getTable().getTable("SAISIE_VENTE_FACTURE"));
        for (SQLRowAccessor sQLRowAccessor : rows) {
            SQLRowAccessor rowAvoir = sQLRowAccessor.getForeign("ID_AVOIR_CLIENT");
            Long montantSolde = (Long)rowAvoir.getObject("MONTANT_SOLDE");
            Long avoirTTC = (Long)sQLRowAccessor.getObject("T_AVOIR_TTC");
            long montant = montantSolde - avoirTTC;
            if (montant < 0L) {
                montant = 0L;
            }
            SQLRowValues rowVals = rowAvoir.createEmptyUpdateRow();
            rowVals.put("SOLDE", Boolean.FALSE);
            rowVals.put("MONTANT_SOLDE", montant);
            Long restant = (Long)rowAvoir.getObject("MONTANT_TTC") - montantSolde;
            rowVals.put("MONTANT_RESTANT", restant);
            try {
                rowVals.update();
                SQLRowValues createEmptyUpdateRow = sQLRowAccessor.createEmptyUpdateRow();
                createEmptyUpdateRow.putEmptyLink("ID_AVOIR_CLIENT");
                createEmptyUpdateRow.put("NET_A_PAYER", sQLRowAccessor.getObject("T_TTC"));
                createEmptyUpdateRow.put("T_AVOIR_TTC", 0L);
                createEmptyUpdateRow.update();
                EcritureSQLElement eltEcr = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement("ECRITURE");
                int foreignIDmvt = sQLRowAccessor.getForeignID("ID_MOUVEMENT");
                eltEcr.archiveMouvementProfondeur(foreignIDmvt, false);
                System.err.println("Regeneration des ecritures");
                new GenerationMvtSaisieVenteFacture(sQLRowAccessor.getID(), foreignIDmvt);
                System.err.println("Fin regeneration");
            }
            catch (SQLException e) {
                ExceptionHandler.handle("Erreur lors de l'annulation de l'avoir", e);
            }
        }
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        for (SQLRow row : trees.getRows()) {
            this.annulationAvoir(row);
            SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
            SQLSelect sel = new SQLSelect(eltMvtStock.getTable().getBase());
            sel.addSelect(eltMvtStock.getTable().getField("ID"));
            Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", row.getID());
            Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
            sel.setWhere(w.and(w2));
            List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
            if (l == null) continue;
            int i = 0;
            while (i < l.size()) {
                Object[] tmp = (Object[])l.get(i);
                eltMvtStock.archive(((Number)tmp[0]).intValue());
                ++i;
            }
        }
        super.archive(trees, cutLinks);
    }
}

