/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.report;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.SheetInterface;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class LivrePayeSheet
extends SheetInterface {
    private static int debutFill;
    private static int endFill;
    private static int nbCol;
    private static final SQLTable tableSalarie;
    private static final SQLTable tableFichePaye;
    private static final SQLTable tableFichePayeElement;
    private static final SQLTable tableMois;
    private static final SQLTable tableRubCot;
    private static final SQLTable tableRubNet;
    private static final SQLTable tableRubBrut;
    private static final DateFormat dateFormat;
    private int moisDu;
    private int moisAu;
    private String annee;
    public static final String TEMPLATE_ID = "Livre de paye";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationLivrePaye";

    static {
        tableSalarie = base.getTable("SALARIE");
        tableFichePaye = base.getTable("FICHE_PAYE");
        tableFichePayeElement = base.getTable("FICHE_PAYE_ELEMENT");
        tableMois = base.getTable("MOIS");
        tableRubCot = Configuration.getInstance().getBase().getTable("RUBRIQUE_COTISATION");
        tableRubNet = Configuration.getInstance().getBase().getTable("RUBRIQUE_NET");
        tableRubBrut = Configuration.getInstance().getBase().getTable("RUBRIQUE_BRUT");
        dateFormat = DateFormat.getDateInstance(2);
        LivrePayeSheet.setSize(9, 65, 6);
    }

    public static void setSize(int debut, int fin, int col) {
        debutFill = debut;
        endFill = fin;
        nbCol = col;
    }

    @Override
    protected String getYear() {
        return "";
    }

    public LivrePayeSheet(int moisDu, int moisAu, String annee) {
        this.printer = PrinterNXProps.getInstance().getStringProperty("LivrePayePrinter");
        this.modele = "LivrePaye.ods";
        this.moisAu = moisAu;
        this.moisDu = moisDu;
        this.annee = annee;
        this.nbRowsPerPage = 67;
        this.createMap();
    }

    private void makeEntete(int row) {
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        this.mCell.put("A" + row, rowSociete.getObject("NOM"));
        this.mCell.put("G" + row, "Edition du " + dateFormat.format(new Date()));
        System.err.println("MAKE ENTETE");
    }

    private void makeBasPage(int row) {
        SQLRow rowMoisDu = tableMois.getRow(this.moisDu);
        SQLRow rowMoisAu = tableMois.getRow(this.moisAu);
        this.mCell.put("A" + row, "P\u00e9riode de " + rowMoisDu.getString("NOM") + " \u00e0 " + rowMoisAu.getString("NOM") + " " + this.annee);
    }

    @Override
    public String getTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    protected void createMap() {
        this.mapReplace = new HashMap();
        this.mCell = new HashMap();
        this.mapStyleRow = new HashMap();
        SQLSelect sel = new SQLSelect(base);
        sel.addSelect(tableFichePaye.getField("ID"));
        sel.addSelect(tableFichePayeElement.getField("ID"));
        sel.addSelect(tableSalarie.getField("ID"));
        Where w = new Where((FieldRef)tableFichePayeElement.getField("ID_FICHE_PAYE"), "=", tableFichePaye.getField("ID"));
        Where w2 = new Where((FieldRef)tableFichePaye.getField("ID_SALARIE"), "=", tableSalarie.getField("ID"));
        Where w3 = new Where((FieldRef)tableFichePaye.getField("ID_MOIS"), new Integer(this.moisDu), (Object)new Integer(this.moisAu));
        Where w4 = new Where((FieldRef)tableFichePaye.getField("ANNEE"), "=", (Object)new Integer(this.annee));
        Where w5 = new Where((FieldRef)tableFichePaye.getField("VALIDE"), "=", (Object)Boolean.TRUE);
        sel.setWhere(w);
        sel.andWhere(w2);
        sel.andWhere(w3);
        sel.andWhere(w4);
        sel.andWhere(w5);
        String req = sel.asString();
        System.err.println(req);
        List l = (List)base.getDataSource().execute(req, new ArrayListHandler());
        HashMap mapSalarieBrut = new HashMap();
        HashMap mapSalarieNet = new HashMap();
        HashMap mapSalarieCot = new HashMap();
        HashMap mapTotalCot = new HashMap();
        HashMap mapTotalNet = new HashMap();
        HashMap mapTotalbrut = new HashMap();
        HashMap<Integer, String> mapRubriqueBrut = new HashMap<Integer, String>();
        HashMap<Integer, String> mapRubriqueNet = new HashMap<Integer, String>();
        HashMap<Integer, String> mapRubriqueCot = new HashMap<Integer, String>();
        HashMap<Integer, String> mapSal = new HashMap<Integer, String>();
        int i = 0;
        while (i < l.size()) {
            float montantTotal;
            float montant;
            Object oTot;
            Object o;
            Object[] tmp = (Object[])l.get(i);
            int idFicheElt = Integer.parseInt(tmp[1].toString());
            int idSal = Integer.parseInt(tmp[2].toString());
            Map<String, Float> mapValue = new HashMap();
            HashMap<Object, Float> mapTotal = new HashMap<Object, Float>();
            SQLRow rowFicheElt = tableFichePayeElement.getRow(idFicheElt);
            mapSal.put(new Integer(idSal), "");
            if (rowFicheElt.getString("SOURCE").equalsIgnoreCase("RUBRIQUE_BRUT")) {
                mapRubriqueBrut.put(new Integer(rowFicheElt.getInt("IDSOURCE")), "");
                mapTotal = mapTotalbrut;
                if (mapSalarieBrut.get(new Integer(idSal)) == null) {
                    mapSalarieBrut.put(new Integer(idSal), mapValue);
                } else {
                    mapValue = (Map)mapSalarieBrut.get(new Integer(idSal));
                }
            } else if (rowFicheElt.getString("SOURCE").equalsIgnoreCase("RUBRIQUE_COTISATION")) {
                mapRubriqueCot.put(new Integer(rowFicheElt.getInt("IDSOURCE")), "");
                mapTotal = mapTotalCot;
                if (mapSalarieCot.get(new Integer(idSal)) == null) {
                    mapSalarieCot.put(new Integer(idSal), mapValue);
                } else {
                    mapValue = (Map)mapSalarieCot.get(new Integer(idSal));
                }
            } else if (rowFicheElt.getString("SOURCE").equalsIgnoreCase("RUBRIQUE_NET")) {
                mapRubriqueNet.put(new Integer(rowFicheElt.getInt("IDSOURCE")), "");
                mapTotal = mapTotalNet;
                if (mapSalarieNet.get(new Integer(idSal)) == null) {
                    mapSalarieNet.put(new Integer(idSal), mapValue);
                } else {
                    mapValue = (Map)mapSalarieNet.get(new Integer(idSal));
                }
            }
            if (rowFicheElt.getObject("MONTANT_SAL_AJ") != null) {
                o = mapValue.get(new Integer(rowFicheElt.getInt("IDSOURCE")));
                oTot = mapTotal.get(new Integer(rowFicheElt.getInt("IDSOURCE")));
                montant = o == null ? 0.0f : ((Float)o).floatValue();
                montantTotal = oTot == null ? 0.0f : ((Float)oTot).floatValue();
                mapValue.put((String)((Object)new Integer(rowFicheElt.getInt("IDSOURCE"))), new Float(montant += rowFicheElt.getFloat("MONTANT_SAL_AJ")));
                mapTotal.put(new Integer(rowFicheElt.getInt("IDSOURCE")), new Float(montantTotal += rowFicheElt.getFloat("MONTANT_SAL_AJ")));
            }
            if (rowFicheElt.getObject("MONTANT_SAL_DED") != null) {
                o = mapValue.get(new Integer(rowFicheElt.getInt("IDSOURCE")));
                oTot = mapTotal.get(new Integer(rowFicheElt.getInt("IDSOURCE")));
                montant = o == null ? 0.0f : ((Float)o).floatValue();
                float montantTot = oTot == null ? 0.0f : ((Float)oTot).floatValue();
                mapValue.put((String)((Object)new Integer(rowFicheElt.getInt("IDSOURCE"))), new Float(montant -= rowFicheElt.getFloat("MONTANT_SAL_DED")));
                mapTotal.put(new Integer(rowFicheElt.getInt("IDSOURCE")), new Float(montantTot -= rowFicheElt.getFloat("MONTANT_SAL_DED")));
            }
            if (rowFicheElt.getObject("MONTANT_PAT") != null) {
                o = mapValue.get(new Integer(rowFicheElt.getInt("IDSOURCE")) + "_PAT");
                oTot = mapTotal.get(new Integer(rowFicheElt.getInt("IDSOURCE")) + "_PAT");
                montant = o == null ? 0.0f : ((Float)o).floatValue();
                montantTotal = oTot == null ? 0.0f : ((Float)oTot).floatValue();
                mapValue.put(new Integer(rowFicheElt.getInt("IDSOURCE")) + "_PAT", new Float(montant += rowFicheElt.getFloat("MONTANT_PAT")));
                mapTotal.put(new Integer(rowFicheElt.getInt("IDSOURCE")) + "_PAT", new Float(montantTotal += rowFicheElt.getFloat("MONTANT_PAT")));
            }
            ++i;
        }
        int posLine = 1;
        int firstLine = 1;
        int nbSalPerPage = 3;
        System.err.println("NB Sal = " + mapSal.keySet().size());
        System.err.println("NB Pages = " + Math.ceil((double)mapSal.keySet().size() / (double)nbSalPerPage));
        int n = 0;
        while ((double)n < Math.ceil((double)(mapSal.keySet().size() + 1) / (double)nbSalPerPage)) {
            SQLRow rowRub;
            this.makeEntete(posLine);
            posLine += debutFill - 1;
            int numFirstSal = n * nbSalPerPage;
            if (numFirstSal < mapSal.keySet().size()) {
                SQLRow rowSal = tableSalarie.getRow((Integer)mapSal.keySet().toArray()[numFirstSal]);
                this.mCell.put("B" + (posLine - 3), rowSal.getObject("NOM"));
                this.mCell.put("B" + (posLine - 2), rowSal.getObject("PRENOM"));
            } else if (numFirstSal == mapSal.keySet().size()) {
                System.err.println("Cumuls B");
                this.mCell.put("B" + (posLine - 3), "Cumuls");
                this.mCell.put("B" + (posLine - 2), "");
            }
            if (numFirstSal + 1 < mapSal.keySet().size()) {
                SQLRow rowSal = tableSalarie.getRow((Integer)mapSal.keySet().toArray()[numFirstSal + 1]);
                this.mCell.put("D" + (posLine - 3), rowSal.getObject("NOM"));
                this.mCell.put("D" + (posLine - 2), rowSal.getObject("PRENOM"));
            } else if (numFirstSal + 1 == mapSal.keySet().size()) {
                System.err.println("Cumuls C");
                this.mCell.put("D" + (posLine - 3), "Cumuls");
                this.mCell.put("D" + (posLine - 2), "");
            }
            if (numFirstSal + 2 < mapSal.keySet().size()) {
                SQLRow rowSal = tableSalarie.getRow((Integer)mapSal.keySet().toArray()[numFirstSal + 2]);
                this.mCell.put("F" + (posLine - 3), rowSal.getObject("NOM"));
                this.mCell.put("F" + (posLine - 2), rowSal.getObject("PRENOM"));
            } else if (numFirstSal + 2 == mapSal.keySet().size()) {
                System.err.println("Cumuls D");
                this.mCell.put("F" + (posLine - 3), "Cumuls");
                this.mCell.put("F" + (posLine - 2), "");
            }
            int i2 = 0;
            while (i2 < mapRubriqueBrut.keySet().size()) {
                int idRub = ((Number)mapRubriqueBrut.keySet().toArray()[i2]).intValue();
                rowRub = tableRubBrut.getRow(idRub);
                this.mCell.put("A" + posLine, rowRub.getObject("NOM"));
                this.mCell.put("B" + posLine, this.fillLine(mapSalarieBrut, idRub, mapSal, numFirstSal, mapTotalbrut, false));
                this.mCell.put("C" + posLine, this.fillLine(mapSalarieBrut, idRub, mapSal, numFirstSal, mapTotalbrut, true));
                this.mCell.put("D" + posLine, this.fillLine(mapSalarieBrut, idRub, mapSal, numFirstSal + 1, mapTotalbrut, false));
                this.mCell.put("E" + posLine, this.fillLine(mapSalarieBrut, idRub, mapSal, numFirstSal + 1, mapTotalbrut, true));
                this.mCell.put("F" + posLine, this.fillLine(mapSalarieBrut, idRub, mapSal, numFirstSal + 2, mapTotalbrut, false));
                this.mCell.put("G" + posLine, this.fillLine(mapSalarieBrut, idRub, mapSal, numFirstSal + 2, mapTotalbrut, true));
                ++posLine;
                ++i2;
            }
            i2 = 0;
            while (i2 < mapRubriqueCot.keySet().size()) {
                int idRub = ((Number)mapRubriqueCot.keySet().toArray()[i2]).intValue();
                rowRub = tableRubCot.getRow(idRub);
                this.mCell.put("A" + posLine, rowRub.getObject("NOM"));
                this.mCell.put("B" + posLine, this.fillLine(mapSalarieCot, idRub, mapSal, numFirstSal, mapTotalCot, false));
                this.mCell.put("C" + posLine, this.fillLine(mapSalarieCot, idRub, mapSal, numFirstSal, mapTotalCot, true));
                this.mCell.put("D" + posLine, this.fillLine(mapSalarieCot, idRub, mapSal, numFirstSal + 1, mapTotalCot, false));
                this.mCell.put("E" + posLine, this.fillLine(mapSalarieCot, idRub, mapSal, numFirstSal + 1, mapTotalCot, true));
                this.mCell.put("F" + posLine, this.fillLine(mapSalarieCot, idRub, mapSal, numFirstSal + 2, mapTotalCot, false));
                this.mCell.put("G" + posLine, this.fillLine(mapSalarieCot, idRub, mapSal, numFirstSal + 2, mapTotalCot, true));
                ++posLine;
                ++i2;
            }
            i2 = 0;
            while (i2 < mapRubriqueNet.keySet().size()) {
                int idRub = ((Number)mapRubriqueNet.keySet().toArray()[i2]).intValue();
                rowRub = tableRubNet.getRow(idRub);
                this.mCell.put("A" + posLine, rowRub.getObject("NOM"));
                this.mCell.put("B" + posLine, this.fillLine(mapSalarieNet, idRub, mapSal, numFirstSal, mapTotalNet, false));
                this.mCell.put("C" + posLine, this.fillLine(mapSalarieNet, idRub, mapSal, numFirstSal, mapTotalNet, true));
                this.mCell.put("D" + posLine, this.fillLine(mapSalarieNet, idRub, mapSal, numFirstSal + 1, mapTotalNet, false));
                this.mCell.put("E" + posLine, this.fillLine(mapSalarieNet, idRub, mapSal, numFirstSal + 1, mapTotalNet, true));
                this.mCell.put("F" + posLine, this.fillLine(mapSalarieNet, idRub, mapSal, numFirstSal + 2, mapTotalNet, false));
                this.mCell.put("G" + posLine, this.fillLine(mapSalarieNet, idRub, mapSal, numFirstSal + 2, mapTotalNet, true));
                ++posLine;
                ++i2;
            }
            posLine = firstLine + endFill - 1;
            this.makeBasPage(posLine += 2);
            firstLine = ++posLine;
            ++n;
        }
        this.nbPage = new Double(Math.ceil((double)(mapSal.keySet().size() + 1) / (double)nbSalPerPage)).intValue();
        System.err.println("Nombre de page " + this.nbPage);
        if (this.nbPage > 0) {
            --this.nbPage;
        }
    }

    private Object fillLine(Map mapSalRub, int idRub, Map mapSal, int numSal, Map mapTotal, boolean pat) {
        Float value = null;
        if (numSal < mapSal.keySet().size()) {
            Integer key;
            Map m = (Map)mapSalRub.get(mapSal.keySet().toArray()[numSal]);
            value = new Float(0.0f);
            Integer n = key = pat ? new Integer(idRub) + "_PAT" : new Integer(idRub);
            if (m != null && m.get(key) != null) {
                value = m.get(key);
            }
        } else {
            Integer key;
            Integer n = key = pat ? new Integer(idRub) + "_PAT" : new Integer(idRub);
            if (numSal == mapSal.keySet().size()) {
                value = mapTotal.get(key);
            }
        }
        return value;
    }
}

