/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.report;

import java.io.File;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.jopendocument.link.Component;
import org.jopendocument.link.OOConnexion;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.DocumentLocalStorageManager;
import org.openconcerto.erp.generationDoc.SheetInterface;
import org.openconcerto.erp.generationDoc.SpreadSheetGeneratorGestComm;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class FichePayeSheet
extends SheetInterface {
    private static final SQLTable tableFiche = base.getTable("FICHE_PAYE");
    private static final SQLTable tableFicheElt = base.getTable("FICHE_PAYE_ELEMENT");
    private static final SQLTable tableMois = base.getTable("MOIS");
    private static final SQLTable tableAdresse = base.getTable("ADRESSE");
    private static final SQLTable tableAdresseCommon = Configuration.getInstance().getBase().getTable("ADRESSE_COMMON");
    private static final SQLTable tableSalarie = base.getTable("SALARIE");
    private static final SQLTable tableEtatCivil = base.getTable("ETAT_CIVIL");
    private static final SQLTable tableInfosPaye = base.getTable("INFOS_SALARIE_PAYE");
    private static final SQLTable tableReglementPaye = base.getTable("REGLEMENT_PAYE");
    private static final SQLTable tableContrat = base.getTable("CONTRAT_SALARIE");
    private static final SQLTable tableModeRegl = base.getTable("MODE_REGLEMENT_PAYE");
    private static final SQLTable tableCumulsConges = base.getTable("CUMULS_CONGES");
    private static final SQLTable tableCumulsPaye = base.getTable("CUMULS_PAYE");
    private static final SQLTable tableVarPeriode = base.getTable("VARIABLE_SALARIE");
    private static final SQLTable tableConventionC = base.getTable("IDCC");
    private static final DateFormat dateFormat = DateFormat.getDateInstance(3);
    private Map styleMapRow;
    public static final String TEMPLATE_ID = "Fiche de paye";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationFichePaye";

    public Map getStyleMapRow() {
        return this.styleMapRow;
    }

    public FichePayeSheet(int idFiche) {
        super(idFiche, tableFiche);
        this.init();
    }

    public FichePayeSheet(SQLRow rowFiche) {
        super(rowFiche);
        this.init();
    }

    public static String getFileName(int id, int type) {
        return FichePayeSheet.getFileName(tableFiche.getRow(id), type);
    }

    public static void generation(int id) {
        FichePayeSheet.generation(tableFiche.getRow(id));
    }

    public static void generation(SQLRow row) {
        FichePayeSheet.generation(row, true);
    }

    public static void generation(SQLRow row, boolean visu) {
        FichePayeSheet fSheet = new FichePayeSheet(row.getID());
        new SpreadSheetGeneratorGestComm(fSheet, FichePayeSheet.getFileName(row, 3), false, visu);
    }

    public static void impression(int id) {
        FichePayeSheet.impression(tableFiche.getRow(id));
    }

    public static void impression(SQLRow row) {
        File f = FichePayeSheet.getFile(row, 1);
        if (f.exists()) {
            try {
                OOConnexion ooConnexion = ComptaPropsConfiguration.getOOConnexion();
                if (ooConnexion == null) {
                    return;
                }
                Component doc = ooConnexion.loadDocument(f, true);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("Name", PrinterNXProps.getInstance().getStringProperty("FichePayePrinter"));
                doc.printDocument(map);
                doc.close();
            }
            catch (LinkageError e) {
                JOptionPane.showMessageDialog(new JFrame(), "Merci d'installer OpenOffice ou LibreOffice");
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionHandler.handle("Impossible de charger le document OpenOffice", e);
            }
        }
    }

    public static void visualisation(SQLRow r, int type) {
        File f = FichePayeSheet.getFile(r, type);
        if (f.exists()) {
            try {
                OOConnexion ooConnexion = ComptaPropsConfiguration.getOOConnexion();
                if (ooConnexion == null) {
                    return;
                }
                ooConnexion.loadDocument(f, false);
            }
            catch (LinkageError e) {
                JOptionPane.showMessageDialog(new JFrame(), "Merci d'installer OpenOffice ou LibreOffice");
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionHandler.handle("Impossible de charger le document OpenOffice", e);
            }
        }
    }

    public static File getFile(SQLRow r, int type) {
        return new File(FichePayeSheet.getLocation(r, type), FichePayeSheet.getFileName(r.getID(), type));
    }

    public static String getFileName(SQLRow r, int type) {
        SQLRow rowSal = tableSalarie.getRow(r.getInt("ID_SALARIE"));
        SQLRow rowMois = tableMois.getRow(r.getInt("ID_MOIS"));
        if (type == 1) {
            return "FichePaye_" + rowSal.getString("CODE") + "_" + rowMois.getString("NOM") + "_" + r.getString("ANNEE") + ".ods";
        }
        if (type == 2) {
            return "FichePaye_" + rowSal.getString("CODE") + "_" + rowMois.getString("NOM") + "_" + r.getString("ANNEE") + ".pdf";
        }
        return "FichePaye_" + rowSal.getString("CODE") + "_" + rowMois.getString("NOM") + "_" + r.getString("ANNEE");
    }

    public static String getLocation(int id, int type) {
        return FichePayeSheet.getLocation(tableFiche.getRow(id), type);
    }

    @Override
    public String getTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    protected String getYear() {
        return this.row.getString("ANNEE");
    }

    public static String getLocation(SQLRow r, int type) {
        DocumentLocalStorageManager storage = DocumentLocalStorageManager.getInstance();
        String path = type == 1 ? storage.getDocumentOutputDirectory(TEMPLATE_ID).getAbsolutePath() : storage.getPDFOutputDirectory(TEMPLATE_ID).getAbsolutePath();
        return String.valueOf(path) + File.separator + r.getString("ANNEE");
    }

    private void init() {
        this.modele = "FichePaye.ods";
        this.printer = PrinterNXProps.getInstance().getStringProperty("FichePayePrinter");
    }

    @Override
    protected void createMap() {
        this.styleMapRow = new HashMap();
        this.mapReplace = new HashMap();
        this.mCell = new HashMap();
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        this.mCell.put("B1", rowSociete.getObject("TYPE") + " " + rowSociete.getObject("NOM"));
        SQLRow rowAdrSociete = tableAdresseCommon.getRow(rowSociete.getInt("ID_ADRESSE_COMMON"));
        this.mCell.put("B2", rowAdrSociete.getObject("RUE"));
        this.mCell.put("B3", String.valueOf(rowAdrSociete.getString("CODE_POSTAL")) + " " + rowAdrSociete.getString("VILLE"));
        this.mCell.put("D5", rowSociete.getObject("NUM_SIRET"));
        this.mCell.put("D6", rowSociete.getObject("NUM_APE"));
        this.mapReplace.put("D8", rowSociete.getObject("NUMERO_URSSAF"));
        SQLRow rowSal = tableSalarie.getRow(this.row.getInt("ID_SALARIE"));
        SQLRow rowEtatCivil = tableEtatCivil.getRow(rowSal.getInt("ID_ETAT_CIVIL"));
        this.mCell.put("G8", rowSal.getObject("NOM") + " " + rowSal.getObject("PRENOM"));
        SQLRow rowAdrSal = tableAdresse.getRow(rowEtatCivil.getInt("ID_ADRESSE"));
        this.mCell.put("G9", rowAdrSal.getObject("RUE"));
        this.mCell.put("G11", String.valueOf(rowAdrSal.getString("CODE_POSTAL")) + " " + rowAdrSal.getString("VILLE"));
        this.mCell.put("D13", rowEtatCivil.getObject("NUMERO_SS"));
        SQLRow rowInfosPaye = tableInfosPaye.getRow(rowSal.getInt("ID_INFOS_SALARIE_PAYE"));
        SQLRow rowContrat = tableContrat.getRow(rowInfosPaye.getInt("ID_CONTRAT_SALARIE"));
        if (this.row.getString("NATURE_EMPLOI").trim().length() == 0) {
            this.mCell.put("D14", rowContrat.getObject("NATURE"));
        } else {
            this.mCell.put("D14", this.row.getString("NATURE_EMPLOI"));
        }
        SQLRow rowCC = this.row.getInt("ID_IDCC") > 1 ? tableConventionC.getRow(this.row.getInt("ID_IDCC")) : tableConventionC.getRow(rowInfosPaye.getInt("ID_IDCC"));
        this.mCell.put("D15", rowCC.getString("NOM"));
        Date du = (Date)this.row.getObject("DU");
        Date au = (Date)this.row.getObject("AU");
        this.mCell.put("F1", "Bulletin de paie du " + dateFormat.format(du) + " au " + dateFormat.format(au));
        SQLRow rowRegl = this.row.getInt("ID_REGLEMENT_PAYE") <= 1 ? tableReglementPaye.getRow(rowSal.getInt("ID_REGLEMENT_PAYE")) : tableReglementPaye.getRow(this.row.getInt("ID_REGLEMENT_PAYE"));
        SQLRow rowModeRegl = tableModeRegl.getRow(rowRegl.getInt("ID_MODE_REGLEMENT_PAYE"));
        Calendar c = Calendar.getInstance();
        c.set(2, this.row.getInt("ID_MOIS") - 2);
        c.set(1, Integer.parseInt(this.row.getString("ANNEE")));
        if (rowRegl.getInt("LE") != 31) {
            c.set(2, c.get(2) + 1);
        }
        int max = c.getActualMaximum(5);
        int day = Math.min(rowRegl.getInt("LE"), max);
        c.set(5, day);
        this.mCell.put("H3", dateFormat.format(c.getTime()));
        this.mCell.put("I3", "Par " + rowModeRegl.getObject("NOM"));
        SQLRow rowConges = this.row.getInt("ID_CUMULS_CONGES") <= 1 ? tableCumulsConges.getRow(rowSal.getInt("ID_CUMULS_CONGES")) : tableCumulsConges.getRow(this.row.getInt("ID_CUMULS_CONGES"));
        SQLRow rowVarSal = this.row.getInt("ID_VARIABLE_SALARIE") <= 1 ? tableVarPeriode.getRow(rowSal.getInt("ID_VARIABLE_SALARIE")) : tableVarPeriode.getRow(this.row.getInt("ID_VARIABLE_SALARIE"));
        float congesPris = rowVarSal.getFloat("CONGES_PRIS");
        float congesRestant = rowConges.getFloat("RESTANT") - congesPris;
        float congesAcquis = rowConges.getFloat("ACQUIS") + this.row.getFloat("CONGES_ACQUIS");
        this.mCell.put("G14", new Float(congesPris));
        this.mCell.put("H14", new Float(congesRestant));
        this.mCell.put("I14", new Float(congesAcquis));
        SQLSelect selElt = new SQLSelect(base);
        selElt.addSelect(tableFicheElt.getField("ID"));
        selElt.setWhere(tableFicheElt.getField("ID_FICHE_PAYE"), "=", this.row.getID());
        String req = String.valueOf(selElt.asString()) + " ORDER BY \"FICHE_PAYE_ELEMENT\".\"POSITION\"";
        List l = (List)base.getDataSource().execute(req, new ArrayListHandler());
        int pos = 20;
        for (Object[] o : l) {
            SQLRow rowTmp = tableFicheElt.getRow(Integer.parseInt(o[0].toString()));
            if (!rowTmp.getBoolean("IMPRESSION").booleanValue() || !rowTmp.getBoolean("IN_PERIODE").booleanValue()) continue;
            Object nomTmp = rowTmp.getObject("NOM");
            this.mCell.put("B" + pos, nomTmp);
            BigDecimal baseTmp = rowTmp.getBigDecimal("NB_BASE");
            if (baseTmp != null) {
                if (baseTmp.signum() != 0) {
                    this.mCell.put("E" + pos, baseTmp);
                } else {
                    this.mCell.put("E" + pos, "");
                }
            } else {
                this.mCell.put("E" + pos, baseTmp);
            }
            BigDecimal tauxSalTmp = rowTmp.getBigDecimal("TAUX_SAL");
            if (tauxSalTmp != null) {
                if (tauxSalTmp.signum() != 0) {
                    this.mCell.put("F" + pos, tauxSalTmp);
                } else {
                    this.mCell.put("F" + pos, "");
                }
            } else {
                this.mCell.put("F" + pos, tauxSalTmp);
            }
            BigDecimal montantSalAjTmp = rowTmp.getBigDecimal("MONTANT_SAL_AJ");
            if (montantSalAjTmp != null) {
                if (montantSalAjTmp.signum() != 0) {
                    this.mCell.put("G" + pos, montantSalAjTmp);
                } else {
                    this.mCell.put("G" + pos, "");
                }
            } else {
                this.mCell.put("G" + pos, montantSalAjTmp);
            }
            BigDecimal montantSalDedTmp = rowTmp.getBigDecimal("MONTANT_SAL_DED");
            if (montantSalDedTmp != null) {
                if (montantSalDedTmp.signum() != 0) {
                    this.mCell.put("H" + pos, montantSalDedTmp);
                } else {
                    this.mCell.put("H" + pos, "");
                }
            } else {
                this.mCell.put("H" + pos, montantSalDedTmp);
            }
            BigDecimal tauxPatTmp = rowTmp.getBigDecimal("TAUX_PAT");
            if (tauxPatTmp != null) {
                if (tauxPatTmp.signum() != 0) {
                    this.mCell.put("I" + pos, tauxPatTmp);
                } else {
                    this.mCell.put("I" + pos, "");
                }
            } else {
                this.mCell.put("I" + pos, tauxPatTmp);
            }
            BigDecimal montantPatTmp = rowTmp.getBigDecimal("MONTANT_PAT");
            if (montantPatTmp != null) {
                if (montantPatTmp.signum() != 0) {
                    this.mCell.put("J" + pos, montantPatTmp);
                } else {
                    this.mCell.put("J" + pos, "");
                }
            } else {
                this.mCell.put("J" + pos, montantPatTmp);
            }
            if (rowTmp.getString("SOURCE").equalsIgnoreCase("RUBRIQUE_COMM")) {
                this.mapStyleRow.put(new Integer(pos), "Titre 1");
            } else {
                this.mapStyleRow.put(new Integer(pos), "Normal");
            }
            ++pos;
        }
        BigDecimal netApayerCumul = this.row.getBigDecimal("NET_A_PAYER");
        BigDecimal salBrutCumul = this.row.getBigDecimal("SAL_BRUT");
        BigDecimal cotSalCumul = this.row.getBigDecimal("COT_SAL");
        BigDecimal cotPatCumul = this.row.getBigDecimal("COT_PAT");
        BigDecimal netImpCumul = this.row.getBigDecimal("NET_IMP");
        this.mCell.put("I61", this.row.getObject("NET_A_PAYER"));
        this.mCell.put("D61", this.row.getObject("SAL_BRUT"));
        this.mCell.put("E61", this.row.getObject("COT_SAL"));
        this.mCell.put("F61", this.row.getObject("COT_PAT"));
        this.mCell.put("H61", this.row.getObject("NET_IMP"));
        SQLRow rowCumulsPaye = this.row.getInt("ID_CUMULS_PAYE") == 1 ? tableCumulsPaye.getRow(rowSal.getInt("ID_CUMULS_PAYE")) : tableCumulsPaye.getRow(this.row.getInt("ID_CUMULS_PAYE"));
        netApayerCumul = netApayerCumul.add(rowCumulsPaye.getBigDecimal("NET_A_PAYER_C"));
        cotSalCumul = cotSalCumul.add(rowCumulsPaye.getBigDecimal("COT_SAL_C"));
        cotPatCumul = cotPatCumul.add(rowCumulsPaye.getBigDecimal("COT_PAT_C"));
        netImpCumul = netImpCumul.add(rowCumulsPaye.getBigDecimal("NET_IMP_C"));
        this.mCell.put("D62", salBrutCumul);
        this.mCell.put("E62", cotSalCumul);
        this.mCell.put("F62", cotPatCumul);
        this.mCell.put("H62", netImpCumul);
    }
}

