/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.SheetInterface;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class EtatChargesPayeSheet
extends SheetInterface {
    private static int debutFill;
    private static int endFill;
    private static final SQLTable tableFichePaye;
    private static final SQLTable tableFichePayeElement;
    private static final SQLTable tableMois;
    private static final SQLTable tableCaisse;
    private static final SQLTable tableRubCot;
    private static final DateFormat dateFormat;
    private int moisDu;
    private int moisAu;
    private String annee;
    public static String TEMPLATE_ID;
    public static String TEMPLATE_PROPERTY_NAME;

    static {
        tableFichePaye = base.getTable("FICHE_PAYE");
        tableFichePayeElement = base.getTable("FICHE_PAYE_ELEMENT");
        tableMois = base.getTable("MOIS");
        tableCaisse = Configuration.getInstance().getBase().getTable("CAISSE_COTISATION");
        tableRubCot = Configuration.getInstance().getBase().getTable("RUBRIQUE_COTISATION");
        dateFormat = DateFormat.getDateInstance(2);
        EtatChargesPayeSheet.setSize(7, 66);
        TEMPLATE_ID = "Etat des charges";
        TEMPLATE_PROPERTY_NAME = "LocationEtatChargesPaye";
    }

    public static void setSize(int debut, int fin) {
        debutFill = debut;
        endFill = fin;
    }

    @Override
    public String getTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    protected String getYear() {
        return "";
    }

    public EtatChargesPayeSheet(int moisDu, int moisAu, String annee) {
        this.printer = PrinterNXProps.getInstance().getStringProperty("EtatChargesPayePrinter");
        this.modele = "EtatChargesPaye.ods";
        this.moisAu = moisAu;
        this.moisDu = moisDu;
        this.annee = annee;
        this.nbRowsPerPage = 68;
        this.createMap();
    }

    private void makeEntete(int row) {
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        this.mCell.put("A" + row, rowSociete.getObject("NOM"));
        this.mCell.put("F" + row, "Edition du " + dateFormat.format(new Date()));
        System.err.println("MAKE ENTETE");
    }

    private void makeBasPage(int row) {
        SQLRow rowMoisDu = tableMois.getRow(this.moisDu);
        SQLRow rowMoisAu = tableMois.getRow(this.moisAu);
        this.mCell.put("A" + row, "P\u00e9riode de " + rowMoisDu.getString("NOM") + " \u00e0 " + rowMoisAu.getString("NOM") + " " + this.annee);
    }

    @Override
    protected void createMap() {
        this.mapReplace = new HashMap();
        this.mCell = new HashMap();
        this.mapStyleRow = new HashMap();
        SQLSelect sel = new SQLSelect(base);
        sel.addSelect(tableFichePaye.getField("ID"));
        sel.addSelect(tableFichePayeElement.getField("ID"));
        Where w = new Where((FieldRef)tableFichePayeElement.getField("ID_FICHE_PAYE"), "=", tableFichePaye.getField("ID"));
        Where w6 = new Where((FieldRef)tableFichePayeElement.getField("SOURCE"), "=", (Object)"RUBRIQUE_COTISATION");
        Where w3 = new Where((FieldRef)tableFichePaye.getField("ID_MOIS"), new Integer(this.moisDu), (Object)new Integer(this.moisAu));
        Where w4 = new Where((FieldRef)tableFichePaye.getField("ANNEE"), "=", (Object)new Integer(this.annee));
        Where w5 = new Where((FieldRef)tableFichePaye.getField("VALIDE"), "=", (Object)Boolean.TRUE);
        sel.setWhere(w);
        sel.andWhere(w3);
        sel.andWhere(w4);
        sel.andWhere(w5);
        sel.andWhere(w6);
        sel.setDistinct(true);
        String req = sel.asString();
        System.err.println(req);
        List l = (List)base.getDataSource().execute(req, new ArrayListHandler());
        HashMap<Integer, Map<Object, SQLRowValues>> mapCaisse = new HashMap<Integer, Map<Object, SQLRowValues>>();
        HashMap<Object, String> mapFiche = new HashMap<Object, String>();
        int i = 0;
        while (i < l.size()) {
            SQLRowValues rowVals;
            Map<Object, SQLRowValues> mapValueRub;
            Object[] tmp = (Object[])l.get(i);
            mapFiche.put(tmp[0], "");
            int idFicheElt = Integer.parseInt(tmp[1].toString());
            SQLRow rowFicheElt = tableFichePayeElement.getRow(idFicheElt);
            SQLRow rowRub = tableRubCot.getRow(rowFicheElt.getInt("IDSOURCE"));
            if (mapCaisse.containsKey(new Integer(rowRub.getInt("ID_CAISSE_COTISATION")))) {
                mapValueRub = (Map)mapCaisse.get(new Integer(rowRub.getInt("ID_CAISSE_COTISATION")));
            } else {
                mapValueRub = new HashMap();
                mapCaisse.put(new Integer(rowRub.getInt("ID_CAISSE_COTISATION")), mapValueRub);
            }
            if (mapValueRub.containsKey(rowFicheElt.getObject("IDSOURCE"))) {
                BigDecimal montant;
                Object o;
                rowVals = (SQLRowValues)mapValueRub.get(rowFicheElt.getObject("IDSOURCE"));
                if (rowFicheElt.getObject("NB_BASE") != null) {
                    o = rowVals.getObject("NB_BASE");
                    BigDecimal base = o == null ? BigDecimal.ZERO : (BigDecimal)o;
                    base = base.add(rowFicheElt.getBigDecimal("NB_BASE"));
                    rowVals.put("NB_BASE", base);
                }
                if (rowFicheElt.getObject("MONTANT_PAT") != null) {
                    o = rowVals.getObject("MONTANT_PAT");
                    montant = o == null ? BigDecimal.ZERO : (BigDecimal)o;
                    montant = montant.add(rowFicheElt.getBigDecimal("MONTANT_PAT"));
                    rowVals.put("MONTANT_PAT", montant);
                }
                if (rowFicheElt.getObject("MONTANT_SAL_DED") != null) {
                    o = rowVals.getObject("MONTANT_SAL_DED");
                    montant = o == null ? BigDecimal.ZERO : (BigDecimal)o;
                    montant = montant.add(rowFicheElt.getBigDecimal("MONTANT_SAL_DED"));
                    rowVals.put("MONTANT_SAL_DED", montant);
                }
            } else {
                BigDecimal montantSal;
                rowVals = new SQLRowValues(tableFichePayeElement);
                Configuration.getInstance().getDirectory().getElement(tableFichePayeElement).loadAllSafe(rowVals, rowFicheElt);
                Object o = rowVals.getObject("MONTANT_PAT");
                BigDecimal montantPat = o == null ? BigDecimal.ZERO : (BigDecimal)o;
                o = rowVals.getObject("MONTANT_SAL_DED");
                BigDecimal bigDecimal = montantSal = o == null ? BigDecimal.ZERO : (BigDecimal)o;
                if (montantPat.signum() != 0 || montantSal.signum() != 0) {
                    mapValueRub.put(rowFicheElt.getObject("IDSOURCE"), rowVals);
                }
            }
            ++i;
        }
        int posLine = 1;
        int firstLine = 1;
        System.err.println("Dump fiche " + mapFiche);
        System.err.println("NB Pages = " + mapCaisse.keySet().size());
        int n = 0;
        while (n < mapCaisse.keySet().size()) {
            this.makeEntete(posLine);
            Map mapValue = (Map)mapCaisse.get(mapCaisse.keySet().toArray()[n]);
            BigDecimal totalMontantSal = BigDecimal.ZERO;
            BigDecimal totalMontantPat = BigDecimal.ZERO;
            SQLRow rowCaisse = tableCaisse.getRow(Integer.parseInt(mapCaisse.keySet().toArray()[n].toString()));
            this.mCell.put("A" + (posLine += debutFill - 1), "Caisse " + rowCaisse.getObject("NOM"));
            this.mCell.put("B" + posLine, "");
            this.mCell.put("C" + posLine, "");
            this.mCell.put("D" + posLine, "");
            this.mCell.put("E" + posLine, "");
            this.mCell.put("F" + posLine, "");
            this.mapStyleRow.put(new Integer(posLine), "Titre 1");
            ++posLine;
            int i2 = 0;
            while (i2 < mapValue.keySet().size()) {
                SQLRowValues rowVals = (SQLRowValues)mapValue.get(mapValue.keySet().toArray()[i2]);
                this.mCell.put("A" + posLine, rowVals.getObject("NOM"));
                this.mCell.put("B" + posLine, rowVals.getObject("NB_BASE"));
                BigDecimal txSal = rowVals.getBigDecimal("TAUX_SAL");
                txSal = txSal == null ? BigDecimal.ZERO : txSal;
                BigDecimal txPat = rowVals.getBigDecimal("TAUX_PAT");
                txPat = txPat == null ? BigDecimal.ZERO : txPat;
                this.mCell.put("C" + posLine, txSal.add(txPat));
                BigDecimal montantSal = rowVals.getBigDecimal("MONTANT_SAL_DED");
                montantSal = montantSal == null ? BigDecimal.ZERO : montantSal;
                BigDecimal montantPat = rowVals.getBigDecimal("MONTANT_PAT");
                montantPat = montantPat == null ? BigDecimal.ZERO : montantPat;
                this.mCell.put("D" + posLine, montantPat);
                this.mCell.put("E" + posLine, montantSal);
                this.mCell.put("F" + posLine, montantSal.add(montantPat));
                totalMontantPat = totalMontantPat.add(montantPat);
                totalMontantSal = totalMontantSal.add(montantSal);
                this.mapStyleRow.put(new Integer(posLine), "Normal");
                ++posLine;
                ++i2;
            }
            this.mCell.put("A" + posLine, "Total");
            this.mCell.put("B" + posLine, "");
            this.mCell.put("C" + posLine, "");
            this.mCell.put("D" + posLine, totalMontantPat);
            this.mCell.put("E" + posLine, totalMontantSal);
            this.mCell.put("F" + posLine, totalMontantPat.add(totalMontantSal));
            this.mapStyleRow.put(new Integer(posLine), "Titre 1");
            posLine = firstLine + endFill - 1;
            this.makeBasPage(posLine += 2);
            firstLine = ++posLine;
            ++n;
        }
        this.nbPage = mapCaisse.size();
        System.err.println("Nombre de page " + this.nbPage);
        if (this.nbPage > 0) {
            --this.nbPage;
        }
    }
}

