/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.JNiceButton;
import org.openconcerto.erp.core.humanresources.payroll.component.VariableRowTreeNode;
import org.openconcerto.erp.core.humanresources.payroll.ui.FichePayeRenderer;
import org.openconcerto.erp.generationEcritures.GenerationMvtFichePaye;
import org.openconcerto.erp.model.FichePayeModel;
import org.openconcerto.erp.model.RubriquePayeTree;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.checks.ValidState;

public class FichePayeSQLElement
extends ComptaSQLConfElement {
    public FichePayeSQLElement() {
        super("FICHE_PAYE", "une fiche de paye", "fiches de paye");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_SALARIE");
        l.add("ID_MOIS");
        l.add("ANNEE");
        l.add("NET_A_PAYER");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_SALARIE");
        l.add("ID_MOIS");
        l.add("ANNEE");
        return l;
    }

    @Override
    public boolean isPrivate() {
        return true;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private FichePayeModel model;
            private ElementComboBox comboSelProfil;
            private ElementComboBox selSalCombo;
            private EditFrame edit;
            private ElementComboBox selMois;
            private int dernMois;
            private int dernAnnee;
            private JTextField textAnnee;
            JDate dateDu;
            JDate dateAu;
            private JScrollPane paneTreeLeft;
            private JPanel pDate;
            private JButton buttonValider;
            private JButton buttonGenCompta;
            {
                this.edit = null;
            }

            @Override
            public void addViews() {
                this.dernMois = 0;
                this.dernAnnee = 0;
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridheight = 0;
                final RubriquePayeTree tree = new RubriquePayeTree();
                tree.expandRow(0);
                this.paneTreeLeft = new JScrollPane(tree);
                JPanel panelRight = new JPanel();
                panelRight.setLayout(new GridBagLayout());
                c.fill = 2;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.gridheight = 1;
                c.gridwidth = 2;
                this.selSalCombo = new ElementComboBox();
                panelRight.add((Component)this.selSalCombo, c);
                ++c.gridy;
                c.fill = 2;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.gridheight = 1;
                c.gridwidth = 3;
                JLabel labelMois = new JLabel("Fiche de paye du mois de");
                this.selMois = new ElementComboBox(true, 20);
                JLabel labelDu = new JLabel("Du");
                JLabel labelAu = new JLabel("Au");
                this.dateDu = new JDate();
                this.dateAu = new JDate();
                JLabel labelAnnee = new JLabel("Ann\u00e9e");
                this.textAnnee = new JTextField();
                this.pDate = new JPanel();
                this.pDate.setOpaque(false);
                this.pDate.add(labelMois);
                this.pDate.add(this.selMois);
                this.pDate.add(labelAnnee);
                this.pDate.add(this.textAnnee);
                this.pDate.add(labelDu);
                this.pDate.add(this.dateDu);
                this.pDate.add(labelAu);
                this.pDate.add(this.dateAu);
                panelRight.add((Component)this.pDate, c);
                c.gridx += 2;
                c.weightx = 1.0;
                c.gridwidth = 1;
                c.fill = 2;
                panelRight.add((Component)new JPanel(), c);
                ++c.gridx;
                c.fill = 2;
                c.weightx = 0.0;
                c.weighty = 0.0;
                JPanel pButtons = new JPanel();
                pButtons.setOpaque(false);
                JNiceButton buttonUp = new JNiceButton(IListFrame.class.getResource("fleche_haut.png"));
                JNiceButton buttonDown = new JNiceButton(IListFrame.class.getResource("fleche_bas.png"));
                JNiceButton buttonRemove = new JNiceButton(SQLComponent.class.getResource("delete.png"));
                pButtons.add(buttonUp);
                pButtons.add(buttonDown);
                pButtons.add(buttonRemove);
                panelRight.add((Component)pButtons, c);
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 1;
                ++c.gridy;
                c.gridwidth = 0;
                this.model = new FichePayeModel(1);
                final JTable table = new JTable(this.model);
                panelRight.add((Component)new JScrollPane(table), c);
                FichePayeRenderer rend = new FichePayeRenderer();
                table.setDefaultRenderer(String.class, rend);
                table.setDefaultRenderer(Float.class, rend);
                c.gridx = 1;
                ++c.gridy;
                c.weightx = 0.0;
                c.weighty = 0.0;
                c.gridwidth = 1;
                c.fill = 2;
                JLabel labelProfil = new JLabel("Importer depuis un profil pr\u00e9d\u00e9fini");
                panelRight.add((Component)labelProfil, c);
                c.gridwidth = 1;
                this.comboSelProfil = new ElementComboBox();
                this.comboSelProfil.setListIconVisible(false);
                ++c.gridx;
                c.gridwidth = 1;
                panelRight.add((Component)this.comboSelProfil, c);
                JButton buttonImportProfil = new JButton("Importer");
                ++c.gridx;
                panelRight.add((Component)buttonImportProfil, c);
                JPanel panelTotal = new JPanel();
                panelTotal.setBorder(BorderFactory.createTitledBorder("Total p\u00e9riode"));
                panelTotal.setLayout(new GridBagLayout());
                DefaultGridBagConstraints cPanel = new DefaultGridBagConstraints();
                JLabel labelBrut = new JLabel(this.getLabelFor("SAL_BRUT"));
                panelTotal.add((Component)labelBrut, cPanel);
                JTextField textSalBrut = new JTextField(10);
                ++cPanel.gridx;
                cPanel.weightx = 0.0;
                panelTotal.add((Component)textSalBrut, cPanel);
                textSalBrut.setEditable(false);
                textSalBrut.setEnabled(false);
                ++cPanel.gridx;
                JLabel labelAcompte = new JLabel(this.getLabelFor("ACOMPTE"));
                panelTotal.add((Component)labelAcompte, cPanel);
                JTextField textAcompte = new JTextField(10);
                ++cPanel.gridx;
                panelTotal.add((Component)textAcompte, cPanel);
                ++cPanel.gridx;
                JLabel labelCongesAcquis = new JLabel(this.getLabelFor("CONGES_ACQUIS"));
                panelTotal.add((Component)labelCongesAcquis, cPanel);
                JTextField textCongesAcquis = new JTextField(10);
                ++cPanel.gridx;
                panelTotal.add((Component)textCongesAcquis, cPanel);
                cPanel.gridx = 0;
                ++cPanel.gridy;
                JLabel labelCotSal = new JLabel(this.getLabelFor("COT_SAL"));
                panelTotal.add((Component)labelCotSal, cPanel);
                JTextField textCotSal = new JTextField(10);
                ++cPanel.gridx;
                panelTotal.add((Component)textCotSal, cPanel);
                textCotSal.setEditable(false);
                textCotSal.setEnabled(false);
                ++cPanel.gridx;
                JLabel labelCotPat = new JLabel(this.getLabelFor("COT_PAT"));
                panelTotal.add((Component)labelCotPat, cPanel);
                JTextField textCotPat = new JTextField(10);
                ++cPanel.gridx;
                panelTotal.add((Component)textCotPat, cPanel);
                textCotPat.setEditable(false);
                textCotPat.setEnabled(false);
                JLabel labelCSG = new JLabel(this.getLabelFor("CSG"));
                ++cPanel.gridx;
                panelTotal.add((Component)labelCSG, cPanel);
                JTextField textCSG = new JTextField(10);
                ++cPanel.gridx;
                panelTotal.add((Component)textCSG, cPanel);
                textCSG.setEditable(false);
                textCSG.setEnabled(false);
                cPanel.gridx = 0;
                ++cPanel.gridy;
                JLabel labelNetImp = new JLabel(this.getLabelFor("NET_IMP"));
                panelTotal.add((Component)labelNetImp, cPanel);
                JTextField textNetImp = new JTextField(10);
                ++cPanel.gridx;
                panelTotal.add((Component)textNetImp, cPanel);
                textNetImp.setEditable(false);
                textNetImp.setEnabled(false);
                ++cPanel.gridx;
                JLabel labelNetAPayer = new JLabel(this.getLabelFor("NET_A_PAYER"));
                panelTotal.add((Component)labelNetAPayer, cPanel);
                JTextField textNetAPayer = new JTextField(10);
                ++cPanel.gridx;
                panelTotal.add((Component)textNetAPayer, cPanel);
                textNetAPayer.setEditable(false);
                textNetAPayer.setEnabled(false);
                c.gridx = 1;
                ++c.gridy;
                c.gridwidth = 0;
                panelRight.add((Component)panelTotal, c);
                c.gridx = 1;
                ++c.gridy;
                c.gridwidth = 1;
                c.fill = 0;
                this.buttonValider = new JButton("Valider");
                ++c.gridx;
                c.gridwidth = 1;
                this.buttonGenCompta = new JButton("Generer la comptabilit\u00e9");
                c.gridx = 0;
                c.gridy = 0;
                c.gridwidth = 1;
                c.gridheight = 1;
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.add((Component)new JSplitPane(1, this.paneTreeLeft, panelRight), c);
                this.buttonGenCompta.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            int[] i = new int[]{this.getSelectedID()};
                            SQLRow rowMois = this.getTable().getBase().getTable("MOIS").getRow(selMois.getSelectedId());
                            new GenerationMvtFichePaye(i, rowMois.getString("NOM"), textAnnee.getText());
                        }
                        catch (Exception ex) {
                            ExceptionHandler.handle("Erreur de g\u00e9n\u00e9ration des mouvements", ex);
                        }
                    }
                });
                this.buttonValider.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            this.validationFiche();
                        }
                        catch (SQLException e1) {
                            ExceptionHandler.handle("Error while updating pay slip", e1);
                        }
                    }
                });
                buttonUp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int newRowSelected = model.upRow(table.getSelectedRow());
                        if (newRowSelected >= 0) {
                            table.setRowSelectionInterval(newRowSelected, newRowSelected);
                        }
                    }
                });
                buttonDown.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int newRowSelected = model.downRow(table.getSelectedRow());
                        if (newRowSelected >= 0) {
                            table.setRowSelectionInterval(newRowSelected, newRowSelected);
                        }
                    }
                });
                buttonRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        model.removeRow(table.getSelectedRow());
                    }
                });
                tree.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mE) {
                        TreePath path = tree.getClosestPathForLocation(mE.getPoint().x, mE.getPoint().y);
                        Object obj = path.getLastPathComponent();
                        if (obj == null) {
                            return;
                        }
                        if (mE.getClickCount() == 2 && mE.getButton() == 1) {
                            if (obj instanceof VariableRowTreeNode) {
                                model.addRowAt(((VariableRowTreeNode)obj).getRow(), table.getSelectedRow());
                            }
                        } else if (mE.getButton() == 3 && obj instanceof VariableRowTreeNode) {
                            final SQLRow row = ((VariableRowTreeNode)obj).getRow();
                            JPopupMenu menuDroit = new JPopupMenu();
                            menuDroit.add(new AbstractAction("Editer"){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (edit != null) {
                                        edit.dispose();
                                    }
                                    edit = new EditFrame(Configuration.getInstance().getDirectory().getElement(row.getTable()), EditFrame.MODIFICATION);
                                    edit.selectionId(row.getID(), 0);
                                    edit.pack();
                                    edit.setVisible(true);
                                }
                            });
                            menuDroit.add(new AbstractAction("Nouvelle rubrique"){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (edit != null) {
                                        edit.dispose();
                                    }
                                    edit = new EditFrame(Configuration.getInstance().getDirectory().getElement(row.getTable()));
                                    edit.pack();
                                    edit.setVisible(true);
                                }
                            });
                            menuDroit.show(mE.getComponent(), mE.getPoint().x, mE.getPoint().y);
                        }
                    }
                });
                this.dateDu.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        java.util.Date d;
                        if (!dateDu.isEmpty() && (d = dateDu.getValue()) != null) {
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(d);
                            if (selMois.getSelectedId() > 1 && cal.get(2) + 2 != selMois.getSelectedId()) {
                                cal.set(5, 1);
                                cal.set(2, selMois.getSelectedId() - 2);
                                System.err.println("Du " + cal.getTime());
                                dateDu.setValue(cal.getTime());
                            }
                            this.fireValidChange();
                        }
                    }
                });
                this.dateAu.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        java.util.Date d;
                        if (!dateAu.isEmpty() && (d = dateAu.getValue()) != null) {
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(d);
                            if (selMois.getSelectedId() > 1 && cal.get(2) + 2 != selMois.getSelectedId()) {
                                cal.set(5, 1);
                                cal.set(2, selMois.getSelectedId() - 2);
                                cal.set(5, cal.getActualMaximum(5));
                                System.err.println("Au " + cal.getTime());
                                dateAu.setValue(cal.getTime());
                            }
                            this.fireValidChange();
                        }
                    }
                });
                this.addRequiredSQLObject(this.textAnnee, "ANNEE");
                this.addRequiredSQLObject(this.selMois, "ID_MOIS");
                this.addSQLObject(this.comboSelProfil, "ID_PROFIL_PAYE");
                this.addSQLObject(textCongesAcquis, "CONGES_ACQUIS");
                this.addSQLObject(textCotPat, "COT_PAT");
                this.addSQLObject(textCotSal, "COT_SAL");
                this.addSQLObject(textCSG, "CSG");
                this.addSQLObject(textNetAPayer, "NET_A_PAYER");
                this.addSQLObject(textNetImp, "NET_IMP");
                this.addSQLObject(textSalBrut, "SAL_BRUT");
                this.addSQLObject(textAcompte, "ACOMPTE");
                this.addSQLObject(this.selSalCombo, "ID_SALARIE");
                this.addRequiredSQLObject(this.dateDu, "DU");
                this.addRequiredSQLObject(this.dateAu, "AU");
                this.selSalCombo.setInteractionMode(InteractionMode.DISABLED);
                this.selSalCombo.setEnabled(false);
                this.selSalCombo.setButtonsVisible(false);
                buttonImportProfil.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        model.loadFromProfil(comboSelProfil.getSelectedId());
                    }
                });
            }

            private boolean isDateValid() {
                String yearS = this.textAnnee.getText().trim();
                int annee = yearS.length() == 0 ? 0 : Integer.parseInt(yearS);
                int mois = this.selMois.getSelectedId();
                return this.dernAnnee == 0 || annee > this.dernAnnee || this.dernMois == 0 || this.dernMois == 13 || mois > this.dernMois;
            }

            @Override
            public synchronized ValidState getValidState() {
                return super.getValidState().and(ValidState.createCached(this.isDateValid(), "Date invalide"));
            }

            @Override
            public int insert(SQLRow order) {
                int id = super.insert(order);
                this.model.updateFields(id);
                return id;
            }

            @Override
            public void update() {
                super.update();
                this.model.updateFields(this.getSelectedID());
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                if (r != null && r.getID() > 1) {
                    this.model.setFicheID(r.getID());
                    SQLTable tableSal = this.getTable().getBase().getTable("SALARIE");
                    SQLRow rowSal = tableSal.getRow(r.getInt("ID_SALARIE"));
                    this.dernMois = rowSal.getInt("DERNIER_MOIS");
                    this.dernAnnee = rowSal.getInt("DERNIERE_ANNEE");
                    this.selSalCombo.setVisible((Boolean)r.getObject("VALIDE"));
                    this.paneTreeLeft.setVisible((Boolean)r.getObject("VALIDE") == false);
                    this.buttonValider.setVisible((Boolean)r.getObject("VALIDE") == false);
                    this.setpDateEnabled((Boolean)r.getObject("VALIDE") == false);
                }
                this.selSalCombo.setInteractionMode(InteractionMode.DISABLED);
                this.selSalCombo.setEnabled(false);
                this.selMois.setButtonsVisible(false);
                this.selSalCombo.setButtonsVisible(false);
            }

            private void setpDateEnabled(boolean b) {
                this.selMois.setInteractionMode(b ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
                this.textAnnee.setEditable(b);
                this.textAnnee.setEnabled(b);
                this.dateDu.setInteractionMode(b ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
                this.dateAu.setInteractionMode(b ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
            }

            private void validationFiche() throws SQLException {
                this.update();
                FichePayeSQLElement.validationFiche(this.getSelectedID());
            }

            @Override
            protected SQLRowValues createDefaults() {
                System.err.println("**********Set Defaults on FichePaye.date");
                SQLRowValues rowVals = new SQLRowValues(this.getTable());
                Calendar cal = Calendar.getInstance();
                rowVals.put("ID_MOIS", cal.get(2) + 2);
                rowVals.put("ANNEE", cal.get(1));
                cal.set(5, 1);
                rowVals.put("DU", new Date(cal.getTime().getTime()));
                cal.set(5, cal.getActualMaximum(5));
                rowVals.put("AU", new Date(cal.getTime().getTime()));
                return rowVals;
            }
        };
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        super.archive(trees, cutLinks);
        for (SQLRow row : trees.getRows()) {
            if (row == null || row.getID() <= 1 || JOptionPane.showConfirmDialog(null, "Soustraire les cumuls de cette fiche \u00e0 celle en cours?", "Suppression d'une fiche de paye", 0) != 0) continue;
            SQLRow rowSal = row.getForeignRow("ID_SALARIE");
            SQLRow rowCumuls = rowSal.getForeignRow("ID_CUMULS_PAYE");
            float salBrut = rowCumuls.getFloat("SAL_BRUT_C") - row.getFloat("SAL_BRUT");
            float cgs = rowCumuls.getFloat("CSG_C") - row.getFloat("CSG");
            float cotSal = rowCumuls.getFloat("COT_SAL_C") - row.getFloat("COT_SAL");
            float cotPat = rowCumuls.getFloat("COT_PAT_C") - row.getFloat("COT_PAT");
            float netImp = rowCumuls.getFloat("NET_IMP_C") - row.getFloat("NET_IMP");
            float netAPayer = rowCumuls.getFloat("NET_A_PAYER_C") - row.getFloat("NET_A_PAYER") - row.getFloat("ACOMPTE");
            SQLRowValues rowValsCumul = rowCumuls.createEmptyUpdateRow();
            rowValsCumul.put("SAL_BRUT_C", new Float(salBrut));
            rowValsCumul.put("COT_SAL_C", new Float(cotSal));
            rowValsCumul.put("COT_PAT_C", new Float(cotPat));
            rowValsCumul.put("NET_IMP_C", new Float(netImp));
            rowValsCumul.put("NET_A_PAYER_C", new Float(netAPayer));
            rowValsCumul.put("CSG_C", new Float(cgs));
            try {
                rowValsCumul.update();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            SQLRow rowCumulConge = rowSal.getForeignRow("ID_CUMULS_CONGES");
            SQLRow rowVarSal = row.getForeignRow("ID_VARIABLE_SALARIE");
            float congeCumule = rowCumulConge.getFloat("ACQUIS");
            float congeRestant = rowCumulConge.getFloat("RESTANT");
            float prisPeriode = rowVarSal.getFloat("CONGES_PRIS");
            SQLRowValues rowValsCumulsConges = new SQLRowValues(rowCumulConge.getTable());
            rowValsCumulsConges.put("ACQUIS", new Float(congeCumule -= row.getFloat("CONGES_ACQUIS")));
            rowValsCumulsConges.put("RESTANT", new Float(congeRestant += prisPeriode));
            try {
                rowValsCumulsConges.update(rowCumulConge.getID());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static synchronized void validationFiche(int id) throws SQLException {
        int oldID = id;
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableSal = base.getTable("SALARIE");
        SQLTable tableCumulConge = base.getTable("CUMULS_CONGES");
        SQLTable tableVariableSal = base.getTable("VARIABLE_SALARIE");
        SQLTable tableFiche = base.getTable("FICHE_PAYE");
        SQLTable tableFicheElt = base.getTable("FICHE_PAYE_ELEMENT");
        SQLTable tableCumuls = base.getTable("CUMULS_PAYE");
        final SQLRowValues rowValsSal = new SQLRowValues(tableSal);
        final SQLRow rowFiche = tableFiche.getRow(oldID);
        final SQLRow rowSal = tableSal.getRow(rowFiche.getInt("ID_SALARIE"));
        if (!FichePayeSQLElement.checkDateValid(id)) {
            String msg = "Impossible de cr\u00e9er la fiche de paye de " + rowSal.getString("NOM") + " " + rowSal.getString("PRENOM") + ".\n La p\u00e9riode est clotur\u00e9e.";
            JOptionPane.showMessageDialog(null, msg, "Cr\u00e9ation paye impossible", 1);
            return;
        }
        FichePayeSQLElement.validElements(id);
        FichePayeSQLElement.stockValidValues(oldID);
        final SQLRowValues rowValsNewFiche = new SQLRowValues(tableFiche);
        try {
            SQLRow r = rowValsNewFiche.insert();
            rowValsNewFiche.put("ID", r.getID());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        int mois = rowFiche.getInt("ID_MOIS");
        int annee = rowFiche.getInt("ANNEE");
        rowValsNewFiche.put("ID_MOIS", mois);
        rowValsNewFiche.put("ANNEE", annee);
        rowValsNewFiche.put("DU", rowFiche.getObject("DU"));
        rowValsNewFiche.put("AU", rowFiche.getObject("AU"));
        rowValsNewFiche.put("ID_PROFIL_PAYE", rowFiche.getInt("ID_PROFIL_PAYE"));
        rowValsNewFiche.put("ID_SALARIE", rowSal.getID());
        rowValsSal.put("ID_FICHE_PAYE", rowValsNewFiche.getID());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    rowValsSal.update(rowSal.getID());
                    rowValsNewFiche.update();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        });
        SQLSelect selAllElt = new SQLSelect();
        selAllElt.addSelect(tableFicheElt.getKey());
        selAllElt.addSelect(tableFicheElt.getField("POSITION"));
        selAllElt.addSelect(tableFicheElt.getField("SOURCE"));
        selAllElt.addSelect(tableFicheElt.getField("IDSOURCE"));
        selAllElt.setWhere(tableFicheElt.getField("ID_FICHE_PAYE"), "=", oldID);
        selAllElt.setDistinct(true);
        selAllElt.addFieldOrder(tableFicheElt.getField("POSITION"));
        for (SQLRow rowTmpElt : SQLRowListRSH.execute(selAllElt)) {
            String source = rowTmpElt.getString("SOURCE");
            int idSource = rowTmpElt.getInt("IDSOURCE");
            int pos = rowTmpElt.getInt("POSITION");
            SQLRowValues rowValsTmp = new SQLRowValues(tableFicheElt);
            rowValsTmp.put("SOURCE", source);
            rowValsTmp.put("IDSOURCE", idSource);
            rowValsTmp.put("POSITION", pos);
            rowValsTmp.put("ID_FICHE_PAYE", rowValsNewFiche.getID());
            rowValsTmp.commit();
        }
        final SQLRow rowVarSal = tableVariableSal.getRow(rowSal.getInt("ID_VARIABLE_SALARIE"));
        int idCumuls = rowSal.getInt("ID_CUMULS_PAYE");
        SQLRow rowCumuls = tableCumuls.getRow(idCumuls);
        float salBrut = rowCumuls.getFloat("SAL_BRUT_C") + rowFiche.getFloat("SAL_BRUT");
        float cgs = rowCumuls.getFloat("CSG_C") + rowFiche.getFloat("CSG");
        float cotSal = rowCumuls.getFloat("COT_SAL_C") + rowFiche.getFloat("COT_SAL");
        float cotPat = rowCumuls.getFloat("COT_PAT_C") + rowFiche.getFloat("COT_PAT");
        float netImp = rowCumuls.getFloat("NET_IMP_C") + rowFiche.getFloat("NET_IMP");
        float hTrav = rowCumuls.getFloat("HEURE_TRAV") + rowVarSal.getFloat("HEURE_TRAV");
        float netAPayer = rowCumuls.getFloat("NET_A_PAYER_C") + rowFiche.getFloat("NET_A_PAYER") + rowFiche.getFloat("ACOMPTE");
        SQLRowValues rowValsCumul = new SQLRowValues(tableCumuls);
        rowValsCumul.put("SAL_BRUT_C", new Float(salBrut));
        rowValsCumul.put("HEURE_TRAV", new Float(hTrav));
        rowValsCumul.put("COT_SAL_C", new Float(cotSal));
        rowValsCumul.put("COT_PAT_C", new Float(cotPat));
        rowValsCumul.put("NET_IMP_C", new Float(netImp));
        rowValsCumul.put("NET_A_PAYER_C", new Float(netAPayer));
        rowValsCumul.put("CSG_C", new Float(cgs));
        SQLRow r = rowValsCumul.insert();
        rowValsCumul.put("ID", r.getID());
        rowValsSal.put("ID_CUMULS_PAYE", rowValsCumul.getID());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    rowValsSal.update(rowFiche.getInt("ID_SALARIE"));
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        });
        final SQLRow rowCumulConge = tableCumulConge.getRow(rowSal.getInt("ID_CUMULS_CONGES"));
        float congeCumule = rowCumulConge.getFloat("ACQUIS");
        float congeRestant = rowCumulConge.getFloat("RESTANT");
        float prisPeriode = rowVarSal.getFloat("CONGES_PRIS");
        congeRestant -= prisPeriode;
        SQLTable tableInfosSalPaye = base.getTable("INFOS_SALARIE_PAYE");
        final SQLRow rowSalInfosPaye = tableInfosSalPaye.getRow(rowSal.getInt("ID_INFOS_SALARIE_PAYE"));
        final SQLRowValues rowValsCumulsConges = new SQLRowValues(tableCumulConge);
        rowValsCumulsConges.put("ACQUIS", new Float(congeCumule += rowFiche.getFloat("CONGES_ACQUIS")));
        rowValsCumulsConges.put("RESTANT", new Float(congeRestant));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    rowValsCumulsConges.update(rowCumulConge.getID());
                    rowValsNewFiche.put("CONGES_ACQUIS", new Float(rowSalInfosPaye.getFloat("CONGES_PAYES")));
                    rowValsNewFiche.update();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
        final SQLRowValues rowValsOldFiche = new SQLRowValues(tableFiche);
        rowValsOldFiche.put("VALIDE", Boolean.TRUE);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    rowValsOldFiche.update(rowFiche.getID());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
        final SQLRowValues rowVals = new SQLRowValues(tableVariableSal);
        for (SQLField field : tableVariableSal.getContentFields()) {
            rowVals.put(field.getName(), Float.valueOf(0.0f));
        }
        rowVals.put("HEURE_TRAV", rowSalInfosPaye.getObject("DUREE_MOIS"));
        if (tableVariableSal.contains("NB_JOUR_MOIS")) {
            rowVals.put("NB_JOUR_MOIS", Float.valueOf(31.0f));
            rowVals.put("NB_JOUR_TRAV", Float.valueOf(31.0f));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    rowVals.update(rowVarSal.getID());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void clotureMensuelle(int idMois, int annee, int idSal) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLRowValues rowValsSal = new SQLRowValues(base.getTable("SALARIE"));
        SQLRow rowSal = base.getTable("SALARIE").getRow(idSal);
        int ancMois = rowSal.getInt("DERNIER_MOIS");
        int ancAnnee = rowSal.getInt("DERNIERE_ANNEE");
        if (ancAnnee < annee && ancMois < idMois) {
            rowValsSal.put("DERNIER_MOIS", idMois);
            rowValsSal.put("DERNIERE_ANNEE", annee);
            try {
                rowValsSal.update(idSal);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
    }

    private static void stockValidValues(int id) throws SQLException {
        ComptaPropsConfiguration conf = ComptaPropsConfiguration.getInstanceCompta();
        SQLElementDirectory dir = conf.getDirectory();
        SQLTable tableFiche = conf.getRootSociete().getTable("FICHE_PAYE");
        SQLRow rowFiche = tableFiche.getRow(id);
        SQLRow rowSal = rowFiche.getForeignRow("ID_SALARIE");
        SQLRowValues rowValsFiche = new SQLRowValues(tableFiche);
        for (String fk : Arrays.asList("ID_VARIABLE_SALARIE", "ID_CUMULS_CONGES", "ID_CUMULS_PAYE", "ID_REGLEMENT_PAYE")) {
            SQLRow fRow = rowSal.getForeignRow(fk);
            SQLRowValues copy = dir.getElement(fRow.getTable()).createCopy(fRow, null);
            assert (copy.getIDNumber() == null);
            rowValsFiche.put(fk, (Object)copy);
        }
        SQLRow rInfosSalPaye = rowSal.getForeignRow("ID_INFOS_SALARIE_PAYE");
        SQLRow rContrat = rInfosSalPaye.getForeignRow("ID_CONTRAT_SALARIE");
        rowValsFiche.put("NATURE_EMPLOI", rContrat.getString("NATURE"));
        rowValsFiche.put("ID_IDCC", rInfosSalPaye.getInt("ID_IDCC"));
        rowValsFiche.update(id);
    }

    private static void validElements(int id) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        System.err.println("Validation des \u00e9l\u00e9ments de la fiche.");
        String trueString = "1";
        if (Configuration.getInstance().getBase().getServer().getSQLSystem() == SQLSystem.POSTGRESQL) {
            trueString = "true";
        }
        String req = "UPDATE \"FICHE_PAYE_ELEMENT\" SET \"VALIDE\" = " + trueString + " WHERE \"FICHE_PAYE_ELEMENT\".\"ID_FICHE_PAYE\" = " + id;
        base.getDataSource().execute(req);
        System.err.println("Validation termin\u00e9e.");
    }

    private static boolean checkDateValid(int idFiche) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLRow rowFiche = base.getTable("FICHE_PAYE").getRow(idFiche);
        SQLRow rowSal = base.getTable("SALARIE").getRow(rowFiche.getInt("ID_SALARIE"));
        int moisClot = rowSal.getInt("DERNIER_MOIS");
        int anneeClot = rowSal.getInt("DERNIERE_ANNEE");
        int mois = rowFiche.getInt("ID_MOIS");
        int annee = rowFiche.getInt("ANNEE");
        return anneeClot == 0 || annee > anneeClot || moisClot == 0 || moisClot == 13 || mois > moisClot;
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".payslip";
    }
}

