/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.ui;

import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class GestionChequesRenderer
extends DefaultTableCellRenderer {
    private static final Color couleurChequeValide = new Color(255, 128, 64);
    private static final DateFormat dateFormat = DateFormat.getDateInstance(2);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component res = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Color fgColor = !isSelected && System.currentTimeMillis() > ((Date)value).getTime() ? couleurChequeValide : table.getForeground();
        res.setForeground(fgColor);
        return res;
    }

    @Override
    protected void setValue(Object value) {
        super.setValue(dateFormat.format((Date)value));
    }
}

