/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.component;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.payment.ui.EncaisseMontantTable;
import org.openconcerto.erp.core.sales.invoice.component.SaisieVenteFactureSQLComponent;
import org.openconcerto.erp.generationEcritures.GenerationReglementVenteNG;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.erp.preferences.ModeReglementDefautPrefPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class EncaisserMontantSQLComponent
extends BaseSQLComponent {
    private EncaisseMontantTable table = new EncaisseMontantTable();
    private JTextField nom = new JTextField();
    private DeviseField montant = new DeviseField(10);
    private JLabel labelWarning = new JLabelWarning("Le montant est trop \u00e9lev\u00e9!");
    private JDate date;

    public EncaisserMontantSQLComponent(SQLElement elt) {
        super(elt);
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)new JLabelBold("Ech\u00e9ances"), c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)this.table, c);
        this.table.getRowValuesTable().setEnabled(false);
        c.fill = 2;
        c.gridwidth = 1;
        ++c.gridy;
        c.weighty = 0.0;
        ElementComboBox comboClient = new ElementComboBox(true, 25);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("ID_CLIENT"), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.add((Component)comboClient, c);
        c.gridwidth = 1;
        this.date = new JDate(true);
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Date"), c);
        c.weightx = 0.0;
        this.add((Component)this.date, c);
        this.addSQLObject(comboClient, "ID_CLIENT");
        ++c.gridy;
        c.gridx = 0;
        JLabel label = new JLabel(this.getLabelFor("NOM"), 4);
        c.weightx = 0.0;
        this.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.add((Component)this.nom, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Montant encaiss\u00e9", 4), c);
        ++c.gridx;
        c.gridwidth = 3;
        c.fill = 0;
        this.add((Component)this.montant, c);
        ++c.gridx;
        c.gridwidth = 0;
        this.labelWarning.setHorizontalAlignment(4);
        this.add((Component)this.labelWarning, c);
        c.fill = 2;
        c.gridwidth = 0;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        JLabelBold sep = new JLabelBold("Mode de r\u00e8glement");
        c.insets = new Insets(10, 2, 1, 2);
        this.add((Component)sep, c);
        c.insets = new Insets(2, 2, 1, 2);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        this.addView("ID_MODE_REGLEMENT", "required;notdecorated;noseparator");
        final ElementSQLObject eltModeRegl = (ElementSQLObject)this.getView("ID_MODE_REGLEMENT");
        this.add((Component)eltModeRegl, c);
        this.addRequiredSQLObject(this.date, "DATE");
        this.addRequiredSQLObject(this.montant, "MONTANT");
        this.addSQLObject(this.nom, "NOM");
        DefaultGridBagConstraints.lockMinimumSize(this.montant);
        final TableModelListener tableListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                RowValuesTableModel model = EncaisserMontantSQLComponent.this.table.getRowValuesTable().getRowValuesTableModel();
                if (e.getColumn() == -1 || e.getColumn() == model.getColumnIndexForElement(EncaisserMontantSQLComponent.this.table.getMontantElement())) {
                    int rowCount = model.getRowCount();
                    long total = 0L;
                    int i = 0;
                    while (i < rowCount) {
                        Number nHT = (Number)model.getValueAt(i, model.getColumnIndexForElement(EncaisserMontantSQLComponent.this.table.getMontantElement()));
                        if (nHT != null) {
                            total += nHT.longValue();
                        }
                        ++i;
                    }
                    EncaisserMontantSQLComponent.this.montant.setText(GestionDevise.currencyToString(total));
                    if (EncaisserMontantSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION && rowCount >= 1) {
                        int idScr = MouvementSQLElement.getSourceId(model.getRowValuesAt(0).getInt("ID_MOUVEMENT_ECHEANCE"));
                        SQLTable tableMvt = Configuration.getInstance().getDirectory().getElement("MOUVEMENT").getTable();
                        if (idScr > 1) {
                            SQLRow rowModeRegl;
                            SQLRow rowSource;
                            SQLRow rowMvt = tableMvt.getRow(idScr);
                            String source = rowMvt.getString("SOURCE");
                            int idSource = rowMvt.getInt("IDSOURCE");
                            SQLElement eltSource = Configuration.getInstance().getDirectory().getElement(source);
                            if (eltSource != null && (rowSource = eltSource.getTable().getRow(idSource)) != null && (rowModeRegl = rowSource.getForeignRow("ID_MODE_REGLEMENT")) != null) {
                                System.err.println("Set mode de r\u00e8glement");
                                int idTypeRegl = rowModeRegl.getInt("ID_TYPE_REGLEMENT");
                                SQLTable tableModeRegl = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT").getTable();
                                SQLRowValues rowVals = new SQLRowValues(tableModeRegl);
                                if (idTypeRegl > 5) {
                                    idTypeRegl = 2;
                                }
                                rowVals.put("ID_TYPE_REGLEMENT", idTypeRegl);
                                rowVals.put("COMPTANT", Boolean.TRUE);
                                rowVals.put("AJOURS", 0);
                                rowVals.put("LENJOUR", 0);
                                rowVals.put("ID_" + BanqueSQLElement.TABLENAME, rowModeRegl.getInt("ID_" + BanqueSQLElement.TABLENAME));
                                eltModeRegl.setValue(rowVals);
                            }
                        }
                    }
                }
                if (e.getColumn() == -1 || e.getColumn() == model.getColumnIndexForElement(EncaisserMontantSQLComponent.this.table.getMontantAReglerElement())) {
                    EncaisserMontantSQLComponent.this.updateWarning();
                }
            }
        };
        this.montant.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                EncaisserMontantSQLComponent.this.table.getRowValuesTable().getRowValuesTableModel().removeTableModelListener(tableListener);
                EncaisserMontantSQLComponent.this.updateMontant(EncaisserMontantSQLComponent.this.montant.getText());
                EncaisserMontantSQLComponent.this.table.getRowValuesTable().getRowValuesTableModel().addTableModelListener(tableListener);
                EncaisserMontantSQLComponent.this.updateWarning();
            }
        });
        this.table.getRowValuesTable().getRowValuesTableModel().addTableModelListener(tableListener);
    }

    private void updateMontant(String s) {
        long total = 0L;
        if (s.trim().length() > 0) {
            total = GestionDevise.parseLongCurrency(s);
        }
        RowValuesTableModel model = this.table.getRowValuesTable().getRowValuesTableModel();
        int rowCount = model.getRowCount();
        int i = 0;
        while (i < rowCount) {
            Number nHT = (Number)model.getValueAt(i, model.getColumnIndexForElement(this.table.getMontantAReglerElement()));
            Long value = 0L;
            value = i < rowCount - 1 ? (nHT.longValue() <= total ? Long.valueOf(nHT.longValue()) : Long.valueOf(total)) : Long.valueOf(total);
            model.putValue(value, i, "MONTANT_REGLE");
            total -= value.longValue();
            ++i;
        }
    }

    @Override
    public void select(SQLRowAccessor r) {
        super.select(r);
        if (r != null && r.getID() > 1) {
            this.table.insertFrom("ID_ENCAISSER_MONTANT", r.getID());
        }
    }

    @Override
    public int insert(SQLRow order) {
        int id = super.insert(order);
        try {
            this.table.updateField("ID_ENCAISSER_MONTANT", id);
            System.out.println("G\u00e9n\u00e9ration des ecritures du reglement");
            SQLRow row = this.getTable().getRow(id);
            String s = row.getString("NOM");
            SQLRow rowModeRegl = row.getForeignRow("ID_MODE_REGLEMENT");
            SQLRow rowTypeRegl = rowModeRegl.getForeignRow("ID_TYPE_REGLEMENT");
            String label = "R\u00e8glement vente " + (s == null ? "" : s) + " (" + rowTypeRegl.getString("NOM") + ")";
            SQLRow clientRow = row.getForeignRow("ID_CLIENT");
            long montant = row.getLong("MONTANT");
            PrixTTC ttc = new PrixTTC(montant);
            Collection l = row.getReferentRows(Configuration.getInstance().getDirectory().getElement("ENCAISSER_MONTANT_ELEMENT").getTable());
            if (l.isEmpty()) {
                JOptionPane.showMessageDialog(null, "Un probl\u00e8me a \u00e9t\u00e9 rencontr\u00e9 lors de l'encaissement! \n Les \u00e9critures comptables non pu \u00eatre g\u00e9n\u00e9rer!");
                System.err.println("Liste des \u00e9ch\u00e9ances vides pour l'encaissement ID " + id);
                Thread.dumpStack();
            }
            new GenerationReglementVenteNG(label, clientRow, ttc, row.getDate("DATE").getTime(), rowModeRegl, row, ((SQLRow)l.get(0)).getForeignRow("ID_MOUVEMENT_ECHEANCE"), false);
            boolean supplement = false;
            for (SQLRow sqlRow : l) {
                SQLRow rowEch = sqlRow.getForeignRow("ID_ECHEANCE_CLIENT");
                SQLRowValues rowValsEch = rowEch.createEmptyUpdateRow();
                if (sqlRow.getLong("MONTANT_REGLE") >= sqlRow.getLong("MONTANT_A_REGLER")) {
                    rowValsEch.put("REGLE", Boolean.TRUE);
                    if (sqlRow.getLong("MONTANT_REGLE") > sqlRow.getLong("MONTANT_A_REGLER")) {
                        supplement = true;
                    }
                }
                rowValsEch.put("MONTANT", rowEch.getLong("MONTANT") - sqlRow.getLong("MONTANT_REGLE"));
                rowValsEch.update();
            }
            if (supplement) {
                SQLElement elt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
                EditFrame f = new EditFrame(elt, EditFrame.CREATION);
                SaisieVenteFactureSQLComponent comp = (SaisieVenteFactureSQLComponent)f.getSQLComponent();
                comp.setComplement(true);
                f.setVisible(true);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur lors de la g\u00e9n\u00e9ration des ecritures du reglement", e);
        }
        return id;
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues vals = new SQLRowValues(this.getTable());
        this.table.getModel().clearRows();
        try {
            SQLRow r = ModeReglementDefautPrefPanel.getDefaultRow(false);
            SQLElement eltModeReglement = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
            if (((SQLRowAccessor)r).getID() > 1) {
                SQLRowValues rowVals = eltModeReglement.createCopy(((SQLRowAccessor)r).getID());
                vals.put("ID_MODE_REGLEMENT", (Object)rowVals);
            }
        }
        catch (SQLException e) {
            System.err.println("Impossible de s\u00e9lectionner le mode de r\u00e8glement par d\u00e9faut du client.");
            e.printStackTrace();
        }
        return vals;
    }

    private final void updateWarning() {
        long montantValue = 0L;
        if (this.table.getRowValuesTable().getRowCount() == 0) {
            this.labelWarning.setVisible(false);
            return;
        }
        try {
            if (this.montant.getText().trim().length() != 0) {
                montantValue = GestionDevise.parseLongCurrency(this.montant.getText().trim());
            }
        }
        catch (NumberFormatException e) {
            System.err.println("format float incorrect " + e);
            e.printStackTrace();
        }
        RowValuesTableModel model = this.table.getRowValuesTable().getRowValuesTableModel();
        int rowCount = model.getRowCount();
        long total = 0L;
        int i = 0;
        while (i < rowCount) {
            Number nHT = (Number)model.getValueAt(i, model.getColumnIndexForElement(this.table.getMontantAReglerElement()));
            total += nHT.longValue();
            ++i;
        }
        this.labelWarning.setVisible(montantValue <= 0L || montantValue > total);
    }

    public void loadEcheancesFromRows(List<SQLRow> rows) {
        Collections.sort(rows, new Comparator<SQLRow>(){

            @Override
            public int compare(SQLRow o1, SQLRow o2) {
                Calendar c1 = o1.getDate("DATE");
                Calendar c2 = o2.getDate("DATE");
                if (c1 == null) {
                    return -1;
                }
                if (c2 == null) {
                    return 1;
                }
                if (c1.getTime().before(c2.getTime())) {
                    return -1;
                }
                return 1;
            }
        });
        SQLTable tableEch = Configuration.getInstance().getDirectory().getElement("ECHEANCE_CLIENT").getTable();
        SQLTable tableEnc = Configuration.getInstance().getDirectory().getElement("ENCAISSER_MONTANT_ELEMENT").getTable();
        SQLInjector inj = SQLInjector.getInjector(tableEch, tableEnc);
        for (SQLRow row : rows) {
            SQLRowValues rowVals = inj.createRowValuesFrom(row.getID());
            rowVals.put("MONTANT_REGLE", rowVals.getObject("MONTANT_A_REGLER"));
            this.table.getModel().addRow(rowVals);
            int rowIndex = this.table.getModel().getRowCount() - 1;
            this.table.getModel().fireTableModelModified(rowIndex);
        }
        this.table.getModel().fireTableDataChanged();
        this.table.repaint();
    }
}

