/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JButton;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.accounting.ui.SuppressionEcrituresPanel;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.utils.cc.ITransformer;

public class ListeGestCommEltPanel
extends ListeAddPanel {
    private EditFrame editModifyFrame;
    private EditFrame editReadOnlyFrame;

    private ListeGestCommEltPanel(SQLElement elem, boolean showAdd, Where w, String variant) {
        this(elem, new IListe(elem.createTableSource(w)), showAdd);
    }

    public ListeGestCommEltPanel(SQLElement elem, IListe l) {
        this(elem, l, false);
    }

    public ListeGestCommEltPanel(SQLElement elem, IListe l, boolean showAdd) {
        super(elem, l);
        this.setAddVisible(showAdd);
        this.setOpaque(false);
        if (elem.getTable().getName().equals("SAISIE_VENTE_FACTURE")) {
            this.btnMngr.setAdditional(this.buttonEffacer, new ITransformer<JButton, String>(){

                @Override
                public String transformChecked(JButton input) {
                    SQLRow row = ListeGestCommEltPanel.this.getListe().fetchSelectedRow();
                    if (row.getBoolean("PARTIAL").booleanValue() && !ListeGestCommEltPanel.this.isLastPartialInvoice(row)) {
                        return "Vous ne pouvez pas supprimer cette facture interm\u00e9diaire.\n Des factures ant\u00e9rieures ont \u00e9t\u00e9 \u00e9tablies !";
                    }
                    return null;
                }
            });
            this.btnMngr.setAdditional(this.buttonModifier, new ITransformer<JButton, String>(){

                @Override
                public String transformChecked(JButton input) {
                    SQLRow row = ListeGestCommEltPanel.this.getListe().fetchSelectedRow();
                    if (row.getBoolean("PARTIAL").booleanValue() || row.getBoolean("SOLDE").booleanValue()) {
                        return "Vous ne pouvez pas modifier une facture interm\u00e9diaire.";
                    }
                    return null;
                }
            });
        }
    }

    public boolean isLastPartialInvoice(SQLRowAccessor sqlRowAccessor) {
        Collection<? extends SQLRowAccessor> rows = sqlRowAccessor.getReferentRows(sqlRowAccessor.getTable().getTable("TR_COMMANDE_CLIENT"));
        for (SQLRowAccessor sQLRowAccessor : rows) {
            SQLRowAccessor rowCmd = sQLRowAccessor.getForeign("ID_COMMANDE_CLIENT");
            if (rowCmd == null || rowCmd.isUndefined()) continue;
            Collection<? extends SQLRowAccessor> rowSFacts = rowCmd.getReferentRows(sqlRowAccessor.getTable().getTable("TR_COMMANDE_CLIENT"));
            for (SQLRowAccessor sQLRowAccessor2 : rowSFacts) {
                SQLRowAccessor rowFact;
                if (sQLRowAccessor2.isForeignEmpty("ID_SAISIE_VENTE_FACTURE") || !(rowFact = sQLRowAccessor2.getForeign("ID_SAISIE_VENTE_FACTURE")).getDate("DATE").after(sqlRowAccessor.getDate("DATE"))) continue;
                return false;
            }
        }
        return true;
    }

    public ListeGestCommEltPanel(SQLElement elem, IListe l, String variant) {
        super(elem, l, variant);
        this.setAddVisible(false);
        this.setOpaque(false);
    }

    public ListeGestCommEltPanel(SQLElement elem, boolean showAdd) {
        this(elem, showAdd, null, null);
    }

    public ListeGestCommEltPanel(SQLElement elem) {
        this(elem, false);
    }

    public ListeGestCommEltPanel(SQLElement elem, Where w, String variant) {
        this(elem, false, w, variant);
    }

    public ListeGestCommEltPanel(SQLElement elem, Where w) {
        this(elem, false, w, null);
    }

    @Override
    protected void handleAction(JButton source, ActionEvent evt) {
        SQLRow row = this.getElement().getTable().getRow(this.getListe().getSelectedId());
        if (row != null && row.getID() > 1) {
            SQLRow mvt = row.getForeign("ID_MOUVEMENT");
            if (source == this.buttonEffacer) {
                if (mvt != null && !mvt.isUndefined()) {
                    PanelFrame frame = new PanelFrame(new SuppressionEcrituresPanel(((SQLRowAccessor)mvt).getID()), "Suppression");
                    frame.pack();
                    frame.setLocationRelativeTo(null);
                    frame.setResizable(false);
                    frame.setVisible(true);
                } else {
                    super.handleAction(source, evt);
                }
            } else if (source == this.buttonModifier) {
                if (mvt == null || mvt.isUndefined() | MouvementSQLElement.isEditable(((SQLRowAccessor)mvt).getID())) {
                    if (this.editModifyFrame == null) {
                        this.editModifyFrame = new EditFrame(this.element, EditPanel.MODIFICATION);
                    }
                    this.editModifyFrame.selectionId(this.getListe().getSelectedId());
                    this.editModifyFrame.setVisible(true);
                } else {
                    if (this.editReadOnlyFrame == null) {
                        this.editReadOnlyFrame = new EditFrame(this.element, EditPanel.READONLY);
                    }
                    this.editReadOnlyFrame.selectionId(this.getListe().getSelectedId());
                    this.editReadOnlyFrame.setVisible(true);
                }
            } else {
                super.handleAction(source, evt);
            }
        } else {
            super.handleAction(source, evt);
        }
    }
}

