/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.ui.SelectionJournalImportPanel;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.importer.ArrayTableModel;
import org.openconcerto.erp.importer.DataImporter;
import org.openconcerto.openoffice.ContentTypeVersioned;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.ReloadPanel;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;

public class ImportEcriturePanel
extends JPanel {
    private final Map<String, Integer> mapJournal;
    private final SQLTable tableEcr = Configuration.getInstance().getDirectory().getElement("ECRITURE").getTable();

    public ImportEcriturePanel() {
        super(new GridBagLayout());
        this.mapJournal = new HashMap<String, Integer>();
        this.mapJournal.put("HA", 2);
        this.mapJournal.put("VE", 3);
        this.mapJournal.put("BA", 4);
        this.mapJournal.put("CA", 5);
        this.mapJournal.put("OD", 6);
        JLabel label = new JLabel("Import depuis un fichier CSV, XLS ou ODT.");
        JLabel label2 = new JLabel("Le fichier doit contenir les colonnes :");
        JLabel label3 = new JLabel(" - Date (format dd/MM/yy pour le CSV)");
        JLabel label4 = new JLabel(" - Journal");
        JLabel label5 = new JLabel(" - N\u00b0 de compte");
        JLabel label6 = new JLabel(" - Nom de la pi\u00e8ce");
        JLabel label7 = new JLabel(" - Libell\u00e9");
        JLabel label8 = new JLabel(" - D\u00e9bit");
        JLabel label9 = new JLabel(" - Cr\u00e9dit");
        final JButton button = new JButton("S\u00e9lectionner le ficher");
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 2;
        this.add((Component)label, c);
        ++c.gridy;
        this.add((Component)label2, c);
        ++c.gridy;
        this.add((Component)label3, c);
        ++c.gridy;
        this.add((Component)label4, c);
        ++c.gridy;
        this.add((Component)label5, c);
        ++c.gridy;
        this.add((Component)label6, c);
        ++c.gridy;
        this.add((Component)label7, c);
        ++c.gridy;
        this.add((Component)label8, c);
        ++c.gridy;
        this.add((Component)label9, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        final ReloadPanel rlPanel = new ReloadPanel();
        c.anchor = 13;
        c.fill = 0;
        this.add((Component)rlPanel, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)button, c);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                button.setEnabled(false);
                final Frame frame = SwingThreadUtils.getAncestorOrSelf(Frame.class, ImportEcriturePanel.this);
                final FileDialog fd = new FileDialog(frame, "Import d'\u00e9critures", 0);
                fd.setFilenameFilter(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith("." + ContentTypeVersioned.SPREADSHEET.getExtension());
                    }
                });
                fd.setVisible(true);
                rlPanel.setMode(0);
                if (fd.getFile() != null) {
                    final DBRoot rootSociete = ((ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance()).getRootSociete();
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                SQLUtils.executeAtomic(rootSociete.getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, IOException>(){

                                    @Override
                                    public Object handle(SQLDataSource ds) throws SQLException, IOException {
                                        try {
                                            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
                                            ImportEcriturePanel.this.importData(new File(fd.getDirectory(), fd.getFile()), "Import " + format.format(new Date()), frame);
                                        }
                                        catch (Exception exn) {
                                            if (exn.getMessage().toLowerCase().contains("file format")) {
                                                JOptionPane.showMessageDialog(ImportEcriturePanel.this, "Mauvais format de fichier");
                                            }
                                            ExceptionHandler.handle("Erreur pendant l'importation", exn);
                                        }
                                        return null;
                                    }
                                });
                            }
                            catch (IOException exn) {
                                ExceptionHandler.handle(frame, "Erreur lors de la lecture du fichier", exn);
                            }
                            catch (SQLException exn) {
                                ExceptionHandler.handle(frame, "Erreur lors de l'insertion dans la base", exn);
                            }
                            frame.dispose();
                        }
                    }.start();
                }
            }
        });
    }

    public void importData(File f, String mvtName, final Frame owner) throws Exception {
        DataImporter importer = new DataImporter(this.tableEcr);
        importer.setSkipFirstLine(false);
        SimpleDateFormat dF = new SimpleDateFormat("dd/MM/yyyy");
        ArrayTableModel m = importer.createModelFrom(f);
        GenerationEcritures gen = new GenerationEcritures();
        int idMvt = gen.getNewMouvement("", 1, 1, mvtName);
        long solde = 0L;
        int i = 0;
        while (i < m.getRowCount()) {
            String trim;
            Date dateValue;
            Object valueAt = m.getValueAt(i, 0);
            if (valueAt == null) break;
            if (valueAt.getClass().isAssignableFrom(Date.class)) {
                dateValue = (Date)valueAt;
            } else {
                if (valueAt.toString().trim().length() == 0) break;
                dateValue = dF.parse(valueAt.toString());
            }
            gen.mEcritures.put("ID_MOUVEMENT", idMvt);
            String numCompt = trim = m.getValueAt(i, 2).toString().trim();
            if (trim.contains(".")) {
                numCompt = trim.substring(0, trim.indexOf(46));
            }
            int idCpt = ComptePCESQLElement.getId(numCompt);
            gen.mEcritures.put("ID_COMPTE_PCE", idCpt);
            String stringValueD = m.getValueAt(i, 5).toString();
            long montantD = GestionDevise.parseLongCurrency(stringValueD);
            String stringValueC = m.getValueAt(i, 6).toString();
            long montantC = GestionDevise.parseLongCurrency(stringValueC);
            gen.mEcritures.put("CREDIT", montantC);
            gen.mEcritures.put("DEBIT", montantD);
            solde += montantD;
            solde -= montantC;
            System.err.println("(" + stringValueD + " : " + stringValueC + ") ---- (" + montantD + " : " + montantC + ")");
            final String valueJrnl = m.getValueAt(i, 1).toString();
            if (this.mapJournal.get(valueJrnl) == null) {
                try {
                    System.err.println("LOCKED");
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            JDialog diag = new JDialog(owner);
                            diag.setModal(true);
                            diag.setContentPane(new SelectionJournalImportPanel(valueJrnl, ImportEcriturePanel.this.mapJournal, null));
                            diag.setTitle("Import \u00e9critures");
                            diag.setLocationRelativeTo(null);
                            diag.pack();
                            diag.setVisible(true);
                        }
                    });
                    System.err.println("PASSED");
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            gen.mEcritures.put("ID_JOURNAL", this.mapJournal.get(valueJrnl));
            gen.mEcritures.put("DATE", dateValue);
            String stringPiece = m.getValueAt(i, 3).toString();
            if (stringPiece != null && stringPiece.length() > 0 && stringPiece.contains(".")) {
                stringPiece = stringPiece.substring(0, stringPiece.indexOf(46));
            }
            gen.mEcritures.put("NOM", String.valueOf(m.getValueAt(i, 4).toString()) + " " + stringPiece);
            gen.ajoutEcriture();
            ++i;
        }
        if (solde != 0L) {
            throw new IllegalArgumentException("La partie double n'est respect\u00e9e (solde = " + solde + "). Import annul\u00e9!");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(owner, "Importation des \u00e9critures termin\u00e9e");
            }
        });
    }
}

