/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTable;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.model.PlanComptableEModel;
import org.openconcerto.erp.core.finance.accounting.ui.AjouterComptePCGtoPCEFrame;
import org.openconcerto.erp.core.finance.accounting.ui.PlanComptableEPanel;
import org.openconcerto.erp.element.objet.Compte;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ExceptionHandler;

public class GestionPlanComptableEFrame
extends JFrame {
    private JButton boutonAjout = new JButton("Cr\u00e9er un nouveau compte");
    private JButton boutonSuppr = new JButton("Supprimer");
    private JButton boutonAjoutPCG = new JButton("Ajouter un compte depuis le PCG");
    private EditFrame edit = null;
    private AjouterComptePCGtoPCEFrame ajoutCptFrame = null;
    private SQLTable compteTable = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("COMPTE_PCE");
    private PlanComptableEPanel panelPCE;

    public GestionPlanComptableEFrame() {
        super("G\u00e9rer le plan comptable entreprise");
        Container container = this.getContentPane();
        Vector<1> actionClickDroitTable = new Vector<1>();
        actionClickDroitTable.add(new AbstractAction("Ajouter un compte"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GestionPlanComptableEFrame.this.edit == null) {
                    GestionPlanComptableEFrame.this.edit = new EditFrame(Configuration.getInstance().getDirectory().getElement("COMPTE_PCE"));
                    GestionPlanComptableEFrame.this.edit.pack();
                }
                GestionPlanComptableEFrame.this.edit.setVisible(true);
            }
        });
        this.panelPCE = new PlanComptableEPanel(actionClickDroitTable);
        container.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        container.add((Component)this.boutonAjout, c);
        this.boutonAjout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GestionPlanComptableEFrame.this.edit == null) {
                    GestionPlanComptableEFrame.this.edit = new EditFrame(Configuration.getInstance().getDirectory().getElement("COMPTE_PCE"));
                    GestionPlanComptableEFrame.this.edit.pack();
                }
                GestionPlanComptableEFrame.this.edit.setVisible(true);
            }
        });
        ++c.gridx;
        container.add((Component)this.boutonSuppr, c);
        this.boutonSuppr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GestionPlanComptableEFrame.this.supprimerCompte();
            }
        });
        ++c.gridx;
        container.add((Component)this.boutonAjoutPCG, c);
        this.boutonAjoutPCG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GestionPlanComptableEFrame.this.ajoutCptFrame == null) {
                    GestionPlanComptableEFrame.this.ajoutCptFrame = new AjouterComptePCGtoPCEFrame();
                    GestionPlanComptableEFrame.this.ajoutCptFrame.pack();
                }
                GestionPlanComptableEFrame.this.ajoutCptFrame.setVisible(true);
            }
        });
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        container.add((Component)this.panelPCE, c);
        this.compteTable.addTableModifiedListener(new SQLTableModifiedListener(){

            @Override
            public void tableModified(SQLTableEvent evt) {
                SQLRow row = evt.getRow();
                GestionPlanComptableEFrame.this.panelPCE.fireModificationCompte(new Compte(evt.getId(), row.getString("NUMERO"), row.getString("NOM")));
            }
        });
    }

    private void supprimerCompte() {
        JTable tableTmp = (JTable)this.panelPCE.getTables().get(this.panelPCE.getSelectedIndex());
        PlanComptableEModel model = (PlanComptableEModel)tableTmp.getModel();
        int[] selectedRows = tableTmp.getSelectedRows();
        if (selectedRows.length == 0) {
            return;
        }
        SQLElement eltComptePCE = Configuration.getInstance().getDirectory().getElement("COMPTE_PCE");
        int i = 0;
        while (i < selectedRows.length) {
            int id = model.getId(selectedRows[i]);
            try {
                eltComptePCE.archive(id);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ExceptionHandler.handle("Erreur lors de la suppression du compte.");
            }
            System.out.println("Compte Supprim\u00e9");
            ++i;
        }
    }

    public PlanComptableEPanel getPanelPCE() {
        return this.panelPCE;
    }
}

