/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.model.SommeCompte;
import org.openconcerto.erp.core.finance.accounting.report.PdfGenerator_3310;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.GestionDevise;

public class Map3310
extends Thread {
    private Map<String, Object> m;
    private static final DateFormat format = new SimpleDateFormat("ddMMyyyy");
    private JProgressBar bar;
    private Date dateDebut;
    private Date dateFin;
    private static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLTable tableCompte = Configuration.getInstance().getRoot().findTable("COMPTE_PCE");
    private SQLRowValues rowPrefCompteVals = new SQLRowValues(tablePrefCompte);
    SommeCompte sommeCompte;

    @Override
    public void run() {
        SQLRow rowPrefCompte = tablePrefCompte.getRow(2);
        this.rowPrefCompteVals.loadAbsolutelyAll(rowPrefCompte);
        int idCompteTVACol = this.rowPrefCompteVals.getInt("ID_COMPTE_PCE_TVA_VENTE");
        if (idCompteTVACol <= 1) {
            try {
                String compte = ComptePCESQLElement.getComptePceDefault("TVACollectee");
                idCompteTVACol = ComptePCESQLElement.getId(compte);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SQLRow rowCompteTVACol = tableCompte.getRow(idCompteTVACol);
        int idCompteTVADed = this.rowPrefCompteVals.getInt("ID_COMPTE_PCE_TVA_ACHAT");
        if (idCompteTVADed <= 1) {
            try {
                String compte = ComptePCESQLElement.getComptePceDefault("TVADeductible");
                idCompteTVADed = ComptePCESQLElement.getId(compte);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SQLRow rowCompteTVADed = tableCompte.getRow(idCompteTVADed);
        int idCompteTVAIntra = this.rowPrefCompteVals.getInt("ID_COMPTE_PCE_TVA_INTRA");
        if (idCompteTVAIntra <= 1) {
            try {
                String compte = ComptePCESQLElement.getComptePceDefault("TVAIntraComm");
                idCompteTVAIntra = ComptePCESQLElement.getId(compte);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SQLRow rowCompteTVAIntra = tableCompte.getRow(idCompteTVAIntra);
        int idCompteAchatsIntra = this.rowPrefCompteVals.getInt("ID_COMPTE_PCE_ACHAT_INTRA");
        if (idCompteAchatsIntra <= 1) {
            try {
                String compte = ComptePCESQLElement.getComptePceDefault("AchatsIntra");
                idCompteAchatsIntra = ComptePCESQLElement.getId(compte);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SQLRow rowCompteAchatIntra = tableCompte.getRow(idCompteAchatsIntra);
        int idCompteTVAImmo = this.rowPrefCompteVals.getInt("ID_COMPTE_PCE_TVA_IMMO");
        if (idCompteTVAImmo <= 1) {
            try {
                String compte = ComptePCESQLElement.getComptePceDefault("TVAImmo");
                idCompteTVAImmo = ComptePCESQLElement.getId(compte);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SQLRow rowCompteTVAImmo = tableCompte.getRow(idCompteTVAImmo);
        PdfGenerator_3310 p = new PdfGenerator_3310();
        this.m = new HashMap<String, Object>();
        long v010 = -this.sommeCompte.soldeCompte(70, 70, true, this.dateDebut, this.dateFin);
        this.m.put("A01", GestionDevise.round(v010));
        this.m.put("A02", "");
        long tvaIntra = -this.sommeCompte.sommeCompteFils(rowCompteTVAIntra.getString("NUMERO"), this.dateDebut, this.dateFin);
        long achatsIntra = this.sommeCompte.sommeCompteFils(rowCompteAchatIntra.getString("NUMERO"), this.dateDebut, this.dateFin);
        this.m.put("A03", GestionDevise.round(achatsIntra));
        this.m.put("A04", "");
        this.m.put("A05", "");
        this.m.put("A06", "");
        this.m.put("A07", "");
        long tvaCol = -this.sommeCompte.sommeCompteFils(rowCompteTVACol.getString("NUMERO"), this.dateDebut, this.dateFin) + tvaIntra;
        this.m.put("B08", GestionDevise.round(tvaCol));
        this.m.put("B08HT", GestionDevise.round(Math.round((double)tvaCol / 0.196)));
        this.m.put("B09", "");
        this.m.put("B09HT", "");
        this.m.put("B09B", "");
        this.m.put("B09BHT", "");
        this.m.put("B10", "");
        this.m.put("B10HT", "");
        this.m.put("B11", "");
        this.m.put("B11HT", "");
        this.m.put("B12", "");
        this.m.put("B12HT", "");
        this.m.put("B13", "");
        this.m.put("B13HT", "");
        this.m.put("B14", "");
        this.m.put("B14HT", "");
        this.m.put("B15", "");
        this.m.put("B16", GestionDevise.round(tvaCol));
        this.m.put("B17", GestionDevise.round(tvaIntra));
        this.m.put("B18", "");
        String numeroCptTVAImmo = rowCompteTVAImmo.getString("NUMERO");
        long tvaImmo = this.sommeCompte.sommeCompteFils(numeroCptTVAImmo, this.dateDebut, this.dateFin);
        this.m.put("B19", GestionDevise.round(tvaImmo));
        String numeroCptTVADed = rowCompteTVADed.getString("NUMERO");
        long tvaAutre = this.sommeCompte.sommeCompteFils(numeroCptTVADed, this.dateDebut, this.dateFin);
        if (numeroCptTVAImmo.startsWith(numeroCptTVADed)) {
            tvaAutre -= tvaImmo;
        }
        this.m.put("B20", GestionDevise.round(tvaAutre));
        this.m.put("B21", "");
        this.m.put("B22", "");
        this.m.put("B23", "");
        long tvaDed = tvaAutre + tvaImmo;
        this.m.put("B24", GestionDevise.round(tvaDed));
        this.m.put("C25", "");
        this.m.put("C26", "");
        this.m.put("C27", "");
        this.m.put("C28", GestionDevise.round(tvaCol - tvaDed));
        this.m.put("C29", "");
        this.m.put("C30", "");
        this.m.put("C31", "");
        this.m.put("C32", GestionDevise.round(tvaCol - tvaDed));
        p.generateFrom(this.m);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Map3310.this.bar.setValue(95);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String file = String.valueOf(TemplateNXProps.getInstance().getStringProperty("Location3310PDF")) + File.separator + String.valueOf(Calendar.getInstance().get(1)) + File.separator + "result_3310_2.pdf";
                System.err.println(file);
                File f = new File(file);
                Gestion.openPDF(f);
                Map3310.this.bar.setValue(100);
            }
        });
    }

    public Map3310(JProgressBar bar, Date dateDeb, Date dateFin) {
        this.bar = bar;
        if (dateDeb == null && dateFin == null) {
            SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
            SQLRow rowExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON").getRow(rowSociete.getInt("ID_EXERCICE_COMMON"));
            dateFin = (Date)rowExercice.getObject("DATE_FIN");
            dateDeb = (Date)rowExercice.getObject("DATE_DEB");
        }
        this.dateDebut = dateDeb;
        this.dateFin = dateFin;
        this.sommeCompte = new SommeCompte();
    }

    public Map3310(JProgressBar bar) {
        this(bar, null, null);
    }

    public void generateMap2033A() {
        this.start();
    }
}

