/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.cc.ITransformer;

public class JournauxSheetXML
extends AbstractListeSheetXml {
    private static final SQLTable tableEcriture = base.getTable("ECRITURE");
    protected static final SQLTable tableJournal = base.getTable("JOURNAL");
    private static final SQLTable tableMvt = base.getTable("MOUVEMENT");
    protected static final SQLTable tableCompte = base.getTable("COMPTE_PCE");
    public static final int MODEALL = 1;
    public static final int MODELETTREE = 2;
    public static final int MODENONLETTREE = 3;
    private static final DateFormat dateFormat = DateFormat.getDateInstance(2);
    private static final DateFormat dateFormatEcr = DateFormat.getDateInstance(3);
    protected Date dateDu;
    protected Date dateAu;
    protected int id;
    protected int lettrage;
    private String compteDeb;
    private String compteEnd;
    public static String TEMPLATE_ID = "Journaux";
    public static String TEMPLATE_PROPERTY_NAME = "LocationJournaux";
    private SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
    Date date;

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    public String getStoragePathP() {
        return "Journaux";
    }

    @Override
    public String getName() {
        if (this.date == null) {
            this.date = new Date();
        }
        return "Journal" + this.date.getTime();
    }

    public JournauxSheetXML(int id, Date du, Date au, int lettrage, String compteDeb, String compteEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(au);
        this.printer = PrinterNXProps.getInstance().getStringProperty("JournauxPrinter");
        this.dateAu = au;
        this.dateDu = du;
        this.id = id;
        this.lettrage = lettrage;
        this.compteDeb = compteDeb;
        this.compteEnd = compteEnd;
    }

    protected void makeEntete(Map<String, Object> line, String nomJournal) {
        line.put("TITRE_1", "Journal " + nomJournal + " - " + this.rowSociete.getObject("TYPE") + " " + this.rowSociete.getObject("NOM"));
        line.put("TITRE_2", "Edition du " + dateFormat.format(new Date()) + " P\u00e9riode du " + dateFormatEcr.format(this.dateDu) + " au " + dateFormatEcr.format(this.dateAu));
    }

    @Override
    protected void createListeValues() {
        SQLRowValues vals = new SQLRowValues(tableEcriture);
        vals.put("ID_JOURNAL", null);
        vals.put("ID_COMPTE_PCE", null);
        vals.put("COMPTE_NUMERO", null);
        vals.put("COMPTE_NOM", null);
        vals.put("JOURNAL_CODE", null);
        vals.put("JOURNAL_NOM", null);
        vals.putRowValues("ID_MOUVEMENT").put("NUMERO", null);
        vals.put("CREDIT", null);
        vals.put("DEBIT", null);
        vals.put("DATE", null);
        vals.put("NOM", null);
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(vals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect sel) {
                Where w = new Where((FieldRef)tableEcriture.getField("DATE"), JournauxSheetXML.this.dateDu, (Object)JournauxSheetXML.this.dateAu);
                Where w2 = new Where((FieldRef)tableEcriture.getField("ID_JOURNAL"), "=", JournauxSheetXML.this.id);
                if (JournauxSheetXML.this.lettrage == 2) {
                    Object o = null;
                    w = w.and(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "<>", (Object)o));
                    w = w.and(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "!=", (Object)""));
                } else if (JournauxSheetXML.this.lettrage == 3) {
                    Object o = null;
                    Where w3 = new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)o);
                    w = w.and(w3.or(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)"")));
                }
                w = JournauxSheetXML.this.compteDeb.equals(JournauxSheetXML.this.compteEnd) ? w.and(new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), "=", (Object)JournauxSheetXML.this.compteDeb)) : w.and(new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), (Object)JournauxSheetXML.this.compteDeb, (Object)JournauxSheetXML.this.compteEnd));
                if (!UserManager.getInstance().getCurrentUser().getRights().haveRight(ComptaUserRight.ACCES_NOT_RESCTRICTED_TO_411)) {
                    w = w.and(new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), "LIKE", (Object)"411%"));
                }
                sel.setWhere(w.and(w2));
                sel.addFieldOrder(sel.getAlias(tableEcriture.getField("ID_JOURNAL")));
                sel.addFieldOrder(sel.getAlias(tableEcriture.getField("DATE")));
                sel.addFieldOrder(sel.getAlias(tableMvt.getField("NUMERO")));
                return sel;
            }
        });
        List<SQLRowValues> list = fetcher.fetch();
        System.err.println("START CREATE JOURNAUX, NB ecritures  " + list.size());
        long totalDebit = 0L;
        long totalCredit = 0L;
        int prevIdMvt = 0;
        String firstJournal = tableJournal.getRow(this.id).getString("NOM");
        ArrayList tableauVals = new ArrayList();
        this.listAllSheetValues.put(0, tableauVals);
        HashMap<Integer, String> style = new HashMap<Integer, String>();
        this.styleAllSheetValues.put(0, style);
        int i = 0;
        while (i < list.size()) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            SQLRowValues rowEcr = list.get(i);
            SQLRowAccessor rowMvt = rowEcr.getForeign("ID_MOUVEMENT");
            if (prevIdMvt != rowMvt.getID()) {
                prevIdMvt = rowMvt.getID();
                style.put(tableauVals.size(), "Titre 1");
            } else {
                style.put(tableauVals.size(), "Normal");
            }
            values.put("DATE", dateFormatEcr.format(rowEcr.getDate("DATE").getTime()));
            values.put("NUMERO_COMPTE", rowEcr.getString("COMPTE_NUMERO"));
            values.put("NUMERO_MOUVEMENT", rowMvt.getObject("NUMERO"));
            Object libelle = rowEcr.getObject("NOM");
            values.put("LIBELLE", libelle);
            long deb = (Long)rowEcr.getObject("DEBIT");
            long cred = (Long)rowEcr.getObject("CREDIT");
            long solde = deb - cred;
            totalCredit += cred;
            totalDebit += deb;
            values.put("DEBIT", deb == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(deb, false)));
            values.put("CREDIT", cred == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(cred, false)));
            values.put("SOLDE", solde == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(solde, false)));
            tableauVals.add(values);
            ++i;
        }
        HashMap<String, Object> sheetVals = new HashMap<String, Object>();
        this.mapAllSheetValues.put(0, sheetVals);
        this.makeEntete(sheetVals, firstJournal);
        sheetVals.put("TOTAL_DEBIT", totalDebit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalDebit, false)));
        sheetVals.put("TOTAL_CREDIT", totalCredit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalCredit, false)));
        sheetVals.put("TOTAL_SOLDE", totalDebit - totalCredit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalDebit - totalCredit, false)));
    }
}

