/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationDoc.SheetInterface;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.cc.ITransformer;

public class GrandLivreSheet
extends SheetInterface {
    private static int debutFill;
    private static int endFill;
    public static int MODEALL;
    public static int MODELETTREE;
    public static int MODENONLETTREE_PERIODE;
    public static int MODENONLETTREE_ALL;
    private static final SQLTable tableEcriture;
    private static final SQLTable tableJournal;
    private static final SQLTable tableMvt;
    private static final SQLTable tableCompte;
    private static final DateFormat dateFormat;
    private static final DateFormat dateFormatEcr;
    private SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
    private Date dateDu;
    private Date dateAu;
    private String compteDeb;
    private String compteEnd;
    private int lettrage;
    private boolean cumul = false;
    private boolean excludeCompteSolde = true;
    private boolean centralClient = false;
    private boolean centralFourn = false;
    int idJrnlExclude = -1;
    public static String TEMPLATE_ID;
    public static String TEMPLATE_PROPERTY_NAME;
    private String toDay = dateFormat.format(new Date());
    private int size;

    static {
        MODEALL = 1;
        MODELETTREE = 2;
        MODENONLETTREE_PERIODE = 3;
        MODENONLETTREE_ALL = 4;
        tableEcriture = base.getTable("ECRITURE");
        tableJournal = base.getTable("JOURNAL");
        tableMvt = base.getTable("MOUVEMENT");
        tableCompte = base.getTable("COMPTE_PCE");
        dateFormat = DateFormat.getDateInstance(2);
        dateFormatEcr = DateFormat.getDateInstance(3);
        TEMPLATE_ID = "Grand Livre";
        TEMPLATE_PROPERTY_NAME = "LocationGrandLivre";
        GrandLivreSheet.setSize(7, 69);
    }

    public static void setSize(int debut, int fin) {
        debutFill = debut;
        endFill = fin;
    }

    @Override
    protected String getYear() {
        return "";
    }

    public GrandLivreSheet(Date du, Date au, String compteDep, String compteEnd, int lettrage, boolean cumul, boolean excludeCptSolde, boolean centralClient, boolean centralFourn, int idJrnlExclude) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(au);
        this.nbRowsPerPage = 72;
        this.idJrnlExclude = idJrnlExclude;
        this.printer = PrinterNXProps.getInstance().getStringProperty("GrandLivrePrinter");
        this.modele = "GrandLivre.ods";
        this.dateAu = au;
        this.dateDu = du;
        this.compteDeb = compteDep.trim();
        this.compteEnd = compteEnd.trim();
        this.lettrage = lettrage;
        this.cumul = cumul;
        this.excludeCompteSolde = excludeCptSolde;
        this.centralClient = centralClient;
        this.centralFourn = centralFourn;
        this.createMap();
    }

    private void makeEntete(int rowDeb) {
        this.mCell.put("A" + rowDeb, this.rowSociete.getObject("NOM"));
        this.mCell.put("G" + rowDeb, "Edition du " + this.toDay);
    }

    private void makePiedPage(int row, String comptes) {
        this.mCell.put("A" + row, "Compte : " + comptes);
        this.mCell.put("E" + row, "P\u00e9riode du " + dateFormatEcr.format(this.dateDu) + " au " + dateFormatEcr.format(this.dateAu));
    }

    private void makeSousTotal(int row, long debit, long credit) {
        this.mapStyleRow.put(new Integer(row), "Titre 1");
        this.mCell.put("A" + row, "");
        this.mCell.put("B" + row, "");
        this.mCell.put("C" + row, "");
        this.mCell.put("D" + row, "Sous total");
        this.mCell.put("E" + row, Double.valueOf(GestionDevise.currencyToString(debit, false)));
        this.mCell.put("F" + row, Double.valueOf(GestionDevise.currencyToString(credit, false)));
        this.mCell.put("G" + row, Double.valueOf(GestionDevise.currencyToString(debit - credit, false)));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void createMap() {
        d = new Date();
        this.mapReplace = new HashMap<K, V>();
        this.mCell = new HashMap<K, V>();
        this.mapStyleRow = new HashMap<K, V>();
        vals = new SQLRowValues(GrandLivreSheet.tableEcriture);
        vals.put("ID_COMPTE_PCE", null);
        vals.put("COMPTE_NUMERO", null);
        vals.put("COMPTE_NOM", null);
        vals.put("ID_JOURNAL", null);
        vals.put("JOURNAL_CODE", null);
        vals.putRowValues("ID_MOUVEMENT").put("NUMERO", null);
        vals.put("CREDIT", null);
        vals.put("DEBIT", null);
        vals.put("DATE", null);
        vals.put("NOM", null);
        lCompteSolde = this.excludeCompteSolde != false ? this.getListeCompteSolde() : null;
        mapCumul = this.getCumulsAnterieur(this.dateDu, lCompteSolde);
        fetcher = new SQLRowValuesListFetcher(vals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect sel) {
                Where w = new Where((FieldRef)tableEcriture.getField("DATE"), GrandLivreSheet.this.dateDu, (Object)GrandLivreSheet.this.dateAu);
                w = GrandLivreSheet.this.compteDeb.equals(GrandLivreSheet.this.compteEnd) ? w.and(new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), "=", (Object)GrandLivreSheet.this.compteDeb)) : w.and(new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), (Object)GrandLivreSheet.this.compteDeb, (Object)GrandLivreSheet.this.compteEnd));
                w = w.and(new Where((FieldRef)tableEcriture.getField("ID_JOURNAL"), "!=", GrandLivreSheet.this.idJrnlExclude));
                w = w.and(new Where((FieldRef)tableEcriture.getField("ID_MOUVEMENT"), "=", tableMvt.getField("ID")));
                if (GrandLivreSheet.this.lettrage == MODELETTREE) {
                    Object o = null;
                    w = w.and(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "<>", (Object)o));
                    w = w.and(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "!=", (Object)""));
                } else if (GrandLivreSheet.this.lettrage == MODENONLETTREE_PERIODE) {
                    Object o = null;
                    Where w2 = new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)o);
                    w = w.and(w2.or(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)"")));
                }
                if (GrandLivreSheet.this.excludeCompteSolde) {
                    System.err.println("Exclude compte");
                    w = w.and(new Where(tableEcriture.getField("ID_COMPTE_PCE"), lCompteSolde).not());
                }
                if (!UserManager.getInstance().getCurrentUser().getRights().haveRight(ComptaUserRight.ACCES_NOT_RESCTRICTED_TO_411)) {
                    w = w.and(new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), "LIKE", (Object)"411%"));
                }
                sel.setWhere(w);
                sel.addFieldOrder(tableEcriture.getField("COMPTE_NUMERO"));
                sel.addFieldOrder(tableEcriture.getField("DATE"));
                sel.addFieldOrder(tableMvt.getField("NUMERO"));
                System.err.println(sel.asString());
                return sel;
            }
        });
        list = fetcher.fetch();
        posLine = 1;
        firstLine = 1;
        this.size = list.size();
        System.err.println("START CREATE Grand livre, NB ecritures  " + this.size);
        this.nbPage = 0;
        totalDebit = 0L;
        totalCredit = 0L;
        sousTotalCredit = 0L;
        sousTotalDebit = 0L;
        totalCreditAntC = 0L;
        totalDebitAntC = 0L;
        totalCreditAntF = 0L;
        totalDebitAntF = 0L;
        rowFirstEcr = null;
        idCptFirstEcr = 1;
        setTitle = true;
        setLine = false;
        setCumuls = true;
        firstEcrCentC = true;
        firstEcrCentF = true;
        numCptFirstEcr = "411";
        numCptClient = "411";
        nomCptClient = "Clients";
        numCptFourn = "401";
        nomCptFourn = "Fournisseurs";
        idCptClient = ComptePCESQLElement.getId(numCptClient, nomCptClient);
        idCptFourn = ComptePCESQLElement.getId(numCptFourn, nomCptFourn);
        titre3 = "Titre 3";
        cumulAntString = "Cumuls ant\u00e9rieurs";
        j = 0;
        i = 0;
        while (i < this.size) {
            System.err.println("START NEW PAGE; POS : " + posLine);
            this.makeEntete(posLine);
            posLine += GrandLivreSheet.debutFill - 1;
            setTitle = true;
            setLine = false;
            doubleZero = Double.valueOf("0");
            j = 0;
            while (j < GrandLivreSheet.endFill - GrandLivreSheet.debutFill + 1 && i < this.size) {
                block22: {
                    block21: {
                        block20: {
                            rowEcr = list.get(i);
                            idCpt = rowEcr.getInt("ID_COMPTE_PCE");
                            nomCpt = rowEcr.getString("COMPTE_NOM");
                            numCpt = rowEcr.getString("COMPTE_NUMERO");
                            if (!setCumuls || !this.cumul || setTitle) break block20;
                            this.mapStyleRow.put(posLine, "Titre 3");
                            this.mCell.put("A" + posLine, "");
                            this.mCell.put("B" + posLine, "");
                            this.mCell.put("C" + posLine, "");
                            this.mCell.put("D" + posLine, "Cumuls ant\u00e9rieurs");
                            longSolde = mapCumul.get(idCpt);
                            if (longSolde == null) {
                                longSolde = 0L;
                            }
                            debitCumulAnt = 0L;
                            creditCumulAnt = 0L;
                            if (longSolde > 0L) {
                                debitCumulAnt = longSolde;
                            } else {
                                creditCumulAnt = -longSolde.longValue();
                            }
                            this.mCell.put("E" + posLine, debitCumulAnt == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(debitCumulAnt, false)));
                            this.mCell.put("F" + posLine, creditCumulAnt == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(creditCumulAnt, false)));
                            this.mCell.put("G" + posLine, longSolde == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(longSolde, false)));
                            totalCredit += creditCumulAnt;
                            totalDebit += debitCumulAnt;
                            sousTotalCredit += creditCumulAnt;
                            sousTotalDebit += debitCumulAnt;
                            setCumuls = false;
                            ** GOTO lbl219
                        }
                        if (!setTitle) break block21;
                        if (!setLine) {
                            this.mapStyleRow.put(new Integer(posLine), "Titre 1");
                            if (this.centralClient && nomCpt.startsWith("411")) {
                                nomCpt = nomCptClient;
                                numCpt = numCptClient;
                                idCpt = idCptClient;
                            }
                            if (this.centralFourn && nomCpt.startsWith("401")) {
                                nomCpt = nomCptFourn;
                                numCpt = numCptFourn;
                                idCpt = idCptFourn;
                            }
                            this.mCell.put("A" + posLine, numCpt);
                            this.mCell.put("B" + posLine, nomCpt);
                            this.mCell.put("C" + posLine, "");
                            this.mCell.put("D" + posLine, "");
                            this.mCell.put("E" + posLine, "");
                            this.mCell.put("F" + posLine, "");
                            this.mCell.put("G" + posLine, "");
                            setTitle = false;
                            setLine = true;
                            if (rowFirstEcr == null) {
                                rowFirstEcr = rowEcr;
                                idCptFirstEcr = rowEcr.getInt("ID_COMPTE_PCE");
                                numCptFirstEcr = rowEcr.getString("COMPTE_NUMERO");
                            }
                        } else {
                            this.mapStyleRow.put(new Integer(posLine), "Normal");
                            setLine = false;
                        }
                        ** GOTO lbl219
                    }
                    if (rowFirstEcr == null || idCptFirstEcr == idCpt || this.centralFourn && numCptFirstEcr.startsWith("401") && numCpt.startsWith("401") || this.centralClient && numCptFirstEcr.startsWith("411") && numCpt.startsWith("411")) break block22;
                    rowFirstEcr = rowEcr;
                    idCptFirstEcr = rowFirstEcr.getInt("ID_COMPTE_PCE");
                    numCptFirstEcr = rowEcr.getString("COMPTE_NUMERO");
                    this.makeSousTotal(posLine, sousTotalDebit, sousTotalCredit);
                    sousTotalCredit = 0L;
                    sousTotalDebit = 0L;
                    setTitle = true;
                    setCumuls = true;
                    ** GOTO lbl219
                }
                cred = rowEcr.getLong("CREDIT");
                deb = rowEcr.getLong("DEBIT");
                if (this.centralFourn && numCpt.startsWith("401")) {
                    ++i;
                    if (firstEcrCentF) {
                        this.mCell.put("D" + (++posLine - 1), "Centralisation des comptes fournisseurs");
                        this.mapStyleRow.put(new Integer(posLine - 1), "Normal");
                        firstEcrCentF = false;
                    } else {
                        --j;
                    }
                    sousTotalCredit += cred;
                    sousTotalDebit += deb;
                    solde = (totalDebitAntF += deb) - (totalCreditAntF += cred);
                    this.mCell.put("E" + (posLine - 1), totalDebitAntF == 0L ? doubleZero : new Double(GestionDevise.currencyToString(totalDebitAntF, false)));
                    this.mCell.put("F" + (posLine - 1), totalCreditAntF == 0L ? doubleZero : new Double(GestionDevise.currencyToString(totalCreditAntF, false)));
                    this.mCell.put("G" + (posLine - 1), solde == 0L ? doubleZero : new Double(GestionDevise.currencyToString(solde, false)));
                } else if (this.centralClient && numCpt.startsWith("411")) {
                    ++i;
                    if (firstEcrCentC) {
                        this.mCell.put("D" + (++posLine - 1), "Centralisation des comptes clients");
                        this.mapStyleRow.put(new Integer(posLine - 1), "Normal");
                        firstEcrCentC = false;
                    } else {
                        --j;
                    }
                    sousTotalCredit += cred;
                    sousTotalDebit += deb;
                    solde = (totalDebitAntC += deb) - (totalCreditAntC += cred);
                    this.mCell.put("E" + (posLine - 1), totalDebitAntC == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(totalDebitAntC, false)));
                    this.mCell.put("F" + (posLine - 1), totalCreditAntC == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(totalCreditAntC, false)));
                    this.mCell.put("G" + (posLine - 1), solde == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(solde, false)));
                } else {
                    this.mCell.put("A" + posLine, GrandLivreSheet.dateFormatEcr.format((Date)rowEcr.getObject("DATE")));
                    this.mCell.put("B" + posLine, rowEcr.getString("JOURNAL_CODE"));
                    this.mCell.put("C" + posLine, rowEcr.getForeign("ID_MOUVEMENT").getObject("NUMERO"));
                    this.mCell.put("D" + posLine, rowEcr.getObject("NOM"));
                    totalCredit += cred;
                    totalDebit += deb;
                    solde = (sousTotalDebit += deb) - (sousTotalCredit += cred);
                    this.mCell.put("E" + posLine, deb == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(deb, false)));
                    this.mCell.put("F" + posLine, cred == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(cred, false)));
                    this.mCell.put("G" + posLine, solde == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(solde, false)));
                    this.mapStyleRow.put(posLine, "Normal");
                    ++i;
lbl219:
                    // 5 sources

                    ++posLine;
                }
                ++j;
            }
            if (i >= this.size && j < GrandLivreSheet.endFill - GrandLivreSheet.debutFill + 1) {
                this.makeSousTotal(posLine, sousTotalDebit, sousTotalCredit);
            }
            posLine = firstLine + GrandLivreSheet.endFill;
            this.mCell.put("E" + posLine, totalDebit == 0L ? doubleZero : new Double(GestionDevise.currencyToString(totalDebit, false)));
            this.mCell.put("F" + posLine, totalCredit == 0L ? doubleZero : new Double(GestionDevise.currencyToString(totalCredit, false)));
            this.mCell.put("G" + posLine, totalDebit - totalCredit == 0L ? doubleZero : new Double(GestionDevise.currencyToString(totalDebit - totalCredit, false)));
            this.makePiedPage(posLine += 2, String.valueOf(this.compteDeb) + " \u00e0 " + this.compteEnd);
            firstLine = ++posLine;
            ++this.nbPage;
            if (i < this.size || j < GrandLivreSheet.endFill - GrandLivreSheet.debutFill + 1) continue;
            this.makeEntete(posLine);
            this.makeSousTotal(posLine += GrandLivreSheet.debutFill - 1, sousTotalDebit, sousTotalCredit);
            ++this.nbPage;
        }
        if (this.nbPage > 0) {
            --this.nbPage;
        }
        end = new Date();
        System.err.println("///////// TAKE " + (end.getTime() - d.getTime()) + " millisecondes TO CREATE MAP");
    }

    private List<Integer> getListeCompteSolde() {
        Object o;
        SQLSelect sel = new SQLSelect(base);
        sel.addSelect(tableCompte.getField("ID"));
        sel.addSelect(tableEcriture.getField("DEBIT"), "SUM");
        sel.addSelect(tableEcriture.getField("CREDIT"), "SUM");
        Where w = this.compteDeb.equals(this.compteEnd) ? new Where((FieldRef)tableCompte.getField("NUMERO"), "=", (Object)this.compteDeb) : new Where((FieldRef)tableCompte.getField("NUMERO"), (Object)this.compteDeb, (Object)this.compteEnd);
        w = w.and(new Where((FieldRef)tableEcriture.getField("ID_COMPTE_PCE"), "=", tableCompte.getField("ID")));
        w = this.cumul ? w.and(new Where((FieldRef)tableEcriture.getField("DATE"), "<=", (Object)this.dateAu)) : w.and(new Where((FieldRef)tableEcriture.getField("DATE"), this.dateDu, (Object)this.dateAu));
        w = w.and(new Where((FieldRef)tableEcriture.getField("ID_JOURNAL"), "!=", this.idJrnlExclude));
        if (this.lettrage == MODELETTREE) {
            o = null;
            w = w.and(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "<>", (Object)o));
            w = w.and(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "!=", (Object)""));
        } else if (this.lettrage == MODENONLETTREE_PERIODE) {
            o = null;
            Where w2 = new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)o);
            w = w.and(w2.or(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)"")));
        }
        sel.setWhere(w);
        String req = String.valueOf(sel.asString()) + " GROUP BY \"COMPTE_PCE\".\"ID\"";
        System.err.println(req);
        List l = (List)base.getDataSource().execute(req, new ArrayListHandler());
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object[] o2 : l) {
            long credit = 0L;
            if (o2[2] != null) {
                credit = Long.valueOf(o2[2].toString());
            }
            long debit = 0L;
            if (o2[1] != null) {
                debit = Long.valueOf(o2[1].toString());
            }
            int id = Integer.valueOf(o2[0].toString());
            long solde = debit - credit;
            if (solde != 0L) continue;
            list.add(id);
        }
        return list;
    }

    private Map<Integer, Long> getCumulsAnterieur(Date d, List<Integer> listCompteSolde) {
        Object o;
        SQLSelect sel = new SQLSelect(base);
        sel.addSelect(tableEcriture.getField("ID_COMPTE_PCE"));
        sel.addSelect(tableEcriture.getField("DEBIT"), "SUM");
        sel.addSelect(tableEcriture.getField("CREDIT"), "SUM");
        sel.addSelect(tableEcriture.getField("COMPTE_NUMERO"));
        Where w = new Where((FieldRef)tableEcriture.getField("DATE"), "<", (Object)d);
        w = w.and(new Where((FieldRef)tableEcriture.getField("ID_MOUVEMENT"), "=", tableMvt.getKey()));
        w = this.compteDeb.equals(this.compteEnd) ? w.and(new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), "=", (Object)this.compteDeb)) : w.and(new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), (Object)this.compteDeb, (Object)this.compteEnd));
        if (this.lettrage == MODELETTREE) {
            o = null;
            w = w.and(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "<>", (Object)o));
            w = w.and(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "!=", (Object)""));
        } else if (this.lettrage == MODENONLETTREE_PERIODE) {
            o = null;
            Where w2 = new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)o);
            w = w.and(w2.or(new Where((FieldRef)tableEcriture.getField("LETTRAGE"), "=", (Object)"")));
        }
        w = w.and(new Where((FieldRef)tableEcriture.getField("ID_COMPTE_PCE"), "=", tableCompte.getField("ID")));
        w = w.and(new Where((FieldRef)tableEcriture.getField("ID_JOURNAL"), "!=", this.idJrnlExclude));
        if (listCompteSolde != null) {
            w = w.and(new Where(tableEcriture.getField("ID_COMPTE_PCE"), listCompteSolde).not());
        }
        sel.setWhere(w);
        String req = String.valueOf(sel.asString()) + " GROUP BY \"ECRITURE\".\"ID_COMPTE_PCE\", \"ECRITURE\".\"COMPTE_NUMERO\"";
        System.err.println(req);
        List l = (List)base.getDataSource().execute(req, new ArrayListHandler());
        HashMap<Integer, Long> map = new HashMap<Integer, Long>();
        int idCptFourn = ComptePCESQLElement.getId("401", "Fournisseurs");
        int idCptClient = ComptePCESQLElement.getId("411", "Clients");
        for (Object[] o2 : l) {
            Long lS;
            long credit = 0L;
            if (o2[2] != null) {
                credit = Long.valueOf(o2[2].toString());
            }
            long debit = 0L;
            if (o2[1] != null) {
                debit = Long.valueOf(o2[1].toString());
            }
            int id = Integer.valueOf(o2[0].toString());
            long solde = debit - credit;
            map.put(id, solde);
            if (o2[3] == null) continue;
            String numero = o2[3].toString();
            if (this.centralFourn && numero.startsWith("401")) {
                lS = (Long)map.get(idCptFourn);
                lS = lS != null ? Long.valueOf(lS + solde) : new Long(solde);
                map.put(idCptFourn, lS);
            }
            if (!this.centralClient || !numero.startsWith("411")) continue;
            lS = (Long)map.get(idCptClient);
            lS = lS != null ? Long.valueOf(lS + solde) : new Long(solde);
            map.put(idCptClient, lS);
        }
        return map;
    }

    @Override
    public String getTemplateId() {
        return TEMPLATE_ID;
    }

    public int getSize() {
        return this.size;
    }
}

