/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class EtatChargeModel
extends AbstractTableModel {
    private Map mapCot = new HashMap();
    private List listRubCaisse;
    private float cotSal;
    private float cotPat;
    private int moisDe;
    private int moisAu;
    private int annee;
    private int idCaisse;
    private static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private static final SQLTable tableFichePaye = base.getTable("FICHE_PAYE");
    private static final SQLTable tableFichePayeElt = base.getTable("FICHE_PAYE_ELEMENT");
    private static final SQLTable tableRubCot = Configuration.getInstance().getBase().getTable("RUBRIQUE_COTISATION");
    private String[] titres;

    public EtatChargeModel(int moisDe, int moisAu, int annee, int idCaisse) {
        this.annee = annee;
        this.moisDe = moisDe;
        this.moisAu = moisAu;
        this.idCaisse = idCaisse;
        this.fill();
        this.titres = new String[7];
        this.titres[0] = "Nom";
        this.titres[1] = "Base";
        this.titres[2] = "Taux Sal.";
        this.titres[3] = "Montant Sal. Ded.";
        this.titres[4] = "Taux Pat.";
        this.titres[5] = "Montant Pat.";
        this.titres[6] = "Total";
    }

    private void fill() {
        new SwingWorker<String, Object>(){

            @Override
            protected String doInBackground() throws Exception {
                if (EtatChargeModel.this.listRubCaisse == null) {
                    EtatChargeModel.this.fillMapCaisse();
                }
                EtatChargeModel.this.mapCot = new HashMap();
                EtatChargeModel.this.cotSal = 0.0f;
                EtatChargeModel.this.cotPat = 0.0f;
                SQLSelect selElt = new SQLSelect(base);
                selElt.addSelect(tableFichePayeElt.getField("SOURCE"));
                selElt.addSelect(tableFichePayeElt.getField("IDSOURCE"));
                selElt.addSelect(tableFichePayeElt.getField("NOM"));
                selElt.addSelect(tableFichePayeElt.getField("NB_BASE"));
                selElt.addSelect(tableFichePayeElt.getField("TAUX_SAL"));
                selElt.addSelect(tableFichePayeElt.getField("MONTANT_SAL_AJ"));
                selElt.addSelect(tableFichePayeElt.getField("MONTANT_SAL_DED"));
                selElt.addSelect(tableFichePayeElt.getField("TAUX_PAT"));
                selElt.addSelect(tableFichePayeElt.getField("MONTANT_PAT"));
                Where w = new Where((FieldRef)tableFichePaye.getField("VALIDE"), "=", (Object)Boolean.TRUE);
                Where w2 = new Where((FieldRef)tableFichePaye.getField("ANNEE"), "=", EtatChargeModel.this.annee);
                Where w3 = new Where((FieldRef)tableFichePaye.getField("ID_MOIS"), new Integer(EtatChargeModel.this.moisDe), (Object)new Integer(EtatChargeModel.this.moisAu));
                Where w4 = new Where((FieldRef)tableFichePayeElt.getField("ID_FICHE_PAYE"), "=", tableFichePaye.getField("ID"));
                Where w5 = new Where((FieldRef)tableFichePayeElt.getField("SOURCE"), "=", (Object)tableRubCot.getName());
                selElt.setWhere(w.and(w2).and(w3).and(w4).and(w5));
                String req = selElt.asString();
                System.err.println(req);
                List listFicheElt = (List)base.getDataSource().execute(req.toString(), new ArrayListHandler());
                for (Object[] tmp : listFicheElt) {
                    SQLRowValues rowVals = null;
                    if (EtatChargeModel.this.mapCot.get(new Integer(tmp[1].toString())) == null && EtatChargeModel.this.listRubCaisse.contains(tmp[1])) {
                        rowVals = new SQLRowValues(tableFichePayeElt);
                        rowVals.put("NOM", tmp[2] == null ? "" : tmp[2].toString());
                        rowVals.put("IDSOURCE", tmp[1] == null ? 0 : Integer.parseInt(tmp[1].toString()));
                        rowVals.put("TAUX_SAL", tmp[4] == null ? BigDecimal.ZERO : tmp[4]);
                        rowVals.put("TAUX_PAT", tmp[7] == null ? BigDecimal.ZERO : tmp[7]);
                        EtatChargeModel.this.mapCot.put(new Integer(tmp[1].toString()), rowVals);
                    } else {
                        rowVals = (SQLRowValues)EtatChargeModel.this.mapCot.get(new Integer(tmp[1].toString()));
                    }
                    if (rowVals == null) continue;
                    BigDecimal base = BigDecimal.ZERO;
                    if (rowVals.getObject("NB_BASE") != null) {
                        base = rowVals.getBigDecimal("NB_BASE");
                    }
                    base = base.add(tmp[3] == null ? BigDecimal.ZERO : (BigDecimal)tmp[3]);
                    rowVals.put("NB_BASE", base);
                    BigDecimal montantSal = rowVals.getObject("MONTANT_SAL_AJ") == null ? BigDecimal.ZERO : rowVals.getBigDecimal("MONTANT_SAL_AJ");
                    montantSal = montantSal.add(tmp[5] == null ? BigDecimal.ZERO : (BigDecimal)tmp[5]);
                    rowVals.put("MONTANT_SAL_AJ", montantSal);
                    BigDecimal montantSalDed = rowVals.getObject("MONTANT_SAL_DED") == null ? BigDecimal.ZERO : rowVals.getBigDecimal("MONTANT_SAL_DED");
                    montantSalDed = montantSalDed.add(tmp[6] == null ? BigDecimal.ZERO : (BigDecimal)tmp[6]);
                    rowVals.put("MONTANT_SAL_DED", montantSalDed);
                    BigDecimal montantPat = rowVals.getObject("MONTANT_PAT") == null ? BigDecimal.ZERO : rowVals.getBigDecimal("MONTANT_PAT");
                    montantPat = montantPat.add(tmp[8] == null ? BigDecimal.ZERO : (BigDecimal)tmp[8]);
                    rowVals.put("MONTANT_PAT", montantPat);
                    EtatChargeModel etatChargeModel = EtatChargeModel.this;
                    etatChargeModel.cotPat = etatChargeModel.cotPat + (tmp[8] == null ? 0.0f : new Float(tmp[8].toString()).floatValue());
                    EtatChargeModel etatChargeModel2 = EtatChargeModel.this;
                    etatChargeModel2.cotSal = etatChargeModel2.cotSal + (tmp[6] == null ? 0.0f : new Float(tmp[6].toString()).floatValue());
                }
                return null;
            }

            @Override
            protected void done() {
                EtatChargeModel.this.fireTableDataChanged();
            }
        }.execute();
    }

    private void fillMapCaisse() {
        SQLSelect selElt = new SQLSelect(Configuration.getInstance().getBase());
        selElt.addSelect(tableRubCot.getField("ID"));
        selElt.setWhere(new Where((FieldRef)tableRubCot.getField("ID_CAISSE_COTISATION"), "=", this.idCaisse));
        List l = Configuration.getInstance().getBase().getDataSource().executeA(selElt.asString());
        if (l != null) {
            this.listRubCaisse = new ArrayList(l.size());
            int i = 0;
            while (i < l.size()) {
                Object o = ((Object[])l.get(i))[0];
                this.listRubCaisse.add(((Number)o).intValue());
                ++i;
            }
        } else {
            this.listRubCaisse = new ArrayList();
        }
    }

    @Override
    public int getColumnCount() {
        return this.titres.length;
    }

    @Override
    public int getRowCount() {
        return this.mapCot.keySet().size();
    }

    @Override
    public String getColumnName(int column) {
        return this.titres[column];
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        return Float.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SQLRowValues rowVals = (SQLRowValues)this.mapCot.get(this.mapCot.keySet().toArray()[rowIndex]);
        if (rowVals != null) {
            if (columnIndex == 0) {
                return rowVals.getObject("NOM");
            }
            if (columnIndex == 1) {
                return rowVals.getObject("NB_BASE");
            }
            if (columnIndex == 2) {
                return rowVals.getObject("TAUX_SAL");
            }
            if (columnIndex == 3) {
                return rowVals.getObject("MONTANT_SAL_DED");
            }
            if (columnIndex == 4) {
                return rowVals.getObject("TAUX_PAT");
            }
            if (columnIndex == 5) {
                return rowVals.getObject("MONTANT_PAT");
            }
            if (columnIndex == 6) {
                return new Float(rowVals.getBigDecimal("MONTANT_PAT").floatValue() + rowVals.getBigDecimal("MONTANT_SAL_DED").floatValue());
            }
        }
        return null;
    }

    public void reload(int moisDe, int moisAu, int annee) {
        this.moisDe = moisDe;
        this.moisAu = moisAu;
        this.annee = annee;
        this.fill();
        this.fireTableDataChanged();
    }

    public float getTotalCotisationSal() {
        return this.cotSal;
    }

    public float getTotalCotisationPat() {
        return this.cotPat;
    }
}

