/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.element;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JTextField;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.utils.CollectionUtils;

public class AssociationAnalytiqueSQLElement
extends ComptaSQLConfElement {
    public AssociationAnalytiqueSQLElement() {
        super("ASSOCIATION_ANALYTIQUE", "une association analytique", "associations analytiques");
    }

    @Override
    protected void ffInited() {
        super.ffInited();
        this.setAction("ID_ECRITURE", SQLElement.ReferenceAction.CASCADE);
        this.setAction("ID_SAISIE_KM_ELEMENT", SQLElement.ReferenceAction.CASCADE);
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("ID_ECRITURE");
        list.add("ID_POSTE_ANALYTIQUE");
        return list;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("ID_ECRITURE");
        list.add("ID_POSTE_ANALYTIQUE");
        return list;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){

            @Override
            public void addViews() {
                this.addRequiredSQLObject(new JTextField(), "ID_ECRITURE");
                this.addRequiredSQLObject(new JTextField(), "ID_POSTE_ANALYTIQUE");
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".analytic.relation";
    }

    @Override
    protected SQLTableModelSourceOnline createTableSource() {
        SQLTableModelSourceOnline table = super.createTableSource();
        BaseSQLTableModelColumn debit = new BaseSQLTableModelColumn("D\u00e9bit", BigDecimal.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                long montant = r.getLong("MONTANT");
                if (montant > 0L) {
                    return new BigDecimal(montant).movePointLeft(2);
                }
                return BigDecimal.ZERO;
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(AssociationAnalytiqueSQLElement.this.getTable());
                return CollectionUtils.createSet(new FieldPath(p, "MONTANT"));
            }
        };
        table.getColumns().add(debit);
        BaseSQLTableModelColumn credit = new BaseSQLTableModelColumn("Cr\u00e9dit", BigDecimal.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                long montant = r.getLong("MONTANT");
                if (montant < 0L) {
                    return new BigDecimal(-montant).movePointLeft(2);
                }
                return BigDecimal.ZERO;
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(AssociationAnalytiqueSQLElement.this.getTable());
                return CollectionUtils.createSet(new FieldPath(p, "MONTANT"));
            }
        };
        table.getColumns().add(credit);
        return table;
    }
}

