/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import interpreterDJava.JavaEditor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.interpreter.InterpreterException;
import koala.dynamicjava.interpreter.TreeInterpreter;
import koala.dynamicjava.parser.wrapper.JavaCCParserFactory;
import koala.dynamicjava.parser.wrapper.ParserFactory;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.checks.ValidChangeSupport;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class SQLJavaEditor
extends JavaEditor
implements ValueWrapper<String> {
    private final List<Object> mVar = new ArrayList<Object>();
    private Map<String, SQLField> mapField = new HashMap<String, SQLField>();
    private Map<String, SQLRow> mapRow = new HashMap<String, SQLRow>();
    private int salarieID = 1;
    private final PropertyChangeSupport supp;
    private final ValidChangeSupport validSupp;

    public SQLJavaEditor(Map<String, List<?>> m) {
        for (String s : m.keySet()) {
            List<?> element = m.get(s);
            for (Object o : element) {
                String name;
                if (o instanceof SQLRow) {
                    SQLRow element2 = (SQLRow)o;
                    name = element2.getString("NOM").trim();
                    this.addNewLitteral(name);
                    this.mVar.add(o);
                    this.mapRow.put(name, element2);
                    continue;
                }
                if (!(o instanceof SQLField)) continue;
                SQLField field2 = (SQLField)o;
                name = field2.getTable().getName();
                this.addNewLitteral(name);
                this.mVar.add(o);
                this.mapField.put(name, field2);
            }
        }
        this.supp = new PropertyChangeSupport(this);
        this.validSupp = new ValidChangeSupport(this);
        this.textFormule.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                SQLJavaEditor.this.checkFormule(SQLJavaEditor.this.textFormule.getText().trim(), SQLJavaEditor.this.varAssign);
                SQLJavaEditor.this.supp.firePropertyChange("value", null, null);
            }
        });
    }

    @Override
    public void setValue(String val) {
        this.setText(val);
    }

    @Override
    public void resetValue() {
        this.setValue("");
    }

    @Override
    public String getValue() {
        return this.getText();
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    @Override
    public ValidState getValidState() {
        return ValidState.createCached(this.isCodeValid(), "la formule n'est pas valide");
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.validSupp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.validSupp.removeValidListener(l);
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    public Object checkFormule(String formule, String varCallName) {
        File f;
        BufferedReader bR;
        HashMap<String, SQLRow> mapCacheRow;
        block19: {
            mapCacheRow = new HashMap<String, SQLRow>();
            bR = null;
            f = null;
            if (formule.trim().length() != 0) break block19;
            this.status.setText("Code correct");
            this.setCodeValid(true);
            return null;
        }
        try {
            File dParent = new File(Configuration.getDefaultConfDir(), "Interpreter");
            dParent.mkdir();
            f = new File(dParent, "CalculVariable" + varCallName + ".txt");
            TreeInterpreter interpreter = new TreeInterpreter((ParserFactory)new JavaCCParserFactory());
            SQLTable tableSal = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("SALARIE");
            SQLRow rowSal = tableSal.getRow(this.salarieID);
            BufferedWriter bW = new BufferedWriter(new FileWriter(f));
            Set<SQLRow> set = rowSal.getForeignRows();
            for (SQLRow row : set) {
                mapCacheRow.put(row.getTable().getName(), row);
                Set<SQLRow> set2 = row.getForeignRows();
                for (SQLRow row2 : set2) {
                    mapCacheRow.put(row2.getTable().getName(), row2);
                }
            }
            for (Object o : this.mVar) {
                Object ob;
                SQLRow rowTmp;
                if (o instanceof SQLField) {
                    SQLField field = (SQLField)o;
                    if (formule.indexOf(field.getName()) < 0) continue;
                    SQLRow rowAssoc = (SQLRow)mapCacheRow.get(field.getTable().getName());
                    Set<SQLRow> foreignRows = null;
                    if (rowAssoc == null) {
                        foreignRows = rowSal.getForeignRows(field.getTable().getName());
                    }
                    if (rowAssoc != null || rowSal != null && foreignRows != null) {
                        Set<SQLRow> rowList;
                        if (rowAssoc == null && (rowList = foreignRows).size() != 0) {
                            Iterator<SQLRow> iterList = rowList.iterator();
                            rowAssoc = iterList.next();
                            mapCacheRow.put(rowAssoc.getTable().getName(), rowAssoc);
                        }
                        if (rowAssoc != null) {
                            this.defineVariable((Interpreter)interpreter, bW, field.getName(), rowAssoc.getObject(field.getName()));
                            continue;
                        }
                        this.defineVariable((Interpreter)interpreter, bW, field.getName(), null);
                        continue;
                    }
                    this.defineVariable((Interpreter)interpreter, bW, field.getName(), null);
                    continue;
                }
                if (!(o instanceof SQLRow) || formule.indexOf((rowTmp = (SQLRow)o).getString("NOM")) < 0) continue;
                if (rowTmp.getString("FORMULE").trim().length() == 0) {
                    this.defineVariable((Interpreter)interpreter, bW, rowTmp.getString("NOM"), rowTmp.getObject("VALEUR"));
                    continue;
                }
                if (rowTmp.getString("NOM").equalsIgnoreCase(varCallName) || (ob = this.checkFormule(rowTmp.getString("FORMULE"), rowTmp.getString("NOM"))) == null) continue;
                this.defineVariable((Interpreter)interpreter, bW, rowTmp.getString("NOM"), ob);
            }
            bW.write(formule);
            bW.flush();
            bW.close();
            bR = new BufferedReader(new FileReader(f));
            Object interpreterResult = interpreter.interpret((Reader)bR, f.getAbsolutePath());
            bR.close();
            try {
                this.status.setText("Code correct, valeur de retour = " + interpreter.getVariable(varCallName).toString());
                this.setCodeValid(true);
                return interpreter.getVariable(varCallName);
            }
            catch (IllegalStateException iSE) {
                if (interpreterResult != null) {
                    this.status.setText("Code correct, valeur de retour = " + interpreterResult.toString());
                    this.setCodeValid(true);
                    bR.close();
                    return interpreterResult;
                }
                this.status.setText("Aucune valeur de retour");
                this.setCodeValid(false);
                return null;
            }
        }
        catch (Exception e) {
            if (e instanceof InterpreterException) {
                int in;
                String m = "";
                InterpreterException ex = (InterpreterException)e;
                System.out.println(ex.getMessage());
                if (ex.getSourceInformation() != null) {
                    m = String.valueOf(m) + " ligne:" + ex.getSourceInformation().getLine();
                }
                if ((in = (m = String.valueOf(m) + ex.getMessage()).indexOf(10)) > 0) {
                    m = m.substring(0, in);
                }
                this.setCodeValid(false);
                this.status.setText(m);
            } else {
                this.setCodeValid(false);
                System.err.println("err-----");
                e.printStackTrace();
            }
            this.setCodeValid(false);
            return null;
        }
    }

    protected void setCodeValid(boolean codeValid) {
        super.setCodeValid(codeValid);
        this.validSupp.fireValidChange(this.getValidState());
    }

    public void setSalarieID(int id) {
        this.salarieID = id;
        this.checkFormule(this.textFormule.getText().trim(), this.varAssign);
    }
}

