/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.text.NumberFormatter;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.RowValuesTableModel;

public class QteCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    JFormattedTextField component;
    SQLRowValues rowVals = null;

    public QteCellEditor() {
        NumberFormatter nf = new NumberFormatter(NumberFormat.getIntegerInstance()){

            @Override
            public String valueToString(Object iv) throws ParseException {
                if (iv == null || (Integer)iv == -1) {
                    return "";
                }
                return super.valueToString(iv);
            }

            @Override
            public Object stringToValue(String text) throws ParseException {
                if (text == null || text.trim().isEmpty()) {
                    return null;
                }
                return super.stringToValue(text);
            }
        };
        nf.setMinimum(Integer.valueOf(0));
        nf.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
        nf.setValueClass(Integer.class);
        this.component = new JFormattedTextField(nf);
        this.component.setBorder(new LineBorder(Color.black));
        this.component.setText("");
        this.component.setHorizontalAlignment(4);
        this.component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3 && QteCellEditor.this.rowVals != null && QteCellEditor.this.rowVals.getTable().getFieldsName().contains("QTE_ACHAT")) {
                    try {
                        QteCellEditor.this.component.commitEdit();
                    }
                    catch (ParseException exn) {
                        exn.printStackTrace();
                    }
                    if (QteCellEditor.this.component.getValue() != null && QteCellEditor.this.rowVals.getInt("QTE_ACHAT") > 1) {
                        JPopupMenu menuDroit = new JPopupMenu();
                        menuDroit.add(new AbstractAction("Arrondir (multiple de " + QteCellEditor.this.rowVals.getInt("QTE_ACHAT") + ")"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Integer i = (Integer)(this).QteCellEditor.this.component.getValue();
                                double a = (double)i.intValue() / (double)(this).QteCellEditor.this.rowVals.getInt("QTE_ACHAT");
                                double ceil = Math.ceil(a);
                                double d = ceil * (double)(this).QteCellEditor.this.rowVals.getInt("QTE_ACHAT");
                                int value = (int)d;
                                (this).QteCellEditor.this.component.setValue(value);
                            }
                        });
                        menuDroit.pack();
                        menuDroit.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
                        menuDroit.setVisible(true);
                    }
                }
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
        this.rowVals = ((RowValuesTableModel)table.getModel()).getRowValuesAt(rowIndex);
        if (value != null) {
            this.component.setText(value.toString());
        } else {
            this.component.setText("");
        }
        return this.component;
    }

    @Override
    public Object getCellEditorValue() {
        try {
            this.component.commitEdit();
        }
        catch (ParseException exn) {
            exn.printStackTrace();
        }
        return this.component.getValue();
    }
}

