/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.DeviseTableCellRenderer;
import org.openconcerto.erp.core.common.ui.NiveauTableCellEditor;
import org.openconcerto.erp.core.common.ui.NiveauTableCellRender;
import org.openconcerto.erp.core.finance.accounting.model.CurrencyConverter;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.ui.CurrencyWithSymbolRenderer;
import org.openconcerto.erp.core.sales.product.ui.QteUnitRowValuesRenderer;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.sqlobject.ITextArticleWithCompletionCellEditor;
import org.openconcerto.sql.view.list.AutoCompletionManager;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.sql.view.list.ValidStateChecker;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.i18n.TranslationManager;

public abstract class AbstractAchatArticleItemTable
extends AbstractArticleItemTable {
    private AutoCompletionManager m;
    private AutoCompletionManager m2;
    private AutoCompletionManager m3;
    private AutoCompletionManager m4;
    private final SQLTable tableArticle = this.getSQLElement().getTable().getTable("ARTICLE");
    private SQLRowAccessor rowDevise;
    private boolean supplierCode;
    private static Map<String, Boolean> visibilityMap = new HashMap<String, Boolean>();
    private String incoterm = "";
    private SQLRow rowFournisseur = null;
    private BigDecimal tauxConversion = null;

    @Override
    protected void setModel(RowValuesTableModel model) {
        super.setModel(model);
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                AbstractAchatArticleItemTable.this.calculTarifNomenclature();
            }
        });
    }

    @Override
    protected void init() {
        SQLElement e = this.getSQLElement();
        final SQLPreferences prefs = SQLPreferences.getMemCached(this.getSQLElement().getTable().getDBRoot());
        boolean selectArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.USE_CREATED_ARTICLE, false);
        boolean createAuto = prefs.getBoolean(GestionArticleGlobalPreferencePanel.CREATE_ARTICLE_AUTO, true);
        this.supplierCode = prefs.getBoolean(GestionArticleGlobalPreferencePanel.SUPPLIER_PRODUCT_CODE, false);
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTableElement eNiveau = new SQLTableElement(e.getTable().getField("NIVEAU")){

            @Override
            public void setValueFrom(SQLRowValues row, Object value) {
                super.setValueFrom(row, value);
            }
        };
        eNiveau.setRenderer(new NiveauTableCellRender());
        eNiveau.setEditor(new NiveauTableCellEditor());
        list.add(eNiveau);
        list.add(new SQLTableElement(e.getTable().getField("ID_STYLE")));
        SQLTableElement tableElementCodeFournisseur = null;
        if (e.getTable().contains("ID_CODE_FOURNISSEUR") && this.supplierCode) {
            tableElementCodeFournisseur = new SQLTableElement(e.getTable().getField("ID_CODE_FOURNISSEUR"), true, true, true);
            list.add(tableElementCodeFournisseur);
        }
        SQLTableElement tableElementArticle = new SQLTableElement(e.getTable().getField("ID_ARTICLE"), true, true, true);
        list.add(tableElementArticle);
        if (e.getTable().getFieldsName().contains("ID_FAMILLE_ARTICLE")) {
            SQLTableElement tableFamille = new SQLTableElement(e.getTable().getField("ID_FAMILLE_ARTICLE"));
            list.add(tableFamille);
        }
        if (e.getTable().getFieldsName().contains("INCOTERM")) {
            SQLTableElement tableElementInco = new SQLTableElement(e.getTable().getField("INCOTERM"));
            tableElementInco.setEditable(false);
            list.add(tableElementInco);
        }
        if (e.getTable().getFieldsName().contains("PREBILAN")) {
            SQLTableElement tableElementPre = new SQLTableElement(e.getTable().getField("PREBILAN"), BigDecimal.class);
            tableElementPre.setRenderer(new DeviseTableCellRenderer());
            list.add(tableElementPre);
        }
        SQLTableElement tableElementCode = new SQLTableElement(e.getTable().getField("CODE"), String.class, new ITextArticleWithCompletionCellEditor(e.getTable().getTable("ARTICLE"), e.getTable().getTable("ARTICLE_FOURNISSEUR")));
        list.add(tableElementCode);
        SQLTableElement tableElementNom = new SQLTableElement(e.getTable().getField("NOM"));
        list.add(tableElementNom);
        if (e.getTable().getFieldsName().contains("DESCRIPTIF")) {
            SQLTableElement tableElementDesc = new SQLTableElement(e.getTable().getField("DESCRIPTIF"));
            list.add(tableElementDesc);
        }
        if (e.getTable().getFieldsName().contains("COLORIS")) {
            SQLTableElement tableElementColoris = new SQLTableElement(e.getTable().getField("COLORIS"));
            list.add(tableElementColoris);
        }
        SQLTableElement tableElement_ValeurMetrique2 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_2"), Float.class);
        list.add(tableElement_ValeurMetrique2);
        SQLTableElement tableElement_ValeurMetrique3 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_3"), Float.class);
        list.add(tableElement_ValeurMetrique3);
        SQLTableElement tableElement_ValeurMetrique1 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_1"), Float.class);
        list.add(tableElement_ValeurMetrique1);
        SQLTableElement tableElement_PrixMetrique1_AchatHT = new SQLTableElement(e.getTable().getField("PRIX_METRIQUE_HA_1"), BigDecimal.class);
        tableElement_PrixMetrique1_AchatHT.setRenderer(new CurrencyWithSymbolRenderer());
        list.add(tableElement_PrixMetrique1_AchatHT);
        SQLTableElement tableElement_Devise = new SQLTableElement(e.getTable().getField("ID_DEVISE"));
        tableElement_Devise.setEditable(false);
        SQLTableElement tableElement_PA_Devise = new SQLTableElement(e.getTable().getField("PA_DEVISE"), BigDecimal.class);
        Path p = (Path)new Path(this.getSQLElement().getTable()).addForeignField("ID_DEVISE");
        tableElement_PA_Devise.setRenderer(new CurrencyWithSymbolRenderer(new FieldPath(p, "CODE")));
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            list.add(tableElement_Devise);
            list.add(tableElement_PA_Devise);
        }
        SQLTableElement tableElement_ModeVente = new SQLTableElement(e.getTable().getField("ID_MODE_VENTE_ARTICLE"));
        list.add(tableElement_ModeVente);
        this.ha = new SQLTableElement(e.getTable().getField("PA_HT"), BigDecimal.class);
        this.ha.setRenderer(new CurrencyWithSymbolRenderer());
        list.add(this.ha);
        SQLTableElement qteU = new SQLTableElement(e.getTable().getField("QTE_UNITAIRE"), BigDecimal.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                SQLRowAccessor row = vals.getForeign("ID_UNITE_VENTE");
                if (row != null && !row.isUndefined() && row.getBoolean("A_LA_PIECE").booleanValue()) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new QteUnitRowValuesRenderer();
            }

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }
        };
        list.add(qteU);
        SQLTableElement uniteVente = new SQLTableElement(e.getTable().getField("ID_UNITE_VENTE"));
        list.add(uniteVente);
        SQLTableElement qteElement = new SQLTableElement(e.getTable().getField("QTE"), Integer.class){

            @Override
            protected Object getDefaultNullValue() {
                return 0;
            }
        };
        list.add(qteElement);
        this.tableElementTVA = new SQLTableElement(e.getTable().getField("ID_TAXE"));
        list.add(this.tableElementTVA);
        SQLTableElement tableElementPoids = new SQLTableElement(e.getTable().getField("POIDS"), Float.class);
        list.add(tableElementPoids);
        this.tableElementPoidsTotal = new SQLTableElement(e.getTable().getField("T_POIDS"), Float.class);
        list.add(this.tableElementPoidsTotal);
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean b = Boolean.valueOf(val);
        if (b != null && b.booleanValue()) {
            this.service = new SQLTableElement(e.getTable().getField("SERVICE"), Boolean.class);
            list.add(this.service);
        }
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            this.tableElementTotalDevise = new SQLTableElement(e.getTable().getField("PA_DEVISE_T"), BigDecimal.class);
            this.tableElementTotalDevise.setRenderer(new CurrencyWithSymbolRenderer(new FieldPath(p, "CODE")));
            list.add(this.tableElementTotalDevise);
        }
        SQLTableElement tableElementRemise = null;
        if (e.getTable().contains("POURCENT_REMISE")) {
            tableElementRemise = new SQLTableElement(e.getTable().getField("POURCENT_REMISE"));
            list.add(tableElementRemise);
        }
        this.totalHT = new SQLTableElement(e.getTable().getField("T_PA_HT"), BigDecimal.class);
        this.totalHT.setRenderer(new DeviseTableCellRenderer());
        this.totalHT.setEditable(false);
        if (e.getTable().contains("POURCENT_REMISE") && tableElementRemise != null) {
            tableElementRemise.addModificationListener(this.totalHT);
        }
        list.add(this.totalHT);
        this.totalHA = this.totalHT;
        this.tableElementTotalTTC = new SQLTableElement(e.getTable().getField("T_PA_TTC"), BigDecimal.class);
        this.tableElementTotalTTC.setRenderer(new DeviseTableCellRenderer());
        list.add(this.tableElementTotalTTC);
        this.defaultRowVals = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(e.getTable()));
        this.defaultRowVals.put("ID_TAXE", TaxeCache.getCache().getFirstTaxe().getID());
        this.defaultRowVals.put("CODE", "");
        this.defaultRowVals.put("NOM", "");
        this.defaultRowVals.put("QTE", 1);
        this.defaultRowVals.put("QTE_UNITAIRE", BigDecimal.ONE);
        this.defaultRowVals.put("ID_UNITE_VENTE", 2);
        this.defaultRowVals.put("ID_MODE_VENTE_ARTICLE", 5);
        RowValuesTableModel model = new RowValuesTableModel(e, list, e.getTable().getField("NOM"), false, this.defaultRowVals);
        this.setModel(model);
        this.table = new RowValuesTable(model, this.getConfigurationFile());
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                this.handlePopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.handlePopup(e);
            }

            public void handlePopup(MouseEvent e) {
                final int rowindex = AbstractAchatArticleItemTable.this.table.getSelectedRow();
                if (rowindex < 0) {
                    return;
                }
                if (e.isPopupTrigger() && e.getComponent() instanceof JTable) {
                    JPopupMenu popup = new JPopupMenu();
                    if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.CAN_EXPAND_NOMENCLATURE_HA, true)) {
                        popup.add(new AbstractAction(TranslationManager.getInstance().getTranslationForItem("product.bom.expand")){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                AbstractAchatArticleItemTable.this.expandNomenclature(rowindex, AbstractAchatArticleItemTable.this.m, AbstractArticleItemTable.EXPAND_TYPE.EXPAND);
                            }
                        });
                        popup.add(new AbstractAction(TranslationManager.getInstance().getTranslationForItem("product.bom.expose")){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                AbstractAchatArticleItemTable.this.expandNomenclature(rowindex, AbstractAchatArticleItemTable.this.m, AbstractArticleItemTable.EXPAND_TYPE.VIEW_ONLY);
                            }
                        });
                        popup.add(new AbstractAction(TranslationManager.getInstance().getTranslationForItem("product.bom.flat")){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                AbstractAchatArticleItemTable.this.expandNomenclature(rowindex, AbstractAchatArticleItemTable.this.m, AbstractArticleItemTable.EXPAND_TYPE.FLAT);
                            }
                        });
                    }
                    for (AbstractAction action : AbstractAchatArticleItemTable.this.getAdditionnalMouseAction(rowindex)) {
                        popup.add(action);
                    }
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        ArrayList<String> completionFields = new ArrayList<String>();
        if (e.getTable().getFieldsName().contains("INCOTERM")) {
            completionFields.add("INCOTERM");
        }
        completionFields.add("ID_UNITE_VENTE");
        completionFields.add("PA_HT");
        completionFields.add("PV_HT");
        completionFields.add("POIDS");
        completionFields.add("ID_TAXE");
        completionFields.add("PRIX_METRIQUE_HA_1");
        completionFields.add("PRIX_METRIQUE_HA_2");
        completionFields.add("PRIX_METRIQUE_HA_3");
        completionFields.add("VALEUR_METRIQUE_1");
        completionFields.add("VALEUR_METRIQUE_2");
        completionFields.add("VALEUR_METRIQUE_3");
        completionFields.add("ID_MODE_VENTE_ARTICLE");
        completionFields.add("PRIX_METRIQUE_VT_1");
        completionFields.add("PRIX_METRIQUE_VT_2");
        completionFields.add("PRIX_METRIQUE_VT_3");
        completionFields.add("SERVICE");
        completionFields.add("ID_DEVISE");
        completionFields.add("PA_DEVISE");
        if (e.getTable().getFieldsName().contains("COLORIS")) {
            completionFields.add("COLORIS");
        }
        if (e.getTable().getFieldsName().contains("DESCRIPTIF")) {
            completionFields.add("DESCRIPTIF");
        }
        if (e.getTable().getFieldsName().contains("ID_FAMILLE_ARTICLE")) {
            completionFields.add("ID_FAMILLE_ARTICLE");
        }
        this.m = new AutoCompletionManager(tableElementCode, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("ARTICLE.CODE"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
                Object res = AbstractAchatArticleItemTable.this.tarifCompletion(row, field);
                if (res == null) {
                    return super.getValueFrom(row, field, rowDest);
                }
                return res;
            }
        };
        this.m.fill("NOM", "NOM");
        this.m.fill("ID", "ID_ARTICLE");
        for (String string : completionFields) {
            this.m.fill(string, string);
        }
        SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        Where w = new Where((FieldRef)sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE);
        this.m.setWhere(w);
        this.m2 = new AutoCompletionManager(tableElementNom, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("ARTICLE.NOM"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
                Object res = AbstractAchatArticleItemTable.this.tarifCompletion(row, field);
                if (res == null) {
                    return super.getValueFrom(row, field, rowDest);
                }
                return res;
            }
        };
        this.m2.fill("CODE", "CODE");
        this.m2.fill("ID", "ID_ARTICLE");
        for (String string : completionFields) {
            this.m2.fill(string, string);
        }
        this.m2.setWhere(w);
        this.m3 = new AutoCompletionManager(tableElementArticle, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("ARTICLE.NOM"), this.table, this.table.getRowValuesTableModel(), 2, true, true, new ValidStateChecker()){

            @Override
            protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
                Object res = AbstractAchatArticleItemTable.this.tarifCompletion(row, field);
                if (res == null) {
                    return super.getValueFrom(row, field, rowDest);
                }
                return res;
            }
        };
        this.m3.fill("CODE", "CODE");
        this.m3.fill("NOM", "NOM");
        for (String string : completionFields) {
            this.m3.fill(string, string);
        }
        this.m3.setWhere(w);
        if (e.getTable().contains("ID_CODE_FOURNISSEUR") && this.supplierCode) {
            this.m4 = new AutoCompletionManager(tableElementCodeFournisseur, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("ARTICLE.NOM"), this.table, this.table.getRowValuesTableModel(), 2, true, true, new ValidStateChecker()){

                @Override
                protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
                    Object res = AbstractAchatArticleItemTable.this.tarifCompletion(row, field);
                    if (res == null) {
                        return super.getValueFrom(row, field, rowDest);
                    }
                    return res;
                }
            };
            this.m4.fill("CODE", "CODE");
            this.m4.fill("NOM", "NOM");
            for (String string : completionFields) {
                this.m4.fill(string, string);
            }
        }
        tableElementCode.addModificationListener(tableElementArticle);
        tableElementArticle.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                try {
                    SQLRowAccessor foreign = row.getForeign("ID_ARTICLE");
                    if (foreign != null && !foreign.isUndefined() && foreign.getObject("CODE") != null && foreign.getString("CODE").equals(row.getString("CODE"))) {
                        return foreign.getID();
                    }
                    return AbstractAchatArticleItemTable.this.tableArticle.getUndefinedID();
                }
                catch (Exception e) {
                    return AbstractAchatArticleItemTable.this.tableArticle.getUndefinedID();
                }
            }
        });
        qteElement.addModificationListener(this.totalHT);
        qteU.addModificationListener(this.totalHT);
        this.ha.addModificationListener(this.totalHT);
        this.totalHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal f = row.getObject("PA_HT") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PA_HT");
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte)), DecimalUtils.HIGH_PRECISION).setScale(AbstractAchatArticleItemTable.this.totalHT.getDecimalDigits(), 4);
                if (row.getTable().contains("POURCENT_REMISE")) {
                    BigDecimal lremise;
                    Object o2 = row.getObject("POURCENT_REMISE");
                    BigDecimal bigDecimal = lremise = o2 == null ? BigDecimal.ZERO : (BigDecimal)o2;
                    if (lremise.compareTo(BigDecimal.ZERO) >= 0 && lremise.compareTo(BigDecimal.valueOf(100L)) < 0) {
                        r = r.multiply(new BigDecimal(100).subtract(lremise).movePointLeft(2)).setScale(AbstractAchatArticleItemTable.this.totalHT.getDecimalDigits(), 4);
                    }
                }
                return r;
            }
        });
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            if (tableElement_PA_Devise != null) {
                tableElement_PA_Devise.addModificationListener(tableElement_PrixMetrique1_AchatHT);
            }
            if (tableElement_PA_Devise != null) {
                tableElement_PrixMetrique1_AchatHT.addModificationListener(tableElement_PA_Devise);
                tableElement_PA_Devise.setModifier(new CellDynamicModifier(){

                    @Override
                    public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                        if (source != null && source.getField().getName().equals("PA_DEVISE")) {
                            return row.getObject("PA_DEVISE");
                        }
                        if (!row.isForeignEmpty("ID_DEVISE")) {
                            String devCode = row.getForeign("ID_DEVISE").getString("CODE");
                            BigDecimal bigDecimal = (BigDecimal)row.getObject("PRIX_METRIQUE_HA_1");
                            CurrencyConverter c = new CurrencyConverter();
                            BigDecimal result = AbstractAchatArticleItemTable.this.convert(bigDecimal, devCode, true);
                            if (result == null) {
                                JOptionPane.showMessageDialog(AbstractAchatArticleItemTable.this, "Unable to convert " + bigDecimal + " from " + c.getCompanyCurrencyCode() + " to " + devCode);
                                return BigDecimal.ZERO;
                            }
                            return result;
                        }
                        if (source != null && source.getField().getName().equalsIgnoreCase("PRIX_METRIQUE_HA_1")) {
                            return row.getObject("PRIX_METRIQUE_HA_1");
                        }
                        return row.getObject("PA_DEVISE");
                    }
                });
            }
            qteElement.addModificationListener(this.tableElementTotalDevise);
            qteU.addModificationListener(this.tableElementTotalDevise);
            tableElement_PA_Devise.addModificationListener(this.tableElementTotalDevise);
            if (e.getTable().contains("POURCENT_REMISE") && tableElementRemise != null) {
                tableElementRemise.addModificationListener(this.tableElementTotalDevise);
            }
            this.tableElementTotalDevise.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    int qte = Integer.parseInt(row.getObject("QTE").toString());
                    BigDecimal f = (BigDecimal)row.getObject("PA_DEVISE");
                    BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                    BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte)), DecimalUtils.HIGH_PRECISION).setScale(AbstractAchatArticleItemTable.this.tableElementTotalDevise.getDecimalDigits(), 4);
                    if (row.getTable().contains("POURCENT_REMISE")) {
                        BigDecimal lremise;
                        Object o2 = row.getObject("POURCENT_REMISE");
                        BigDecimal bigDecimal = lremise = o2 == null ? BigDecimal.ZERO : (BigDecimal)o2;
                        if (lremise.compareTo(BigDecimal.ZERO) >= 0 && lremise.compareTo(BigDecimal.valueOf(100L)) < 0) {
                            r = r.multiply(new BigDecimal(100).subtract(lremise).movePointLeft(2)).setScale(AbstractAchatArticleItemTable.this.tableElementTotalDevise.getDecimalDigits(), 4);
                        }
                    }
                    return r;
                }
            });
        }
        qteElement.addModificationListener(this.tableElementTotalTTC);
        qteU.addModificationListener(this.tableElementTotalTTC);
        this.ha.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTVA.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTotalTTC.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal f = (BigDecimal)row.getObject("PA_HT");
                int idTaux = Integer.parseInt(row.getObject("ID_TAXE").toString());
                if (idTaux < 0) {
                    System.out.println(row);
                }
                Float resultTaux = TaxeCache.getCache().getTauxFromId(idTaux);
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte), DecimalUtils.HIGH_PRECISION), DecimalUtils.HIGH_PRECISION).setScale(AbstractAchatArticleItemTable.this.tableElementTotalTTC.getDecimalDigits(), 4);
                float taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                BigDecimal total = r.multiply(BigDecimal.ONE.add(new BigDecimal(taux / 100.0f))).setScale(AbstractAchatArticleItemTable.this.tableElementTotalTTC.getDecimalDigits(), RoundingMode.HALF_UP);
                return total;
            }
        });
        this.table.readState();
        String valModeAvanceVt = DefaultNXProps.getInstance().getStringProperty("ArticleModeVenteAvance");
        Boolean bModeAvance = Boolean.valueOf(valModeAvanceVt);
        boolean view = bModeAvance == null || bModeAvance != false;
        this.setColumnVisible(model.getColumnForField("VALEUR_METRIQUE_1"), view);
        this.setColumnVisible(model.getColumnForField("VALEUR_METRIQUE_2"), view);
        this.setColumnVisible(model.getColumnForField("VALEUR_METRIQUE_3"), view);
        this.setColumnVisible(model.getColumnForField("PRIX_METRIQUE_VT_1"), view);
        this.setColumnVisible(model.getColumnForField("ID_MODE_VENTE_ARTICLE"), view);
        this.setColumnVisible(model.getColumnForField("PA_HT"), view);
        boolean gestionUV = prefs.getBoolean(GestionArticleGlobalPreferencePanel.UNITE_VENTE, true);
        this.setColumnVisible(model.getColumnForField("QTE_UNITAIRE"), gestionUV);
        this.setColumnVisible(model.getColumnForField("ID_UNITE_VENTE"), gestionUV);
        this.setColumnVisible(model.getColumnForField("ID_STYLE"), DefaultNXProps.getInstance().getBooleanValue("ArticleShowStyle", true));
        this.setColumnVisible(model.getColumnForField("ID_ARTICLE"), selectArticle);
        this.setColumnVisible(model.getColumnForField("CODE"), !selectArticle || selectArticle && createAuto);
        this.setColumnVisible(model.getColumnForField("NOM"), !selectArticle || selectArticle && createAuto);
        tableElement_ValeurMetrique1.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique2.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique3.addModificationListener(tableElementPoids);
        tableElementPoids.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                return new Float(ReferenceArticleSQLElement.getPoidsFromDetails(row));
            }
        });
        tableElementPoids.addModificationListener(this.tableElementPoidsTotal);
        qteElement.addModificationListener(this.tableElementPoidsTotal);
        qteU.addModificationListener(this.tableElementPoidsTotal);
        this.tableElementPoidsTotal.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                Integer f = row.getObject("POIDS") == null ? (Number)0 : (Number)((Number)row.getObject("POIDS"));
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                return Float.valueOf(b.multiply(new BigDecimal(((Number)f).floatValue() * (float)qte)).floatValue());
            }
        });
        tableElement_PrixMetrique1_AchatHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (source != null && source.getField().getName().equals("PRIX_METRIQUE_HA_1")) {
                    return row.getObject("PRIX_METRIQUE_HA_1");
                }
                if (source != null && source.getField().getName().equals("PA_DEVISE")) {
                    if (!row.isForeignEmpty("ID_DEVISE")) {
                        String devCode = row.getForeign("ID_DEVISE").getString("CODE");
                        BigDecimal bigDecimal = (BigDecimal)row.getObject("PA_DEVISE");
                        return AbstractAchatArticleItemTable.this.convert(bigDecimal, devCode, false);
                    }
                    return row.getObject("PRIX_METRIQUE_HA_1");
                }
                return row.getObject("PRIX_METRIQUE_HA_1");
            }
        });
        tableElement_ValeurMetrique1.addModificationListener(this.ha);
        tableElement_ValeurMetrique2.addModificationListener(this.ha);
        tableElement_ValeurMetrique3.addModificationListener(this.ha);
        tableElement_PrixMetrique1_AchatHT.addModificationListener(this.ha);
        this.ha.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (row.isForeignEmpty("ID_MODE_VENTE_ARTICLE") || row.getInt("ID_MODE_VENTE_ARTICLE") == 5) {
                    return row.getObject("PRIX_METRIQUE_HA_1");
                }
                BigDecimal prixHAFromDetails = ReferenceArticleSQLElement.getPrixHAFromDetails(row);
                return prixHAFromDetails.setScale(AbstractAchatArticleItemTable.this.ha.getDecimalDigits(), RoundingMode.HALF_UP);
            }
        });
        uniteVente.addModificationListener(qteU);
        qteU.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                SQLRowAccessor rowUnite = row.getForeign("ID_UNITE_VENTE");
                if (rowUnite != null && !rowUnite.isUndefined() && rowUnite.getBoolean("A_LA_PIECE").booleanValue()) {
                    return BigDecimal.ONE;
                }
                return row.getObject("QTE_UNITAIRE");
            }
        });
        this.setColumnVisible(model.getColumnIndexForElement(tableElement_Devise), false);
        for (String string : visibilityMap.keySet()) {
            this.setColumnVisible(model.getColumnForField(string), visibilityMap.get(string));
        }
        this.table.writeState();
    }

    public static Map<String, Boolean> getVisibilityMap() {
        return visibilityMap;
    }

    protected List<AbstractAction> getAdditionnalMouseAction(int rowIndex) {
        return Collections.emptyList();
    }

    public void setIncoterms(String incoterm) {
        if (incoterm == null) {
            incoterm = "";
        }
        this.incoterm = incoterm;
    }

    public void setFournisseur(SQLRow rowFournisseur) {
        this.rowFournisseur = rowFournisseur;
        if (this.getSQLElement().getTable().contains("ID_CODE_FOURNISSEUR") && this.supplierCode) {
            if (rowFournisseur != null && !rowFournisseur.isUndefined()) {
                Where w = new Where((FieldRef)this.getSQLElement().getTable().getTable("CODE_FOURNISSEUR").getField("ID_FOURNISSEUR"), "=", rowFournisseur.getID());
                this.m4.setWhere(w);
            } else {
                this.m4.setWhere(null);
            }
        }
    }

    private BigDecimal getPrice(SQLRowAccessor r, List<String> list) {
        BigDecimal result = r.getBigDecimal(list.get(0));
        int i = 1;
        while (i < list.size()) {
            BigDecimal m0 = r.getBigDecimal(list.get(i));
            if (m0 != null && m0.floatValue() > 0.0f) {
                result = result.divide(m0, 2, RoundingMode.HALF_UP);
            }
            ++i;
        }
        return result;
    }

    private Object tarifCompletion(SQLRow row, String field) {
        SQLTable tTarifFournisseur = this.getSQLElement().getTable().getDBRoot().getTable("ARTICLE_TARIF_FOURNISSEUR");
        if (row != null && !row.isUndefined() && field.equalsIgnoreCase("PRIX_METRIQUE_HA_1") && tTarifFournisseur != null) {
            List<String> incoTerms = this.incoterm != null && this.incoterm.equalsIgnoreCase("CPT") ? Arrays.asList("PRIX_ACHAT", "COEF_TRANSPORT_PORT") : (this.incoterm != null && this.incoterm.equalsIgnoreCase("DDP") ? Arrays.asList("PRIX_ACHAT", "COEF_TRANSPORT_PORT", "COEF_TAXE_D") : Arrays.asList("PRIX_ACHAT"));
            Collection rows = row.getReferentRows(tTarifFournisseur);
            if (row.getBoolean("AUTO_PRIX_ACHAT_NOMENCLATURE").booleanValue()) {
                Collection rowsElt = row.getReferentRows(row.getTable().getTable("ARTICLE_ELEMENT").getField("ID_ARTICLE_PARENT"));
                BigDecimal price = BigDecimal.ZERO;
                final HashSet<String> tarifNotFound = new HashSet<String>();
                for (SQLRow sqlRow : rowsElt) {
                    Collection rowsT = sqlRow.getForeign("ID_ARTICLE").getReferentRows(tTarifFournisseur);
                    boolean priceFound = false;
                    boolean tarifFound = false;
                    if (rowsT.size() > 0) {
                        BigDecimal min = BigDecimal.ZERO;
                        BigDecimal defaultPrice = BigDecimal.ZERO;
                        Calendar c = null;
                        for (SQLRow sqlRowT : rowsT) {
                            BigDecimal priceT;
                            if (this.rowFournisseur == null || this.rowFournisseur.getID() != sqlRowT.getForeignID("ID_FOURNISSEUR")) continue;
                            defaultPrice = priceT = this.getPrice(sqlRowT, incoTerms);
                            Calendar datePrice = sqlRowT.getDate("DATE_PRIX");
                            if (datePrice == null || this.getDateDevise() != null && !this.getDateDevise().before(datePrice.getTime())) {
                                if (c == null || c.before(datePrice)) {
                                    min = priceT;
                                    c = datePrice;
                                    priceFound = true;
                                } else if (c != null) {
                                    defaultPrice = priceT;
                                }
                            }
                            tarifFound = true;
                        }
                        price = priceFound ? price.add(min.multiply(sqlRow.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(sqlRow.getInt("QTE"), DecimalUtils.HIGH_PRECISION)))) : price.add(defaultPrice.multiply(sqlRow.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(sqlRow.getInt("QTE"), DecimalUtils.HIGH_PRECISION))));
                    }
                    if (tarifFound) continue;
                    tarifNotFound.add(sqlRow.getForeign("ID_ARTICLE").getString("CODE"));
                }
                if (!tarifNotFound.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(AbstractAchatArticleItemTable.this.table, "Attention, impossible de calculer le tarif.\nLes articles suivants n'ont pas de tarif associ\u00e9 :\n" + tarifNotFound);
                        }
                    });
                }
                return price;
            }
            if (!rows.isEmpty()) {
                BigDecimal min = BigDecimal.ZERO;
                Calendar c = null;
                for (SQLRow sqlRow : rows) {
                    if (this.rowFournisseur == null || this.rowFournisseur.getID() != sqlRow.getForeignID("ID_FOURNISSEUR")) continue;
                    BigDecimal price = this.getPrice(sqlRow, incoTerms);
                    Calendar datePrice = sqlRow.getDate("DATE_PRIX");
                    if (datePrice != null && (this.getDateDevise() == null || this.getDateDevise().before(datePrice.getTime())) || c != null && !c.before(datePrice)) continue;
                    min = price;
                    c = datePrice;
                }
                return min.setScale(2, RoundingMode.HALF_UP);
            }
        }
        if (field.equalsIgnoreCase("INCOTERM")) {
            return this.incoterm;
        }
        if (this.getDevise() != null && !this.getDevise().isUndefined()) {
            if (field.equalsIgnoreCase("ID_DEVISE") || field.equalsIgnoreCase("ID_DEVISE_HA")) {
                return this.getDevise().getID();
            }
            if (field.equalsIgnoreCase("PA_DEVISE")) {
                if (row.getBigDecimal("PA_DEVISE") != null && row.getBigDecimal("PA_DEVISE").signum() != 0 && this.incoterm.length() == 0) {
                    return row.getBigDecimal("PA_DEVISE");
                }
                String devCode = this.getDevise().getString("CODE");
                BigDecimal tarifCompletion = (BigDecimal)this.tarifCompletion(row, "PRIX_METRIQUE_HA_1");
                if (tarifCompletion == null) {
                    tarifCompletion = row.getBigDecimal("PRIX_METRIQUE_HA_1");
                }
                if (tarifCompletion == null) {
                    return null;
                }
                return this.convert(tarifCompletion, devCode, true);
            }
        } else {
            if (field.equalsIgnoreCase("ID_DEVISE") || field.equalsIgnoreCase("ID_DEVISE_HA")) {
                return Configuration.getInstance().getDirectory().getElement("DEVISE").getTable().getUndefinedID();
            }
            if (field.equalsIgnoreCase("PA_DEVISE")) {
                return BigDecimal.ZERO;
            }
        }
        return null;
    }

    @Override
    protected void refreshDeviseAmount() {
        int count = this.getRowValuesTable().getRowCount();
        int columnForField = this.getRowValuesTable().getRowValuesTableModel().getColumnForField("PA_DEVISE");
        if (columnForField >= 0) {
            SQLTableElement eltDevise = this.getRowValuesTable().getRowValuesTableModel().getSQLTableElementAt(columnForField);
            int i = 0;
            while (i < count) {
                SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(i);
                eltDevise.setValueFrom(rowVals, rowVals.getObject("PA_DEVISE"));
                this.getRowValuesTable().getRowValuesTableModel().fireTableChanged(new TableModelEvent(this.getRowValuesTable().getRowValuesTableModel(), i, i, columnForField));
                ++i;
            }
        }
    }

    public SQLRowAccessor getDevise() {
        return this.rowDevise;
    }

    public void setDevise(SQLRowAccessor deviseRow) {
        this.rowDevise = deviseRow;
        if (deviseRow == null) {
            this.getDefaultRowValues().put("ID_DEVISE", null);
        } else {
            this.getDefaultRowValues().put("ID_DEVISE", this.rowDevise.getID());
        }
    }

    public void setTauxConversion(BigDecimal tauxConversion) {
        if (tauxConversion != null && tauxConversion.signum() == 0) {
            tauxConversion = null;
        }
        this.tauxConversion = tauxConversion;
        this.refreshDeviseAmount();
    }

    public BigDecimal convert(BigDecimal val, String devCode, boolean fromCompanyCurrency) {
        if (val == null) {
            return val;
        }
        if (this.tauxConversion == null) {
            CurrencyConverter c = new CurrencyConverter();
            if (fromCompanyCurrency) {
                return c.convert(val, c.getCompanyCurrencyCode(), devCode, this.getDateDevise(), this.isUsedBiasedDevise());
            }
            return c.convert(val, devCode, c.getCompanyCurrencyCode(), this.getDateDevise(), this.isUsedBiasedDevise());
        }
        if (fromCompanyCurrency) {
            return val.divide(this.tauxConversion, DecimalUtils.HIGH_PRECISION).setScale(val.scale(), RoundingMode.HALF_UP);
        }
        return val.multiply(this.tauxConversion, DecimalUtils.HIGH_PRECISION).setScale(val.scale(), RoundingMode.HALF_UP);
    }

    public void setFournisseurFilterOnCompletion(SQLRow row) {
        SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        Where w = new Where((FieldRef)sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE);
        if (row != null && !row.isUndefined()) {
            w = w.and(new Where((FieldRef)this.tableArticle.getField("ID_FOURNISSEUR"), "=", row.getID()));
        }
        this.m.setWhere(w);
        this.m2.setWhere(w);
        this.m3.setWhere(w);
    }

    public void insertFromReliquat(List<SQLRowValues> reliquats) {
        for (SQLRowValues reliquat : reliquats) {
            SQLRowValues row2Insert = new SQLRowValues(this.getRowValuesTable().getRowValuesTableModel().getDefaultRowValues());
            SQLRow article = reliquat.getForeign("ID_ARTICLE").asRow();
            row2Insert.put("ID_ARTICLE", ((SQLRowAccessor)article).getID());
            row2Insert.put("CODE", ((SQLRowAccessor)article).getObject("CODE"));
            row2Insert.put("NOM", ((SQLRowAccessor)article).getObject("NOM"));
            row2Insert.put("QTE", reliquat.getObject("QTE"));
            row2Insert.put("QTE_UNITAIRE", reliquat.getObject("QTE_UNITAIRE"));
            row2Insert.put("ID_UNITE_VENTE", reliquat.getForeignID("ID_UNITE_VENTE"));
            this.getRowValuesTable().getRowValuesTableModel().addRowAt(0, row2Insert);
        }
    }
}

