/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.element;

import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jdom2.Document;
import org.jdom2.input.DOMBuilder;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.sql.ui.light.GroupToLightUIConvertor;
import org.openconcerto.sql.ui.light.LightEditFrame;
import org.openconcerto.sql.ui.light.LightUIPanelFiller;
import org.openconcerto.sql.ui.light.SearchInfo;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.AutoHideListener;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.light.ColumnSpec;
import org.openconcerto.ui.light.ColumnsSpec;
import org.openconcerto.ui.light.InformationLine;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUIFrame;
import org.openconcerto.ui.light.LightUILine;
import org.openconcerto.ui.light.LightUIPanel;
import org.openconcerto.ui.light.LightUITable;
import org.openconcerto.ui.light.Row;
import org.openconcerto.ui.light.RowSelectionSpec;
import org.openconcerto.ui.light.RowsBulk;
import org.openconcerto.ui.light.SearchSpec;
import org.openconcerto.ui.light.SimpleTextLine;
import org.openconcerto.ui.light.TableContent;
import org.openconcerto.ui.light.TableSpec;
import org.openconcerto.ui.table.TableCellRendererUtils;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.convertor.ValueConvertor;

public abstract class SocieteSQLConfElement
extends SQLElement {
    public static final TableCellRenderer CURRENCY_RENDERER = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component res = super.getTableCellRendererComponent(table, GestionDevise.currencyToString((BigDecimal)value), isSelected, hasFocus, row, column);
            TableCellRendererUtils.setColors(res, table, isSelected);
            ((JLabel)res).setHorizontalAlignment(4);
            return res;
        }
    };
    private static final SQLTable.VirtualFields FIELDS_TO_IGNORE = SQLTable.VirtualFields.PRIMARY_KEY.union(SQLTable.VirtualFields.ARCHIVE).union(SQLTable.VirtualFields.ORDER);

    public SocieteSQLConfElement(SQLTable table, String singular, String plural) {
        super(singular, plural, table);
        this.setL18nLocation(Gestion.class);
    }

    public SocieteSQLConfElement(SQLTable table) {
        this(table, (String)null);
    }

    public SocieteSQLConfElement(SQLTable table, String code) {
        super(table, null, code);
        this.setL18nLocation(Gestion.class);
    }

    public static final JPanel createAdditionalPanel() {
        return AutoHideListener.listen(new JPanel());
    }

    @Override
    protected String createCode() {
        return this.createCodeFromPackage();
    }

    public SQLRowValues createDefaultRowValues(String sessionSecurityToken) {
        return new SQLRowValues(this.getTable());
    }

    public RowsBulk doSearch(PropsConfiguration configuration, SearchSpec searchSpec, ColumnsSpec columnsSpec, final int startIndex, final int limit) {
        long t1 = System.currentTimeMillis();
        final SQLTableModelSourceOnline tableSource = this.getTableSource();
        final SearchInfo sInfo = searchSpec != null ? new SearchInfo(searchSpec) : null;
        ListSQLRequest req = tableSource.getReq();
        req.setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect sel) {
                SocieteSQLConfElement.this.setWhere(sel, tableSource, sInfo, startIndex, -1);
                return sel;
            }
        });
        long t2 = System.currentTimeMillis();
        int count = req.getValuesCount();
        long t3 = System.currentTimeMillis();
        req.setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect sel) {
                SocieteSQLConfElement.this.setWhere(sel, tableSource, sInfo, startIndex, limit);
                return sel;
            }
        });
        long t4 = System.currentTimeMillis();
        List<SQLRowValues> rowValues = req.getValues();
        int size = rowValues.size();
        long t5 = System.currentTimeMillis();
        System.err.println("DefaultTableContentHandler.handle() getReq :" + (t2 - t1) + " ms");
        System.err.println("DefaultTableContentHandler.handle() getValuesCount() :" + count + " : " + (t3 - t2) + " ms");
        System.err.println("DefaultTableContentHandler.handle() setWhere : " + (t4 - t3) + " ms");
        System.err.println("DefaultTableContentHandler.handle() getValues() :" + size + " : " + (t5 - t4) + " ms");
        List<SQLTableModelColumn> allCols = tableSource.getColumns();
        ArrayList<Row> matchingRows = new ArrayList<Row>();
        int columnsCount = allCols.size();
        if (columnsSpec.getColumnCount() == columnsCount) {
            int i = 0;
            while (i < size) {
                SQLRowValues rowV = rowValues.get(i);
                Row row = new Row(rowV.getID());
                ArrayList<Object> l = new ArrayList<Object>();
                int j = 0;
                while (j < columnsCount) {
                    Object value;
                    String columnId = columnsSpec.getColumn(j).getId();
                    SQLTableModelColumn col = this.getColumnFromId(allCols, columnId);
                    if (col != null) {
                        value = col.show(rowV);
                        if (col.getLightUIrenderer() != null) {
                            value = col.getLightUIrenderer().getLightUIElement(value, i, j);
                        }
                        if (value instanceof SQLRowValues) {
                            value = ((SQLRowValues)value).getIDNumber();
                        }
                    } else {
                        throw new IllegalArgumentException("column " + columnId + " is in xmlPref but it is not found in SQLTableModelColumn");
                    }
                    l.add(value);
                    ++j;
                }
                row.setValues(l);
                matchingRows.add(row);
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                SQLRowValues rowV = rowValues.get(i);
                Row row = new Row(rowV.getID());
                ArrayList<Object> l = new ArrayList<Object>();
                int j = 0;
                while (j < columnsCount) {
                    SQLTableModelColumn tableModelColumn = allCols.get(j);
                    Object value = tableModelColumn.show(rowV);
                    if (tableModelColumn.getLightUIrenderer() != null) {
                        value = tableModelColumn.getLightUIrenderer().getLightUIElement(value, i, j);
                    }
                    if (value instanceof SQLRowValues) {
                        value = ((SQLRowValues)value).getIDNumber();
                    }
                    l.add(value);
                    ++j;
                }
                row.setValues(l);
                matchingRows.add(row);
                ++i;
            }
        }
        return new RowsBulk(matchingRows, startIndex, count);
    }

    private void setWhere(SQLSelect sel, SQLTableModelSourceOnline tableSource, SearchInfo sInfo, int startIndex, int limit) {
        if (sInfo != null) {
            List<SQLTableModelColumn> cols = tableSource.getColumns();
            HashSet<SQLField> fields = new HashSet<SQLField>();
            for (SQLTableModelColumn sqlTableModelColumn : cols) {
                fields.addAll(sqlTableModelColumn.getFields());
            }
            ArrayList<SQLField> strFields = new ArrayList<SQLField>();
            ArrayList<Where> wheres = new ArrayList<Where>();
            for (SQLField sqlField : fields) {
                if (!sqlField.getType().getJavaType().equals(String.class)) continue;
                strFields.add(sqlField);
                List<String> texts = sInfo.getTexts();
                for (String string : texts) {
                    Where w = new Where(sel.getAlias(sqlField), "LIKE", (Object)("%" + string + "%"));
                    wheres.add(w);
                }
            }
            sel.setWhere(Where.or(wheres));
        }
        if (limit != -1) {
            sel.setLimit(limit);
            sel.setOffset(startIndex);
        }
    }

    protected String getReadOnlyFrameTitle(SQLRowValues sqlRow) {
        return EditFrame.getReadOnlyMessage(this);
    }

    protected String getModificationFrameTitle(SQLRowValues sqlRow) {
        return EditFrame.getModifyMessage(this);
    }

    protected String getCreationFrameTitle() {
        return EditFrame.getCreateMessage(this);
    }

    protected final String createCodeFromPackage() {
        return SocieteSQLConfElement.createCodeFromPackage(this.getLastNonAbstractClass());
    }

    /*
     * Unable to fully structure code
     */
    private final Class<? extends ComptaSQLConfElement> getLastNonAbstractClass() {
        prev = null;
        cl = this.getClass();
        if (SocieteSQLConfElement.$assertionsDisabled || !Modifier.isAbstract(cl.getModifiers()) && ComptaSQLConfElement.class.isAssignableFrom(cl) && Modifier.isAbstract(ComptaSQLConfElement.class.getModifiers())) ** GOTO lbl7
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            prev = cl;
            cl = cl.getSuperclass();
lbl7:
            // 2 sources

            ** while (!Modifier.isAbstract((int)cl.getModifiers()))
        }
lbl8:
        // 1 sources

        if (!SocieteSQLConfElement.$assertionsDisabled && !ComptaSQLConfElement.class.isAssignableFrom(prev)) {
            throw new AssertionError();
        }
        res = prev;
        return res;
    }

    protected static String createCodeFromPackage(Class<? extends ComptaSQLConfElement> cl) {
        String canonicalName = cl.getName();
        if (canonicalName.contains("erp.core") && canonicalName.contains(".element")) {
            int i = canonicalName.indexOf("erp.core") + 9;
            int j = canonicalName.indexOf(".element");
            canonicalName = canonicalName.substring(i, j);
        }
        return canonicalName;
    }

    @Override
    protected void _initTableSource(SQLTableModelSourceOnline res) {
        super._initTableSource(res);
        for (SQLTableModelColumn col : res.getColumns()) {
            if (col.getValueClass() != Long.class && col.getValueClass() != BigInteger.class) continue;
            col.setConverter(new ValueConvertor<Number, BigDecimal>(){

                @Override
                public BigDecimal convert(Number o) {
                    if (o == null) {
                        System.err.println("ComptaSQLConfElement._initTableSource: Warning null Number conversion (" + this + ")");
                        return BigDecimal.ZERO;
                    }
                    return new BigDecimal(o.longValue()).movePointLeft(2);
                }

                @Override
                public Number unconvert(BigDecimal o) {
                    if (o == null) {
                        System.err.println("ComptaSQLConfElement._initTableSource: Warning null BigDecimal conversion (" + this + ")");
                        return 0;
                    }
                    return o.movePointRight(2);
                }
            }, BigDecimal.class);
            col.setRenderer(CURRENCY_RENDERER);
        }
    }

    protected Document getColumnsUserPerfs(Configuration configuration, int userId, String tableId, List<SQLTableModelColumn> sqlColumns) {
        Document columnsPrefs = null;
        try {
            DOMBuilder in = new DOMBuilder();
            org.w3c.dom.Document w3cDoc = configuration.getXMLConf(userId, tableId);
            if (w3cDoc != null) {
                columnsPrefs = in.build(w3cDoc);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to get ColumnPrefs for table " + tableId + " and for user " + userId + "\n" + ex.getMessage());
        }
        return columnsPrefs;
    }

    protected ColumnsSpec createColumnsSpec(Configuration configuration, List<SQLTableModelColumn> columns, Document columnsPrefs) {
        ArrayList<String> possibleColumnIds = new ArrayList<String>();
        ArrayList<String> sortedIds = new ArrayList<String>();
        ArrayList<ColumnSpec> columnsSpec = new ArrayList<ColumnSpec>();
        int columnsCount = columns.size();
        int i = 0;
        while (i < columnsCount) {
            SQLTableModelColumn sqlColumn = columns.get(i);
            String columnId = sqlColumn.getIdentifier();
            possibleColumnIds.add(columnId);
            Class<LightUIElement> valueClass = sqlColumn.getValueClass();
            if (sqlColumn.getLightUIrenderer() != null) {
                valueClass = LightUIElement.class;
            }
            String columnName = "";
            if (sqlColumn.getFields().size() == 1) {
                SQLField field = sqlColumn.getFields().iterator().next();
                columnName = SQLTableModelColumnPath.getDescFor(field, configuration).getTitleLabel();
            }
            if (columnName == null || columnName.isEmpty()) {
                columnName = sqlColumn.getName();
            }
            columnsSpec.add(new ColumnSpec(columnId, valueClass, columnName, null, false, null));
            ++i;
        }
        sortedIds.add(((ColumnSpec)columnsSpec.get(0)).getId());
        ColumnsSpec cSpec = new ColumnsSpec(this.getCode(), columnsSpec, possibleColumnIds, sortedIds);
        cSpec.setAllowMove(true);
        cSpec.setAllowResize(true);
        cSpec.setUserPrefs(columnsPrefs);
        return cSpec;
    }

    public LightUITable createUIElementForTable(Configuration configuration) throws IllegalArgumentException {
        String tableId = String.valueOf(this.getCode()) + ".table";
        SQLTableModelSourceOnline source = this.getTableSource();
        List<SQLTableModelColumn> columns = source.getColumns();
        Document columnsPrefs = this.getColumnsUserPerfs(configuration, UserManager.getUserID(), tableId, columns);
        RowSelectionSpec selection = new RowSelectionSpec(tableId);
        ColumnsSpec columnsSpec = this.createColumnsSpec(configuration, columns, columnsPrefs);
        TableSpec tSpec = new TableSpec(tableId, selection, columnsSpec);
        LightUITable table = new LightUITable(tableId);
        table.setFillWidth(true);
        table.setWeightX(1);
        table.setElementCode(this.getCode());
        table.setTableSpec(tSpec);
        return table;
    }

    public LightUILine createSecondaryRowActionLine(RowSelectionSpec selection) {
        return null;
    }

    public LightUIPanel createDataPanel(List<SQLRowValues> selection, Configuration configuration, String sessionSecurityToken) {
        if (selection == null) {
            return null;
        }
        LightUIPanel panel = new LightUIPanel(String.valueOf(this.getCode()) + ".data.panel");
        panel.setVerticallyScrollable(true);
        panel.setWeightX(1);
        SQLFieldTranslator translator = configuration.getTranslator();
        for (SQLRowValues row : selection) {
            int rowId = row.getID();
            LightUILine mainLine = new LightUILine();
            LightUIPanel mainLinePanel = new LightUIPanel(String.valueOf(panel.getId()) + ".main.line." + rowId);
            mainLinePanel.setWeightX(1);
            mainLinePanel.addChild(new SimpleTextLine("Information sur l'\u00e9l\u00e9ment n\u00b0" + rowId, true, 1));
            LightUILine lineData = new LightUILine();
            LightUIPanel dataPanel = new LightUIPanel(String.valueOf(this.getCode()) + ".data.panel." + rowId);
            dataPanel.setWeightX(1);
            for (String fieldName : row.getFields()) {
                this.addFieldToPanel(fieldName, dataPanel, row, translator);
            }
            lineData.addChild(dataPanel);
            mainLinePanel.addChild(lineData);
            mainLine.addChild(mainLinePanel);
            panel.addChild(mainLine);
        }
        return panel;
    }

    public void addFieldToPanel(String fieldName, LightUIPanel dataPanel, SQLRowValues row, SQLFieldTranslator translator) {
        this.addFieldToPanel(fieldName, dataPanel, row, translator, false, "");
    }

    public void addFieldToPanel(String fieldName, LightUIPanel dataPanel, SQLRowValues row, SQLFieldTranslator translator, boolean addEmpty, String defaultValue) {
        SQLField field = this.getTable().getField(fieldName);
        if (!this.getTable().getFields(FIELDS_TO_IGNORE).contains(field)) {
            String key = translator.getLabelFor(field);
            boolean error = false;
            if (key == null) {
                error = true;
                key = field.getFieldName();
            }
            String value = "";
            if (field.isKey()) {
                List<FieldPath> fieldsPath = this.getListExpander().expand(field);
                for (FieldPath fieldPath : fieldsPath) {
                    SQLRowValues foreignRow = row.followPath(fieldPath.getPath());
                    if (foreignRow == null) continue;
                    value = String.valueOf(value) + foreignRow.getString(fieldPath.getField().getName()) + " ";
                }
            } else {
                value = row.getString(fieldName);
            }
            boolean isDefault = false;
            if (value == null || value.isEmpty()) {
                isDefault = true;
                value = defaultValue;
            }
            if (!value.isEmpty() || addEmpty) {
                InformationLine line = new InformationLine(key, value);
                if (error) {
                    line.setLabelColor(Color.RED);
                }
                line.setItalicOnValue(isDefault);
                dataPanel.addChild(line);
            }
        }
    }

    public Group getEditGroup(EditPanel.EditMode editMode) {
        if (editMode.equals((Object)EditPanel.EditMode.CREATION)) {
            return this.getGroupForCreation();
        }
        return this.getGroupForModification();
    }

    public GroupToLightUIConvertor getGroupToLightUIConvertor(PropsConfiguration configuration, EditPanel.EditMode editMode, SQLRowValues sqlRow, String sessionSecurityToken) {
        GroupToLightUIConvertor convertor = new GroupToLightUIConvertor(configuration);
        if (editMode.equals((Object)EditPanel.EditMode.CREATION)) {
            convertor.putAllCustomEditorProvider(this.getCustomEditorProviderForCreation(configuration, sessionSecurityToken));
        } else {
            convertor.putAllCustomEditorProvider(this.getCustomEditorProviderForModification(configuration, sqlRow, sessionSecurityToken));
        }
        return convertor;
    }

    public LightEditFrame createEditFrame(PropsConfiguration configuration, LightUIFrame parentFrame, EditPanel.EditMode editMode, SQLRowValues sqlRow, String sessionSecurityToken) {
        Group editGroup = this.getEditGroup(editMode);
        if (editGroup == null) {
            Log.get().severe("The edit group is null for this element : " + this);
            return null;
        }
        GroupToLightUIConvertor convertor = this.getGroupToLightUIConvertor(configuration, editMode, sqlRow, sessionSecurityToken);
        LightEditFrame editFrame = convertor.convert(editGroup, sqlRow, parentFrame, editMode);
        if (editMode.equals((Object)EditPanel.EditMode.CREATION)) {
            editFrame.setTitle(this.getCreationFrameTitle());
        } else if (editMode.equals((Object)EditPanel.EditMode.MODIFICATION)) {
            editFrame.setTitle(this.getModificationFrameTitle(sqlRow));
            new LightUIPanelFiller(editFrame.getFirstChild(LightUIPanel.class)).fillFromRow(configuration, sqlRow);
        } else if (editMode.equals((Object)EditPanel.EditMode.READONLY)) {
            editFrame.setTitle(this.getReadOnlyFrameTitle(sqlRow));
            new LightUIPanelFiller(editFrame.getFirstChild(LightUIPanel.class)).fillFromRow(configuration, sqlRow);
        }
        this.setEditFrameModifiers(editFrame, sessionSecurityToken);
        return editFrame;
    }

    public List<SQLRowValues> getRowValues(String fieldName, long id) {
        SQLTableModelSourceOnline tableSource = this.getTableSource(true);
        ListSQLRequest req = tableSource.getReq();
        req.setWhere(new Where((FieldRef)this.getTable().getField(fieldName), "=", (Object)id));
        return req.getValues();
    }

    public TableContent createTableContent(LightUITable uiTable, String fieldName, long id) {
        SQLTableModelSourceOnline tableSource = this.getTableSource(true);
        List<SQLTableModelColumn> allCols = tableSource.getColumns();
        List<SQLRowValues> listRowValues = this.getRowValues(fieldName, id);
        ArrayList<Row> matchingRows = new ArrayList<Row>();
        int size = listRowValues.size();
        int i = 0;
        while (i < size) {
            SQLRowValues rowV = listRowValues.get(i);
            matchingRows.add(this.createRowFromSQLRow(rowV, allCols, uiTable.getTableSpec().getColumns()));
            ++i;
        }
        TableContent tableContent = new TableContent(uiTable.getId(), matchingRows);
        return tableContent;
    }
}

