/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.config.CloudPanel;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.InstallationPanel;
import org.openconcerto.erp.config.ServerConfigListModel;
import org.openconcerto.erp.config.ServerFinderConfig;
import org.openconcerto.erp.core.sales.pos.ui.ConfigCaissePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.VFlowLayout;
import org.openconcerto.utils.DesktopEnvironment;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.PropertiesUtils;

public class ServerFinderPanel
extends JPanel {
    private ServerConfigListModel dataModel;
    private File confFile;
    private JComboBox comboMode;
    private JTextField textMainProperties;
    private JTextField textIP;
    private JTextField textPort;
    private JTextField textFile;
    private JTextField textBase;
    private Properties props = new Properties();
    private JButton buttonDir;
    private JTabbedPane tabbedPane;

    public static void main(String[] args) {
        System.setProperty("redirectToFile", "true");
        System.setProperty("org.openconcerto.sql.identifier.allowRemoval", "true");
        System.setProperty("org.openconcerto.sql.noautoCreateMetadata", "true");
        ExceptionHandler.setForceUI(true);
        ExceptionHandler.setForumURL("http://www.openconcerto.org/forum");
        PropsConfiguration conf = new PropsConfiguration(new Properties()){

            @Override
            protected File createWD() {
                return new File(String.valueOf(DesktopEnvironment.getDE().getDocumentsFolder().getAbsolutePath()) + File.separator + ComptaPropsConfiguration.APP_NAME);
            }
        };
        try {
            conf.setupLogging();
        }
        catch (Exception e) {
            System.out.println("Logs d\u00e9sactiv\u00e9s : " + e.getMessage());
        }
        final File confFile = ComptaPropsConfiguration.getConfFile();
        System.out.println("Reading configuration from: " + confFile.getAbsolutePath());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                JFrame f = new JFrame("Configuration OpenConcerto");
                f.setDefaultCloseOperation(3);
                ServerFinderPanel panel = new ServerFinderPanel();
                panel.uiInit();
                boolean loaded = panel.setConfigFile(confFile);
                if (!loaded) {
                    panel.fillWithDefaultH2Config();
                    panel.updateUIFromProps();
                }
                panel.tabbedPane.addTab("Cloud", new CloudPanel(panel));
                f.setContentPane(panel);
                f.pack();
                f.setMinimumSize(new Dimension(f.getWidth(), f.getHeight()));
                f.setLocationRelativeTo(null);
                f.setVisible(true);
            }
        });
    }

    protected void fillWithDefaultH2Config() {
        this.props.setProperty("server.driver", "h2");
        this.props.setProperty("customer", "Gestion_Default");
        this.props.setProperty("systemRoot", "OpenConcerto");
        this.props.setProperty("base.root", "Common");
        this.props.setProperty("server.ip", "file:${data.dir}/");
    }

    public static final String getDefaultSystemRootName() {
        return ComptaPropsConfiguration.APP_NAME;
    }

    public static final boolean containsValidH2DB(File dir) {
        return ServerFinderPanel.testH2DBDir(dir) == null;
    }

    public static final String testH2DBDir(File dir) {
        String fileName;
        File h2File;
        String err = dir == null ? "Dossier de base de donn\u00e9es non d\u00e9fini" : (!dir.exists() ? "Dossier de base de donn\u00e9es inexistant" : (!(h2File = new File(dir, fileName = String.valueOf(ServerFinderPanel.getDefaultSystemRootName()) + ".h2.db")).exists() ? "Le dossier de base de donn\u00e9es ne contient pas " + fileName : (h2File.length() < 50000L ? "Le dossier de base de donn\u00e9es contient un fichier " + fileName + " vide" : null)));
        return err;
    }

    private boolean loadConfigFile() {
        this.textMainProperties.setText(this.confFile.getAbsolutePath());
        Properties defaults = new Properties();
        defaults.put("server.driver", "postgresql");
        defaults.put("server.ip", "127.0.0.1");
        defaults.put("systemRoot", ServerFinderPanel.getDefaultSystemRootName());
        defaults.put("customer", "Gestion_Default");
        this.props.clear();
        PropertiesUtils.load(this.props, defaults);
        if (!this.confFile.exists()) {
            System.out.println("Unable to find: " + this.confFile.getAbsolutePath());
            File dir1 = new File(Configuration.getDefaultConfDir(), String.valueOf(ComptaPropsConfiguration.APP_NAME) + "-GESTION_DEFAULT/DBData");
            File dir2 = new File(Configuration.getDefaultConfDir(), String.valueOf(ComptaPropsConfiguration.APP_NAME) + "/DBData");
            File validDir = ServerFinderPanel.containsValidH2DB(dir1) ? dir1 : (ServerFinderPanel.containsValidH2DB(dir2) ? dir2 : null);
            if (validDir != null) {
                System.out.println("Found DB in " + validDir);
                this.updateUIForMode(SQLSystem.H2);
                this.textFile.setText(validDir.getAbsolutePath());
                this.textBase.setText(ServerFinderPanel.getDefaultSystemRootName());
            }
            return validDir != null;
        }
        System.out.println("Loading: " + this.confFile.getAbsolutePath());
        if (!this.confFile.isFile()) {
            JOptionPane.showMessageDialog(null, this.confFile + " n'est pas un fichier valide");
        } else if (!this.confFile.canRead()) {
            JOptionPane.showMessageDialog(null, "Vous n'avez pas les droits de lire le fichier " + this.confFile);
        } else {
            if (!this.confFile.canWrite()) {
                JOptionPane.showMessageDialog(null, "Vous n'avez pas les droits de modifier le fichier " + this.confFile);
            }
            try {
                this.props.load(new FileInputStream(this.confFile));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Impossible de lire le fichier " + this.confFile + " \n" + e.getLocalizedMessage());
            }
            this.updateUIFromProps();
        }
        return true;
    }

    private void updateUIFromProps() {
        try {
            this.updateUIForMode(SQLSystem.get(this.props.getProperty("server.driver")));
        }
        catch (Exception e) {
            this.updateUIForMode(SQLSystem.POSTGRESQL);
        }
        String serverIp = this.props.getProperty("server.ip");
        if (serverIp.startsWith("file:")) {
            this.textFile.setText(new ComptaPropsConfiguration(new Properties(this.props), false, false).getServerIp().substring(5));
        } else {
            int i = serverIp.lastIndexOf(58);
            if (i > 0) {
                this.textIP.setText(serverIp.substring(0, i));
                this.textPort.setText(serverIp.substring(i + 1));
            } else {
                this.textIP.setText(serverIp);
            }
        }
        this.textBase.setText(this.props.getProperty("systemRoot"));
        if (this.getToken() != null) {
            this.textFile.setText("");
        }
    }

    protected void saveConfigFile() {
        block28: {
            System.out.println("Saving:" + this.confFile.getAbsolutePath());
            if (this.confFile.getParentFile() != null) {
                try {
                    FileUtils.mkdir_p(this.confFile.getParentFile());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Impossible de cr\u00e9er le dossier");
                    return;
                }
            }
            if (this.confFile.exists()) {
                if (!this.confFile.isFile()) {
                    JOptionPane.showMessageDialog(null, this.confFile + " n'est pas un fichier valide");
                    return;
                }
                if (!this.confFile.canRead()) {
                    JOptionPane.showMessageDialog(null, "Vous n'avez pas les droits de lire le fichier " + this.confFile);
                    return;
                }
                if (!this.confFile.canWrite()) {
                    JOptionPane.showMessageDialog(null, "Vous n'avez pas les droits de modifier le fichier " + this.confFile);
                    return;
                }
            }
            FileOutputStream out = null;
            try {
                try {
                    String serverIp;
                    ServerFinderConfig config = this.createServerFinderConfig();
                    String serverDriver = config.getSystem().getJDBCName();
                    if (config.getSystem() == SQLSystem.H2) {
                        String filePath;
                        File file = config.getFile();
                        if (file == null) {
                            file = new File("");
                        }
                        if (file.getPath().length() == 0) {
                            filePath = "${data.dir}";
                            if (this.getToken() != null) {
                                JOptionPane.showMessageDialog(null, "Attention. Le dossier de donn\u00e9es n'est pas rempli");
                            }
                        } else {
                            File canonFile = file.getCanonicalFile();
                            File dataDir = config.createConf().getDataDir().getCanonicalFile();
                            filePath = canonFile.getPath().startsWith(dataDir.getPath()) ? "${data.dir}" + canonFile.getPath().substring(dataDir.getPath().length()) : file.getPath();
                        }
                        serverIp = "file:" + filePath + (filePath.endsWith("/") ? "" : "/");
                    } else {
                        String ip = config.getIp();
                        if ((ip == null || ip.trim().length() == 0) && this.getToken() != null) {
                            ip = "127.0.0.1";
                            JOptionPane.showMessageDialog(null, "Attention. L'adresse du serveur n'est pas remplie");
                        }
                        String port = config.getPort().trim();
                        serverIp = String.valueOf(ip) + (port.length() > 0 ? ":" + port : "");
                    }
                    this.props.put("server.driver", serverDriver);
                    this.props.put("server.ip", serverIp);
                    this.props.put("systemRoot", config.getSystemRoot());
                    out = new FileOutputStream(this.confFile);
                    this.props.store(out, ComptaPropsConfiguration.APP_NAME);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Impossible d'\u00e9crire le fichier " + this.confFile + " \n" + e.getLocalizedMessage());
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block28;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        JOptionPane.showMessageDialog(this, "Configuration sauvegard\u00e9e.\n" + this.confFile.getAbsolutePath());
    }

    protected void deleteConfigFile() {
        if (this.confFile.exists()) {
            int ans = JOptionPane.showConfirmDialog(this, "Supprimer le fichier de configuration ?", "Confirmation", 0);
            if (ans == 0 && !this.confFile.delete()) {
                JOptionPane.showMessageDialog(this, "Impossible d'effacer le fichier " + this.confFile, "Erreur", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Rien \u00e0 effacer", null, 1);
        }
    }

    protected boolean setConfigFile(File f) {
        this.confFile = f;
        return this.loadConfigFile();
    }

    private void uiInit() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, c);
        JPanel configurationPanel = this.createPanelConfig();
        JPanel findServerPanel = this.createPanelFinder();
        this.tabbedPane.addTab("Configuration", configurationPanel);
        this.tabbedPane.addTab("Recherche", findServerPanel);
        final ConfigCaissePanel createPanelCaisse = this.createPanelCaisse();
        this.tabbedPane.addTab("Caisse", createPanelCaisse);
        this.tabbedPane.addTab("Installation", new InstallationPanel(this));
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(2, 2, 1));
        buttons.setOpaque(false);
        buttons.add(new JButton(new AbstractAction("Supprimer la configuration"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ServerFinderPanel.this.deleteConfigFile();
            }
        }));
        JButton bSave = new JButton("Enregistrer la configuration");
        bSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerFinderPanel.this.saveConfigFile();
                createPanelCaisse.saveConfiguration();
            }
        });
        buttons.add(bSave);
        c.weighty = 0.0;
        ++c.gridy;
        this.add((Component)buttons, c);
        this.updateUIForMode(ServerFinderConfig.H2);
        this.comboMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerFinderPanel.this.updateUIForMode((SQLSystem)((Object)ServerFinderPanel.this.comboMode.getSelectedItem()));
            }
        });
    }

    private ConfigCaissePanel createPanelCaisse() {
        ConfigCaissePanel configCaissePanel = new ConfigCaissePanel(this);
        configCaissePanel.loadConfiguration();
        return configCaissePanel;
    }

    public void updateUIForMode(SQLSystem mode) {
        if (this.getToken() != null) {
            this.comboMode.setEnabled(false);
            this.comboMode.setSelectedItem((Object)ServerFinderConfig.POSTGRESQL);
            this.textIP.setEnabled(false);
            this.textPort.setEnabled(false);
            this.textFile.setEnabled(false);
            this.buttonDir.setEnabled(false);
        } else {
            this.comboMode.setEnabled(true);
            if (mode.equals((Object)ServerFinderConfig.H2)) {
                this.comboMode.setSelectedItem((Object)ServerFinderConfig.H2);
                this.textIP.setEnabled(false);
                this.textPort.setEnabled(false);
                this.textFile.setEnabled(true);
                this.buttonDir.setEnabled(true);
            } else if (mode.equals((Object)ServerFinderConfig.MYSQL)) {
                this.comboMode.setSelectedItem((Object)ServerFinderConfig.MYSQL);
                this.textIP.setEnabled(true);
                this.textPort.setEnabled(true);
                this.textFile.setEnabled(false);
                this.buttonDir.setEnabled(false);
            } else if (mode.equals((Object)ServerFinderConfig.POSTGRESQL)) {
                this.comboMode.setSelectedItem((Object)ServerFinderConfig.POSTGRESQL);
                this.textIP.setEnabled(true);
                this.textPort.setEnabled(true);
                this.textFile.setEnabled(false);
                this.buttonDir.setEnabled(false);
            } else {
                throw new IllegalArgumentException((Object)((Object)mode) + " is not a valid access mode");
            }
        }
    }

    private JPanel createPanelConfig() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 0.0;
        p.add((Component)new JLabel("Fichier de configuration", 4), c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.textMainProperties = new JTextField("");
        this.textMainProperties.setEditable(false);
        p.add((Component)this.textMainProperties, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        p.add((Component)new JLabel("Type", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        this.comboMode = new JComboBox<SQLSystem>(new SQLSystem[]{ServerFinderConfig.H2, ServerFinderConfig.POSTGRESQL, ServerFinderConfig.MYSQL});
        this.comboMode.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, ((SQLSystem)((Object)value)).getLabel(), index, isSelected, cellHasFocus);
            }
        });
        p.add((Component)this.comboMode, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 2;
        p.add((Component)new JLabel("Adresse du serveur", 4), c);
        ++c.gridx;
        c.weighty = 0.0;
        this.textIP = new JTextField(20);
        p.add((Component)this.textIP, c);
        ++c.gridx;
        c.weightx = 0.0;
        p.add((Component)new JLabel("port", 4), c);
        ++c.gridx;
        c.weighty = 0.0;
        this.textPort = new JTextField(5);
        p.add((Component)this.textPort, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        p.add((Component)new JLabel("Base de donn\u00e9es", 4), c);
        ++c.gridx;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.textBase = new JTextField();
        this.textBase.setEditable(false);
        p.add((Component)this.textBase, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        p.add((Component)new JLabel("Dossier de base de donn\u00e9es", 4), c);
        ++c.gridx;
        c.weighty = 0.0;
        c.gridwidth = 2;
        this.textFile = new JTextField();
        this.textFile.setEditable(false);
        p.add((Component)this.textFile, c);
        c.gridx += 2;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.buttonDir = new JButton("S\u00e9lectionner");
        this.buttonDir.setOpaque(false);
        this.buttonDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal;
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(1);
                File oldDir = new File(ServerFinderPanel.this.textFile.getText());
                if (oldDir.exists() && oldDir.isDirectory()) {
                    fc.setCurrentDirectory(oldDir);
                }
                if ((returnVal = fc.showOpenDialog(ServerFinderPanel.this)) == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        ServerFinderPanel.this.textFile.setText(file.getCanonicalPath());
                    }
                    catch (IOException e1) {
                        ServerFinderPanel.this.textFile.setText(file.getAbsolutePath());
                        e1.printStackTrace();
                    }
                }
            }
        });
        p.add((Component)this.buttonDir, c);
        c.gridx = 1;
        ++c.gridy;
        final JButton buttonTest = new JButton("Tester la connexion");
        buttonTest.setOpaque(false);
        buttonTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                buttonTest.setEnabled(false);
                SwingWorker<String, Void> worker = new SwingWorker<String, Void>(){

                    @Override
                    public String doInBackground() {
                        ServerFinderConfig conf = ServerFinderPanel.this.createServerFinderConfig();
                        System.out.println("Testing:" + conf);
                        String test = conf.test();
                        test = test.replace("(", "\n(");
                        System.out.println(test);
                        return test;
                    }

                    @Override
                    public void done() {
                        buttonTest.setEnabled(true);
                        try {
                            String r = (String)this.get();
                            JOptionPane.showMessageDialog(ServerFinderPanel.this, r);
                        }
                        catch (InterruptedException r) {
                        }
                        catch (ExecutionException e) {
                            e.printStackTrace();
                            JOptionPane.showMessageDialog(ServerFinderPanel.this, e.getMessage());
                        }
                    }
                };
                worker.execute();
            }
        });
        c.fill = 0;
        p.add((Component)buttonTest, c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        spacer.setPreferredSize(new Dimension(10, 200));
        p.add((Component)spacer, c);
        return p;
    }

    private JPanel createPanelFinder() {
        JPanel p = new JPanel();
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        p.setLayout(new GridBagLayout());
        final JProgressBar bar = new JProgressBar(0, 100);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        p.add((Component)bar, c);
        final JButton searchButton = new JButton("Rechercher");
        searchButton.setOpaque(false);
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                searchButton.setEnabled(false);
                searchButton.setText("Recherche en cours...");
                bar.setValue(0);
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    public Void doInBackground() {
                        try {
                            ServerFinderPanel.this.dataModel.startScan(new PropertyChangeListener(){

                                @Override
                                public void propertyChange(PropertyChangeEvent evt) {
                                    final int i = (Integer)evt.getNewValue();
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            bar.setValue(i);
                                        }
                                    });
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return null;
                    }

                    @Override
                    public void done() {
                        bar.setValue(100);
                        searchButton.setEnabled(true);
                        searchButton.setText("Rechercher");
                    }
                };
                worker.execute();
            }
        });
        c.weightx = 0.0;
        ++c.gridx;
        p.add((Component)searchButton, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weightx = 1.0;
        p.add((Component)new JLabel("Bases de donn\u00e9es disponibles:"), c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        this.dataModel = new ServerConfigListModel();
        final JList l = new JList(this.dataModel);
        l.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel p = new JPanel();
                if (!isSelected) {
                    p.setBackground(list.getBackground());
                    p.setForeground(list.getForeground());
                } else {
                    p.setBackground(list.getSelectionBackground());
                    p.setForeground(list.getSelectionForeground());
                }
                p.setLayout(new VFlowLayout());
                ServerFinderConfig c = (ServerFinderConfig)value;
                String label = !c.getType().equals((Object)ServerFinderConfig.H2) ? String.valueOf(c.getIp()) + ":" + c.getPort() + " " + (Object)((Object)c.getType()) : String.valueOf(c.getFile().getAbsolutePath()) + " " + (Object)((Object)c.getType());
                JLabelBold l1 = new JLabelBold(label);
                l1.setOpaque(false);
                p.add(l1);
                JLabel l2 = new JLabel(c.getProduct() == null ? "Connexion impossible" : c.getProduct());
                l2.setOpaque(false);
                p.add(l2);
                JLabel l3 = new JLabel(c.getError() == null ? "Serveur op\u00e9rationnel" : c.getError());
                l3.setOpaque(false);
                p.add(l3);
                l1.setForeground(p.getForeground());
                l2.setForeground(p.getForeground());
                l3.setForeground(p.getForeground());
                return p;
            }
        });
        l.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    ServerFinderPanel.this.useSelectedConfig(l);
                }
            }
        });
        l.setSelectionMode(0);
        l.setBorder(BorderFactory.createEtchedBorder());
        final JButton buttonSelect = new JButton("Utiliser ce serveur");
        buttonSelect.setOpaque(false);
        buttonSelect.setEnabled(false);
        buttonSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerFinderPanel.this.useSelectedConfig(l);
            }
        });
        l.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Object sel = l.getSelectedValue();
                    System.err.println(sel + " " + ((ServerFinderConfig)sel).getError());
                    buttonSelect.setEnabled(sel != null);
                }
            }
        });
        p.add(l, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.weighty = 0.0;
        p.add((Component)buttonSelect, c);
        p.setOpaque(false);
        return p;
    }

    public ServerFinderConfig getServerConfig() {
        return this.createServerFinderConfig();
    }

    private void useSelectedConfig(JList l) {
        Object sel = l.getSelectedValue();
        if (sel != null) {
            ServerFinderConfig config = (ServerFinderConfig)sel;
            this.textIP.setText(config.getIp());
            this.textPort.setText(String.valueOf(config.getPort()));
            if (config.getType().equals((Object)ServerFinderConfig.H2)) {
                this.textIP.setText("");
                this.textPort.setText("");
                this.textFile.setText(config.getFile().getAbsolutePath());
            } else {
                this.textIP.setText(config.getIp());
                this.textPort.setText(String.valueOf(config.getPort()));
            }
            this.updateUIForMode(config.getType());
            this.tabbedPane.setSelectedIndex(0);
            if (((ServerFinderConfig)sel).getError() != null) {
                JOptionPane.showMessageDialog(this, "Attention. Ce serveur n'est pas configur\u00e9 correctement.");
            }
        }
    }

    public ServerFinderConfig createServerFinderConfig() {
        ServerFinderConfig conf = new ServerFinderConfig(this.props);
        conf.setType((SQLSystem)((Object)this.comboMode.getSelectedItem()));
        conf.setSystemRoot(this.textBase.getText());
        if (!conf.getType().equals((Object)ServerFinderConfig.H2)) {
            conf.resetFile();
            conf.setIp(this.textIP.getText());
            conf.setPort(this.textPort.getText());
        } else {
            File file = new File(this.textFile.getText());
            conf.setFile(file);
            conf.setIp("");
            conf.setPort("");
        }
        return conf;
    }

    public String getToken() {
        String property = this.props.getProperty("token");
        if (property != null && property.length() < 20) {
            return null;
        }
        return property;
    }

    public void setToken(String token) {
        if (token == null) {
            this.props.remove("token");
        } else {
            this.props.setProperty("token", token);
        }
    }
}

