/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.openconcerto.erp.action.AboutAction;
import org.openconcerto.erp.action.AstuceAction;
import org.openconcerto.erp.action.GestionDroitsAction;
import org.openconcerto.erp.action.ListeBanqueAction;
import org.openconcerto.erp.action.NouvelleSocieteAction;
import org.openconcerto.erp.action.PreferencesAction;
import org.openconcerto.erp.action.SauvegardeBaseAction;
import org.openconcerto.erp.action.TaskAdminAction;
import org.openconcerto.erp.action.list.ListeDesSocietesCommonsAction;
import org.openconcerto.erp.action.list.ListeDesUsersCommonAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.config.MainFrame;
import org.openconcerto.erp.config.MenuAndActions;
import org.openconcerto.erp.config.MenuConfiguration;
import org.openconcerto.erp.core.customerrelationship.customer.action.ListeDesClientsAction;
import org.openconcerto.erp.core.customerrelationship.customer.action.ListeDesContactsAction;
import org.openconcerto.erp.core.customerrelationship.customer.action.ListeDesDepartementsClientsAction;
import org.openconcerto.erp.core.customerrelationship.customer.action.NouvelHistoriqueListeClientAction;
import org.openconcerto.erp.core.finance.accounting.action.BalanceAgeeAction;
import org.openconcerto.erp.core.finance.accounting.action.CompteResultatBilanAction;
import org.openconcerto.erp.core.finance.accounting.action.EtatBalanceAction;
import org.openconcerto.erp.core.finance.accounting.action.EtatChargeAction;
import org.openconcerto.erp.core.finance.accounting.action.EtatGrandLivreAction;
import org.openconcerto.erp.core.finance.accounting.action.EtatJournauxAction;
import org.openconcerto.erp.core.finance.accounting.action.ExportRelationExpertAction;
import org.openconcerto.erp.core.finance.accounting.action.GestionPlanComptableEAction;
import org.openconcerto.erp.core.finance.accounting.action.ImportEcritureAction;
import org.openconcerto.erp.core.finance.accounting.action.ImpressionJournauxAnalytiqueAction;
import org.openconcerto.erp.core.finance.accounting.action.ImpressionLivrePayeAction;
import org.openconcerto.erp.core.finance.accounting.action.ImpressionRepartitionAnalytiqueAction;
import org.openconcerto.erp.core.finance.accounting.action.ListeDesDevisesAction;
import org.openconcerto.erp.core.finance.accounting.action.ListeDesEcrituresAction;
import org.openconcerto.erp.core.finance.accounting.action.ListeDesEcrituresAnalytiquesAction;
import org.openconcerto.erp.core.finance.accounting.action.ListeDesJournauxAction;
import org.openconcerto.erp.core.finance.accounting.action.ListeDesPostesAnalytiquesAction;
import org.openconcerto.erp.core.finance.accounting.action.ListeDesTauxDeChangeAction;
import org.openconcerto.erp.core.finance.accounting.action.ListeEcritureParClasseAction;
import org.openconcerto.erp.core.finance.accounting.action.NouveauClotureAction;
import org.openconcerto.erp.core.finance.accounting.action.NouveauLettrageAction;
import org.openconcerto.erp.core.finance.accounting.action.NouveauPointageAction;
import org.openconcerto.erp.core.finance.accounting.action.NouvelleValidationAction;
import org.openconcerto.erp.core.finance.payment.action.ListeDesChequesAEncaisserAction;
import org.openconcerto.erp.core.finance.payment.action.ListeDesChequesAvoirAction;
import org.openconcerto.erp.core.finance.payment.action.ListeDesChequesFournisseursAction;
import org.openconcerto.erp.core.finance.payment.action.ListeDesEncaissementsAction;
import org.openconcerto.erp.core.finance.payment.action.ListeDesRelancesAction;
import org.openconcerto.erp.core.finance.payment.action.ListeDesTraitesFournisseursAction;
import org.openconcerto.erp.core.finance.payment.action.NouveauDecaissementChequeAvoirAction;
import org.openconcerto.erp.core.finance.payment.action.NouveauListeDesChequesADecaisserAction;
import org.openconcerto.erp.core.finance.payment.action.NouveauListeDesChequesAEncaisserAction;
import org.openconcerto.erp.core.humanresources.ListeDesContactsAdministratif;
import org.openconcerto.erp.core.humanresources.employe.action.ListeDesCommerciauxAction;
import org.openconcerto.erp.core.humanresources.employe.action.ListeDesSalariesAction;
import org.openconcerto.erp.core.humanresources.employe.action.N4DSAction;
import org.openconcerto.erp.core.humanresources.payroll.action.ClotureMensuellePayeAction;
import org.openconcerto.erp.core.humanresources.payroll.action.EditionFichePayeAction;
import org.openconcerto.erp.core.humanresources.payroll.action.ListeDesProfilsPayeAction;
import org.openconcerto.erp.core.humanresources.payroll.action.ListeDesRubriquesDePayeAction;
import org.openconcerto.erp.core.humanresources.payroll.action.ListeDesVariablesPayes;
import org.openconcerto.erp.core.humanresources.payroll.action.NouvelAcompteAction;
import org.openconcerto.erp.core.humanresources.payroll.action.NouvelHistoriqueFichePayeAction;
import org.openconcerto.erp.core.humanresources.payroll.action.NouvelleSaisieKmAction;
import org.openconcerto.erp.core.reports.stat.action.EvolutionCAAction;
import org.openconcerto.erp.core.reports.stat.action.EvolutionCACumulAction;
import org.openconcerto.erp.core.reports.stat.action.EvolutionCmdAction;
import org.openconcerto.erp.core.reports.stat.action.EvolutionCmdCumulAction;
import org.openconcerto.erp.core.reports.stat.action.EvolutionMargeAction;
import org.openconcerto.erp.core.reports.stat.action.VenteArticleFamilleGraphAction;
import org.openconcerto.erp.core.reports.stat.action.VenteArticleGraphAction;
import org.openconcerto.erp.core.reports.stat.action.VenteArticleMargeGraphAction;
import org.openconcerto.erp.core.sales.credit.action.ListeDesAvoirsClientsAction;
import org.openconcerto.erp.core.sales.credit.action.NouveauAvoirClientAction;
import org.openconcerto.erp.core.sales.invoice.action.EtatVenteAction;
import org.openconcerto.erp.core.sales.invoice.action.GenListeVenteAction;
import org.openconcerto.erp.core.sales.invoice.action.ListeDebiteursAction;
import org.openconcerto.erp.core.sales.invoice.action.ListeDesVentesAction;
import org.openconcerto.erp.core.sales.invoice.action.ListeSaisieVenteFactureAction;
import org.openconcerto.erp.core.sales.invoice.action.ListesFacturesClientsImpayeesAction;
import org.openconcerto.erp.core.sales.invoice.action.NouveauSaisieVenteComptoirAction;
import org.openconcerto.erp.core.sales.invoice.action.NouveauSaisieVenteFactureAction;
import org.openconcerto.erp.core.sales.order.action.ListeDesCommandesClientAction;
import org.openconcerto.erp.core.sales.order.action.NouvelleCommandeClientAction;
import org.openconcerto.erp.core.sales.pos.action.ListeDesCaissesTicketAction;
import org.openconcerto.erp.core.sales.product.action.ListeDesArticlesAction;
import org.openconcerto.erp.core.sales.quote.action.ListeDesDevisAction;
import org.openconcerto.erp.core.sales.quote.action.NouveauDevisAction;
import org.openconcerto.erp.core.sales.shipment.action.ListeDesBonsDeLivraisonAction;
import org.openconcerto.erp.core.sales.shipment.action.NouveauBonLivraisonAction;
import org.openconcerto.erp.core.supplychain.credit.action.ListeDesAvoirsFournisseurAction;
import org.openconcerto.erp.core.supplychain.credit.action.NouvelAvoirFournisseurAction;
import org.openconcerto.erp.core.supplychain.order.action.ListeDesCommandesAction;
import org.openconcerto.erp.core.supplychain.order.action.ListeDesFacturesFournisseurAction;
import org.openconcerto.erp.core.supplychain.order.action.ListeSaisieAchatAction;
import org.openconcerto.erp.core.supplychain.order.action.NouveauSaisieAchatAction;
import org.openconcerto.erp.core.supplychain.order.action.NouvelleCommandeAction;
import org.openconcerto.erp.core.supplychain.order.action.NouvelleFactureFournisseurAction;
import org.openconcerto.erp.core.supplychain.product.action.ListeDesArticlesFournisseurAction;
import org.openconcerto.erp.core.supplychain.receipt.action.ListeDesBonsReceptionsAction;
import org.openconcerto.erp.core.supplychain.receipt.action.ListeDesReliquatsBonsReceptionsAction;
import org.openconcerto.erp.core.supplychain.receipt.action.NouveauBonReceptionAction;
import org.openconcerto.erp.core.supplychain.stock.action.ListeDesMouvementsStockAction;
import org.openconcerto.erp.core.supplychain.stock.action.NouvelleSaisieMouvementStockAction;
import org.openconcerto.erp.core.supplychain.supplier.action.ListeDesContactsFournisseursAction;
import org.openconcerto.erp.core.supplychain.supplier.action.ListeDesFournisseursAction;
import org.openconcerto.erp.core.supplychain.supplier.action.ListesFacturesFournImpayeesAction;
import org.openconcerto.erp.core.supplychain.supplier.action.NouvelHistoriqueListeFournAction;
import org.openconcerto.erp.modules.ModuleFrame;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionClientPreferencePanel;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.erp.rights.NXRights;
import org.openconcerto.erp.utils.correct.CorrectMouvement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.LayoutHints;

public class DefaultMenuConfiguration
implements MenuConfiguration {
    public void registerMenuTranslations() {
    }

    @Override
    public final MenuAndActions createMenuAndActions() {
        MenuAndActions res = new MenuAndActions();
        this.createMenuGroup(res.getGroup());
        this.registerMenuActions(res);
        return res;
    }

    private void createMenuGroup(Group mGroup) {
        UserRights rights = UserManager.getInstance().getCurrentUser().getRights();
        ComptaPropsConfiguration configuration = ComptaPropsConfiguration.getInstanceCompta();
        mGroup.add(this.createFilesMenuGroup());
        mGroup.add(this.createCreationMenuGroup());
        mGroup.add(this.createListMenuGroup());
        if (rights.haveRight(ComptaUserRight.MENU)) {
            mGroup.add(this.createAccountingMenuGroup());
            mGroup.add(this.createStatsDocumentsGroup());
        }
        if (rights.haveRight(NXRights.ACCES_MENU_STAT.getCode())) {
            mGroup.add(this.createStatsMenuGroup());
        }
        mGroup.add(this.createPaymentMenuGroup());
        if (rights.haveRight(NXRights.LOCK_MENU_PAYE.getCode())) {
            mGroup.add(this.createPayrollMenuGroup());
        }
        if (rights.haveRight(NXRights.ACCES_MENU_STRUCTURE.getCode())) {
            mGroup.add(this.createOrganizationMenuGroup());
        }
        mGroup.add(this.createHelpMenuGroup());
        if (rights.haveRight(NXRights.LOCK_MENU_TEST.getCode())) {
            mGroup.add(this.createTestMenuGroup());
        }
    }

    public void registerMenuActions(MenuAndActions ma) {
        this.registerFilesMenuActions(ma);
        this.registerCreationMenuActions(ma);
        this.registerListMenuActions(ma);
        this.registerAccountingMenuActions(ma);
        this.registerStatsDocumentsActions(ma);
        this.registerStatsMenuActions(ma);
        this.registerPaymentMenuActions(ma);
        this.registerPayrollMenuActions(ma);
        this.registerOrganizationMenuActions(ma);
        this.registerHelpMenuActions(ma);
        this.registerHelpTestActions(ma);
    }

    private Group createFilesMenuGroup() {
        Group group = new Group("menu.file");
        if (UserRightsManager.getCurrentUserRights().haveRight("BACKUP")) {
            group.addItem("backup");
        }
        group.addItem("modules");
        if (!Gestion.MAC_OS_X) {
            group.addItem("preferences");
            group.addItem("quit");
        }
        return group;
    }

    private Group createCreationMenuGroup() {
        Group group = new Group("menu.create");
        ComptaPropsConfiguration configuration = ComptaPropsConfiguration.getInstanceCompta();
        Boolean bModeVenteComptoir = DefaultNXProps.getInstance().getBooleanValue("ArticleVenteComptoir", true);
        UserRights rights = UserManager.getInstance().getCurrentUser().getRights();
        Group accountingGroup = new Group("accounting");
        if (rights.haveRight(ComptaUserRight.MENU)) {
            accountingGroup.addItem("accounting.entry.create");
        }
        group.add(accountingGroup);
        Group customerGroup = new Group("customer", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        customerGroup.addItem("customer.quote.create");
        customerGroup.addItem("customer.delivery.create");
        customerGroup.addItem("customer.order.create");
        if (bModeVenteComptoir.booleanValue() && rights.haveRight("VENTE_COMPTOIR")) {
            customerGroup.addItem("pos.sale.create");
        }
        customerGroup.addItem("customer.invoice.create");
        customerGroup.addItem("customer.credit.create");
        group.add(customerGroup);
        Group supplierGroup = new Group("supplier", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        group.add(supplierGroup);
        if (rights.haveRight(NXRights.LOCK_MENU_ACHAT.getCode())) {
            supplierGroup.addItem("supplier.order.create");
            supplierGroup.addItem("supplier.receipt.create");
            supplierGroup.addItem("supplier.purchase.create");
            supplierGroup.addItem("supplier.invoice.purchase.create");
            supplierGroup.addItem("supplier.credit.create");
            group.addItem("stock.io.create");
        }
        return group;
    }

    private Group createHelpMenuGroup() {
        Group group = new Group("menu.help");
        group.addItem("information");
        group.addItem("tips");
        return group;
    }

    private Group createOrganizationMenuGroup() {
        Group group = new Group("menu.organization");
        UserRights rights = UserManager.getInstance().getCurrentUser().getRights();
        ComptaPropsConfiguration configuration = ComptaPropsConfiguration.getInstanceCompta();
        if (rights.haveRight(ComptaUserRight.MENU)) {
            Group gAccounting = new Group("menu.organization.accounting", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
            gAccounting.addItem("accounting.chart");
            gAccounting.addItem("accounting.journal");
            gAccounting.addItem("accounting.checkDB");
            gAccounting.addItem("accounting.currency");
            gAccounting.addItem("accounting.currency.rates");
            group.add(gAccounting);
        }
        if (rights.haveRight("LOCK_MENU_ADMIN")) {
            Group gUser = new Group("menu.organization.user", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
            gUser.addItem("user.list");
            gUser.addItem("user.right.list");
            gUser.addItem("user.task.right");
            group.add(gUser);
        }
        group.addItem("office.contact.list");
        group.addItem("salesman.list");
        Group gPos = new Group("menu.organization.pos", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        gPos.addItem("pos.list");
        group.add(gPos);
        group.addItem("enterprise.list");
        group.addItem("divison.bank.list");
        group.addItem("enterprise.create");
        return group;
    }

    private Group createPayrollMenuGroup() {
        Group group = new Group("menu.payroll");
        group.addItem("payroll.list.report.print");
        group.addItem("payroll.profile.list");
        group.addItem("payroll.history");
        group.addItem("payroll.create");
        group.addItem("payroll.deposit.create");
        group.addItem("employee.list");
        Group groupConfig = new Group("menu.payroll.config", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        groupConfig.addItem("payroll.section");
        groupConfig.addItem("payroll.variable");
        group.add(groupConfig);
        group.addItem("payroll.closing");
        return group;
    }

    public Group createPaymentMenuGroup() {
        Group group = new Group("menu.payment");
        UserRights rights = UserManager.getInstance().getCurrentUser().getRights();
        if (rights.haveRight(ComptaUserRight.MENU) || rights.haveRight(ComptaUserRight.POINTAGE_LETTRAGE)) {
            group.addItem("payment.checking.create");
            group.addItem("payment.reconciliation.create");
        }
        if (rights.haveRight(NXRights.GESTION_ENCAISSEMENT.getCode())) {
            Group gCustomer = new Group("menu.payment.customer");
            gCustomer.addItem("customer.invoice.unpaid.list");
            gCustomer.addItem("customer.dept.list");
            gCustomer.addItem("customer.payment.list");
            gCustomer.addItem("customer.payment.followup.list");
            gCustomer.addItem("customer.payment.check.pending.list");
            gCustomer.addItem("customer.payment.check.pending.create");
            gCustomer.addItem("customer.credit.check.list");
            gCustomer.addItem("customer.credit.check.create");
            group.add(gCustomer);
        }
        if (rights.haveRight(NXRights.LOCK_MENU_ACHAT.getCode())) {
            Group gSupplier = new Group("menu.payment.supplier");
            gSupplier.addItem("supplier.invoice.unpaid.list");
            gSupplier.addItem("supplier.bill.list");
            gSupplier.addItem("supplier.payment.check.list");
            gSupplier.addItem("supplier.payment.check.pending.list");
            group.add(gSupplier);
        }
        return group;
    }

    public Group createStatsMenuGroup() {
        Group group = new Group("menu.stats");
        ComptaPropsConfiguration configuration = ComptaPropsConfiguration.getInstanceCompta();
        group.addItem("sales.graph");
        group.addItem("sales.graph.cumulate");
        group.addItem("sales.graph.cmd");
        group.addItem("sales.graph.cmd.cumulate");
        group.addItem("sales.margin.graph");
        group.addItem("sales.list.report");
        group.addItem("sales.product.graph");
        group.addItem("sales.product.margin.graph");
        group.addItem("sales.product.family.graph");
        group.addItem("sales.list.graph");
        return group;
    }

    public Group createStatsDocumentsGroup() {
        Group group = new Group("menu.report");
        group.addItem("accounting.costs.report");
        group.addItem("accounting.balance.report");
        group.addItem("employe.social.report");
        return group;
    }

    public Group createAccountingMenuGroup() {
        Group group = new Group("menu.accounting");
        group.addItem("accounting.balance");
        group.addItem("accounting.client.balance");
        group.addItem("accounting.ledger");
        Group analytic = new Group("accounting.analytical");
        analytic.addItem("accounting.analytical.ledger");
        analytic.addItem("accounting.analytical.entries.ledger");
        analytic.addItem("accounting.analytical.ledger.global");
        analytic.addItem("accounting.analytical.dpt");
        group.add(analytic);
        group.addItem("accounting.general.ledger");
        group.addItem("accounting.entries.ledger");
        group.addItem("accounting.entries.list");
        Group gIO = new Group("menu.accounting.io", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        gIO.addItem("accounting.import");
        gIO.addItem("accounting.export");
        group.add(gIO);
        Group gClosing = new Group("menu.accounting.closing", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        gClosing.addItem("accounting.validating");
        gClosing.addItem("accounting.closing");
        group.add(gClosing);
        return group;
    }

    private Group createListMenuGroup() {
        Group group = new Group("menu.list");
        Boolean bModeVenteComptoir = DefaultNXProps.getInstance().getBooleanValue("ArticleVenteComptoir", true);
        ComptaPropsConfiguration configuration = ComptaPropsConfiguration.getInstanceCompta();
        UserRights rights = UserManager.getInstance().getCurrentUser().getRights();
        Group gCustomer = new Group("menu.list.customer", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        gCustomer.addItem("customer.list");
        SQLPreferences prefs = SQLPreferences.getMemCached(configuration.getRootSociete());
        if (prefs.getBoolean(GestionClientPreferencePanel.DISPLAY_CLIENT_DPT, false)) {
            gCustomer.addItem("customer.department.list");
        }
        gCustomer.addItem("contact.list");
        if (rights.haveRight(NXRights.ACCES_HISTORIQUE.getCode())) {
            gCustomer.addItem("customer.history");
        }
        gCustomer.addItem("customer.quote.list");
        gCustomer.addItem("customer.order.list");
        gCustomer.addItem("customer.delivery.list");
        group.add(gCustomer);
        boolean useListDesVentesAction = bModeVenteComptoir;
        if (useListDesVentesAction) {
            gCustomer.addItem("sales.list");
        } else {
            gCustomer.addItem("customer.invoice.list");
        }
        gCustomer.addItem("customer.credit.list");
        Group gSupplier = new Group("menu.list.supplier", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        gSupplier.addItem("supplier.list");
        gSupplier.addItem("supplier.contact.list");
        gSupplier.addItem("supplier.history");
        if (rights.haveRight(NXRights.LOCK_MENU_ACHAT.getCode())) {
            gSupplier.addItem("supplier.order.list");
            gSupplier.addItem("supplier.receipt.list");
            if (configuration.getRootSociete().contains("RELIQUAT_BR")) {
                gSupplier.addItem("supplier.receipt.reliquat.list");
            }
            gSupplier.addItem("supplier.purchase.list");
            gSupplier.addItem("supplier.invoice.purchase.list");
            gSupplier.addItem("supplier.credit.list");
        }
        group.add(gSupplier);
        Group gProduct = new Group("menu.list.product", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        gProduct.addItem("product.list");
        gProduct.addItem("stock.io.list");
        group.add(gProduct);
        return group;
    }

    private Group createTestMenuGroup() {
        Group group = new Group("menu.test");
        group.addItem("test.lettrage.fact");
        group.addItem("test.lettrage.compt");
        group.addItem("test.lettrage.achat");
        return group;
    }

    private void registerFilesMenuActions(MenuAndActions mManager) {
        mManager.registerAction("backup", (Action)new SauvegardeBaseAction());
        mManager.registerAction("modules", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameUtil.show(ModuleFrame.getInstance());
            }
        });
        if (!Gestion.MAC_OS_X) {
            mManager.registerAction("preferences", (Action)new PreferencesAction());
            mManager.registerAction("quit", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.getInstance().quit();
                }
            });
        }
    }

    private void registerCreationMenuActions(MenuAndActions mManager) {
        Boolean bModeVenteComptoir = DefaultNXProps.getInstance().getBooleanValue("ArticleVenteComptoir", true);
        UserRights rights = UserManager.getInstance().getCurrentUser().getRights();
        ComptaPropsConfiguration configuration = ComptaPropsConfiguration.getInstanceCompta();
        if (rights.haveRight(ComptaUserRight.MENU)) {
            mManager.registerAction("accounting.entry.create", (Action)((Object)new NouvelleSaisieKmAction()));
        }
        mManager.registerAction("customer.quote.create", (Action)((Object)new NouveauDevisAction()));
        mManager.registerAction("customer.delivery.create", (Action)((Object)new NouveauBonLivraisonAction()));
        mManager.registerAction("customer.order.create", (Action)((Object)new NouvelleCommandeClientAction()));
        if (bModeVenteComptoir.booleanValue() && rights.haveRight("VENTE_COMPTOIR")) {
            mManager.registerAction("pos.sale.create", (Action)((Object)new NouveauSaisieVenteComptoirAction()));
        }
        mManager.registerAction("customer.invoice.create", (Action)((Object)new NouveauSaisieVenteFactureAction()));
        mManager.registerAction("customer.credit.create", (Action)((Object)new NouveauAvoirClientAction()));
        if (rights.haveRight(NXRights.LOCK_MENU_ACHAT.getCode())) {
            mManager.registerAction("supplier.order.create", (Action)((Object)new NouvelleCommandeAction()));
            mManager.registerAction("supplier.receipt.create", (Action)((Object)new NouveauBonReceptionAction()));
            mManager.registerAction("supplier.purchase.create", (Action)((Object)new NouveauSaisieAchatAction()));
            mManager.registerAction("supplier.invoice.purchase.create", (Action)((Object)new NouvelleFactureFournisseurAction()));
            mManager.registerAction("supplier.credit.create", (Action)((Object)new NouvelAvoirFournisseurAction()));
            mManager.registerAction("stock.io.create", (Action)((Object)new NouvelleSaisieMouvementStockAction()));
        }
    }

    private void registerListMenuActions(MenuAndActions mManager) {
        Boolean bModeVenteComptoir = DefaultNXProps.getInstance().getBooleanValue("ArticleVenteComptoir", true);
        ComptaPropsConfiguration configuration = ComptaPropsConfiguration.getInstanceCompta();
        UserRights rights = UserManager.getInstance().getCurrentUser().getRights();
        mManager.registerAction("customer.list", (Action)((Object)new ListeDesClientsAction()));
        SQLPreferences prefs = SQLPreferences.getMemCached(configuration.getRootSociete());
        if (prefs.getBoolean(GestionClientPreferencePanel.DISPLAY_CLIENT_DPT, false)) {
            mManager.registerAction("customer.department.list", (Action)((Object)new ListeDesDepartementsClientsAction()));
        }
        mManager.registerAction("contact.list", (Action)((Object)new ListeDesContactsAction()));
        if (rights.haveRight(NXRights.ACCES_HISTORIQUE.getCode())) {
            mManager.registerAction("customer.history", (Action)((Object)new NouvelHistoriqueListeClientAction()));
        }
        mManager.registerAction("customer.quote.list", (Action)((Object)new ListeDesDevisAction()));
        mManager.registerAction("customer.order.list", (Action)((Object)new ListeDesCommandesClientAction()));
        mManager.registerAction("customer.delivery.list", (Action)((Object)new ListeDesBonsDeLivraisonAction()));
        boolean useListDesVentesAction = bModeVenteComptoir;
        if (useListDesVentesAction) {
            mManager.registerAction("sales.list", (Action)((Object)new ListeDesVentesAction()));
        } else {
            mManager.registerAction("customer.invoice.list", (Action)((Object)new ListeSaisieVenteFactureAction()));
        }
        mManager.registerAction("customer.credit.list", (Action)((Object)new ListeDesAvoirsClientsAction()));
        mManager.registerAction("supplier.list", (Action)((Object)new ListeDesFournisseursAction()));
        mManager.registerAction("supplier.contact.list", (Action)((Object)new ListeDesContactsFournisseursAction()));
        mManager.registerAction("supplier.history", (Action)((Object)new NouvelHistoriqueListeFournAction()));
        if (rights.haveRight(NXRights.LOCK_MENU_ACHAT.getCode())) {
            mManager.registerAction("supplier.order.list", (Action)((Object)new ListeDesCommandesAction()));
            mManager.registerAction("supplier.receipt.reliquat.list", (Action)((Object)new ListeDesReliquatsBonsReceptionsAction()));
            mManager.registerAction("supplier.receipt.list", (Action)((Object)new ListeDesBonsReceptionsAction()));
            mManager.registerAction("supplier.purchase.list", (Action)((Object)new ListeSaisieAchatAction()));
            mManager.registerAction("supplier.invoice.purchase.list", (Action)((Object)new ListeDesFacturesFournisseurAction()));
            mManager.registerAction("supplier.credit.list", (Action)((Object)new ListeDesAvoirsFournisseurAction()));
        }
        mManager.registerAction("product.list", (Action)((Object)new ListeDesArticlesAction()));
        mManager.registerAction("product.supplychain.list", (Action)((Object)new ListeDesArticlesFournisseurAction()));
        mManager.registerAction("stock.io.list", (Action)((Object)new ListeDesMouvementsStockAction()));
    }

    public void registerAccountingMenuActions(MenuAndActions mManager) {
        mManager.registerAction("accounting.balance", (Action)((Object)new EtatBalanceAction()));
        mManager.registerAction("accounting.client.balance", (Action)((Object)new BalanceAgeeAction()));
        mManager.registerAction("accounting.analytical.ledger", (Action)((Object)new ImpressionJournauxAnalytiqueAction()));
        mManager.registerAction("accounting.ledger", (Action)((Object)new EtatJournauxAction()));
        mManager.registerAction("accounting.general.ledger", (Action)((Object)new EtatGrandLivreAction()));
        mManager.registerAction("accounting.entries.ledger", (Action)((Object)new ListeDesEcrituresAction()));
        mManager.registerAction("accounting.analytical.entries.ledger", (Action)((Object)new ListeDesEcrituresAnalytiquesAction()));
        mManager.registerAction("accounting.analytical.dpt", (Action)((Object)new ListeDesPostesAnalytiquesAction()));
        mManager.registerAction("accounting.analytical.ledger.global", (Action)((Object)new ImpressionRepartitionAnalytiqueAction()));
        mManager.registerAction("accounting.entries.list", (Action)((Object)new ListeEcritureParClasseAction()));
        mManager.registerAction("accounting.validating", (Action)((Object)new NouvelleValidationAction()));
        mManager.registerAction("accounting.closing", (Action)((Object)new NouveauClotureAction()));
        mManager.registerAction("accounting.import", new ImportEcritureAction());
        mManager.registerAction("accounting.export", (Action)((Object)new ExportRelationExpertAction()));
    }

    public void registerStatsDocumentsActions(MenuAndActions mManager) {
        mManager.registerAction("accounting.costs.report", (Action)((Object)new EtatChargeAction()));
        mManager.registerAction("accounting.balance.report", (Action)((Object)new CompteResultatBilanAction()));
        mManager.registerAction("employe.social.report", new N4DSAction());
    }

    public void registerStatsMenuActions(MenuAndActions mManager) {
        ComptaPropsConfiguration configuration = ComptaPropsConfiguration.getInstanceCompta();
        mManager.registerAction("sales.graph", (Action)((Object)new EvolutionCAAction()));
        mManager.registerAction("sales.graph.cumulate", (Action)((Object)new EvolutionCACumulAction()));
        mManager.registerAction("sales.graph.cmd", (Action)((Object)new EvolutionCmdAction()));
        mManager.registerAction("sales.graph.cmd.cumulate", (Action)((Object)new EvolutionCmdCumulAction()));
        mManager.registerAction("sales.margin.graph", (Action)((Object)new EvolutionMargeAction()));
        mManager.registerAction("sales.list.report", (Action)((Object)new GenListeVenteAction()));
        mManager.registerAction("sales.product.graph", (Action)((Object)new VenteArticleGraphAction()));
        mManager.registerAction("sales.product.margin.graph", (Action)((Object)new VenteArticleMargeGraphAction()));
        mManager.registerAction("sales.product.family.graph", (Action)((Object)new VenteArticleFamilleGraphAction()));
        mManager.registerAction("sales.list.graph", (Action)((Object)new EtatVenteAction()));
    }

    public void registerPaymentMenuActions(MenuAndActions mManager) {
        UserRights rights = UserManager.getInstance().getCurrentUser().getRights();
        if (rights.haveRight(ComptaUserRight.MENU) || rights.haveRight(ComptaUserRight.POINTAGE_LETTRAGE)) {
            mManager.registerAction("payment.checking.create", (Action)((Object)new NouveauPointageAction()));
            mManager.registerAction("payment.reconciliation.create", (Action)((Object)new NouveauLettrageAction()));
        }
        if (rights.haveRight(NXRights.GESTION_ENCAISSEMENT.getCode())) {
            mManager.registerAction("customer.invoice.unpaid.list", (Action)((Object)new ListesFacturesClientsImpayeesAction()));
            mManager.registerAction("customer.dept.list", new ListeDebiteursAction());
            mManager.registerAction("customer.payment.list", (Action)((Object)new ListeDesEncaissementsAction()));
            mManager.registerAction("customer.payment.followup.list", (Action)((Object)new ListeDesRelancesAction()));
            mManager.registerAction("customer.payment.check.pending.list", (Action)((Object)new ListeDesChequesAEncaisserAction()));
            mManager.registerAction("customer.payment.check.pending.create", (Action)((Object)new NouveauListeDesChequesAEncaisserAction()));
            mManager.registerAction("customer.credit.check.list", (Action)((Object)new ListeDesChequesAvoirAction()));
            mManager.registerAction("customer.credit.check.create", (Action)((Object)new NouveauDecaissementChequeAvoirAction()));
        }
        if (rights.haveRight(NXRights.LOCK_MENU_ACHAT.getCode())) {
            mManager.registerAction("supplier.invoice.unpaid.list", (Action)((Object)new ListesFacturesFournImpayeesAction()));
            mManager.registerAction("supplier.bill.list", (Action)((Object)new ListeDesTraitesFournisseursAction()));
            mManager.registerAction("supplier.payment.check.list", (Action)((Object)new ListeDesChequesFournisseursAction()));
            mManager.registerAction("supplier.payment.check.pending.list", (Action)((Object)new NouveauListeDesChequesADecaisserAction()));
        }
    }

    private void registerPayrollMenuActions(MenuAndActions mManager) {
        mManager.registerAction("payroll.list.report.print", (Action)((Object)new ImpressionLivrePayeAction()));
        mManager.registerAction("payroll.profile.list", (Action)((Object)new ListeDesProfilsPayeAction()));
        mManager.registerAction("payroll.history", (Action)((Object)new NouvelHistoriqueFichePayeAction()));
        mManager.registerAction("payroll.create", (Action)((Object)new EditionFichePayeAction()));
        mManager.registerAction("payroll.deposit.create", (Action)((Object)new NouvelAcompteAction()));
        mManager.registerAction("employee.list", (Action)((Object)new ListeDesSalariesAction()));
        mManager.registerAction("payroll.section", (Action)((Object)new ListeDesRubriquesDePayeAction()));
        mManager.registerAction("payroll.variable", (Action)((Object)new ListeDesVariablesPayes()));
        mManager.registerAction("payroll.closing", (Action)((Object)new ClotureMensuellePayeAction()));
    }

    public void registerOrganizationMenuActions(MenuAndActions mManager) {
        UserRights rights = UserManager.getInstance().getCurrentUser().getRights();
        ComptaPropsConfiguration configuration = ComptaPropsConfiguration.getInstanceCompta();
        if (rights.haveRight(ComptaUserRight.MENU)) {
            mManager.putAction((Action)((Object)new GestionPlanComptableEAction()), "accounting.chart");
            mManager.putAction((Action)((Object)new ListeDesJournauxAction()), "accounting.journal");
            mManager.putAction((Action)((Object)new ListeDesDevisesAction()), "accounting.currency");
            mManager.putAction((Action)((Object)new ListeDesTauxDeChangeAction()), "accounting.currency.rates");
            mManager.putAction(new AbstractAction("Check DB"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBRoot rootSociete = ComptaPropsConfiguration.getInstanceCompta().getRootSociete();
                    SQLSelect sel = CorrectMouvement.createUnbalancedSelect((DBRoot)rootSociete);
                    List ids = rootSociete.getDBSystemRoot().getDataSource().executeCol(sel.asString());
                    JOptionPane.showMessageDialog((Component)e.getSource(), "Il y a " + ids.size() + " mouvement(s) non \u00e9quilibr\u00e9(s).", "R\u00e9sultat", ids.size() == 0 ? 1 : 2);
                }
            }, "accounting.checkDB");
        }
        if (rights.haveRight("LOCK_MENU_ADMIN")) {
            mManager.registerAction("user.list", (Action)new ListeDesUsersCommonAction());
            mManager.registerAction("user.right.list", (Action)new GestionDroitsAction());
            mManager.registerAction("user.task.right", (Action)new TaskAdminAction());
        }
        mManager.registerAction("office.contact.list", (Action)((Object)new ListeDesContactsAdministratif()));
        mManager.registerAction("salesman.list", (Action)((Object)new ListeDesCommerciauxAction()));
        mManager.registerAction("pos.list", (Action)((Object)new ListeDesCaissesTicketAction()));
        mManager.registerAction("enterprise.list", (Action)new ListeDesSocietesCommonsAction());
        mManager.registerAction("divison.bank.list", (Action)new ListeBanqueAction());
        mManager.registerAction("enterprise.create", (Action)new NouvelleSocieteAction());
    }

    private void registerHelpMenuActions(MenuAndActions mManager) {
        mManager.registerAction("information", (Action)AboutAction.getInstance());
        mManager.registerAction("tips", (Action)new AstuceAction());
    }

    private void registerHelpTestActions(MenuAndActions mManager) {
    }
}

