/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.RankingPathElement;
import org.jgrapht.alg.RankingPathElementList;

class KShortestPathsIterator<V, E>
implements Iterator<Set<V>> {
    private V endVertex;
    private Graph<V, E> graph;
    private int k;
    private Set<V> prevImprovedVertices;
    private Map<V, RankingPathElementList<V, E>> prevSeenDataContainer;
    private Map<V, RankingPathElementList<V, E>> seenDataContainer;
    private V startVertex;
    private boolean startVertexEncountered;

    public KShortestPathsIterator(Graph<V, E> graph, V startVertex, V endVertex, int maxSize) {
        this.assertKShortestPathsIterator(graph, startVertex);
        this.graph = graph;
        this.startVertex = startVertex;
        this.endVertex = endVertex;
        this.k = maxSize;
        this.seenDataContainer = new HashMap<V, RankingPathElementList<V, E>>();
        this.prevSeenDataContainer = new HashMap<V, RankingPathElementList<V, E>>();
        this.prevImprovedVertices = new HashSet<V>();
    }

    @Override
    public boolean hasNext() {
        if (!this.startVertexEncountered) {
            this.encounterStartVertex();
        }
        return !this.prevImprovedVertices.isEmpty();
    }

    @Override
    public Set<V> next() {
        if (!this.startVertexEncountered) {
            this.encounterStartVertex();
        }
        if (this.hasNext()) {
            HashSet improvedVertices = new HashSet();
            for (V vertex : this.prevImprovedVertices) {
                if (vertex.equals(this.endVertex)) continue;
                this.updateOutgoingVertices(vertex, improvedVertices);
            }
            this.savePassData(improvedVertices);
            return improvedVertices;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    RankingPathElementList<V, E> getPathElements(V endVertex) {
        return this.seenDataContainer.get(endVertex);
    }

    private void addFirstPath(V vertex, E edge) {
        RankingPathElementList<V, E> data = this.createSeenData(vertex, edge);
        this.seenDataContainer.put((RankingPathElementList<V, E>)vertex, (RankingPathElementList<RankingPathElementList<V, E>, E>)data);
    }

    private void assertKShortestPathsIterator(Graph<V, E> graph, V startVertex) {
        if (graph == null) {
            throw new NullPointerException("graph is null");
        }
        if (startVertex == null) {
            throw new NullPointerException("startVertex is null");
        }
    }

    private RankingPathElementList<V, E> createSeenData(V vertex, E edge) {
        V oppositeVertex = Graphs.getOppositeVertex(this.graph, edge, vertex);
        RankingPathElementList<V, E> oppositeData = this.prevSeenDataContainer.get(oppositeVertex);
        RankingPathElementList<V, E> data = new RankingPathElementList<V, E>(this.graph, this.k, oppositeData, edge);
        return data;
    }

    private Set<E> edgesOf(V vertex) {
        if (this.graph instanceof DirectedGraph) {
            return ((DirectedGraph)this.graph).outgoingEdgesOf(vertex);
        }
        return this.graph.edgesOf(vertex);
    }

    private void encounterStartVertex() {
        RankingPathElementList<V, E> data = new RankingPathElementList<V, E>(this.graph, this.k, new RankingPathElement(this.startVertex));
        this.seenDataContainer.put((RankingPathElementList<V, E>)this.startVertex, (RankingPathElementList<RankingPathElementList<V, E>, E>)data);
        this.prevSeenDataContainer.put((RankingPathElementList<V, E>)this.startVertex, (RankingPathElementList<RankingPathElementList<V, E>, E>)data);
        this.prevImprovedVertices.add(this.startVertex);
        this.startVertexEncountered = true;
    }

    private void savePassData(Set<V> improvedVertices) {
        for (V vertex : improvedVertices) {
            RankingPathElementList<V, E> clonedData = new RankingPathElementList<V, E>(this.seenDataContainer.get(vertex));
            this.prevSeenDataContainer.put((RankingPathElementList<V, E>)vertex, (RankingPathElementList<RankingPathElementList<V, E>, E>)clonedData);
        }
        this.prevImprovedVertices = improvedVertices;
    }

    private boolean tryToAddNewPaths(V vertex, E edge) {
        RankingPathElementList<V, E> data = this.seenDataContainer.get(vertex);
        V oppositeVertex = Graphs.getOppositeVertex(this.graph, edge, vertex);
        RankingPathElementList<V, E> oppositeData = this.prevSeenDataContainer.get(oppositeVertex);
        return data.addPathElements(oppositeData, edge);
    }

    private void updateOutgoingVertices(V vertex, Set<V> improvedVertices) {
        for (E edge : this.edgesOf(vertex)) {
            V vertexReachedByEdge = Graphs.getOppositeVertex(this.graph, edge, vertex);
            if (vertexReachedByEdge == this.startVertex) continue;
            if (this.seenDataContainer.containsKey(vertexReachedByEdge)) {
                boolean relaxed = this.tryToAddNewPaths(vertexReachedByEdge, edge);
                if (!relaxed) continue;
                improvedVertices.add(vertexReachedByEdge);
                continue;
            }
            this.addFirstPath(vertexReachedByEdge, edge);
            improvedVertices.add(vertexReachedByEdge);
        }
    }
}

