/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.Assert;
import com.ibm.icu.impl.CharTrie;
import com.ibm.icu.impl.CharacterIteration;
import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.CjkBreakEngine;
import com.ibm.icu.text.LanguageBreakEngine;
import com.ibm.icu.text.RBBIDataWrapper;
import com.ibm.icu.text.ThaiBreakEngine;
import com.ibm.icu.text.UnhandledBreakEngine;
import java.io.IOException;
import java.io.InputStream;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class RuleBasedBreakIterator
extends BreakIterator {
    private CharacterIterator fText = new StringCharacterIterator("");
    RBBIDataWrapper fRData;
    private int fLastRuleStatusIndex;
    private boolean fLastStatusIndexValid = true;
    private int fDictionaryCharCount = 0;
    private static final boolean TRACE = ICUDebug.enabled("rbbi") && ICUDebug.value("rbbi").indexOf("trace") >= 0;
    private int fBreakType = 2;
    private final UnhandledBreakEngine fUnhandledBreakEngine = new UnhandledBreakEngine();
    private int[] fCachedBreakPositions;
    private int fPositionInCache;
    private boolean fUseDictionary = true;
    private final Set<LanguageBreakEngine> fBreakEngines = Collections.synchronizedSet(new HashSet());
    static final String fDebugEnv = ICUDebug.enabled("rbbi") ? ICUDebug.value("rbbi") : null;

    private RuleBasedBreakIterator() {
        this.fBreakEngines.add(this.fUnhandledBreakEngine);
    }

    public static RuleBasedBreakIterator getInstanceFromCompiledRules(InputStream is) throws IOException {
        RuleBasedBreakIterator This = new RuleBasedBreakIterator();
        This.fRData = RBBIDataWrapper.get(is);
        return This;
    }

    public Object clone() {
        RuleBasedBreakIterator result = (RuleBasedBreakIterator)super.clone();
        if (this.fText != null) {
            result.fText = (CharacterIterator)this.fText.clone();
        }
        return result;
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        try {
            RuleBasedBreakIterator other = (RuleBasedBreakIterator)that;
            if (this.fRData != other.fRData && (this.fRData == null || other.fRData == null)) {
                return false;
            }
            if (this.fRData != null && other.fRData != null && !this.fRData.fRuleSource.equals(other.fRData.fRuleSource)) {
                return false;
            }
            if (this.fText == null && other.fText == null) {
                return true;
            }
            if (this.fText == null || other.fText == null) {
                return false;
            }
            return this.fText.equals(other.fText);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        String retStr = "";
        if (this.fRData != null) {
            retStr = this.fRData.fRuleSource;
        }
        return retStr;
    }

    public int hashCode() {
        return this.fRData.fRuleSource.hashCode();
    }

    public int first() {
        this.fCachedBreakPositions = null;
        this.fDictionaryCharCount = 0;
        this.fPositionInCache = 0;
        this.fLastRuleStatusIndex = 0;
        this.fLastStatusIndexValid = true;
        if (this.fText == null) {
            return -1;
        }
        this.fText.first();
        return this.fText.getIndex();
    }

    public int next() {
        return this.handleNext();
    }

    public void setText(CharacterIterator newText) {
        this.fText = newText;
        int firstIdx = this.first();
        if (newText != null) {
            this.fUseDictionary = (this.fBreakType == 1 || this.fBreakType == 2) && newText.getEndIndex() != firstIdx;
        }
    }

    void setBreakType(int type) {
        this.fBreakType = type;
        if (type != 1 && type != 2) {
            this.fUseDictionary = false;
        }
    }

    int getBreakType() {
        return this.fBreakType;
    }

    private LanguageBreakEngine getEngineFor(int c) {
        if (c == Integer.MAX_VALUE || !this.fUseDictionary) {
            return null;
        }
        for (LanguageBreakEngine candidate : this.fBreakEngines) {
            if (!candidate.handles(c, this.fBreakType)) continue;
            return candidate;
        }
        int script = UCharacter.getIntPropertyValue(c, 4106);
        LanguageBreakEngine eng = null;
        try {
            switch (script) {
                case 38: {
                    eng = new ThaiBreakEngine();
                    break;
                }
                case 17: 
                case 20: 
                case 22: {
                    if (this.getBreakType() == 1) {
                        eng = new CjkBreakEngine(false);
                        break;
                    }
                    this.fUnhandledBreakEngine.handleChar(c, this.getBreakType());
                    eng = this.fUnhandledBreakEngine;
                    break;
                }
                case 18: {
                    if (this.getBreakType() == 1) {
                        eng = new CjkBreakEngine(true);
                        break;
                    }
                    this.fUnhandledBreakEngine.handleChar(c, this.getBreakType());
                    eng = this.fUnhandledBreakEngine;
                    break;
                }
                default: {
                    this.fUnhandledBreakEngine.handleChar(c, this.getBreakType());
                    eng = this.fUnhandledBreakEngine;
                    break;
                }
            }
        }
        catch (IOException e) {
            eng = null;
        }
        if (eng != null) {
            this.fBreakEngines.add(eng);
        }
        return eng;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int handleNext() {
        if (this.fCachedBreakPositions == null || this.fPositionInCache == this.fCachedBreakPositions.length - 1) {
            int startPos = this.fText.getIndex();
            this.fDictionaryCharCount = 0;
            int result = this.handleNext(this.fRData.fFTable);
            if (this.fDictionaryCharCount > 1 && result - startPos > 1) {
                this.fText.setIndex(startPos);
                LanguageBreakEngine e = this.getEngineFor(CharacterIteration.current32(this.fText));
                if (e == null) {
                    this.fText.setIndex(result);
                    return result;
                }
                Stack<Integer> breaks = new Stack<Integer>();
                e.findBreaks(this.fText, startPos, result, false, this.getBreakType(), breaks);
                int breaksSize = breaks.size();
                this.fCachedBreakPositions = new int[breaksSize + 2];
                this.fCachedBreakPositions[0] = startPos;
                for (int i = 0; i < breaksSize; ++i) {
                    this.fCachedBreakPositions[i + 1] = (Integer)breaks.elementAt(i);
                }
                this.fCachedBreakPositions[breaksSize + 1] = result;
                this.fPositionInCache = 0;
            } else {
                this.fCachedBreakPositions = null;
                return result;
            }
        }
        if (this.fCachedBreakPositions != null) {
            ++this.fPositionInCache;
            this.fText.setIndex(this.fCachedBreakPositions[this.fPositionInCache]);
            return this.fCachedBreakPositions[this.fPositionInCache];
        }
        Assert.assrt(false);
        return -1;
    }

    private int handleNext(short[] stateTable) {
        int initialPosition;
        if (TRACE) {
            System.out.println("Handle Next   pos      char  state category");
        }
        this.fLastStatusIndexValid = true;
        this.fLastRuleStatusIndex = 0;
        CharacterIterator text = this.fText;
        CharTrie trie = this.fRData.fTrie;
        int c = text.current();
        if (c >= 55296 && (c = CharacterIteration.nextTrail32(text, c)) == Integer.MAX_VALUE) {
            return -1;
        }
        int result = initialPosition = text.getIndex();
        int state = 1;
        int row = this.fRData.getRowIndex(state);
        int category = 3;
        short flagsState = stateTable[5];
        int mode = 1;
        if ((flagsState & 2) != 0) {
            category = 2;
            mode = 0;
            if (TRACE) {
                System.out.print("            " + RBBIDataWrapper.intToString(text.getIndex(), 5));
                System.out.print(RBBIDataWrapper.intToHexString(c, 10));
                System.out.println(RBBIDataWrapper.intToString(state, 7) + RBBIDataWrapper.intToString(category, 6));
            }
        }
        short lookaheadStatus = 0;
        int lookaheadTagIdx = 0;
        int lookaheadResult = 0;
        while (state != 0) {
            if (c == Integer.MAX_VALUE) {
                if (mode == 2) {
                    if (lookaheadResult <= result) break;
                    result = lookaheadResult;
                    this.fLastRuleStatusIndex = lookaheadTagIdx;
                    break;
                }
                mode = 2;
                category = 1;
            } else if (mode == 1) {
                category = (short)trie.getCodePointValue(c);
                if ((category & 0x4000) != 0) {
                    ++this.fDictionaryCharCount;
                    category = (short)(category & 0xFFFFBFFF);
                }
                if (TRACE) {
                    System.out.print("            " + RBBIDataWrapper.intToString(text.getIndex(), 5));
                    System.out.print(RBBIDataWrapper.intToHexString(c, 10));
                    System.out.println(RBBIDataWrapper.intToString(state, 7) + RBBIDataWrapper.intToString(category, 6));
                }
                if ((c = (int)text.next()) >= 55296) {
                    c = CharacterIteration.nextTrail32(text, c);
                }
            } else {
                mode = 1;
            }
            state = stateTable[row + 4 + category];
            row = this.fRData.getRowIndex(state);
            if (stateTable[row + 0] == -1) {
                result = text.getIndex();
                if (c >= 65536 && c <= 0x10FFFF) {
                    --result;
                }
                this.fLastRuleStatusIndex = stateTable[row + 2];
            }
            if (stateTable[row + 1] != 0) {
                if (lookaheadStatus != 0 && stateTable[row + 0] == lookaheadStatus) {
                    result = lookaheadResult;
                    this.fLastRuleStatusIndex = lookaheadTagIdx;
                    lookaheadStatus = 0;
                    if ((flagsState & 1) == 0) continue;
                    text.setIndex(result);
                    return result;
                }
                lookaheadResult = text.getIndex();
                if (c >= 65536 && c <= 0x10FFFF) {
                    --lookaheadResult;
                }
                lookaheadStatus = stateTable[row + 1];
                lookaheadTagIdx = stateTable[row + 2];
                continue;
            }
            if (stateTable[row + 0] == 0) continue;
            lookaheadStatus = 0;
        }
        if (result == initialPosition) {
            if (TRACE) {
                System.out.println("Iterator did not move. Advancing by 1.");
            }
            text.setIndex(initialPosition);
            CharacterIteration.next32(text);
            result = text.getIndex();
        } else {
            text.setIndex(result);
        }
        if (TRACE) {
            System.out.println("result = " + result);
        }
        return result;
    }
}

