/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.CurrencyData;
import com.ibm.icu.impl.ICUCache;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.SimpleCache;
import com.ibm.icu.text.NumberingSystem;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.Serializable;
import java.text.ChoiceFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;

public class DecimalFormatSymbols
implements Serializable,
Cloneable {
    private String[] currencySpcBeforeSym;
    private String[] currencySpcAfterSym;
    private char zeroDigit;
    private char[] digits;
    private char groupingSeparator;
    private char decimalSeparator;
    private char perMill;
    private char percent;
    private char digit;
    private char sigDigit;
    private char patternSeparator;
    private String infinity;
    private String NaN;
    private char minusSign;
    private String currencySymbol;
    private String intlCurrencySymbol;
    private char monetarySeparator;
    private char monetaryGroupingSeparator;
    private String exponentSeparator;
    private char padEscape;
    private char plusSign;
    private Locale requestedLocale;
    private ULocale ulocale;
    private int serialVersionOnStream = 6;
    private static final ICUCache<ULocale, String[][]> cachedLocaleData = new SimpleCache<ULocale, String[][]>();
    private String currencyPattern = null;
    private ULocale validLocale;
    private ULocale actualLocale;
    private transient Currency currency;

    public DecimalFormatSymbols() {
        this.initialize(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public DecimalFormatSymbols(ULocale locale) {
        this.initialize(locale);
    }

    public char getZeroDigit() {
        if (this.digits != null) {
            return this.digits[0];
        }
        return this.zeroDigit;
    }

    public char[] getDigits() {
        if (this.digits != null) {
            return (char[])this.digits.clone();
        }
        char[] digitArray = new char[10];
        for (int i = 0; i < 10; ++i) {
            digitArray[i] = (char)(this.zeroDigit + i);
        }
        return digitArray;
    }

    char[] getDigitsLocal() {
        if (this.digits != null) {
            return this.digits;
        }
        char[] digitArray = new char[10];
        for (int i = 0; i < 10; ++i) {
            digitArray[i] = (char)(this.zeroDigit + i);
        }
        return digitArray;
    }

    public char getSignificantDigit() {
        return this.sigDigit;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public char getPerMill() {
        return this.perMill;
    }

    public char getPercent() {
        return this.percent;
    }

    public char getDigit() {
        return this.digit;
    }

    public char getPatternSeparator() {
        return this.patternSeparator;
    }

    public String getInfinity() {
        return this.infinity;
    }

    public String getNaN() {
        return this.NaN;
    }

    public char getMinusSign() {
        return this.minusSign;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currency) {
        this.currencySymbol = currency;
    }

    public String getInternationalCurrencySymbol() {
        return this.intlCurrencySymbol;
    }

    public void setCurrency(Currency currency) {
        if (currency == null) {
            throw new NullPointerException();
        }
        this.currency = currency;
        this.intlCurrencySymbol = currency.getCurrencyCode();
        this.currencySymbol = currency.getSymbol(this.requestedLocale);
    }

    public char getMonetaryDecimalSeparator() {
        return this.monetarySeparator;
    }

    public char getMonetaryGroupingSeparator() {
        return this.monetaryGroupingSeparator;
    }

    String getCurrencyPattern() {
        return this.currencyPattern;
    }

    public String getExponentSeparator() {
        return this.exponentSeparator;
    }

    public char getPlusSign() {
        return this.plusSign;
    }

    public char getPadEscape() {
        return this.padEscape;
    }

    public ULocale getULocale() {
        return this.ulocale;
    }

    public Object clone() {
        try {
            return (DecimalFormatSymbols)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof DecimalFormatSymbols)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DecimalFormatSymbols other = (DecimalFormatSymbols)obj;
        for (i = 0; i <= 2; ++i) {
            if (!this.currencySpcBeforeSym[i].equals(other.currencySpcBeforeSym[i])) {
                return false;
            }
            if (this.currencySpcAfterSym[i].equals(other.currencySpcAfterSym[i])) continue;
            return false;
        }
        if (other.digits == null) {
            for (i = 0; i < 10; ++i) {
                if (this.digits[i] == other.zeroDigit + i) continue;
                return false;
            }
        } else if (!Arrays.equals(this.digits, other.digits)) {
            return false;
        }
        return this.groupingSeparator == other.groupingSeparator && this.decimalSeparator == other.decimalSeparator && this.percent == other.percent && this.perMill == other.perMill && this.digit == other.digit && this.minusSign == other.minusSign && this.patternSeparator == other.patternSeparator && this.infinity.equals(other.infinity) && this.NaN.equals(other.NaN) && this.currencySymbol.equals(other.currencySymbol) && this.intlCurrencySymbol.equals(other.intlCurrencySymbol) && this.padEscape == other.padEscape && this.plusSign == other.plusSign && this.exponentSeparator.equals(other.exponentSeparator) && this.monetarySeparator == other.monetarySeparator && this.monetaryGroupingSeparator == other.monetaryGroupingSeparator;
    }

    public int hashCode() {
        int result = this.digits[0];
        result = result * 37 + this.groupingSeparator;
        result = result * 37 + this.decimalSeparator;
        return result;
    }

    private void initialize(ULocale locale) {
        String nsName;
        this.requestedLocale = locale.toLocale();
        this.ulocale = locale;
        NumberingSystem ns = NumberingSystem.getInstance(locale);
        this.digits = new char[10];
        if (ns != null && ns.getRadix() == 10 && !ns.isAlgorithmic() && NumberingSystem.isValidDigitString(ns.getDescription())) {
            String digitString = ns.getDescription();
            this.digits[0] = digitString.charAt(0);
            this.digits[1] = digitString.charAt(1);
            this.digits[2] = digitString.charAt(2);
            this.digits[3] = digitString.charAt(3);
            this.digits[4] = digitString.charAt(4);
            this.digits[5] = digitString.charAt(5);
            this.digits[6] = digitString.charAt(6);
            this.digits[7] = digitString.charAt(7);
            this.digits[8] = digitString.charAt(8);
            this.digits[9] = digitString.charAt(9);
            nsName = ns.getName();
        } else {
            this.digits[0] = 48;
            this.digits[1] = 49;
            this.digits[2] = 50;
            this.digits[3] = 51;
            this.digits[4] = 52;
            this.digits[5] = 53;
            this.digits[6] = 54;
            this.digits[7] = 55;
            this.digits[8] = 56;
            this.digits[9] = 57;
            nsName = "latn";
        }
        String[][] data = cachedLocaleData.get(locale);
        if (data == null) {
            data = new String[1][];
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt51b", locale);
            boolean isLatn = nsName.equals("latn");
            String baseKey = "NumberElements/" + nsName + "/symbols/";
            String latnKey = "NumberElements/latn/symbols/";
            String[] symbolKeys = new String[]{"decimal", "group", "list", "percentSign", "minusSign", "plusSign", "exponential", "perMille", "infinity", "nan", "currencyDecimal", "currencyGroup"};
            String[] fallbackElements = new String[]{".", ",", ";", "%", "-", "+", "E", "\u2030", "\u221e", "NaN", null, null};
            String[] symbolsArray = new String[symbolKeys.length];
            for (int i = 0; i < symbolKeys.length; ++i) {
                try {
                    symbolsArray[i] = rb.getStringWithFallback(baseKey + symbolKeys[i]);
                    continue;
                }
                catch (MissingResourceException ex) {
                    if (!isLatn) {
                        try {
                            symbolsArray[i] = rb.getStringWithFallback(latnKey + symbolKeys[i]);
                        }
                        catch (MissingResourceException ex1) {
                            symbolsArray[i] = fallbackElements[i];
                        }
                        continue;
                    }
                    symbolsArray[i] = fallbackElements[i];
                }
            }
            data[0] = symbolsArray;
            cachedLocaleData.put(locale, data);
        }
        String[] numberElements = data[0];
        ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt51b", locale);
        ULocale uloc = r.getULocale();
        this.setLocale(uloc, uloc);
        this.decimalSeparator = numberElements[0].charAt(0);
        this.groupingSeparator = numberElements[1].charAt(0);
        this.patternSeparator = numberElements[2].charAt(0);
        this.percent = numberElements[3].charAt(0);
        this.minusSign = numberElements[4].charAt(0);
        this.plusSign = numberElements[5].charAt(0);
        this.exponentSeparator = numberElements[6];
        this.perMill = numberElements[7].charAt(0);
        this.infinity = numberElements[8];
        this.NaN = numberElements[9];
        this.monetarySeparator = numberElements[10] != null ? numberElements[10].charAt(0) : this.decimalSeparator;
        this.monetaryGroupingSeparator = numberElements[11] != null ? numberElements[11].charAt(0) : this.groupingSeparator;
        this.digit = (char)35;
        this.padEscape = (char)42;
        this.sigDigit = (char)64;
        CurrencyData.CurrencyDisplayInfo info = CurrencyData.provider.getInstance(locale, true);
        String currname = null;
        this.currency = Currency.getInstance(locale);
        if (this.currency != null) {
            this.intlCurrencySymbol = this.currency.getCurrencyCode();
            boolean[] isChoiceFormat = new boolean[1];
            currname = this.currency.getName(locale, 0, isChoiceFormat);
            this.currencySymbol = isChoiceFormat[0] ? new ChoiceFormat(currname).format(2.0) : currname;
            CurrencyData.CurrencyFormatInfo fmtInfo = info.getFormatInfo(this.intlCurrencySymbol);
            if (fmtInfo != null) {
                this.currencyPattern = fmtInfo.currencyPattern;
                this.monetarySeparator = fmtInfo.monetarySeparator;
                this.monetaryGroupingSeparator = fmtInfo.monetaryGroupingSeparator;
            }
        } else {
            this.intlCurrencySymbol = "XXX";
            this.currencySymbol = "\u00a4";
        }
        this.currencySpcBeforeSym = new String[3];
        this.currencySpcAfterSym = new String[3];
        this.initSpacingInfo(info.getSpacingInfo());
    }

    private void initSpacingInfo(CurrencyData.CurrencySpacingInfo spcInfo) {
        this.currencySpcBeforeSym[0] = spcInfo.beforeCurrencyMatch;
        this.currencySpcBeforeSym[1] = spcInfo.beforeContextMatch;
        this.currencySpcBeforeSym[2] = spcInfo.beforeInsert;
        this.currencySpcAfterSym[0] = spcInfo.afterCurrencyMatch;
        this.currencySpcAfterSym[1] = spcInfo.afterContextMatch;
        this.currencySpcAfterSym[2] = spcInfo.afterInsert;
    }

    public final ULocale getLocale(ULocale.Type type) {
        return type == ULocale.ACTUAL_LOCALE ? this.actualLocale : this.validLocale;
    }

    final void setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }
}

