/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

public class CalendarAstronomer {
    public static final SolarLongitude VERNAL_EQUINOX = new SolarLongitude(0.0);
    public static final SolarLongitude SUMMER_SOLSTICE = new SolarLongitude(1.5707963267948966);
    public static final SolarLongitude AUTUMN_EQUINOX = new SolarLongitude(Math.PI);
    public static final SolarLongitude WINTER_SOLSTICE = new SolarLongitude(4.71238898038469);
    public static final MoonAge NEW_MOON = new MoonAge(0.0);
    public static final MoonAge FIRST_QUARTER = new MoonAge(1.5707963267948966);
    public static final MoonAge FULL_MOON = new MoonAge(Math.PI);
    public static final MoonAge LAST_QUARTER = new MoonAge(4.71238898038469);
    private long time;
    private double fLongitude = 0.0;
    private double fLatitude = 0.0;
    private long fGmtOffset = 0L;
    private transient double julianDay = Double.MIN_VALUE;
    private transient double julianCentury = Double.MIN_VALUE;
    private transient double sunLongitude = Double.MIN_VALUE;
    private transient double meanAnomalySun = Double.MIN_VALUE;
    private transient double moonLongitude = Double.MIN_VALUE;
    private transient double moonEclipLong = Double.MIN_VALUE;
    private transient double eclipObliquity = Double.MIN_VALUE;
    private transient double siderealT0 = Double.MIN_VALUE;
    private transient double siderealTime = Double.MIN_VALUE;
    private transient Equatorial moonPosition = null;

    public CalendarAstronomer() {
        this(System.currentTimeMillis());
    }

    public CalendarAstronomer(long aTime) {
        this.time = aTime;
    }

    public void setTime(long aTime) {
        this.time = aTime;
        this.clearCache();
    }

    public double getJulianDay() {
        if (this.julianDay == Double.MIN_VALUE) {
            this.julianDay = (double)(this.time - -210866760000000L) / 8.64E7;
        }
        return this.julianDay;
    }

    public final Equatorial eclipticToEquatorial(double eclipLong, double eclipLat) {
        double obliq = this.eclipticObliquity();
        double sinE = Math.sin(obliq);
        double cosE = Math.cos(obliq);
        double sinL = Math.sin(eclipLong);
        double cosL = Math.cos(eclipLong);
        double sinB = Math.sin(eclipLat);
        double cosB = Math.cos(eclipLat);
        double tanB = Math.tan(eclipLat);
        return new Equatorial(Math.atan2(sinL * cosE - tanB * sinE, cosL), Math.asin(sinB * cosE + cosB * sinE * sinL));
    }

    public double getSunLongitude() {
        if (this.sunLongitude == Double.MIN_VALUE) {
            double[] result = this.getSunLongitude(this.getJulianDay());
            this.sunLongitude = result[0];
            this.meanAnomalySun = result[1];
        }
        return this.sunLongitude;
    }

    double[] getSunLongitude(double julian) {
        double day = julian - 2447891.5;
        double epochAngle = CalendarAstronomer.norm2PI(0.017202791632524146 * day);
        double meanAnomaly = CalendarAstronomer.norm2PI(epochAngle + 4.87650757829735 - 4.935239984568769);
        return new double[]{CalendarAstronomer.norm2PI(this.trueAnomaly(meanAnomaly, 0.016713) + 4.935239984568769), meanAnomaly};
    }

    public long getSunTime(double desired, boolean next) {
        return this.timeOfAngle(new AngleFunc(){

            public double eval() {
                return CalendarAstronomer.this.getSunLongitude();
            }
        }, desired, 365.242191, 60000L, next);
    }

    public long getSunTime(SolarLongitude desired, boolean next) {
        return this.getSunTime(desired.value, next);
    }

    public Equatorial getMoonPosition() {
        if (this.moonPosition == null) {
            double sunLong = this.getSunLongitude();
            double day = this.getJulianDay() - 2447891.5;
            double meanLongitude = CalendarAstronomer.norm2PI(0.22997150421858628 * day + 5.556284436750021);
            double meanAnomalyMoon = CalendarAstronomer.norm2PI(meanLongitude - 0.001944368345221015 * day - 0.6342598060246725);
            double evection = 0.022233749341155764 * Math.sin(2.0 * (meanLongitude - sunLong) - meanAnomalyMoon);
            double annual = 0.003242821750205464 * Math.sin(this.meanAnomalySun);
            double a3 = 0.00645771823237902 * Math.sin(this.meanAnomalySun);
            double center = 0.10975677534091541 * Math.sin(meanAnomalyMoon += evection - annual - a3);
            double a4 = 0.0037350045992678655 * Math.sin(2.0 * meanAnomalyMoon);
            this.moonLongitude = meanLongitude + evection + center - annual + a4;
            double variation = 0.011489502465878671 * Math.sin(2.0 * (this.moonLongitude - sunLong));
            this.moonLongitude += variation;
            double nodeLongitude = CalendarAstronomer.norm2PI(5.559050068029439 - 9.242199067718253E-4 * day);
            double y = Math.sin(this.moonLongitude - (nodeLongitude -= 0.0027925268031909274 * Math.sin(this.meanAnomalySun)));
            double x = Math.cos(this.moonLongitude - nodeLongitude);
            this.moonEclipLong = Math.atan2(y * Math.cos(0.08980357792017056), x) + nodeLongitude;
            double moonEclipLat = Math.asin(y * Math.sin(0.08980357792017056));
            this.moonPosition = this.eclipticToEquatorial(this.moonEclipLong, moonEclipLat);
        }
        return this.moonPosition;
    }

    public double getMoonAge() {
        this.getMoonPosition();
        return CalendarAstronomer.norm2PI(this.moonEclipLong - this.sunLongitude);
    }

    public long getMoonTime(double desired, boolean next) {
        return this.timeOfAngle(new AngleFunc(){

            public double eval() {
                return CalendarAstronomer.this.getMoonAge();
            }
        }, desired, 29.530588853, 60000L, next);
    }

    public long getMoonTime(MoonAge desired, boolean next) {
        return this.getMoonTime(desired.value, next);
    }

    private long timeOfAngle(AngleFunc func, double desired, double periodDays, long epsilon, boolean next) {
        double deltaT;
        double lastAngle = func.eval();
        double deltaAngle = CalendarAstronomer.norm2PI(desired - lastAngle);
        double lastDeltaT = deltaT = (deltaAngle + (next ? 0.0 : Math.PI * -2)) * (periodDays * 8.64E7) / (Math.PI * 2);
        long startTime = this.time;
        this.setTime(this.time + (long)deltaT);
        do {
            double angle = func.eval();
            double factor = Math.abs(deltaT / CalendarAstronomer.normPI(angle - lastAngle));
            deltaT = CalendarAstronomer.normPI(desired - angle) * factor;
            if (Math.abs(deltaT) > Math.abs(lastDeltaT)) {
                long delta = (long)(periodDays * 8.64E7 / 8.0);
                this.setTime(startTime + (next ? delta : -delta));
                return this.timeOfAngle(func, desired, periodDays, epsilon, next);
            }
            lastDeltaT = deltaT;
            lastAngle = angle;
            this.setTime(this.time + (long)deltaT);
        } while (Math.abs(deltaT) > (double)epsilon);
        return this.time;
    }

    private static final double normalize(double value, double range) {
        return value - range * Math.floor(value / range);
    }

    private static final double norm2PI(double angle) {
        return CalendarAstronomer.normalize(angle, Math.PI * 2);
    }

    private static final double normPI(double angle) {
        return CalendarAstronomer.normalize(angle + Math.PI, Math.PI * 2) - Math.PI;
    }

    private double trueAnomaly(double meanAnomaly, double eccentricity) {
        double delta;
        double E = meanAnomaly;
        do {
            delta = E - eccentricity * Math.sin(E) - meanAnomaly;
            E -= delta / (1.0 - eccentricity * Math.cos(E));
        } while (Math.abs(delta) > 1.0E-5);
        return 2.0 * Math.atan(Math.tan(E / 2.0) * Math.sqrt((1.0 + eccentricity) / (1.0 - eccentricity)));
    }

    private double eclipticObliquity() {
        if (this.eclipObliquity == Double.MIN_VALUE) {
            double epoch = 2451545.0;
            double T = (this.getJulianDay() - 2451545.0) / 36525.0;
            this.eclipObliquity = 23.439292 - 0.013004166666666666 * T - 1.6666666666666665E-7 * T * T + 5.027777777777778E-7 * T * T * T;
            this.eclipObliquity *= Math.PI / 180;
        }
        return this.eclipObliquity;
    }

    private void clearCache() {
        this.julianDay = Double.MIN_VALUE;
        this.julianCentury = Double.MIN_VALUE;
        this.sunLongitude = Double.MIN_VALUE;
        this.meanAnomalySun = Double.MIN_VALUE;
        this.moonLongitude = Double.MIN_VALUE;
        this.moonEclipLong = Double.MIN_VALUE;
        this.eclipObliquity = Double.MIN_VALUE;
        this.siderealTime = Double.MIN_VALUE;
        this.siderealT0 = Double.MIN_VALUE;
        this.moonPosition = null;
    }

    public static final class Equatorial {
        public final double ascension;
        public final double declination;

        public Equatorial(double asc, double dec) {
            this.ascension = asc;
            this.declination = dec;
        }

        public String toString() {
            return Double.toString(this.ascension * 57.29577951308232) + "," + this.declination * 57.29577951308232;
        }
    }

    private static interface AngleFunc {
        public double eval();
    }

    private static class MoonAge {
        double value;

        MoonAge(double val) {
            this.value = val;
        }
    }

    private static class SolarLongitude {
        double value;

        SolarLongitude(double val) {
            this.value = val;
        }
    }
}

