/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.lang.reflect.Field;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class Oid {
    public static String toString(int oid) {
        try {
            Field[] fields = Oid.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].getInt(null) != oid) continue;
                return fields[i].getName();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return "<unknown:" + oid + ">";
    }

    public static int valueOf(String oid) throws PSQLException {
        try {
            return (int)Long.parseLong(oid);
        }
        catch (NumberFormatException ex) {
            try {
                oid = oid.toUpperCase();
                Field[] fields = Oid.class.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    if (!fields[i].getName().toUpperCase().equals(oid)) continue;
                    return fields[i].getInt(null);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            throw new PSQLException(GT.tr("oid type {0} not known and not a number", oid), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }
}

